/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.servlet.result;

import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import kd.bos.nocode.restapi.common.constant.HttpStatus;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.result.RestApiFile;
import kd.bos.nocode.restapi.common.result.RestApiResult;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.servlet.context.RestApiContext;
import kd.bos.nocode.restapi.servlet.result.ResultHandler;
import kd.bos.nocode.restapi.servlet.utils.ApiStreamUtil;

public class StreamResultHandler
implements ResultHandler {
    @Override
    public void handleResult(Object resultData) {
        this.handleResult(resultData, RestApiContext.getResponse());
    }

    @Override
    public void handleResult(Object resultData, HttpServletResponse resp) {
        RestApiFile fileResult = new RestApiFile("errorFile.txt", "text/plain", true, new byte[0]);
        String errorCode = "ErrorCode:";
        String errMsg = "";
        if (resultData != null && !((RestApiResult)resultData).isStatus()) {
            RestApiResult result = (RestApiResult)resultData;
            errMsg = errorCode + result.getErrorCode() + ", Message:" + result.getMessage();
        } else if (resultData == null || ((RestApiResult)resultData).getData() == null) {
            errMsg = errorCode + RestApiErrorCode.HTTP_BAD_REQUEST.getStatusCode() + " , CustomApiResult cannot be null.";
        } else {
            Object data = ((RestApiResult)resultData).getData();
            if (!(data instanceof RestApiFile)) {
                errMsg = errorCode + RestApiErrorCode.HTTP_BAD_REQUEST.getStatusCode() + ", CustomApiResult must be instance of RestApiFile.";
            } else {
                errMsg = "";
                fileResult = (RestApiFile)data;
            }
        }
        if (!StringUtil.isEmpty((String)errMsg)) {
            int httpStatus = HttpStatus.BAD_REQUEST.getStatusCode();
            if (ApiStreamUtil.getStatus() < HttpStatus.BAD_REQUEST.getStatusCode()) {
                ApiStreamUtil.sendStatus(httpStatus);
            }
            byte[] errorData = errMsg.getBytes(StandardCharsets.UTF_8);
            fileResult = new RestApiFile("errorFile.txt", "text/plain", true, errorData);
        }
        try {
            if (fileResult.isDownload()) {
                ApiStreamUtil.downloadAttachment(fileResult, resp);
            } else {
                ApiStreamUtil.openAttachment(fileResult, resp);
            }
        }
        catch (Exception ex) {
            throw new RestApiException((Throwable)ex);
        }
    }
}

