/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.servlet.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.result.RestApiFile;
import kd.bos.nocode.restapi.common.util.IOUtil;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.servlet.context.RestApiContext;
import org.apache.commons.fileupload.FileItem;

public class ApiStreamUtil {
    private ApiStreamUtil() {
    }

    public static void sendStatus(int statusCode) {
        HttpServletResponse resp = RestApiContext.getResponse();
        try {
            if (resp != null) {
                resp.setStatus(statusCode);
            }
        }
        catch (Exception ex) {
            throw new RestApiException((Throwable)ex);
        }
    }

    public static int getStatus() {
        return RestApiContext.getResponse() != null ? RestApiContext.getResponse().getStatus() : 0;
    }

    public static void writeData(String data, HttpServletResponse response, String contentType) {
        OutputStreamWriter writer = null;
        try {
            if (StringUtil.isEmpty((String)data)) {
                response.setContentLength(0);
            } else {
                response.setContentType(contentType);
                response.setCharacterEncoding("UTF-8");
                writer = ApiStreamUtil.getWriter(response);
                writer.write(data);
                writer.flush();
            }
        }
        catch (IOException ex) {
            throw new RestApiException((Throwable)ex);
        }
        finally {
            IOUtil.closeQuietly(writer);
        }
    }

    private static OutputStreamWriter getWriter(HttpServletResponse response) {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.apiIO, new Object[]{e.getMessage()});
        }
        return writer;
    }

    public static void openAttachment(RestApiFile fileResult, HttpServletResponse response) throws IOException {
        response.addHeader("Content-Disposition", "filename=\"" + new String(fileResult.getFileName().getBytes("gb2312"), StandardCharsets.ISO_8859_1) + "\"");
        String fileType = fileResult.getContentType();
        if (!StringUtil.isEmpty((String)fileType)) {
            response.setHeader("Content-Type", fileResult.getContentType());
        }
        ApiStreamUtil.writeStreamResponse(fileResult.getFileData(), response);
    }

    public static void downloadAttachment(RestApiFile fileResult, HttpServletResponse response) throws IOException {
        response.setHeader("Pragma", "No-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("application/octet-stream;charset=UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=\"" + new String(fileResult.getFileName().getBytes("gb2312"), StandardCharsets.ISO_8859_1) + "\"");
        ApiStreamUtil.writeStreamResponse(fileResult.getFileData(), response);
    }

    private static void writeStreamResponse(byte[] data, HttpServletResponse resp) throws IOException {
        ServletOutputStream out = null;
        try {
            out = resp.getOutputStream();
            out.write(data);
            out.flush();
        }
        finally {
            IOUtil.closeQuietly((Closeable)out);
        }
    }

    public static byte[] getBytesByFileItem(FileItem fileItem) throws IOException {
        long size = fileItem.getSize();
        if (size > 0x6400000L) {
            throw new RestApiException(RestApiErrorCode.HTTP_BAD_REQUEST, "The maximum allowed FileStream length is 100 MB. ", new Object[0]);
        }
        InputStream stream = fileItem.getInputStream();
        byte[] data = IOUtil.getByteArray((InputStream)stream);
        fileItem.delete();
        return data;
    }
}

