/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.servlet.utils;

import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletRequest;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.common.constant.HttpStatus;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.result.RestApiResult;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.servlet.context.RestApiContext;
import kd.bos.nocode.restapi.servlet.utils.ApiStreamUtil;

public class RestApiExceptionUtil {
    private static Log log = LogFactory.getLog(RestApiExceptionUtil.class);
    private static final int CAUSE_DEPTH = 50;

    private RestApiExceptionUtil() {
    }

    public static String getExceptionMessage(Throwable ex) {
        if (ex == null) {
            return "";
        }
        int count = 0;
        while (ex instanceof InvocationTargetException && count++ < 50) {
            ex = ((InvocationTargetException)ex).getTargetException();
        }
        count = 0;
        while (ex.getCause() != null && count++ < 50 && (!(ex instanceof RestApiException) || StringUtil.isEmpty((String)ex.getMessage()))) {
            ex = ex.getCause();
        }
        String errMsg = ex.getMessage();
        return errMsg;
    }

    public static String getExceptionStackInfo(Throwable ex) {
        if (ex == null) {
            return "";
        }
        int count = 0;
        while (ex.getCause() != null && count++ < 50) {
            ex = ex.getCause();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(",TraceId\uff1a").append(RequestContext.get().getTraceId());
        return sb.toString();
    }

    public static RestApiResult handleException(Throwable exception, HttpServletRequest req) {
        String errMsg = RestApiExceptionUtil.getExceptionMessage(exception);
        int httpCode = HttpStatus.OK.getStatusCode();
        boolean isArmoEx = RestApiExceptionUtil.isException(exception, "ArmorException");
        RestApiResult result = RestApiContext.getResult();
        if (exception instanceof RestApiException) {
            String errorCode = ((RestApiException)exception).getCode();
            if (StringUtil.isEmpty((String)errorCode)) {
                errorCode = RestApiErrorCode.ERROR.getStatusCode();
            }
            result.fail(errMsg, errorCode);
        } else if (exception instanceof KDException) {
            String errorCode;
            int step = 0;
            for (Throwable cause = exception.getCause(); cause != null && step++ < 50; cause = cause.getCause()) {
                if (!(cause instanceof RestApiException)) continue;
                errorCode = ((RestApiException)cause).getCode();
                if (StringUtil.isEmpty((String)errorCode)) {
                    errorCode = RestApiErrorCode.ERROR.getStatusCode();
                }
                result.fail(errMsg, errorCode);
                break;
            }
            if (StringUtil.isEmpty((String)result.getErrorCode())) {
                errorCode = ((KDException)exception).getErrorCode().getCode();
                result.fail(errMsg, errorCode);
            }
        } else if (isArmoEx) {
            httpCode = HttpStatus.TOO_MANY_REQUESTS_429.getStatusCode();
            String errorCode = String.valueOf(HttpStatus.TOO_MANY_REQUESTS_429.getStatusCode());
            result.fail("Too many request, Flow Limit is exceed.", errorCode);
        } else {
            log.debug("RestApi-" + errMsg, (Object)exception);
            httpCode = HttpStatus.BAD_REQUEST.getStatusCode();
            String errorCode = RestApiErrorCode.HTTP_INTERNAL_ERROR.getStatusCode();
            result.fail(errMsg, String.valueOf(errorCode));
        }
        if (ApiStreamUtil.getStatus() < HttpStatus.BAD_REQUEST.getStatusCode()) {
            ApiStreamUtil.sendStatus(httpCode);
        }
        result.setTraceId(RequestContext.get().getTraceId());
        return result;
    }

    public static boolean isException(Throwable e, String exceptionName) {
        if (e == null) {
            return false;
        }
        return e.getClass().getCanonicalName().contains(exceptionName);
    }
}

