/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.nocode.expression.NoCodeCalcExprParser;
import kd.bos.nocode.ext.property.NoCodeAttachmentProp;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;
import kd.bos.nocode.rule.NoCodeBR;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class HeadFormulaBizRuleExecutor {
    private NoCodeBR br;
    private FormRuleExecuteContext executeContext;
    private IDataModel model;

    public HeadFormulaBizRuleExecutor(NoCodeBR br, FormRuleExecuteContext executeContext) {
        this.br = br;
        this.executeContext = executeContext;
        this.model = executeContext.getModel();
    }

    public void execute(ExpressionParameter parameter) {
        try (EntityTraceSpan span = EntityTracer.create((String)"HeadFormulaBizRuleExecutor", (String)"execute");){
            String[] deptKeyArray;
            HashMap<String, Object> var = new HashMap<String, Object>(16);
            String depKeys = this.br.getDepFldKeys();
            if (StringUtils.isBlank((CharSequence)depKeys)) {
                this.calcFormulaValue(parameter, var);
                return;
            }
            IDataEntityProperty affectProp = this.model.getProperty(this.br.getAffectFldKeys());
            boolean isFormulaExpression = true;
            if (parameter.getExpression().equalsIgnoreCase(depKeys)) {
                isFormulaExpression = false;
            }
            for (String s : deptKeyArray = depKeys.split(",")) {
                IDataEntityProperty sourceProp;
                List objs;
                DynamicObjectCollection col;
                String[] fieldSplits;
                IDataEntityProperty property;
                if (s.indexOf(".") == -1) {
                    IDataEntityProperty p;
                    Object val = this.model.getValue(s);
                    IDataEntityProperty sourceProp2 = p = this.model.getProperty(s);
                    if (!isFormulaExpression) {
                        sourceProp2 = affectProp;
                    }
                    if (p instanceof NoCodeProp) {
                        val = ((NoCodeProp)p).getDBValue(val, sourceProp2);
                        var.put(s, val);
                        continue;
                    }
                    if (p instanceof NoCodeRefBillTableProp) {
                        NoCodeRefBillProp refBillProp;
                        String refBillKey = ((NoCodeRefBillTableProp)p).getRefBillKey();
                        Object refValue = this.model.getValue(refBillKey);
                        if (((NoCodeRefBillTableProp)p).getMulti() == 0) {
                            refBillProp = (NoCodeRefBillProp)this.model.getProperty(refBillKey);
                            val = refBillProp.getDBValue(refValue, sourceProp2);
                        } else {
                            refBillProp = (NoCodeMulRefBillProp)this.model.getProperty(refBillKey);
                            val = refBillProp.getDBValue(refValue, sourceProp2);
                        }
                        var.put(s, val);
                        continue;
                    }
                }
                if ((property = this.model.getProperty((fieldSplits = s.split("\\."))[0])) instanceof NoCodeRefBillTableProp) {
                    NoCodeRefBillTableProp tableProp;
                    DynamicObjectCollection collection = this.model.getEntryEntity(fieldSplits[0]);
                    if (collection.size() == 0 && this.model.getValue((tableProp = (NoCodeRefBillTableProp)property).getRefBillKey()) != null) {
                        this.executeContext.getView().updateView(tableProp.getName());
                    }
                    if ((collection = this.model.getEntryEntity(fieldSplits[0])).size() == 0) {
                        var.put(s, null);
                        continue;
                    }
                    if (s.indexOf("fbasedataid") != -1) {
                        col = ((DynamicObject)collection.get(0)).getDynamicObjectCollection(fieldSplits[1]);
                        if (col.isEmpty()) {
                            var.put(s, null);
                            continue;
                        }
                        if (fieldSplits.length == 4) {
                            objs = NoCodeProp.sortAttachment((DynamicObjectCollection)col);
                            DynamicObject obj = ((DynamicObject)objs.get(0)).getDynamicObject("fbasedataid");
                            var.put(s, obj.get(fieldSplits[3]));
                            continue;
                        }
                        var.put(s, col);
                        continue;
                    }
                    sourceProp = this.getSourceProp(isFormulaExpression, affectProp, fieldSplits[1], collection.getDynamicObjectType());
                    if (collection.size() == 1) {
                        var.put(s, NoCodeProp.getDisplayValue((DynamicObject)((DynamicObject)collection.get(0)), (String)fieldSplits[1], (IDataEntityProperty)sourceProp) == null ? " " : NoCodeProp.getDisplayValue((DynamicObject)((DynamicObject)collection.get(0)), (String)fieldSplits[1], (IDataEntityProperty)sourceProp));
                        continue;
                    }
                    String val = collection.stream().map(o -> NoCodeProp.getDisplayValue((DynamicObject)o, (String)fieldSplits[1], (IDataEntityProperty)sourceProp) == null ? " " : NoCodeProp.getDisplayValue((DynamicObject)o, (String)fieldSplits[1], (IDataEntityProperty)sourceProp)).map(Object::toString).collect(Collectors.joining(","));
                    var.put(s, val);
                    continue;
                }
                if (property instanceof NoCodeMulRefBillProp) {
                    String pks = (String)this.model.getValue(fieldSplits[0]);
                    if (StringUtils.isBlank((CharSequence)pks)) {
                        var.put(s, null);
                        continue;
                    }
                    ArrayList<Long> pkList = new ArrayList<Long>(10);
                    String[] pkArray = pks.split(",");
                    NoCodeMulRefBillProp prop = (NoCodeMulRefBillProp)property;
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)prop.getBillEntityId());
                    for (int i = 0; i < pkArray.length; ++i) {
                        pkList.add(Long.parseLong(pkArray[i]));
                    }
                    DynamicObject[] cols = BusinessDataServiceHelper.load((Object[])pkList.toArray(new Object[0]), (DynamicObjectType)entityType);
                    if (s.indexOf("fbasedataid") != -1) {
                        DynamicObjectCollection col2 = cols[0].getDynamicObjectCollection(fieldSplits[1]);
                        if (col2.isEmpty()) {
                            var.put(s, null);
                            continue;
                        }
                        if (fieldSplits.length == 4) {
                            List objs2 = NoCodeProp.sortAttachment((DynamicObjectCollection)col2);
                            DynamicObject obj = ((DynamicObject)objs2.get(0)).getDynamicObject("fbasedataid");
                            var.put(s, obj.get(fieldSplits[3]));
                            continue;
                        }
                        var.put(s, col2);
                        continue;
                    }
                    IDataEntityProperty sourceProp3 = this.getSourceProp(isFormulaExpression, affectProp, fieldSplits[1], cols[0].getDynamicObjectType());
                    if (cols.length == 1) {
                        var.put(s, NoCodeProp.getDisplayValue((DynamicObject)cols[0], (String)fieldSplits[1], (IDataEntityProperty)sourceProp3) == null ? " " : NoCodeProp.getDisplayValue((DynamicObject)cols[0], (String)fieldSplits[1], (IDataEntityProperty)sourceProp3));
                        continue;
                    }
                    String val = Arrays.stream(cols).map(o -> NoCodeProp.getDisplayValue((DynamicObject)o, (String)fieldSplits[1], (IDataEntityProperty)sourceProp3) == null ? " " : NoCodeProp.getDisplayValue((DynamicObject)o, (String)fieldSplits[1], (IDataEntityProperty)sourceProp3)).map(Object::toString).collect(Collectors.joining(","));
                    var.put(s, val);
                    continue;
                }
                if (property instanceof NoCodeAttachmentProp) {
                    DynamicObjectCollection col3 = this.model.getDataEntity().getDynamicObjectCollection(fieldSplits[0]);
                    if (col3.isEmpty()) {
                        var.put(s, null);
                        continue;
                    }
                    List objs3 = NoCodeProp.sortAttachment((DynamicObjectCollection)col3);
                    DynamicObject obj = ((DynamicObject)objs3.get(0)).getDynamicObject("fbasedataid");
                    var.put(s, obj.get(fieldSplits[2]));
                    continue;
                }
                DynamicObject obj = this.model.getDataEntity().getDynamicObject(fieldSplits[0]);
                if (obj == null) {
                    var.put(s, null);
                    continue;
                }
                if (s.indexOf("fbasedataid") != -1) {
                    col = obj.getDynamicObjectCollection(fieldSplits[1]);
                    if (col.isEmpty()) {
                        var.put(s, null);
                        continue;
                    }
                    objs = NoCodeProp.sortAttachment((DynamicObjectCollection)col);
                    DynamicObject attObj = ((DynamicObject)objs.get(0)).getDynamicObject("fbasedataid");
                    IDataEntityProperty sourceProp4 = this.getSourceProp(isFormulaExpression, affectProp, fieldSplits[3], attObj.getDynamicObjectType());
                    var.put(s, NoCodeProp.getDisplayValue((DynamicObject)attObj, (String)fieldSplits[3], (IDataEntityProperty)sourceProp4));
                    continue;
                }
                sourceProp = this.getSourceProp(isFormulaExpression, affectProp, fieldSplits[1], obj.getDynamicObjectType());
                Object value = NoCodeProp.getDisplayValue((DynamicObject)obj, (String)fieldSplits[1], (IDataEntityProperty)sourceProp);
                if (isFormulaExpression && value == null) {
                    value = "";
                }
                var.put(s, value);
            }
            this.calcFormulaValue(parameter, var);
        }
        catch (Exception exc) {
            try (EntityTraceSpan span2 = EntityTracer.create((String)"HeadFormulaBizRuleExecutor", (String)"execute");){
                span2.throwException((Throwable)exc);
            }
        }
    }

    private IDataEntityProperty getSourceProp(boolean isFormulaExpression, IDataEntityProperty affectProp, String fieldKey, DynamicObjectType entityType) {
        DynamicProperty sourceProp = entityType.getProperty(fieldKey);
        if (!isFormulaExpression) {
            sourceProp = affectProp;
        }
        return sourceProp;
    }

    private void calcFormulaValue(ExpressionParameter parameter, Map<String, Object> var) {
        try (EntityTraceSpan span = EntityTracer.create((String)"HeadFormulaBizRuleExecutor", (String)"calcFormulaValue");){
            span.addLocaleTag("var:", var);
            Object val = NoCodeCalcExprParser.getExpressionValue(parameter, var);
            span.addLocaleTag("val:", val);
            IDataEntityProperty property = this.model.getProperty(this.br.getAffectFldKeys());
            if (property != null) {
                if (property instanceof NoCodeProp) {
                    NoCodeProp prop = (NoCodeProp)property;
                    Object value = prop.formatDefValue(val);
                    prop.setDBValue(this.model, this.br.getAffectFldKeys(), value);
                } else {
                    this.model.setValue(this.br.getAffectFldKeys(), val);
                }
            }
        }
        catch (Exception exc) {
            try (EntityTraceSpan span2 = EntityTracer.create((String)"HeadFormulaBizRuleExecutor", (String)"calcFormulaValue");){
                span2.throwException((Throwable)exc);
            }
        }
    }
}

