/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.rule.AbstractRule;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.converter.FormMetadataConverter;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.nocode.expression.NoCodeCalcExprParser;
import kd.bos.nocode.ext.metadata.form.NoCodeBillFormAp;
import kd.bos.nocode.ext.metadata.form.container.NoCodeGroupContainerAp;
import kd.bos.nocode.ext.metadata.form.control.NoCodeEntryAp;
import kd.bos.nocode.ext.property.NoCodeDateTimeProp;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;
import kd.bos.nocode.internalapi.FilterValueService;
import kd.bos.nocode.metadata.IDateFormatSupport;
import kd.bos.nocode.metadata.IDecimalFormatSupport;
import kd.bos.nocode.mservice.NoCodeDefValueCalculatorService;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.rule.ActionTypeEnum;
import kd.bos.nocode.rule.HeadFormulaBizRuleExecutor;
import kd.bos.nocode.rule.QueryFormExecutor;
import kd.bos.nocode.rule.RelationFormExecutor;
import kd.bos.nocode.rule.RelationFormMultiExecutor;
import kd.bos.nocode.rule.RelationFormSingleExecutor;
import kd.bos.nocode.rule.TableFormulaBizRuleExecutor;
import kd.bos.nocode.servicehelper.ServiceFactory;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class NoCodeBR
extends AbstractRule {
    private static final Log logger = LogFactory.getLog(NoCodeBR.class);
    public static final String FIELD_VALUE = "fieldValue";
    private String affectFldKeys;
    private Set<String> affectFldSet;
    private String ruleType;

    public String getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(String ruleType) {
        this.ruleType = ruleType;
    }

    public String getAffectFldKeys() {
        return this.affectFldKeys;
    }

    public void setAffectFldKeys(String affectFldKeys) {
        this.affectFldKeys = affectFldKeys;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public Set<String> getAffectFldSet() {
        if (this.affectFldSet == null) {
            String[] keys;
            this.affectFldSet = new HashSet<String>();
            for (String key : keys = this.affectFldKeys.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                this.affectFldSet.add(key.split("\\.")[0]);
            }
        }
        return this.affectFldSet;
    }

    public void execute(RuleExecuteContext executeContext) {
        if ("0".equals(this.getRuleType())) {
            this.dealWithFormRule(executeContext);
        } else if ("1".equals(this.getRuleType())) {
            this.dealWithBizRule(executeContext);
        }
    }

    private void dealWithBizRule(RuleExecuteContext executeContext) {
        try (EntityTraceSpan span = EntityTracer.create((String)"NoCodeBR", (String)"dealWithBizRule");){
            FormRuleExecuteContext context = (FormRuleExecuteContext)executeContext;
            IDataModel model = context.getModel();
            String expression = this.getPreCondition();
            span.addTag("affectFldKeys:", this.affectFldKeys);
            span.addTag("depFldKeys:", this.getDepFldKeys());
            span.addTag("preCondition:", this.getPreCondition());
            span.addLocaleTag("dataEntity:", context.getDataEntities().get(0));
            Map valMap = (Map)SerializationUtils.fromJsonString((String)expression, Map.class);
            int valueType = (Integer)valMap.get("valueType");
            if (valueType == 1) {
                String formulaExpression = (String)valMap.get("value");
                if (StringUtils.isBlank((CharSequence)formulaExpression)) {
                    return;
                }
                String result = NcEntityTypeUtil.getRuntimeExpression((String)formulaExpression);
                span.addTag("expression", formulaExpression);
                RowDataModel rowModel = new RowDataModel(model.getDataEntityType().getName(), model);
                ExpressionParameter parameter = new ExpressionParameter(result, rowModel);
                RowDataEntity dataEntity = (RowDataEntity)context.getDataEntities().get(0);
                parameter.setActiveRow((Object)dataEntity.getDataEntity());
                parameter.setRowIndex(dataEntity.getRowIndex());
                String affectKeys = this.getAffectFldKeys();
                if (affectKeys.contains(".")) {
                    String[] split = affectKeys.split("\\.");
                    TableFormulaBizRuleExecutor executor = new TableFormulaBizRuleExecutor(this, context);
                    executor.execute(parameter, split);
                } else {
                    HeadFormulaBizRuleExecutor executor = new HeadFormulaBizRuleExecutor(this, context);
                    executor.execute(parameter);
                }
            } else if (valueType == 2) {
                QueryFormExecutor executor = new QueryFormExecutor(this, context);
                executor.execute();
            } else if (valueType == 3) {
                RelationFormExecutor executor;
                IDataEntityProperty property;
                Map configs = (Map)valMap.get("value");
                String relationFormKey = (String)configs.get("relationFormId");
                String multi = configs.getOrDefault("multi", "0");
                String[] fields = relationFormKey.split("\\.");
                if (fields.length > 2) {
                    return;
                }
                RaiseEventSource arg = (RaiseEventSource)executeContext.getRaiseEventSources().get(0);
                if (arg.getDataEntities().isEmpty()) {
                    return;
                }
                DynamicObject dataEntity = ((RowDataEntity)arg.getDataEntities().get(0)).getDataEntity();
                if (dataEntity.getDynamicObjectType() instanceof EntryType) {
                    dataEntity = (DynamicObject)dataEntity.getParent();
                }
                if (!((property = model.getProperty(fields[0])) instanceof INoCodeRefBillProp)) {
                    return;
                }
                String relationFormId = ((INoCodeRefBillProp)property).getBillEntityId();
                Object value = dataEntity.get(fields[0]);
                Object object = value = value instanceof DynamicObject ? ((DynamicObject)value).getPkValue() : value;
                if (fields.length > 1) {
                    Set pks = Arrays.stream(value.toString().split(",")).map(this::tryParseNumberId).collect(Collectors.toSet());
                    if (pks.isEmpty()) {
                        return;
                    }
                    QFilter filter = new QFilter("id", "in", pks);
                    DynamicObject[] load = BusinessDataServiceHelper.load((String)relationFormId, (String)("id," + fields[1]), (QFilter[])new QFilter[]{filter});
                    if (load.length == 0) {
                        return;
                    }
                    IDataEntityProperty p = (IDataEntityProperty)load[0].getDataEntityType().getProperties().get((Object)fields[1]);
                    if (!(p instanceof INoCodeRefBillProp)) {
                        return;
                    }
                    relationFormId = ((INoCodeRefBillProp)p).getBillEntityId();
                    Set collect = Arrays.stream(load).map(dy -> dy.get(fields[1])).map(obj -> obj instanceof DynamicObject ? ((DynamicObject)obj).getPkValue() : obj).flatMap(dy -> Arrays.stream(dy.toString().split(","))).collect(Collectors.toSet());
                    if (collect.isEmpty()) {
                        return;
                    }
                    value = String.join((CharSequence)",", collect);
                }
                if ("1".equals(multi)) {
                    executor = new RelationFormMultiExecutor(context);
                    ((RelationFormMultiExecutor)executor).execute(configs, relationFormId, value);
                } else {
                    executor = new RelationFormSingleExecutor(context);
                    ((RelationFormSingleExecutor)executor).execute(configs, relationFormId, value, relationFormKey);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            try (EntityTraceSpan span2 = EntityTracer.create((String)"NoCodeBR", (String)"dealWithBizRule");){
                span2.throwException((Throwable)e);
            }
        }
    }

    private Object tryParseNumberId(String input) {
        try {
            return Long.parseLong(input);
        }
        catch (Exception e) {
            return input;
        }
    }

    private void parseExpression(List<Map<String, Object>> filterInfos, FormRuleExecuteContext context) {
        for (Map<String, Object> map : filterInfos) {
            String fieldName = (String)map.get("fieldName");
            Object value = map.get("value");
            String compareTypeId = (String)map.get("compareType");
            List<Object> valueList = this.getValueList(value);
            for (Object obj : valueList) {
                Object result;
                String fieldValue;
                Map val;
                if (!(obj instanceof Map) || !((val = (Map)obj).get(FIELD_VALUE) instanceof String) || (fieldValue = (String)val.get(FIELD_VALUE)).indexOf("${model") == -1) continue;
                fieldValue = fieldValue.replace("${model.", "");
                fieldValue = fieldValue.replace("}", "");
                String firstFieldName = fieldValue.split("\\.")[0];
                RaiseEventSource arg = (RaiseEventSource)context.getRaiseEventSources().get(0);
                IDataModel dataModel = context.getModel();
                if (!arg.getDataEntities().isEmpty() && arg.getDataEntities().get(0) instanceof ChangeData) {
                    ChangeData data = (ChangeData)arg.getDataEntities().get(0);
                    result = firstFieldName.equals(arg.getProperty().getName()) ? data.getNewValue() : dataModel.getValue(firstFieldName);
                } else {
                    result = dataModel.getValue(firstFieldName);
                }
                IDataEntityProperty property = dataModel.getProperty(firstFieldName);
                IDataEntityProperty leftProperty = dataModel.getProperty(fieldName.split("\\.")[0]);
                if (FilterValueService.create().isAttachmentSubProp((DynamicObjectType)dataModel.getDataEntityType(), fieldValue)) {
                    result = FilterValueService.create().getAttachmentPropValue(dataModel, fieldValue, compareTypeId);
                } else if (FilterValueService.create().isPictureProp((DynamicObjectType)dataModel.getDataEntityType(), fieldValue)) {
                    result = FilterValueService.create().getImagePropValue(dataModel, fieldValue, compareTypeId);
                }
                if (leftProperty instanceof IDateFormatSupport) {
                    result = ((IDateFormatSupport)leftProperty).getFormattedValue(result);
                }
                if (!(leftProperty instanceof IDecimalFormatSupport) && property instanceof IDecimalFormatSupport) {
                    result = ((IDecimalFormatSupport)property).getFormattedValue(result);
                }
                val.put(FIELD_VALUE, NcEntityTypeUtil.getOriginalValue((IDataEntityProperty)property, (Object)result));
            }
        }
    }

    private List<Object> getValueList(Object value) {
        List valueList = value instanceof String ? SerializationUtils.fromJsonStringToList((String)((String)value), Object.class) : (List)value;
        return valueList;
    }

    private void dealWithFormRule(RuleExecuteContext executeContext) {
        try (EntityTraceSpan span = EntityTracer.create((String)"NoCodeBR", (String)"dealWithFormRule");){
            FormRuleExecuteContext context = (FormRuleExecuteContext)executeContext;
            MainEntityType entityType = context.getModel().getDataEntityType();
            IFormView formView = context.getView();
            String expressionStr = this.getPreCondition();
            if (!expressionStr.equals("force:true")) {
                List list = (List)SerializationUtils.fromJsonString((String)expressionStr, List.class);
                this.parseExpression(list, context);
                String formId = context.getModel().getDataEntityType().getName();
                NoCodeDefValueCalculatorService defValueCalculatorService = (NoCodeDefValueCalculatorService)ServiceFactory.getService((String)"NoCodeDefValueCalculatorService");
                String expression = defValueCalculatorService.getFilterInfo(list, formId);
                if (StringUtils.isBlank((CharSequence)expression)) {
                    return;
                }
                span.addTag("noCodeBr_expression", expression);
                RowDataModel rowModel = new RowDataModel(formId, context.getModel());
                ExpressionParameter parameter = new ExpressionParameter(expression, rowModel);
                RowDataEntity dataEntity = (RowDataEntity)context.getDataEntities().get(0);
                parameter.setActiveRow((Object)dataEntity.getDataEntity());
                parameter.setRowIndex(dataEntity.getRowIndex());
                Object expValue = NoCodeCalcExprParser.getExpressionValue(parameter);
                span.addTag("noCodeBr_expValue", expValue == null ? null : expValue.toString());
                span.addLocaleTag("dataEntity", (Object)dataEntity.getDataEntity());
                if (expValue == null || !((Boolean)expValue).booleanValue()) {
                    return;
                }
            }
            Map<String, String> stateMap = new HashMap();
            Map<String, String> requiredMap = new HashMap();
            String stateStr = formView.getPageCache().get("nocodefieldstatemap");
            String requiredStr = formView.getPageCache().get("nocodefieldrequiredmap");
            if (StringUtils.isNotBlank((CharSequence)stateStr)) {
                stateMap = (Map)SerializationUtils.fromJsonString((String)stateStr, Map.class);
            }
            if (StringUtils.isNotBlank((CharSequence)requiredStr)) {
                requiredMap = (Map)SerializationUtils.fromJsonString((String)requiredStr, Map.class);
            }
            HashMap<String, Integer> currentStatus = new HashMap();
            String statusStr = formView.getPageCache().get("currentStatus");
            if (StringUtils.isNotBlank((CharSequence)statusStr)) {
                currentStatus = (Map)SerializationUtils.fromJsonString((String)statusStr, Map.class);
            }
            ArrayList<Map<String, Object>> controls = new ArrayList<Map<String, Object>>();
            FormMetadata metadata = this.getFormmetaData(formView);
            List controlAps = metadata.getItems();
            Map key2Ap = controlAps.stream().collect(Collectors.toMap(AbstractElement::getKey, Function.identity()));
            for (Map action : this.getTrueActions()) {
                String actionType = String.valueOf(action.get("actionType"));
                Object fieldKey = action.get("fieldName");
                ArrayList<String> list = new ArrayList<String>(10);
                if (fieldKey instanceof String) {
                    list.add(fieldKey.toString());
                } else if (fieldKey instanceof List) {
                    list.addAll((List)fieldKey);
                }
                HashSet<String> allParentKeys = new HashSet<String>(10);
                for (String key : list) {
                    IDataEntityProperty property = entityType.findProperty(key);
                    if (property instanceof NoCodeDateTimeProp) {
                        NoCodeDateTimeProp timeProp = (NoCodeDateTimeProp)property;
                        if (StringUtils.isNotBlank((CharSequence)timeProp.getRelateDateTimeRange()) && key.indexOf("_startdate") != -1) {
                            key = key.replace("_startdate", "");
                        } else if (StringUtils.isNotBlank((CharSequence)timeProp.getRelateDateTimeRange()) && key.indexOf("_enddate") != -1) {
                            key = key.replace("_enddate", "");
                        }
                    }
                    if (ActionTypeEnum.MustInput.getValue().equals(actionType) || ActionTypeEnum.NonMustInput.getValue().equals(actionType)) {
                        if (property == null) {
                            property = entityType.findProperty(key + "_startdate");
                        }
                        DynamicProperty property1 = null;
                        if (property != null) {
                            property1 = (DynamicProperty)property;
                        }
                        if (property1 == null || property1.getCustomProperty("FieldRequired") != null && "3".equals(property1.getCustomProperty("FieldRequired"))) continue;
                        requiredMap.put(property1.getName(), actionType);
                        if (property1 != null && property1.getParent() instanceof EntryType) {
                            controls.add(Maps.of((Object)"k", (Object)property1.getParent().getName(), (Object)"v", (Object)(key + "@@" + actionType)));
                            continue;
                        }
                        controls.add(Maps.of((Object)"k", (Object)key, (Object)"v", (Object)actionType));
                        continue;
                    }
                    if (property == null && (property = entityType.findProperty(key + "_startdate")) == null && key.indexOf("_") != -1) {
                        property = entityType.findProperty(key.substring(0, key.lastIndexOf("_")) + "_startdate");
                    }
                    if (property != null) {
                        stateMap.put(property.getName(), actionType);
                    } else {
                        stateMap.put(key, actionType);
                    }
                    ArrayList<String> parentKeys = new ArrayList<String>(10);
                    this.findParent(key, actionType, currentStatus, parentKeys, metadata, allParentKeys);
                    if (!parentKeys.isEmpty()) {
                        for (String pKey : parentKeys) {
                            ControlAp ap = (ControlAp)key2Ap.get(pKey);
                            String pVal = actionType;
                            if (ap instanceof NoCodeGroupContainerAp) {
                                pVal = "1";
                            }
                            controls.add(Maps.of((Object)"k", (Object)pKey, (Object)"v", (Object)pVal));
                            if (ap instanceof NoCodeEntryAp) {
                                DynamicProperty tableProp = entityType.getProperty(pKey);
                                this.setBtnStatusFromTable((IDataEntityProperty)tableProp, actionType, formView, controls);
                            }
                            stateMap.put(pKey, pVal);
                            currentStatus.put(pKey, Integer.parseInt(pVal));
                        }
                    }
                    currentStatus.put(key, Integer.parseInt(actionType));
                    if (property != null && property.getParent() instanceof EntryType) {
                        controls.add(Maps.of((Object)"k", (Object)property.getParent().getName(), (Object)"v", (Object)(key + "@@" + actionType)));
                    } else {
                        controls.add(Maps.of((Object)"k", (Object)key, (Object)"v", (Object)actionType));
                    }
                    this.setBtnStatusFromTable(property, actionType, formView, controls);
                }
            }
            formView.getPageCache().put("nocodefieldstatemap", SerializationUtils.toJsonString(stateMap));
            formView.getPageCache().put("nocodefieldrequiredmap", SerializationUtils.toJsonString(requiredMap));
            formView.getPageCache().put("currentStatus", SerializationUtils.toJsonString(currentStatus));
            IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
            clientViewProxy.addAction("setControlState", controls);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            try (EntityTraceSpan span2 = EntityTracer.create((String)"NoCodeBR", (String)"dealWithFormRule");){
                span2.throwException((Throwable)e);
            }
        }
    }

    private void setBtnStatusFromTable(IDataEntityProperty property, String actionType, IFormView formView, List<Map<String, Object>> controls) {
        NoCodeRefBillTableProp tableProp;
        if (property instanceof NoCodeRefBillTableProp && Arrays.asList("2", "3", "4").contains(actionType)) {
            tableProp = (NoCodeRefBillTableProp)property;
            formView.getPageCache().put("nocode_table_formrule" + property.getName(), "true");
            if (StringUtils.isNotBlank((Object)tableProp.getCustomProperty("newEntry"))) {
                controls.add(Maps.of((Object)"k", (Object)tableProp.getCustomProperty("newEntry"), (Object)"v", (Object)"4"));
            }
            if (StringUtils.isNotBlank((Object)tableProp.getCustomProperty("selectEntry"))) {
                controls.add(Maps.of((Object)"k", (Object)tableProp.getCustomProperty("selectEntry"), (Object)"v", (Object)"4"));
            }
        }
        if (property instanceof NoCodeRefBillTableProp && "1".equals(actionType)) {
            tableProp = (NoCodeRefBillTableProp)property;
            formView.getPageCache().put("nocode_table_formrule" + property.getName(), "true");
            if (tableProp.canShowNewBtn() && StringUtils.isNotBlank((Object)tableProp.getCustomProperty("newEntry"))) {
                controls.add(Maps.of((Object)"k", (Object)tableProp.getCustomProperty("newEntry"), (Object)"v", (Object)"1"));
            }
            if (tableProp.canShowSelectBtn() && StringUtils.isNotBlank((Object)tableProp.getCustomProperty("selectEntry"))) {
                controls.add(Maps.of((Object)"k", (Object)tableProp.getCustomProperty("selectEntry"), (Object)"v", (Object)"1"));
            }
        }
    }

    protected FormMetadata getFormmetaData(IFormView formView) {
        String id = NcEntityTypeUtil.getRealBillEntityId((String)formView.getEntityId());
        Map designerMetadata = MetadataDao.loadDesignerMetadata((String)id, (String)RequestContext.get().getLang().toString());
        FormMetadataConverter converter = new FormMetadataConverter();
        return (FormMetadata)converter.convertTo(designerMetadata);
    }

    private void findParent(String key, String targetStatus, Map<String, Integer> currentStatus, List<String> parentKeys, FormMetadata metadata, Set<String> allParentKeys) {
        int target;
        if (currentStatus == null || currentStatus.isEmpty() || currentStatus.get(key) == null) {
            return;
        }
        int status = currentStatus.get(key);
        if (status <= (target = Integer.parseInt(targetStatus))) {
            return;
        }
        List controlAps = metadata.getItems();
        Map key2Ap = controlAps.stream().collect(Collectors.toMap(AbstractElement::getKey, Function.identity()));
        ControlAp ap = (ControlAp)key2Ap.get(key);
        String parentId = ap.getParentId();
        ControlAp parentAp = metadata.getItem(parentId);
        if (parentAp instanceof NoCodeBillFormAp) {
            return;
        }
        int parentStatus = currentStatus.get(parentAp.getKey());
        if (parentStatus <= target) {
            return;
        }
        if (!allParentKeys.contains(parentAp.getKey())) {
            parentKeys.add(parentAp.getKey());
            allParentKeys.add(parentAp.getKey());
            this.findParent(parentAp.getKey(), targetStatus, currentStatus, parentKeys, metadata, allParentKeys);
        }
    }
}

