/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.rule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.entity.rule.RuleDataEntities;
import kd.bos.entity.rule.TaskCollection;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.mvc.form.FormRuleContainer;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.form.NoCodeBillFormAp;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;
import kd.bos.nocode.mvc.NoCodeBillView;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.rule.ActionTypeEnum;
import kd.bos.nocode.rule.NoCodeBR;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;

public class NoCodeFormRuleContainer
extends FormRuleContainer {
    private static final Log logger = LogFactory.getLog(NoCodeFormRuleContainer.class);
    public static final String FORM_ID = "formid";
    private final Boolean nested;
    private final Boolean skip;
    private final String formId;
    private final JSONArray buttonRules;
    private final IFormView view;
    private Map<String, Object> userInputContent;
    private String userInputTargetFormId;
    private final String IdIsNotNull_Expression = "[{\"fieldName\":\"id\",\"compareType\":\"502\",\"value\":[]}]";

    public NoCodeFormRuleContainer(IFormView view) {
        super(view);
        this.view = view;
        this.nested = (Boolean)view.getFormShowParameter().getCustomParam("nested");
        this.skip = (Boolean)view.getFormShowParameter().getCustomParam("skip");
        this.buttonRules = (JSONArray)view.getFormShowParameter().getCustomParam("buttonRules");
        this.formId = view.getFormShowParameter().getFormId();
        this.initUserInputData(view);
        this.initEntryEntityField(view);
    }

    private void initEntryEntityField(IFormView view) {
        String formId = view.getFormShowParameter().getFormId();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        DataEntityPropertyCollection properties = dt.getProperties();
        ArrayList<Map> controls = new ArrayList<Map>();
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof NoCodeRefBillTableProp)) continue;
            NoCodeRefBillTableProp tableProp = (NoCodeRefBillTableProp)property;
            String refBillKey = tableProp.getRefBillKey();
            Set noViewFieldPermSet = new HashSet(0);
            OperationStatus status = this.view.getFormShowParameter().getStatus();
            String refBillEntityId = ((INoCodeRefBillProp)dt.findProperty(refBillKey)).getBillEntityId();
            if (!NcEntityTypeUtil.isFormExist((String)refBillEntityId)) continue;
            switch (status) {
                case ADDNEW: {
                    noViewFieldPermSet = NoCodePermHelper.getNoInputFieldPermSet((String)((INoCodeRefBillProp)dt.findProperty(refBillKey)).getBillEntityId());
                    break;
                }
                case VIEW: {
                    noViewFieldPermSet = NoCodePermHelper.getNoViewFieldPermSet((String)((INoCodeRefBillProp)dt.findProperty(refBillKey)).getBillEntityId());
                    break;
                }
                case EDIT: {
                    noViewFieldPermSet = NoCodePermHelper.getNoEditFieldPermSet((String)((INoCodeRefBillProp)dt.findProperty(refBillKey)).getBillEntityId());
                }
            }
            for (String s : noViewFieldPermSet) {
                controls.add(Maps.of((Object)"k", (Object)property.getName(), (Object)"v", (Object)(s + "_" + tableProp.getId().toLowerCase() + "@@" + 4)));
            }
        }
        if (!controls.isEmpty()) {
            ((IClientViewProxy)view.getService(IClientViewProxy.class)).addAction("setControlState", controls);
        }
    }

    protected void onFieldChanged(RaiseEventSource arg, TaskCollection taskContext) {
        IDataEntityProperty property = arg.getProperty();
        List sources = taskContext.getRaiseEventSources();
        sources.remove(sources.size() - 1);
        for (RaiseEventSource source : sources) {
            int newIndex;
            if (source.getProperty() == null || !source.getProperty().equals(property)) continue;
            if (!(source.getProperty().getParent() instanceof EntryType)) {
                return;
            }
            int oldIndex = ((RowDataEntity)source.getDataEntities().get(0)).getRowIndex();
            if (oldIndex != (newIndex = ((RowDataEntity)arg.getDataEntities().get(0)).getRowIndex())) continue;
            return;
        }
        sources.add(arg);
        super.onFieldChanged(arg, taskContext);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        filterList.add(new QFilter(FORM_ID, "=", (Object)((NoCodeBillView)this.view).getFormId()));
        if (property.getParent() instanceof EntryType) {
            QFilter f1 = QFilter.like((String)"depfldkeys", (String)(property.getParent().getName() + "." + property.getName()));
            EntryProp entryProp = (EntryProp)this.view.getModel().getProperty(property.getParent().getName());
            if (entryProp instanceof NoCodeRefBillTableProp) {
                NoCodeRefBillTableProp tableProp = (NoCodeRefBillTableProp)entryProp;
                QFilter f2 = QFilter.like((String)"depfldkeys", (String)(tableProp.getRefBillKey() + "." + property.getName().substring(0, property.getName().lastIndexOf("_"))));
                QFilter f = f1.or(f2);
                filterList.add(f);
            } else {
                filterList.add(f1);
            }
        } else if (property instanceof INoCodeRefBillProp) {
            String showType = ((DynamicProperty)property).getCustomProperty("showType") == null ? "1" : (String)((DynamicProperty)property).getCustomProperty("showType");
            INoCodeRefBillProp refBillProp = (INoCodeRefBillProp)property;
            if ("1".equals(showType)) {
                filterList.add(QFilter.like((String)"depfldkeys", (String)property.getName()));
            } else {
                filterList.add(QFilter.like((String)"depfldkeys", (String)refBillProp.getRefTableKey()));
            }
        } else {
            filterList.add(QFilter.like((String)"depfldkeys", (String)property.getName()));
        }
        List<RuleDataEntities> list = this.getDependencyRules(arg, filterList.toArray(new QFilter[0]));
        taskContext.addAll(list);
        if (this.skip == null || !this.skip.booleanValue()) {
            taskContext.addAll(this.buildFieldPermRules(arg));
        }
    }

    protected void onInitialized(RaiseEventSource arg, TaskCollection taskContext) {
        List<RuleDataEntities> userInputRules;
        logger.debug("begin onInitialized");
        super.onInitialized(arg, taskContext);
        if (this.userInputContent != null && !this.userInputContent.isEmpty() && !(userInputRules = this.getUserInputRules(arg)).isEmpty()) {
            taskContext.addAll(userInputRules);
            return;
        }
        if (this.nested != null && this.nested.booleanValue()) {
            taskContext.addAll(this.getButtonRules(arg));
        }
        String ignoreRules = this.view.getFormShowParameter().getCustomParams().getOrDefault("ignoreRules", "false");
        if (this.view instanceof NoCodeBillView) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            if ("false".equals(ignoreRules) && this.view.getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
                qFilters.add(new QFilter(FORM_ID, "=", (Object)arg.getDataEntityType().getName()));
                List<RuleDataEntities> list = this.getDependencyRules(arg, qFilters.toArray(new QFilter[0]));
                taskContext.addAll(list);
            } else {
                qFilters.add(new QFilter(FORM_ID, "=", (Object)arg.getDataEntityType().getName()));
                qFilters.add(new QFilter("ruletype", "=", (Object)"0"));
                List<RuleDataEntities> list = this.getDependencyRules(arg, qFilters.toArray(new QFilter[0]));
                taskContext.addAll(list);
            }
        }
        if (this.skip == null || !this.skip.booleanValue()) {
            taskContext.addAll(this.buildFieldPermRules(arg));
        }
    }

    protected void onItemAddedOrItemReset(RaiseEventSource arg, TaskCollection taskContext) {
        if (!(arg.getDataEntityType() instanceof EntryType)) {
            return;
        }
        super.onItemAddedOrItemReset(arg, taskContext);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter(FORM_ID, "=", (Object)arg.getDataEntityType().getParent().getName()));
        filters.add(new QFilter("affectfldkeys", "!=", (Object)arg.getDataEntityType().getName()));
        QFilter f = QFilter.like((String)"affectfldkeys", (String)(arg.getDataEntityType().getName() + "."));
        QFilter f1 = QFilter.like((String)"depfldkeys", (String)arg.getDataEntityType().getName());
        NoCodeRefBillTableProp entryProp = (NoCodeRefBillTableProp)this.view.getModel().getProperty(arg.getDataEntityType().getName());
        QFilter f2 = QFilter.like((String)"depfldkeys", (String)entryProp.getRefBillKey());
        QFilter relation = f.or(f1).or(f2);
        filters.add(relation);
        List<RuleDataEntities> list = this.getDependencyRules(arg, filters.toArray(new QFilter[0]));
        taskContext.addAll(list);
        if (this.skip == null || !this.skip.booleanValue()) {
            taskContext.addAll(this.buildFieldPermRules(arg));
        }
    }

    private List<RuleDataEntities> buildFieldPermRules(RaiseEventSource arg) {
        OperationStatus status = this.view.getFormShowParameter().getStatus();
        long uid = RequestContext.get().getCurrUserId();
        Map fieldPermMap = NoCodePermissionServiceHelper.getNoPermProperties((long)uid, (String)this.formId);
        Set<String> hides = new HashSet<String>();
        switch (status) {
            case ADDNEW: {
                hides = fieldPermMap.getOrDefault(FuncPermItemEnum.input.getId(), new HashSet());
                break;
            }
            case VIEW: {
                hides = fieldPermMap.getOrDefault(FuncPermItemEnum.view.getId(), new HashSet());
                break;
            }
            case EDIT: {
                hides = fieldPermMap.getOrDefault(FuncPermItemEnum.edit.getId(), new HashSet());
            }
        }
        this.removeOuterRefTableFields(hides, this.formId);
        if (!hides.isEmpty()) {
            NoCodeBR br = new NoCodeBR();
            br.setSource(this.formId);
            br.setPreCondition("force:true");
            String fields = JSON.toJSONString(hides);
            StringBuilder exp = new StringBuilder();
            exp.append("[");
            exp.append("{\"actionType\":4,\"fieldName\":").append(fields).append("}");
            exp.append("]");
            String trueActionStr = exp.toString();
            List trueActions = (List)SerializationUtils.fromJsonString((String)trueActionStr, List.class);
            br.setTrueActions(trueActions);
            br.setRuleType("0");
            RuleDataEntities res = new RuleDataEntities();
            res.DataEntities = arg.getDataEntities();
            res.Rule = br;
            return Collections.singletonList(res);
        }
        return Collections.emptyList();
    }

    private void removeOuterRefTableFields(Set<String> mainFields, String formId) {
        List outerTableIds = EntityMetadataCache.getDataEntityType((String)formId).getProperties().stream().filter(e -> e instanceof NoCodeRefBillTableProp).map(NoCodeRefBillTableProp.class::cast).filter(e -> "2".equals(e.getSourceForm())).map(NoCodeRefBillTableProp::getId).map(String::toLowerCase).collect(Collectors.toList());
        mainFields.removeIf(e -> {
            for (String outerTableId : outerTableIds) {
                if (!e.endsWith(outerTableId)) continue;
                return true;
            }
            return false;
        });
    }

    private List<RuleDataEntities> getButtonRules(RaiseEventSource arg) {
        if (this.buttonRules == null) {
            return Collections.emptyList();
        }
        ArrayList<RuleDataEntities> rules = new ArrayList<RuleDataEntities>(this.buttonRules.size());
        for (int i = 0; i < this.buttonRules.size(); ++i) {
            JSONObject rule = this.buttonRules.getJSONObject(i);
            NoCodeBR br = new NoCodeBR();
            br.setSource(rule.getString(FORM_ID));
            br.setPreCondition(rule.getString("expression"));
            br.setDepFldKeys(rule.getString("depfldkeys"));
            br.setAffectFldKeys(rule.getString("affectfldkeys"));
            String trueActionStr = rule.getString("trueaction");
            br.setRuleType(rule.getString("ruletype"));
            if (StringUtils.isNotBlank((CharSequence)trueActionStr)) {
                List trueActions = (List)SerializationUtils.fromJsonString((String)trueActionStr, List.class);
                br.setTrueActions(trueActions);
            }
            RuleDataEntities res = new RuleDataEntities();
            res.DataEntities = arg.getDataEntities();
            res.Rule = br;
            rules.add(res);
        }
        return rules;
    }

    private List<RuleDataEntities> getDependencyRules(RaiseEventSource arg, QFilter[] filters) {
        String selectFields = "id,formid,expression,depfldkeys,trueaction,ruletype,affectfldkeys";
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_nocode_rule", (String)selectFields, (QFilter[])filters);
        ArrayList<RuleDataEntities> rules = new ArrayList<RuleDataEntities>();
        for (DynamicObject obj : collection) {
            NoCodeBR br = new NoCodeBR();
            br.setId(String.valueOf(obj.getLong("id")));
            br.setSource(obj.getString(FORM_ID));
            br.setPreCondition(obj.getString("expression"));
            br.setDepFldKeys(obj.getString("depfldkeys"));
            br.setAffectFldKeys(obj.getString("affectfldkeys"));
            String trueActionStr = obj.getString("trueaction");
            br.setRuleType(obj.getString("ruletype"));
            if (StringUtils.isNotBlank((CharSequence)trueActionStr)) {
                List trueActions = (List)SerializationUtils.fromJsonString((String)trueActionStr, List.class);
                br.setTrueActions(trueActions);
            }
            RuleDataEntities res = new RuleDataEntities();
            res.DataEntities = arg.getDataEntities();
            res.Rule = br;
            rules.add(res);
        }
        return rules;
    }

    private void initUserInputData(IFormView view) {
        IFormView billContainerView = this.getBillContainer(view);
        if (billContainerView == null) {
            return;
        }
        String noCodeWfNodeUserInputConTentStr = billContainerView.getPageCache().get("NoCodeWfNodeUserInputContent");
        this.userInputContent = StringUtils.isNotBlank((CharSequence)noCodeWfNodeUserInputConTentStr) ? (Map)SerializationUtils.fromJsonString((String)noCodeWfNodeUserInputConTentStr, Map.class) : Collections.emptyMap();
        this.userInputTargetFormId = billContainerView.getPageCache().get("targetFormId");
    }

    private IFormView getBillContainer(IFormView view) {
        if (view == null) {
            return null;
        }
        if ("bos_nocode_bill".equalsIgnoreCase(view.getEntityId())) {
            return view;
        }
        return this.getBillContainer(view.getParentView());
    }

    private List<RuleDataEntities> getUserInputRules(RaiseEventSource arg) {
        if (this.userInputContent.isEmpty() || StringUtils.isBlank((CharSequence)this.userInputTargetFormId)) {
            return Collections.EMPTY_LIST;
        }
        NoCodeBR br = new NoCodeBR();
        br.setId(Uuid16.create().toString());
        br.setSource(this.userInputTargetFormId);
        br.setPreCondition("[{\"fieldName\":\"id\",\"compareType\":\"502\",\"value\":[]}]");
        br.setRuleType("0");
        br.setDescription("userInputTask-" + this.userInputTargetFormId);
        br.setDepFldKeys("id");
        br.setAffectFldKeys(String.join((CharSequence)",", this.userInputContent.keySet()));
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)this.userInputTargetFormId, (MetaCategory)MetaCategory.Form);
        ArrayList<Map<String, Object>> trueActions = new ArrayList<Map<String, Object>>(10);
        this.genUserInputTrueRule_MustInput(trueActions);
        this.genUserInputTrueRule_ReadOnly(trueActions);
        this.genUserInputTrueRule_Hidden(trueActions, formmeta);
        this.genUserInputTrueRule_Disabled(trueActions);
        this.genUserInputTrueRule_Default(trueActions);
        br.setTrueActions(trueActions);
        ArrayList<RuleDataEntities> rules = new ArrayList<RuleDataEntities>();
        RuleDataEntities res = new RuleDataEntities();
        res.DataEntities = arg.getDataEntities();
        res.Rule = br;
        rules.add(res);
        logger.debug("abc_getUserInputRules:" + this.userInputTargetFormId);
        return rules;
    }

    private void genUserInputTrueRule_MustInput(List<Map<String, Object>> trueActions) {
        List mustInputKeys = this.userInputContent.entrySet().stream().filter(u -> WfConsts.UserInputContentType.MUSTINPUT.getValue().equals(u.getValue())).map(u -> (String)u.getKey()).collect(Collectors.toList());
        if (!mustInputKeys.isEmpty()) {
            HashMap<String, Object> actionMapDefault = new HashMap<String, Object>(1);
            actionMapDefault.put("actionType", ActionTypeEnum.Normal.getValue());
            actionMapDefault.put("fieldName", mustInputKeys);
            trueActions.add(actionMapDefault);
            HashMap<String, Object> actionMapMustInput = new HashMap<String, Object>(1);
            actionMapMustInput.put("actionType", ActionTypeEnum.MustInput.getValue());
            actionMapMustInput.put("fieldName", mustInputKeys);
            trueActions.add(actionMapMustInput);
        }
    }

    private void genUserInputTrueRule_ReadOnly(List<Map<String, Object>> trueActions) {
        List readOnlyKeys = this.userInputContent.entrySet().stream().filter(u -> WfConsts.UserInputContentType.READONLY.getValue().equals(u.getValue())).map(u -> (String)u.getKey()).collect(Collectors.toList());
        if (!readOnlyKeys.isEmpty()) {
            HashMap<String, Object> actionMapDefault = new HashMap<String, Object>(1);
            actionMapDefault.put("actionType", ActionTypeEnum.Readonly.getValue());
            actionMapDefault.put("fieldName", readOnlyKeys);
            trueActions.add(actionMapDefault);
            HashMap<String, Object> actionMapNotMustInput = new HashMap<String, Object>(1);
            actionMapNotMustInput.put("actionType", ActionTypeEnum.NonMustInput.getValue());
            actionMapNotMustInput.put("fieldName", readOnlyKeys);
            trueActions.add(actionMapNotMustInput);
        }
    }

    private void genUserInputTrueRule_Hidden(List<Map<String, Object>> trueActions, FormMetadata formmeta) {
        HashSet<String> keysToHide = new HashSet<String>(10);
        HashSet<String> keysToUnMustInput = new HashSet<String>(10);
        for (ControlAp item : formmeta.getItems()) {
            if (item instanceof NoCodeBillFormAp) continue;
            keysToHide.add(item.getKey());
            if (!(item instanceof FieldAp)) continue;
            keysToUnMustInput.add(item.getKey());
        }
        List showKeysSetting = this.userInputContent.entrySet().stream().filter(u -> !WfConsts.UserInputContentType.HIDDEN.getValue().equals(u.getValue())).map(u -> (String)u.getKey()).collect(Collectors.toList());
        keysToHide.removeAll(showKeysSetting);
        keysToUnMustInput.removeAll(showKeysSetting);
        if (!keysToHide.isEmpty()) {
            HashMap<String, Object> actionMapHidden = new HashMap<String, Object>(1);
            actionMapHidden.put("actionType", ActionTypeEnum.Hidden.getValue());
            actionMapHidden.put("fieldName", keysToHide);
            trueActions.add(actionMapHidden);
        }
        if (!keysToUnMustInput.isEmpty()) {
            HashMap<String, Object> actionMapNotMustInput = new HashMap<String, Object>(1);
            actionMapNotMustInput.put("actionType", ActionTypeEnum.NonMustInput.getValue());
            actionMapNotMustInput.put("fieldName", keysToUnMustInput);
            trueActions.add(actionMapNotMustInput);
        }
    }

    private void genUserInputTrueRule_Disabled(List<Map<String, Object>> trueActions) {
        List desabledKeys = this.userInputContent.entrySet().stream().filter(u -> WfConsts.UserInputContentType.DISABLED.getValue().equals(u.getValue())).map(u -> (String)u.getKey()).collect(Collectors.toList());
        if (!desabledKeys.isEmpty()) {
            HashMap<String, Object> actionMapHidden = new HashMap<String, Object>(1);
            actionMapHidden.put("actionType", ActionTypeEnum.Disabled.getValue());
            actionMapHidden.put("fieldName", desabledKeys);
            trueActions.add(actionMapHidden);
            HashMap<String, Object> actionMapNotMustInput = new HashMap<String, Object>(1);
            actionMapNotMustInput.put("actionType", ActionTypeEnum.NonMustInput.getValue());
            actionMapNotMustInput.put("fieldName", desabledKeys);
            trueActions.add(actionMapNotMustInput);
        }
    }

    private void genUserInputTrueRule_Default(List<Map<String, Object>> trueActions) {
        List defaultKeys = this.userInputContent.entrySet().stream().filter(u -> WfConsts.UserInputContentType.DEFAULT.getValue().equals(u.getValue())).map(u -> (String)u.getKey()).collect(Collectors.toList());
        if (!defaultKeys.isEmpty()) {
            HashMap<String, Object> actionMapNormal = new HashMap<String, Object>(1);
            actionMapNormal.put("actionType", ActionTypeEnum.Normal.getValue());
            actionMapNormal.put("fieldName", defaultKeys);
            trueActions.add(actionMapNormal);
            HashMap<String, Object> actionMapNotMustInput = new HashMap<String, Object>(1);
            actionMapNotMustInput.put("actionType", ActionTypeEnum.NonMustInput.getValue());
            actionMapNotMustInput.put("fieldName", defaultKeys);
            trueActions.add(actionMapNotMustInput);
        }
    }
}

