/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.form.control.NoCodeRefBillTableGrid;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;
import kd.bos.nocode.mservice.NoCodeDefValueCalculatorService;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.rule.NoCodeBR;
import kd.bos.nocode.servicehelper.ServiceFactory;
import kd.bos.nocode.utils.BlackFormUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class QueryFormExecutor {
    private static final Log logger = LogFactory.getLog(QueryFormExecutor.class);
    private NoCodeBR br;
    private FormRuleExecuteContext executeContext;
    private IDataModel model;

    public QueryFormExecutor(NoCodeBR br, FormRuleExecuteContext executeContext) {
        this.br = br;
        this.executeContext = executeContext;
        this.model = executeContext.getModel();
    }

    public void execute() {
        try (EntityTraceSpan span = EntityTracer.create((String)"QueryFormExecutor", (String)"execute");){
            String expression = this.br.getPreCondition();
            NoCodeDefValueCalculatorService defValueCalculatorService = (NoCodeDefValueCalculatorService)ServiceFactory.getService((String)"NoCodeDefValueCalculatorService");
            span.addTag("expression", expression);
            Map resultMap = defValueCalculatorService.getQueryFormRecord(expression, (RaiseEventSource)this.executeContext.getRaiseEventSources().get(0), this.model);
            logger.debug("resultMap is {}, expression = {}", (Object)SerializationUtils.toJsonString((Object)resultMap), (Object)expression);
            if (resultMap == null) {
                return;
            }
            span.addLocaleTag("resultMap", (Object)resultMap);
            for (Map.Entry entry : resultMap.entrySet()) {
                NoCodeProp prop;
                if (this.model.getProperty((String)entry.getKey()) == null) continue;
                IDataEntityProperty property = this.model.getProperty((String)entry.getKey());
                if (property instanceof NoCodeRefBillProp) {
                    prop = (NoCodeProp)property;
                    if (property.getParent() instanceof EntryType) {
                        if (this.model.getEntryRowCount(property.getParent().getName()) <= 0) continue;
                        prop.setDBValue(this.model, (String)entry.getKey(), entry.getValue(), this.model.getEntryCurrentRowIndex(property.getParent().getName()));
                        continue;
                    }
                    prop.setDBValue(this.model, (String)entry.getKey(), entry.getValue());
                    continue;
                }
                if (property instanceof NoCodeProp) {
                    Object value;
                    prop = (NoCodeProp)property;
                    if (property.getParent() instanceof EntryType) {
                        if (this.model.getEntryRowCount(property.getParent().getName()) <= 0) continue;
                        value = prop.formatDefValue(entry.getValue());
                        prop.setDBValue(this.model, (String)entry.getKey(), value, this.model.getEntryCurrentRowIndex(property.getParent().getName()));
                        continue;
                    }
                    value = prop.formatDefValue(entry.getValue());
                    prop.setDBValue(this.model, (String)entry.getKey(), value);
                    continue;
                }
                if (property instanceof NoCodeRefBillTableProp) {
                    Object pk;
                    prop = (NoCodeRefBillTableProp)property;
                    String key = prop.getRefBillKey();
                    if (entry.getValue() instanceof DynamicObject) {
                        DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                        pk = dynamicObject.getPkValue();
                    } else {
                        pk = entry.getValue();
                    }
                    if (this.isCopyData((NoCodeRefBillTableProp)prop)) {
                        this.copyRefTableData(pk, key, prop.getName());
                        continue;
                    }
                    IDataEntityProperty refBillProp = this.model.getProperty(key);
                    if (refBillProp instanceof NoCodeProp) {
                        ((NoCodeProp)refBillProp).setDBValue(this.model, key, pk);
                    } else {
                        this.model.setValue(key, pk);
                    }
                    DynamicObjectCollection collection = this.model.getEntryEntity(prop.getName());
                    collection.clear();
                    this.model.updateEntryCache(collection);
                    this.executeContext.getView().updateView(prop.getName());
                    continue;
                }
                this.model.setValue((String)entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            try (EntityTraceSpan span2 = EntityTracer.create((String)"QueryFormExecutor", (String)"execute");){
                span2.throwException((Throwable)e);
            }
        }
    }

    private boolean isCopyData(NoCodeRefBillTableProp property) {
        if ("1".equals(property.getSourceForm())) {
            return true;
        }
        if (BlackFormUtil.isCosmicForm((String)property.getBillEntityIdEx())) {
            return false;
        }
        return false;
    }

    private void copyRefTableData(Object pk, String refBillKey, String tableKey) {
        IDataEntityProperty refBillProp = this.model.getProperty(refBillKey);
        ((NoCodeProp)refBillProp).setDBValue(this.model, refBillKey, null);
        DynamicObjectCollection collection = this.model.getEntryEntity(tableKey);
        collection.clear();
        this.model.updateEntryCache(collection);
        NoCodeRefBillTableGrid grid = (NoCodeRefBillTableGrid)this.executeContext.getView().getControl(tableKey);
        List fieldKeys = grid.getFieldKeys();
        ArrayList objs = new ArrayList();
        String[] pkArray = pk.toString().split(",");
        ArrayList<Long> pkList = new ArrayList<Long>(10);
        INoCodeRefBillProp prop = (INoCodeRefBillProp)refBillProp;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)prop.getBillEntityId());
        for (int i = 0; i < pkArray.length; ++i) {
            pkList.add(Long.parseLong(pkArray[i]));
        }
        DynamicObject[] objArray = BusinessDataServiceHelper.load((Object[])pkList.toArray(new Object[0]), (DynamicObjectType)entityType);
        Collections.addAll(objs, objArray);
        grid.fillTableData(collection, objs, fieldKeys, true, new DynamicObjectCollection());
        this.executeContext.getView().updateView(tableKey);
    }
}

