/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.nocode.mservice.NoCodeDefValueCalculatorService;
import kd.bos.nocode.servicehelper.ServiceFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class RelationFormExecutor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DynamicObject[] load(Map<String, Object> configs, IDataModel model, String target, Set<Object> pks, String selectField) {
        try (EntityTraceSpan span = EntityTracer.create((String)"RelationFormExecutor", (String)"load");){
            String top = (String)configs.getOrDefault("top", "1");
            int t = Integer.parseInt(top);
            List filterInfos = configs.getOrDefault("filterInfos", Collections.emptyList());
            NoCodeDefValueCalculatorService service = (NoCodeDefValueCalculatorService)ServiceFactory.getService((String)"NoCodeDefValueCalculatorService");
            service.parseExpression(filterInfos, model);
            QFilter[] filters = service.getFilters(filterInfos, target);
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(Arrays.asList(filters));
            QFilter filter = new QFilter("id", "in", pks);
            filterList.add(filter);
            List sortInfos = configs.getOrDefault("sortInfos", Collections.emptyList());
            StringBuilder orderByBuilder = new StringBuilder();
            String orderBy = "";
            if (sortInfos != null) {
                for (Map map : sortInfos) {
                    String number = (String)map.get("number");
                    Boolean isAsc = (Boolean)map.get("isAsc");
                    if (!StringUtils.isNotBlank((CharSequence)number) || isAsc == null) continue;
                    String sortType = isAsc != false ? "asc" : "desc";
                    orderByBuilder.append(number).append(" ").append(sortType).append(",");
                }
                orderBy = StringUtils.removeEnd((String)orderByBuilder.toString(), (String)",");
            }
            if (StringUtils.isBlank((CharSequence)orderBy)) {
                orderBy = "id desc";
            }
            span.addLocaleTag("formId", (Object)target);
            span.addLocaleTag("selectField", (Object)selectField);
            DynamicObject[] cols = BusinessDataServiceHelper.load((String)target, (String)selectField, (QFilter[])filterList.toArray(new QFilter[0]), (String)orderBy, (int)t);
            span.addLocaleTag("dataEntities", (Object)cols);
            DynamicObject[] dynamicObjectArray = cols;
            return dynamicObjectArray;
        }
        catch (Exception e) {
            try (EntityTraceSpan span2 = EntityTracer.create((String)"RelationFormExecutor", (String)"load");){
                span2.throwException((Throwable)e);
                return null;
            }
        }
    }

    protected Object tryParseNumberId(String input) {
        try {
            return Long.parseLong(input);
        }
        catch (Exception e) {
            return input;
        }
    }
}

