/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.rule;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.rule.RelationFormExecutor;

public class RelationFormMultiExecutor
extends RelationFormExecutor {
    private FormRuleExecuteContext executeContext;
    private IDataModel model;

    public RelationFormMultiExecutor(FormRuleExecuteContext executeContext) {
        this.executeContext = executeContext;
        this.model = executeContext.getModel();
    }

    public void execute(Map<String, Object> configs, String target, Object value) {
        if (target == null) {
            return;
        }
        List result = (List)configs.get("result");
        IFormView view = this.executeContext.getView();
        if (StringUtils.isBlank((Object)value)) {
            this.fillValueByMulRef(result, target, null, view);
            return;
        }
        Set<Object> pks = Arrays.stream(value.toString().split(",")).filter(StringUtils::isNotEmpty).map(this::tryParseNumberId).collect(Collectors.toSet());
        if (pks.isEmpty()) {
            this.fillValueByMulRef(result, target, null, view);
            return;
        }
        DynamicObject[] cols = this.load(configs, this.model, target, pks, "id");
        this.fillValueByMulRef(result, target, cols, view);
    }

    private void fillValueByMulRef(List<Map<String, Object>> result, String target, DynamicObject[] cols, IFormView view) {
        for (Map<String, Object> map : result) {
            String key;
            INoCodeRefBillProp property;
            IDataEntityProperty p;
            String targetField = (String)map.get("targetField");
            if (StringUtils.isNotBlank((CharSequence)targetField) && targetField.contains(".")) {
                targetField = targetField.split("\\.")[1];
            }
            if ((p = this.model.getProperty(targetField)) instanceof NoCodeMulRefBillProp) {
                if (p.getParent() instanceof EntryType && this.model.getEntryRowCount(p.getParent().getName()) <= 0 || !target.equals(((NoCodeMulRefBillProp)p).getBillEntityId())) continue;
                this.setMulRefBillValue(cols, p, targetField);
                continue;
            }
            if (!(p instanceof NoCodeRefBillTableProp) || !((property = (INoCodeRefBillProp)this.model.getProperty(key = ((NoCodeRefBillTableProp)p).getRefBillKey())) instanceof NoCodeMulRefBillProp) || !target.equals(property.getBillEntityId())) continue;
            this.setMulRefBillValue(cols, (IDataEntityProperty)property, key);
            DynamicObjectCollection collection = this.model.getEntryEntity(p.getName());
            collection.clear();
            this.model.updateEntryCache(collection);
            view.updateView(p.getName());
        }
    }

    private void setMulRefBillValue(DynamicObject[] cols, IDataEntityProperty property, String key) {
        if (cols == null) {
            ((NoCodeMulRefBillProp)property).setDBValue(this.model, key, null);
        } else {
            List collect = Arrays.stream(cols).map(DataEntityBase::getPkValue).map(String::valueOf).collect(Collectors.toList());
            ((NoCodeMulRefBillProp)property).setDBValue(this.model, key, (Object)String.join((CharSequence)",", collect));
        }
    }
}

