/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.rule;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;
import kd.bos.nocode.rule.RelationFormExecutor;

public class RelationFormSingleExecutor
extends RelationFormExecutor {
    private static final String FBASEDATAID = "fbasedataid";
    private FormRuleExecuteContext executeContext;
    private IDataModel model;

    public RelationFormSingleExecutor(FormRuleExecuteContext executeContext) {
        this.executeContext = executeContext;
        this.model = executeContext.getModel();
    }

    public void execute(Map<String, Object> configs, String refId, Object pk, String relationFormKey) {
        List result = (List)configs.get("result");
        String selectField = "id,";
        HashSet<String> newSelectSet = new HashSet<String>(result.size());
        HashMap<String, Set<String>> fieldMapping = new HashMap<String, Set<String>>(result.size());
        StringBuilder selectFieldBuilder = new StringBuilder(selectField);
        for (Map map : result) {
            String sourceField = (String)map.get("sourceField");
            String targetField = (String)map.get("targetField");
            if (StringUtils.isNotBlank((CharSequence)targetField) && targetField.indexOf(".") != -1) {
                targetField = targetField.split("\\.")[1];
            }
            if (sourceField.contains(relationFormKey + ".")) {
                sourceField = sourceField.substring(relationFormKey.length() + 1);
            }
            if (!newSelectSet.contains(sourceField) && !"currentRecord".equals(sourceField)) {
                if (sourceField.indexOf(FBASEDATAID) != -1) {
                    String[] chars = sourceField.split("\\.");
                    if (chars.length == 3) {
                        selectFieldBuilder.append(chars[0]).append(",");
                    } else if (chars.length == 4) {
                        selectFieldBuilder.append(chars[0]).append(".").append(chars[1]).append(",");
                    }
                } else {
                    selectFieldBuilder.append(sourceField).append(",");
                }
            }
            newSelectSet.add(sourceField);
            Set<String> targetFields = new HashSet<String>();
            if (fieldMapping.containsKey(sourceField)) {
                targetFields = (Set)fieldMapping.get(sourceField);
            }
            targetFields.add(targetField);
            fieldMapping.put(sourceField, targetFields);
        }
        selectField = selectFieldBuilder.toString();
        selectField = selectField.substring(0, selectField.length() - 1);
        if (StringUtils.isBlank((Object)pk)) {
            this.fillValueByMulField(fieldMapping, null);
            return;
        }
        Set<Object> pks = Arrays.stream(pk.toString().split(",")).filter(StringUtils::isNotEmpty).map(this::tryParseNumberId).collect(Collectors.toSet());
        if (pks.isEmpty()) {
            this.fillValueByMulField(fieldMapping, null);
            return;
        }
        DynamicObject[] cols = this.load(configs, this.model, refId, pks, selectField);
        if (cols.length == 0) {
            this.fillValueByMulField(fieldMapping, null);
            return;
        }
        DynamicObject col = cols[0];
        this.fillValueByMulField(fieldMapping, col);
    }

    private void fillValueByMulField(Map<String, Set<String>> fieldMapping, DynamicObject col) {
        for (Map.Entry<String, Set<String>> entry : fieldMapping.entrySet()) {
            String sourceField = entry.getKey();
            Set<String> targetFields = entry.getValue();
            for (String targetField : targetFields) {
                Object value;
                String editableKey;
                String string = editableKey = this.model.getContextVariable("nocode_current_editable_fieldkey") == null ? null : this.model.getContextVariable("nocode_current_editable_fieldkey").toString();
                if (targetField.equals(editableKey)) {
                    return;
                }
                if (this.model.getProperty(targetField) == null) continue;
                IDataEntityProperty property = this.model.getProperty(targetField);
                if (property instanceof NoCodeRefBillTableProp) {
                    String key = ((NoCodeRefBillTableProp)property).getRefBillKey();
                    if ("currentRecord".equals(sourceField)) {
                        sourceField = "id";
                    }
                    value = NoCodeProp.getDisplayValue((DynamicObject)col, (String)sourceField, (IDataEntityProperty)this.model.getProperty(key));
                    IDataEntityProperty p = this.model.getProperty(key);
                    ((NoCodeProp)p).setDBValue(this.model, key, value);
                    DynamicObjectCollection collection = this.model.getEntryEntity(property.getName());
                    collection.clear();
                    this.model.updateEntryCache(collection);
                    this.executeContext.getView().updateView(property.getName());
                    continue;
                }
                if (property.getParent() != null && property.getParent() instanceof EntryType) {
                    IDataEntityProperty p = this.model.getProperty(property.getParent().getName());
                    DynamicObjectCollection collection = this.model.getEntryEntity(p.getName());
                    for (int i = 0; i < collection.size(); ++i) {
                        NoCodeProp prop = (NoCodeProp)property;
                        if (col == null) {
                            prop.setDBValue(this.model, targetField, null, i);
                            continue;
                        }
                        if ("currentRecord".equals(sourceField)) {
                            sourceField = "id";
                        }
                        Object value2 = null;
                        if (sourceField.indexOf(FBASEDATAID) != -1) {
                            String[] fields = sourceField.split("\\.");
                            DynamicObjectCollection attObjs = col.getDynamicObjectCollection(fields[0]);
                            if (!attObjs.isEmpty()) {
                                List objs = NoCodeProp.sortAttachment((DynamicObjectCollection)attObjs);
                                DynamicObject obj = ((DynamicObject)objs.get(0)).getDynamicObject(FBASEDATAID);
                                value2 = prop.formatDefValue(obj.get(fields[2]));
                            }
                        } else {
                            value2 = prop.formatDefValue(NoCodeProp.getDisplayValue((DynamicObject)col, (String)sourceField, (IDataEntityProperty)this.model.getProperty(targetField)));
                        }
                        prop.setDBValue(this.model, targetField, value2, i);
                    }
                    continue;
                }
                if (!(property instanceof NoCodeProp)) continue;
                NoCodeProp prop = (NoCodeProp)property;
                if (col == null) {
                    prop.setDBValue(this.model, targetField, null);
                    continue;
                }
                if ("currentRecord".equals(sourceField)) {
                    sourceField = "id";
                }
                value = null;
                if (sourceField.indexOf(FBASEDATAID) != -1) {
                    String[] fields = sourceField.split("\\.");
                    DynamicObjectCollection attObjs = null;
                    if (fields.length == 3) {
                        attObjs = col.getDynamicObjectCollection(fields[0]);
                    } else if (fields.length == 4) {
                        attObjs = col.getDynamicObject(fields[0]).getDynamicObjectCollection(fields[1]);
                    }
                    if (attObjs != null && !attObjs.isEmpty()) {
                        List objs = NoCodeProp.sortAttachment((DynamicObjectCollection)attObjs);
                        DynamicObject obj = ((DynamicObject)objs.get(0)).getDynamicObject(FBASEDATAID);
                        if (fields.length == 3) {
                            value = prop.formatDefValue(obj.get(fields[2]));
                        } else if (fields.length == 4) {
                            value = prop.formatDefValue(obj.get(fields[3]));
                        }
                    }
                } else {
                    value = prop.formatDefValue(NoCodeProp.getDisplayValue((DynamicObject)col, (String)sourceField, (IDataEntityProperty)this.model.getProperty(targetField)));
                }
                prop.setDBValue(this.model, targetField, value);
            }
        }
    }
}

