/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.nocode.expression.NoCodeCalcExprParser;
import kd.bos.nocode.ext.property.NoCodeAttachmentProp;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;
import kd.bos.nocode.rule.NoCodeBR;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TableFormulaBizRuleExecutor {
    private NoCodeBR br;
    private FormRuleExecuteContext executeContext;
    private IDataModel model;

    public TableFormulaBizRuleExecutor(NoCodeBR br, FormRuleExecuteContext executeContext) {
        this.br = br;
        this.executeContext = executeContext;
        this.model = executeContext.getModel();
    }

    /*
     * WARNING - void declaration
     */
    public void execute(ExpressionParameter parameter, String[] currentKey) {
        try (EntityTraceSpan span = EntityTracer.create((String)"TableFormulaBizRuleExecutor", (String)"execute");){
            if (currentKey.length > 2) {
                return;
            }
            IDataEntityProperty property = this.model.getProperty(currentKey[0]);
            if (!(property instanceof NoCodeRefBillTableProp)) {
                return;
            }
            NoCodeRefBillTableProp table = (NoCodeRefBillTableProp)property;
            String refBillKey = table.getRefBillKey();
            if (StringUtils.isBlank((CharSequence)refBillKey)) {
                return;
            }
            IDataEntityProperty refBillProp = this.model.getProperty(refBillKey);
            if (refBillProp == null) {
                return;
            }
            HashMap<String, Object> var = new HashMap<String, Object>(16);
            String depKeys = this.br.getDepFldKeys();
            if (StringUtils.isBlank((CharSequence)depKeys)) {
                this.calcFormulaValue(parameter, currentKey, var);
                return;
            }
            IDataEntityProperty affectProp = this.model.getProperty(currentKey[1]);
            boolean isFormulaExpression = true;
            if (parameter.getExpression().equalsIgnoreCase(depKeys)) {
                isFormulaExpression = false;
            }
            String[] deptKeyArray = depKeys.split(",");
            boolean headFieldExists = false;
            ArrayList<String> tableFields = new ArrayList<String>(10);
            for (String string : deptKeyArray) {
                if (string.indexOf(".") == -1) {
                    void var20_47;
                    Object object = this.model.getValue(string);
                    IDataEntityProperty p = this.model.getProperty(string);
                    if (p instanceof NoCodeProp) {
                        IDataEntityProperty sourceProp = p;
                        if (!isFormulaExpression) {
                            sourceProp = affectProp;
                        }
                        Object object2 = ((NoCodeProp)p).getDBValue(object, sourceProp);
                    }
                    var.put(string, var20_47);
                    headFieldExists = true;
                    continue;
                }
                String[] stringArray = string.split("\\.");
                if (stringArray[0].equals(currentKey[0])) {
                    IDataEntityProperty property1 = this.model.getProperty(stringArray[1]);
                    if (property1 instanceof NoCodeAttachmentProp) {
                        tableFields.add(string);
                        continue;
                    }
                    tableFields.add(stringArray[1]);
                    continue;
                }
                headFieldExists = true;
                Object obj = this.model.getDataEntity().get(stringArray[0]);
                IDataEntityProperty property1 = this.model.getProperty(stringArray[0]);
                if (property1 instanceof NoCodeAttachmentProp) {
                    DynamicObjectCollection col = this.model.getDataEntity().getDynamicObjectCollection(stringArray[0]);
                    if (col.isEmpty()) {
                        var.put(string, null);
                        continue;
                    }
                    List objs = NoCodeProp.sortAttachment((DynamicObjectCollection)col);
                    DynamicObject attObj = ((DynamicObject)objs.get(0)).getDynamicObject("fbasedataid");
                    var.put(string, attObj.get(stringArray[2]));
                    continue;
                }
                if (obj == null) {
                    var.put(string, null);
                    continue;
                }
                if (obj instanceof DynamicObject) {
                    DynamicObject dynamicObject = (DynamicObject)obj;
                    IDataEntityProperty sourceProp = this.getSourceProp(isFormulaExpression, affectProp, stringArray[1], dynamicObject.getDynamicObjectType());
                    var.put(string, NoCodeProp.getDisplayValue((DynamicObject)dynamicObject, (String)stringArray[1], (IDataEntityProperty)sourceProp));
                    continue;
                }
                span.addLocaleTag("obj:", obj);
                String pks = obj.toString();
                if (StringUtils.isBlank((CharSequence)pks)) {
                    var.put(string, null);
                    continue;
                }
                String[] pkArray = pks.split(",");
                ArrayList<Long> pkList = new ArrayList<Long>(10);
                NoCodeMulRefBillProp prop = (NoCodeMulRefBillProp)this.model.getProperty(stringArray[0]);
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)prop.getBillEntityId());
                for (int i = 0; i < pkArray.length; ++i) {
                    pkList.add(Long.parseLong(pkArray[i]));
                }
                DynamicObject[] cols = BusinessDataServiceHelper.load((Object[])pkList.toArray(new Object[0]), (DynamicObjectType)entityType);
                IDataEntityProperty sourceProp = this.getSourceProp(isFormulaExpression, affectProp, stringArray[1], cols[0].getDynamicObjectType());
                String val = Arrays.stream(cols).map(o -> NoCodeProp.getDisplayValue((DynamicObject)o, (String)fieldSplits[1], (IDataEntityProperty)sourceProp) == null ? " " : NoCodeProp.getDisplayValue((DynamicObject)o, (String)fieldSplits[1], (IDataEntityProperty)sourceProp)).map(Object::toString).collect(Collectors.joining(","));
                var.put(string, val);
            }
            DynamicObjectCollection collection = this.model.getEntryEntity(currentKey[0]);
            if (this.executeContext.getDataEntities().get(0) instanceof ChangeData || "ItemReset".equals(((RaiseEventSource)this.executeContext.getRaiseEventSources().get(0)).getRaiseEventType().name())) {
                if (headFieldExists) {
                    for (int i = 0; i < collection.size(); ++i) {
                        DynamicObject dy = (DynamicObject)collection.get(i);
                        for (String string : tableFields) {
                            this.fillTableFieldVal(string, var, dy, currentKey, isFormulaExpression);
                        }
                        this.calcFormulaValue(parameter, currentKey, var, i);
                    }
                } else {
                    DynamicObject dy = (DynamicObject)collection.get(parameter.getRowIndex());
                    for (String string : tableFields) {
                        this.fillTableFieldVal(string, var, dy, currentKey, isFormulaExpression);
                    }
                    this.calcFormulaValue(parameter, currentKey, var);
                }
            } else {
                if (collection.isEmpty()) {
                    return;
                }
                DynamicObject dy = (DynamicObject)collection.get(parameter.getRowIndex());
                for (String string : tableFields) {
                    this.fillTableFieldVal(string, var, dy, currentKey, isFormulaExpression);
                }
                this.calcFormulaValue(parameter, currentKey, var);
            }
        }
        catch (Exception exc) {
            try (EntityTraceSpan span2 = EntityTracer.create((String)"TableFormulaBizRuleExecutor", (String)"execute");){
                span2.throwException((Throwable)exc);
            }
        }
    }

    private IDataEntityProperty getSourceProp(boolean isFormulaExpression, IDataEntityProperty affectProp, String fieldKey, DynamicObjectType entityType) {
        DynamicProperty sourceProp = entityType.getProperty(fieldKey);
        if (!isFormulaExpression) {
            sourceProp = affectProp;
        }
        return sourceProp;
    }

    private void fillTableFieldVal(String key, Map<String, Object> var, DynamicObject dy, String[] currentKey, boolean isFormulaExpression) {
        if (key.indexOf(".") != -1) {
            String[] chars = key.split("\\.");
            IDataEntityProperty property1 = this.model.getProperty(chars[1]);
            if (property1 instanceof NoCodeAttachmentProp) {
                DynamicObjectCollection col = dy.getDynamicObjectCollection(chars[1]);
                if (col.isEmpty()) {
                    var.put(key, null);
                    return;
                }
                if (chars.length == 4) {
                    List objs = NoCodeProp.sortAttachment((DynamicObjectCollection)col);
                    DynamicObject obj = ((DynamicObject)objs.get(0)).getDynamicObject("fbasedataid");
                    var.put(key, obj.get(chars[3]));
                } else {
                    var.put(key, col);
                }
                return;
            }
        } else {
            IDataEntityProperty affectProp = this.model.getProperty(currentKey[1]);
            IDataEntityProperty sourceProp = this.getSourceProp(isFormulaExpression, affectProp, key, dy.getDynamicObjectType());
            var.put(currentKey[0] + "." + key, NoCodeProp.getDisplayValue((DynamicObject)dy, (String)key, (IDataEntityProperty)sourceProp));
        }
    }

    private void calcFormulaValue(ExpressionParameter parameter, String[] currentKey, Map<String, Object> var) {
        try (EntityTraceSpan span = EntityTracer.create((String)"TableFormulaBizRuleExecutor", (String)"calcFormulaValue");){
            span.addLocaleTag("var1:", var);
            span.addTag("index1:", parameter.getRowIndex() + "");
            Object val = NoCodeCalcExprParser.getExpressionValue(parameter, var);
            span.addLocaleTag("val1:", val);
            IDataEntityProperty property = this.model.getProperty(currentKey[1]);
            if (property != null) {
                if (property instanceof NoCodeProp) {
                    NoCodeProp prop = (NoCodeProp)property;
                    Object value = prop.formatDefValue(val);
                    prop.setDBValue(this.model, currentKey[1], value, parameter.getRowIndex());
                } else {
                    this.model.setValue(currentKey[1], val, parameter.getRowIndex());
                }
            }
        }
        catch (Exception e) {
            try (EntityTraceSpan span2 = EntityTracer.create((String)"TableFormulaBizRuleExecutor", (String)"calcFormulaValue");){
                span2.throwException((Throwable)e);
            }
        }
    }

    private void calcFormulaValue(ExpressionParameter parameter, String[] currentKey, Map<String, Object> var, int index) {
        try (EntityTraceSpan span = EntityTracer.create((String)"TableFormulaBizRuleExecutor", (String)"calcFormulaValue");){
            span.addLocaleTag("var:", var);
            span.addTag("index:", index + "");
            Object val = NoCodeCalcExprParser.getExpressionValue(parameter, var);
            span.addLocaleTag("val:", val);
            IDataEntityProperty property = this.model.getProperty(currentKey[1]);
            if (property != null) {
                if (property instanceof NoCodeProp) {
                    NoCodeProp prop = (NoCodeProp)property;
                    Object value = prop.formatDefValue(val);
                    prop.setDBValue(this.model, currentKey[1], value, index);
                } else {
                    this.model.setValue(currentKey[1], val, index);
                }
            }
        }
        catch (Exception e) {
            try (EntityTraceSpan span2 = EntityTracer.create((String)"TableFormulaBizRuleExecutor", (String)"calcFormulaValue");){
                span2.throwException((Throwable)e);
            }
        }
    }
}

