/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.nocode.ext.metadata.form.control.NoCodeBizButtonAp;
import kd.bos.nocode.utils.NcEntityTypeUtil;

public class BizButtonUtil {
    private BizButtonUtil() {
        throw new IllegalStateException("BizButtonUtil class");
    }

    public static List<NoCodeBizButtonAp> getBizButtonsDesignMeta(String formId) {
        ArrayList<NoCodeBizButtonAp> result = new ArrayList<NoCodeBizButtonAp>();
        if (NcEntityTypeUtil.isFormExist((String)formId)) {
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
            List bizButtons = formMetadata.getItems().stream().filter(i -> i instanceof NoCodeBizButtonAp).sorted(Comparator.comparingInt(ControlAp::getIndex)).collect(Collectors.toList());
            for (ControlAp bizButton : bizButtons) {
                NoCodeBizButtonAp noCodeBizButtonAp = (NoCodeBizButtonAp)bizButton;
                result.add(noCodeBizButtonAp);
            }
        }
        return result;
    }

    public static NoCodeBizButtonAp getBizButtonDesignMeta(String formId, String btnKey) {
        List<NoCodeBizButtonAp> bizButtonsDesignMeta = BizButtonUtil.getBizButtonsDesignMeta(formId);
        for (NoCodeBizButtonAp noCodeBizButtonAp : bizButtonsDesignMeta) {
            if (!noCodeBizButtonAp.getKey().equalsIgnoreCase(btnKey)) continue;
            return noCodeBizButtonAp;
        }
        return null;
    }
}

