/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.IFormView;
import kd.bos.nocode.ext.operation.validate.NoCodeFieldValidator;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;

public class FieldRequiredValidateUtil {
    private IFormView formView;
    private String operationKey;

    public FieldRequiredValidateUtil(IFormView formView, String operationKey) {
        this.formView = formView;
        this.operationKey = operationKey;
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String str = metadataService.loadFormRuntimeMeta(formView.getEntityId(), RuntimeMetaType.Form.getValue(), formView.getEntityId());
        if (StringUtils.isNotBlank((CharSequence)str)) {
            Map formMetas = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
            List items = (List)formMetas.get("Items");
            ArrayList<String> fields = new ArrayList<String>();
            this.addHiddenFieldsByGroup(items, false, fields);
            formView.getPageCache().put("nocodehiddenfields", SerializationUtils.toJsonString(fields));
        }
    }

    private void addHiddenFieldsByGroup(List<Map<String, Object>> list, boolean isHide, List<String> fields) {
        if (list == null) {
            return;
        }
        List<String> containers = Arrays.asList("TabPage", "AdvContainer", "Container", "NoCodeRefBillTableGrid");
        for (Map<String, Object> map : list) {
            String fieldKey;
            if (containers.contains(map.get("_Type_").toString())) {
                List hideState;
                boolean isChildrenHide;
                List children;
                String fieldKey2 = map.get("Key") == null ? null : map.get("Key").toString();
                if (StringUtils.isBlank((CharSequence)fieldKey2) || (children = (List)map.get("Items")) == null) continue;
                if (isHide) {
                    this.addHiddenFieldsByGroup(children, true, fields);
                    continue;
                }
                boolean bl = isChildrenHide = map.get("Status") == null ? false : "4".equals(map.get("Status"));
                if (!isChildrenHide) {
                    Map stateMap = new HashMap();
                    String stateStr = this.formView.getPageCache().get("nocodefieldstatemap");
                    if (StringUtils.isNotBlank((CharSequence)stateStr)) {
                        stateMap = (Map)SerializationUtils.fromJsonString((String)stateStr, Map.class);
                    }
                    if (stateMap.containsKey(fieldKey2) && !"1".equals(stateMap.get(fieldKey2))) {
                        isChildrenHide = true;
                    }
                }
                if ((hideState = Arrays.stream(new String[]{"2", "3", "4"}).collect(Collectors.toList())).contains(map.get("Status")) && "NoCodeRefBillTableGrid".equals(map.get("_Type_").toString())) {
                    fields.add(fieldKey2);
                }
                this.addHiddenFieldsByGroup(children, isChildrenHide, fields);
                continue;
            }
            if ("Toolbar".equals(map.get("_Type_"))) continue;
            List hideState = Arrays.stream(new String[]{"2", "3", "4"}).collect(Collectors.toList());
            if (!isHide && !hideState.contains(map.get("Status")) || !StringUtils.isNotBlank((CharSequence)(fieldKey = map.get("Key") == null ? null : map.get("Key").toString()))) continue;
            if ("NoCodeDateRangeField".equals(map.get("FieldType"))) {
                fields.add(fieldKey + "_startdate");
                continue;
            }
            fields.add(fieldKey);
        }
    }

    public Tuple<Boolean, OperationResult> doValidate(OperateOption option) {
        Map operateMetaMap = EntityMetadataCache.getDataEntityOperate((String)this.formView.getEntityId(), (String)this.operationKey);
        NoCodeFieldValidator validator = this.createFieldValidator();
        if (validator == null) {
            return new Tuple((Object)true, null);
        }
        ValidateContext validateContext = this.createValidateContext(option, operateMetaMap);
        String entityNumber = validateContext.getEntityNumber();
        validator.setEntityKey(entityNumber);
        ExtendedDataEntitySet entitySet = validateContext.getExtendedDataEntitySet();
        validator.setValidateContext(validateContext);
        validator.setExtendedDataEntitySet(entitySet);
        ExtendedDataEntity[] array = entitySet.FindByEntityKey(validator.getEntityKey());
        validator.setDataEntities(array);
        ValidateResultCollection validateResults = new ValidateResultCollection();
        validateContext.setValidateResults(validateResults);
        validator.validateFieldRequired(this.formView);
        ValidateResult res = validator.getValidateResult();
        return this.processValidateResult(validateResults, res);
    }

    private Tuple<Boolean, OperationResult> processValidateResult(ValidateResultCollection validateResults, ValidateResult res) {
        Boolean result = true;
        if (!res.isSuccess()) {
            result = false;
            boolean isExist = false;
            ArrayList<String> errMsgs = new ArrayList<String>();
            for (ValidateResult rs : validateResults.getValidateErrors()) {
                for (OperateErrorInfo operInfo : rs.getAllErrorInfo()) {
                    String errMsg = operInfo.getMessage();
                    errMsgs.add(errMsg);
                }
            }
            for (OperateErrorInfo operInfo : res.getAllErrorInfo()) {
                String errMsg = operInfo.getMessage();
                if (!errMsgs.contains(errMsg)) continue;
                isExist = true;
                break;
            }
            if (!isExist) {
                validateResults.addValidateError(this.getOpName(), res);
            }
        }
        OperationResult operationResult = new OperationResult();
        operationResult.setValidateResult(validateResults);
        operationResult.setSuccess(false);
        operationResult.setMessage(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"FieldRequiredValidateUtil_0", (String)"bos-nocode-core", (Object[])new Object[0]));
        return new Tuple((Object)result, (Object)operationResult);
    }

    private NoCodeFieldValidator createFieldValidator() {
        Map operateMetaMap = EntityMetadataCache.getDataEntityOperate((String)this.formView.getEntityId(), (String)this.operationKey);
        String operateType = (String)operateMetaMap.get("type");
        String operateName = this.getOpName();
        List validationMeta = (List)operateMetaMap.get("validations");
        NoCodeFieldValidator validator = null;
        for (Map validatorMap : validationMeta) {
            String validatorClass;
            if (!((Boolean)validatorMap.get("enabled")).booleanValue() || StringUtils.isBlank((CharSequence)(validatorClass = (String)validatorMap.get("class"))) || validatorClass.indexOf("NoCodeFieldValidator") == -1) continue;
            validator = (NoCodeFieldValidator)TypesContainer.createInstance((String)validatorClass);
            validator.setValidation(validatorMap);
            validator.setOperateKey(this.operationKey);
            validator.setOperationName(operateName);
            validator.setOperateType(operateType);
            Object levelId = validatorMap.get("levelId");
            String errorLevelStr = levelId != null ? levelId.toString() : "";
            ErrorLevel errorLevel = ErrorLevel.values()[Integer.parseInt(errorLevelStr)];
            validator.setErrorLevel(errorLevel);
        }
        return validator;
    }

    private ValidateContext createValidateContext(OperateOption option, Map<String, Object> operateMetaMap) {
        ExtendedDataEntitySet extendDataEntitySet = new ExtendedDataEntitySet();
        DynamicObject[] dataEntities = new DynamicObject[]{this.formView.getModel().getDataEntity(true)};
        if (dataEntities != null && dataEntities.length > 0) {
            extendDataEntitySet.Parse(dataEntities, (MainEntityType)dataEntities[0].getDataEntityType());
        }
        List validationMeta = (List)operateMetaMap.get("validations");
        ValidateContext validateContext = new ValidateContext(validationMeta, this.formView.getEntityId(), this.operationKey, extendDataEntitySet);
        MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)this.formView.getEntityId());
        validateContext.setBillEntityType(billEntityType);
        validateContext.setSubEntityType(billEntityType);
        validateContext.setValidatePrefix(null);
        validateContext.setOperateMetaMap(operateMetaMap);
        validateContext.setOption(option);
        return validateContext;
    }

    public String getOpName() {
        Map operateMetaMap = EntityMetadataCache.getDataEntityOperate((String)this.formView.getEntityId(), (String)this.operationKey);
        String operationName = this.operationKey;
        if (operateMetaMap == null || !operateMetaMap.containsKey("name")) {
            return operationName;
        }
        Map opName = (Map)operateMetaMap.get("name");
        if (opName.containsKey(ResManager.getLanguage())) {
            operationName = (String)opName.get(ResManager.getLanguage());
        } else {
            Object zh_cn = opName.get("zh_CN");
            if (zh_cn != null) {
                operationName = (String)zh_cn;
            }
        }
        return operationName;
    }
}

