/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.dao.DesignerData;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.nocode.design.NoCodeDesignerData;
import kd.bos.nocode.mservice.NoCodeRuleService;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveRowErrorData;
import kd.bos.nocode.servicehelper.ServiceFactory;
import kd.bos.nocode.util.MenuMetaUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.MapUtils;

public class FormMetaUtils {
    private static final Log log = LogFactory.getLog(FormMetaUtils.class);
    protected static final String MODEL_TYPE = "modelType";
    protected static final String NAME = "name";
    protected static final String NUMBER = "number";
    private static final String ID = "id";
    private static final String ID2 = "Id";
    private static final String ENTITY_ID = "EntityId";
    private static final String NO_CODE_DESIGNER_DATA_SERVICE = "nocode_DesignerDataService";
    private static final String SUCCESS = "success";
    private static final String ERRORS = "errors";
    private static final String BOD_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String DUPLICATEENTRY = "Duplicate entry";
    private static final String BIZ_APPID = "bizappid";
    private static final String TEMPLATEID = "templateId";
    private static final String BIZAPP = "bizapp";
    private static final String BIZUNIT = "bizunit";
    private static final String FORM = "form";
    private static final String FORM_META = "formmeta";
    private static final String ENTITY_META = "entitymeta";
    private static final String ITEMS = "Items";
    private static final String TABLE_NAME = "TableName";
    private static final String MENU_INFO = "menuInfo";

    public static void createModel(Map<String, Object> parameters, RestApiSaveItemData saveItemData) {
        Map<String, Object> content;
        Throwable throwable;
        TXHandle tx;
        boolean custom;
        String number;
        String bizAppId;
        block32: {
            block33: {
                block34: {
                    bizAppId = (String)parameters.get(BIZ_APPID);
                    number = (String)parameters.get(ID);
                    custom = (Boolean)parameters.getOrDefault("custom", false);
                    if (custom) {
                        parameters.put(MODEL_TYPE, "DynamicFormModel");
                    } else {
                        parameters.put(MODEL_TYPE, "NoCodeModel");
                    }
                    tx = TX.required((String)NO_CODE_DESIGNER_DATA_SERVICE);
                    throwable = null;
                    content = null;
                    Map<String, Object> saveResult = null;
                    NoCodeDesignerData designerData = new NoCodeDesignerData();
                    boolean fromTemplate = false;
                    if (parameters.get(TEMPLATEID) != null) {
                        content = FormMetaUtils.createFromTemplate(parameters, content, designerData, bizAppId);
                        fromTemplate = true;
                    }
                    if (content == null) {
                        content = designerData.createBlankModel(parameters);
                    }
                    content.put(ID, number);
                    Map formMeta = (Map)content.get(FORM_META);
                    formMeta.put(ID2, number);
                    formMeta.put(ENTITY_ID, number);
                    Map entityMeta = (Map)content.get(ENTITY_META);
                    entityMeta.put(ID2, number);
                    if (!custom) {
                        List entityItems = (List)entityMeta.get(ITEMS);
                        Map noCodeBillEntity = (Map)entityItems.get(0);
                        noCodeBillEntity.put(TABLE_NAME, String.format("%s%s", "t_nc_", number));
                    }
                    if (fromTemplate) {
                        content.put("fromTemplate", true);
                        saveResult = designerData.save(content, true, false);
                    } else if (custom) {
                        DesignerData d = new DesignerData();
                        d.save(content);
                    } else {
                        saveResult = designerData.save(content, false, false);
                    }
                    if (saveResult == null || saveResult.get(SUCCESS) == null || !Boolean.FALSE.equals(saveResult.get(SUCCESS)) || saveResult.get(ERRORS) == null) break block32;
                    saveItemData.setBillStatus(false);
                    RestApiSaveRowErrorData restApiSaveRowErrorData = new RestApiSaveRowErrorData();
                    HashSet<String> msgs = new HashSet<String>(1);
                    msgs.add(((ErrorInfo)((ArrayList)saveResult.get(ERRORS)).get(0)).getError());
                    restApiSaveRowErrorData.setRowMsg(msgs);
                    saveItemData.getErrors().add(restApiSaveRowErrorData);
                    if (tx == null) break block33;
                    if (throwable == null) break block34;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block33;
                }
                tx.close();
            }
            return;
        }
        try {
            RestApiSaveRowErrorData restApiSaveRowErrorData;
            String msg;
            try {
                String formId = (String)content.get(ID);
                AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId, (boolean)false);
                AppFunctionPacketElement appFunctionPacketElement = (AppFunctionPacketElement)appMetadata.getAppFunctionPackets().get(0);
                String bizUnitId = appFunctionPacketElement.getId();
                DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
                dObject.set(BIZAPP, (Object)bizAppId);
                dObject.set(BIZUNIT, (Object)bizUnitId);
                dObject.set(FORM, (Object)formId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
                Map menuInfo = (Map)parameters.get(MENU_INFO);
                if (parameters.containsKey("enabled") && menuInfo != null) {
                    menuInfo.put("enabled", parameters.get("enabled"));
                }
                String name = (String)parameters.get(NAME);
                if (MapUtils.isNotEmpty((Map)menuInfo)) {
                    menuInfo.put("custom", custom);
                    MenuMetaUtils.saveMenuInfo(name, formId, appMetadata, menuInfo);
                }
                saveItemData.setId(formId);
                saveItemData.setNumber(number);
                saveItemData.setBillStatus(true);
            }
            catch (NullPointerException exception) {
                log.warn((Throwable)exception);
                tx.markRollback();
                saveItemData.setBillStatus(false);
                msg = ResManager.loadKDString((String)"\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u8c03\u7528\u94fe", (String)"FormMetaUtils_0", (String)BOD_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                if (msg.contains(DUPLICATEENTRY)) {
                    msg = ResManager.loadKDString((String)"\u8be5\u8868\u5355\u7f16\u7801\u3010", (String)"FormMetaUtils_1", (String)BOD_DEVPORTAL_PLUGIN, (Object[])new Object[0]) + number + ResManager.loadKDString((String)"bos-nocode-core", (String)"FormMetaUtils_3", (String)BOD_DEVPORTAL_PLUGIN, (Object[])new Object[0]) + msg;
                }
                restApiSaveRowErrorData = new RestApiSaveRowErrorData();
                HashSet<String> msgs = new HashSet<String>(1);
                msgs.add(msg);
                restApiSaveRowErrorData.setRowMsg(msgs);
                saveItemData.getErrors().add(restApiSaveRowErrorData);
            }
            catch (Exception e) {
                log.warn((Throwable)e);
                tx.markRollback();
                saveItemData.setBillStatus(false);
                msg = e.getMessage();
                if (e.getMessage().contains(DUPLICATEENTRY)) {
                    msg = ResManager.loadKDString((String)"\u8be5\u8868\u5355\u7f16\u7801\u3010", (String)"FormMetaUtils_1", (String)BOD_DEVPORTAL_PLUGIN, (Object[])new Object[0]) + number + ResManager.loadKDString((String)"bos-nocode-core", (String)"FormMetaUtils_3", (String)BOD_DEVPORTAL_PLUGIN, (Object[])new Object[0]) + msg;
                }
                restApiSaveRowErrorData = new RestApiSaveRowErrorData();
                HashSet<String> msgs = new HashSet<String>(1);
                msgs.add(msg);
                restApiSaveRowErrorData.setRowMsg(msgs);
                saveItemData.getErrors().add(restApiSaveRowErrorData);
            }
        }
        catch (Throwable e) {
            throwable = e;
            throw e;
        }
        catch (Throwable throwable3) {
            throw throwable3;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable e) {
                        throwable.addSuppressed(e);
                    }
                } else {
                    tx.close();
                }
            }
        }
        if (parameters.get(TEMPLATEID) != null) {
            Object templateid = parameters.get(TEMPLATEID);
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)templateid, (String)"bos_nocode_templateconfig");
            String src = dy.getString("formid");
            NoCodeRuleService ruleService = (NoCodeRuleService)ServiceFactory.getService((String)"NoCodeRuleService");
            ruleService.copyRules(src, number);
        }
    }

    private static Map<String, Object> createFromTemplate(Map<String, Object> parameters, Map<String, Object> content, NoCodeDesignerData designerData, String bizAppId) {
        Object templateid = parameters.get(TEMPLATEID);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)templateid, (String)"bos_nocode_templateconfig");
        if (dy != null) {
            String formid = dy.getString("formid");
            Map metadata = MetadataDao.loadDesignerMetadata((String)formid, (String)RequestContext.get().getLang().toString());
            String number = (String)parameters.get(ID);
            FormMetadata formMeta = designerData.generateTemplateMeta(metadata, number);
            formMeta.getEntityMetadata().getRootEntity().setTemplate(false);
            String key = (String)parameters.get(ID);
            Object objName = parameters.get(NAME);
            LocaleString name = null;
            if (objName instanceof LocaleString) {
                name = (LocaleString)objName;
            } else if (objName instanceof OrmLocaleValue) {
                HashMap<String, String> localNameMap = new HashMap<String, String>(16);
                for (String loId : ((OrmLocaleValue)objName).keySet()) {
                    localNameMap.put(loId, ((OrmLocaleValue)objName).get((Object)loId));
                }
                name = LocaleString.fromMap(localNameMap);
            } else {
                name = new LocaleString("zh_CN", (String)objName);
            }
            formMeta.setKey(key);
            formMeta.setName(name);
            FormMetaUtils.setUpAppId(bizAppId, formMeta);
            content = formMeta.buildDesignMeta("zh_CN");
            Map em = (Map)content.get(ENTITY_META);
            List entityItems = (List)em.get(ITEMS);
            Map noCodeBillEntity = (Map)entityItems.get(0);
            noCodeBillEntity.remove(TABLE_NAME);
            Map fm = (Map)content.get(FORM_META);
            List fromItems = (List)fm.get(ITEMS);
            Map noCodeBillForm = (Map)fromItems.get(0);
            noCodeBillForm.remove(TABLE_NAME);
        } else {
            log.debug("template:" + templateid + "not found");
        }
        return content;
    }

    private static void setUpAppId(String bizAppId, FormMetadata formMeta) {
        if (!bizAppId.equals(formMeta.getBizappId())) {
            formMeta.setBizappId(bizAppId);
            EntityMetadata entityMeta = formMeta.getEntityMetadata();
            entityMeta.setBizappId(bizAppId);
        }
    }
}

