/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.util;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.NameVersionEntryProp;
import kd.bos.lang.Lang;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.nocode.cache.NoCodeCacheService;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.constant.FieldStatusEnum;
import kd.bos.nocode.ext.constant.ValueMapItemVO;
import kd.bos.nocode.ext.metadata.NoCodeBillEntityType;
import kd.bos.nocode.ext.metadata.entity.NoCodeRefBillTable;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeAttachmentUploadField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDateRangeField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDecimalField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeMulRefBillField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeSelectItemField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeTextAreaField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeTextField;
import kd.bos.nocode.ext.metadata.entity.helper.DispProp;
import kd.bos.nocode.ext.pojo.NoCodeFilterField;
import kd.bos.nocode.ext.property.NoCodeAttachmentProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;
import kd.bos.nocode.ext.util.ComboItemUtils;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.metadata.IDateFormatSupport;
import kd.bos.nocode.metadata.INoCodeRefBillField;
import kd.bos.nocode.restapi.api.model.ListFilterRequestBO;
import kd.bos.nocode.restapi.common.constant.NoCodeEnvironmentEnum;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ListConfigUtils {
    public static final String NUMBER = "number";
    public static final String LIST_ITEM_CONFIG = "listItemConfig";
    public static final String LIST_TREE_CONFIG = "listTreeConfig";
    public static final String LIST_FILTER_CONFIG = "listFilterConfig";
    private static final String PARENT = "parent";
    private static final String ROOT_PARENT_NUMBER = "0";

    private ListConfigUtils() {
    }

    public static long getDBUserIdByEnv(String env) {
        NoCodeEnvironmentEnum noCodeEnvironmentEnum = NoCodeEnvironmentEnum.getByCode((String)env);
        if (noCodeEnvironmentEnum == NoCodeEnvironmentEnum.DESIGN) {
            return 0L;
        }
        return RequestContext.get().getCurrUserId();
    }

    public static long getDBUserIdByEnv(NoCodeEnvironmentEnum env) {
        if (env == NoCodeEnvironmentEnum.DESIGN) {
            return 0L;
        }
        return RequestContext.get().getCurrUserId();
    }

    public static QFilter[] getQFilters(String appId, String formId, long userId) {
        QFilter appFilter = new QFilter("appid", "=", (Object)appId);
        QFilter formFilter = new QFilter("formid", "=", (Object)formId);
        QFilter userFilter = new QFilter("userid", "=", (Object)userId);
        return new QFilter[]{appFilter, formFilter, userFilter};
    }

    public static QFilter[] getQFiltersByEnv(String appId, String formId, NoCodeEnvironmentEnum env) {
        if (env == NoCodeEnvironmentEnum.DESIGN) {
            return ListConfigUtils.getQFilters(appId, formId, 0L);
        }
        return ListConfigUtils.getQFilters(appId, formId, RequestContext.get().getCurrUserId());
    }

    public static QFilter[] getRuntimeQFilter(ListFilterRequestBO requestBO) {
        return ListConfigUtils.getQFilters(requestBO.getAppId(), requestBO.getFormId(), requestBO.getUserId());
    }

    public static QFilter[] getDesignQFilter(ListFilterRequestBO requestBO) {
        return ListConfigUtils.getQFilters(requestBO.getAppId(), requestBO.getFormId(), 0L);
    }

    public static QFilter[] getQFilterByEnv(ListFilterRequestBO requestBO, String env) {
        if (NoCodeEnvironmentEnum.DESIGN.getCode().equalsIgnoreCase(env)) {
            return ListConfigUtils.getDesignQFilter(requestBO);
        }
        return ListConfigUtils.getRuntimeQFilter(requestBO);
    }

    public static void clearNoExistField(String formId, List<Map<String, Object>> rows) {
        ListConfigUtils.clearNoExistField(formId, rows, "fieldName");
    }

    public static void clearNoExistField(String formId, List<Map<String, Object>> rows, String fieldNameKey) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        String entityNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)formId);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Iterator<Map<String, Object>> iterator = rows.iterator();
        List hideFields = FormMetadataUtils.getHideFields((String)formId, (boolean)true);
        Set noViewFieldPermSet = NoCodePermHelper.getNoViewFieldPermSet((String)entityNumber);
        while (iterator.hasNext()) {
            Map<String, Object> row = iterator.next();
            String fieldName = (String)row.get(fieldNameKey);
            if (hideFields.contains(fieldName)) {
                iterator.remove();
                continue;
            }
            if (!NcEntityTypeUtil.existProperty((DynamicObjectType)dt, (String)fieldName)) {
                iterator.remove();
                continue;
            }
            if (!noViewFieldPermSet.contains(fieldName)) continue;
            iterator.remove();
        }
    }

    public static Map<String, IDataEntityProperty> getDirectFields(String formId) {
        return ListConfigUtils.getDirectFields(formId, false);
    }

    public static Map<String, IDataEntityProperty> getDirectFields(String formId, boolean expandRefBill) {
        return ListConfigUtils.getDirectFields(formId, expandRefBill, new ArrayList<String>());
    }

    private static List<IDataEntityProperty> sortAndFilterProperties(String formId, List<String> fieldKeys) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)NcEntityTypeUtil.getRealBillEntityNumber((String)formId));
        if (fieldKeys.isEmpty()) {
            return NcEntityTypeUtil.getDisplayProperties((MainEntityType)dt);
        }
        ArrayList<IDataEntityProperty> props = new ArrayList<IDataEntityProperty>();
        for (String fieldKey : fieldKeys) {
            DynamicProperty prop = dt.getProperty(fieldKey);
            if (prop == null) continue;
            props.add((IDataEntityProperty)prop);
        }
        return props;
    }

    public static Map<String, IDataEntityProperty> getDirectFields(String formId, boolean expandRefBill, List<String> fieldKeys) {
        String entityNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)formId);
        if (!NcEntityTypeUtil.isFormExist((String)entityNumber)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"ListConfigUtils_0", (String)"bos-nocode-core", (Object[])new Object[0]));
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityNumber);
        List<IDataEntityProperty> properties = ListConfigUtils.sortAndFilterProperties(formId, fieldKeys);
        LinkedHashMap<String, IDataEntityProperty> newFields = new LinkedHashMap<String, IDataEntityProperty>(properties.size());
        List hideFields = FormMetadataUtils.getHideFields((String)dt.getName(), (boolean)true);
        for (IDataEntityProperty property : properties) {
            String fieldName = property.getName();
            boolean isValid = ListConfigUtils.checkProperty(hideFields, property, newFields);
            if (!isValid) continue;
            if (property instanceof NoCodeRefBillProp && expandRefBill) {
                newFields.put(fieldName, property);
                NoCodeRefBillProp prop = (NoCodeRefBillProp)property;
                DataEntityPropertyCollection props = prop.getBillEntityType().getProperties();
                for (IDataEntityProperty p : props) {
                    if (!prop.getPropsDisplay().contains(p.getName()) || !(isValid = ListConfigUtils.checkProperty(hideFields, p, newFields))) continue;
                    newFields.put(prop.getName() + "." + p.getName(), p);
                }
                continue;
            }
            newFields.put(fieldName, property);
        }
        return newFields;
    }

    private static boolean checkProperty(List<String> hideFields, IDataEntityProperty property, Map<String, IDataEntityProperty> newFields) {
        String fieldName = property.getName();
        if (WfConsts.WfLockStatusEnum.LOCK_STATUS_KEY.equalsIgnoreCase(fieldName)) {
            return false;
        }
        if (hideFields.contains(fieldName)) {
            return false;
        }
        if (property instanceof IFieldHandle && ((IFieldHandle)property).isSysField()) {
            return false;
        }
        if (property instanceof NameVersionEntryProp) {
            return false;
        }
        if (property instanceof DynamicLocaleProperty) {
            return false;
        }
        if (property instanceof NoCodeRefBillTableProp) {
            return false;
        }
        if (property instanceof EntryProp) {
            newFields.putIfAbsent(fieldName, property);
            return false;
        }
        return true;
    }

    public static List<Map<String, Object>> getListItemConfig(String formId) {
        String cacheKey = String.format("nocode:listItemConfig:%s", formId);
        String listItemConfigStr = NoCodeCacheService.getInstance().get(cacheKey);
        if (StringUtils.isNotEmpty((CharSequence)listItemConfigStr)) {
            return SerializationUtils.fromJsonStringToList((String)listItemConfigStr, Map.class);
        }
        List<Map<String, Object>> listItemConfig = ListConfigUtils.getListItemConfig(formId, false);
        NoCodeCacheService.getInstance().put(cacheKey, SerializationUtils.toJsonString(listItemConfig));
        return listItemConfig;
    }

    public static List<Map<String, Object>> getListItemConfig(String formId, boolean expandRefBill) {
        return ListConfigUtils.getListItemConfig(formId, expandRefBill, new ArrayList<String>());
    }

    public static List<Map<String, Object>> getListItemConfig(String formId, boolean expandRefBill, List<String> fieldKeys) {
        Map<String, IDataEntityProperty> fields = ListConfigUtils.getDirectFields(formId, expandRefBill, fieldKeys);
        List<Map<String, Object>> listItemConfig = fields.entrySet().stream().map(ListConfigUtils::castToListItem).collect(Collectors.toList());
        ListConfigUtils.addExtraFields(formId, listItemConfig);
        return listItemConfig;
    }

    public static List<Map<String, Object>> getListTreeConfig(String formId, List<Map<String, Object>> listItemConfig, boolean isShare) {
        listItemConfig = ListConfigUtils.copyListItemConfig(formId, listItemConfig, isShare);
        List formClientItems = NcEntityTypeUtil.getFormClientItems((String)formId);
        Map<String, String> key2ParentKey = ListConfigUtils.getKey2ParentKey(formClientItems, ROOT_PARENT_NUMBER);
        for (Map<String, Object> listItem : listItemConfig) {
            listItem.put(PARENT, key2ParentKey.getOrDefault((String)listItem.get(NUMBER), ROOT_PARENT_NUMBER));
        }
        List<Map<String, Object>> groupItems = ListConfigUtils.getGroupItems(formClientItems);
        for (Map<String, Object> item : groupItems) {
            int firstIndex = ListConfigUtils.findFirstFieldItemIndex(listItemConfig, (String)item.get(NUMBER));
            if (firstIndex == -1) continue;
            listItemConfig.add(firstIndex, item);
        }
        for (Map<String, Object> groupItem : groupItems) {
            groupItem.put(PARENT, key2ParentKey.getOrDefault((String)groupItem.get(NUMBER), ROOT_PARENT_NUMBER));
        }
        return ListConfigUtils.buildListTreeConfig(listItemConfig);
    }

    private static int findFirstFieldItemIndex(List<Map<String, Object>> listItemConfig, String groupNumber) {
        for (int i = 0; i < listItemConfig.size(); ++i) {
            Map<String, Object> item = listItemConfig.get(i);
            if (!Objects.equals(groupNumber, item.get(PARENT))) continue;
            return i;
        }
        return -1;
    }

    private static List<Map<String, Object>> copyListItemConfig(String formId, List<Map<String, Object>> listItemConfig, boolean isShare) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(listItemConfig.size());
        Set hides = NoCodePermHelper.getNoViewFieldPermSet((String)formId);
        for (Map<String, Object> listItem : listItemConfig) {
            String field = (String)listItem.get(NUMBER);
            if (!isShare && (hides.contains(field) || field.endsWith("_startdate") && hides.contains(field.replace("_startdate", "")) || field.endsWith("_enddate") && hides.contains(field.replace("_enddate", "")))) continue;
            result.add(listItem);
        }
        return result;
    }

    private static List<Map<String, Object>> buildListTreeConfig(List<Map<String, Object>> listItemConfig) {
        Map<String, List<Map>> parent2Children = listItemConfig.stream().collect(Collectors.groupingBy(e -> (String)e.get(PARENT)));
        listItemConfig.forEach(e -> e.put("children", parent2Children.getOrDefault((String)e.get(NUMBER), new ArrayList(0))));
        return listItemConfig.stream().filter(e -> e.get(PARENT).equals(ROOT_PARENT_NUMBER)).collect(Collectors.toList());
    }

    private static List<Map<String, Object>> getGroupItems(List<Map<String, Object>> formClientItems) {
        ArrayList<Map<String, Object>> groupItems = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> formClientItem : formClientItems) {
            if (!"groupcontainer".equalsIgnoreCase((String)formClientItem.get("type"))) continue;
            String key = (String)formClientItem.get("id");
            String name = (String)((Map)formClientItem.get("text")).get(Lang.get().getLocale().toString());
            HashMap<String, String> item = new HashMap<String, String>();
            item.put(NUMBER, key);
            item.put("name", name);
            item.put("type", "group");
            groupItems.add(item);
            groupItems.addAll(ListConfigUtils.getGroupItems((List)formClientItem.get("items")));
        }
        return groupItems;
    }

    private static Map<String, String> getKey2ParentKey(List<Map<String, Object>> formClientItems, String parentKey) {
        HashMap<String, String> key2ParentKey = new HashMap<String, String>(64);
        for (Map<String, Object> formClientItem : formClientItems) {
            String key = (String)formClientItem.get("id");
            if (StringUtils.isBlank((CharSequence)key)) continue;
            String fieldType = (String)formClientItem.get("FieldType");
            if ("NoCodeDateRangeField".equalsIgnoreCase(fieldType)) {
                key2ParentKey.put(key + "_startdate", parentKey);
                key2ParentKey.put(key + "_enddate", parentKey);
            } else {
                key2ParentKey.put(key, parentKey);
            }
            if (!"groupcontainer".equalsIgnoreCase((String)formClientItem.get("type"))) continue;
            key2ParentKey.putAll(ListConfigUtils.getKey2ParentKey((List)formClientItem.get("items"), key));
        }
        return key2ParentKey;
    }

    public static Set<String> sureSelectSet(String entityNumber) {
        return ListConfigUtils.sureSelectSet(entityNumber, new ArrayList<String>());
    }

    public static Set<String> sureSelectSet(String entityNumber, List<String> fieldKeys) {
        Map<String, IDataEntityProperty> directFields = ListConfigUtils.getDirectFields(entityNumber, false, fieldKeys);
        StringBuilder sb = new StringBuilder();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        ISimpleProperty primaryKeyProp = mainEntityType.getPrimaryKey();
        sb.append(primaryKeyProp.getName());
        for (IDataEntityProperty property : directFields.values()) {
            if (ListConfigUtils.skip(primaryKeyProp, property)) continue;
            sb.append(",").append(property.getName());
        }
        String[] splitFields = sb.toString().split(",");
        HashSet<String> selectSet = new HashSet<String>(splitFields.length);
        Collections.addAll(selectSet, splitFields);
        return selectSet;
    }

    public static boolean skip(ISimpleProperty primaryKeyProp, IDataEntityProperty property) {
        if (property instanceof NoCodeAttachmentProp) {
            return false;
        }
        if (property instanceof EntryProp) {
            return false;
        }
        return property instanceof DataEntityProperty || property instanceof DynamicCollectionProperty || property.equals(primaryKeyProp);
    }

    public static Map<String, Object> castToListItem(Map.Entry<String, IDataEntityProperty> entry) {
        HashMap<String, Object> listItem = new HashMap<String, Object>(4);
        listItem.put(NUMBER, entry.getKey());
        LocaleString displayName = entry.getValue().getDisplayName();
        String caption = "";
        if (Objects.nonNull(displayName)) {
            caption = displayName.getLocaleValue();
        }
        if (entry.getKey().contains(".") && entry.getValue().getParent() instanceof NoCodeBillEntityType) {
            caption = entry.getValue().getParent().getDisplayName().getLocaleValue() + "." + caption;
        }
        listItem.put("name", caption);
        listItem.put("display", true);
        listItem.put("locked", false);
        return listItem;
    }

    private static void addExtraFields(String formId, List<Map<String, Object>> fields) {
        JSONArray dispProps = new JSONArray(fields.size());
        fields.stream().map(ListConfigUtils::wrap2DispProp).forEach(arg_0 -> ((JSONArray)dispProps).add(arg_0));
        ListConfigUtils.addExtraFieldsForRefBill(formId, dispProps);
        Map<String, DispProp> number2DispProp = dispProps.stream().collect(Collectors.toMap(e -> ((DispProp)e).getProperyKey(), e -> (DispProp)e));
        fields.forEach(f -> {
            String number = (String)f.get(NUMBER);
            DispProp dispProp = (DispProp)number2DispProp.get(number);
            f.put("type", dispProp.getType());
            f.put("items", dispProp.getItems());
            f.put("isMulti", dispProp.isMulti());
            f.put("formatType", dispProp.getFormatType());
            f.put("entityId", dispProp.getEntityId());
            f.put("displayProp", dispProp.getDisplayProp());
            f.put("filterFields", dispProp.getFilterFields());
            f.put("precision", dispProp.getPrecision());
            f.put("scale", dispProp.getScale());
            f.put("dataRange", dispProp.getDataRange());
            f.put("status", dispProp.getStatus());
            f.put("maxLength", dispProp.getMaxLength());
            f.put("innerTable", dispProp.isInnerTable());
        });
    }

    private static DispProp wrap2DispProp(Map<String, Object> itemMap) {
        String number = (String)itemMap.get(NUMBER);
        String name = (String)itemMap.get("name");
        DispProp dispProp = new DispProp();
        dispProp.setProperyKey(number);
        dispProp.setPropertyCaption(name);
        return dispProp;
    }

    public static void addExtraFieldsForRefBill(String formId, JSONArray fields) {
        formId = NcEntityTypeUtil.getRealBillEntityId((String)formId);
        String formNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)formId);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Entity);
        List entityItems = entityMetadata.getItems();
        HashMap<String, EntityItem> key2Item = new HashMap<String, EntityItem>(entityItems.size());
        for (EntityItem item : entityItems) {
            if (item instanceof NoCodeDateRangeField) {
                NoCodeDateRangeField dateRangeField = (NoCodeDateRangeField)item;
                key2Item.put(dateRangeField.getStartDateFieldKey(), item);
                key2Item.put(dateRangeField.getEndDateFieldKey(), item);
                continue;
            }
            key2Item.put(item.getKey(), item);
        }
        Map fieldKey2Status = FormMetadataUtils.getFieldKey2Status((String)formId);
        Set noEditFieldPermSet = NoCodePermHelper.getNoEditFieldPermSet((String)formId);
        fields.forEach(e -> {
            DispProp f = (DispProp)e;
            EntityItem item = (EntityItem)key2Item.get(f.getProperyKey());
            if (Objects.nonNull(item)) {
                ComboField field;
                f.setType(item.getClass().getSimpleName().toLowerCase());
                if (item instanceof ComboField) {
                    field = (ComboField)item;
                    f.setItems(ComboItemUtils.buildComboItemsVOByComboItems((List)field.getItems()));
                    if (item instanceof NoCodeSelectItemField) {
                        f.setMulti(((NoCodeSelectItemField)field).isMulti());
                    }
                } else if (item instanceof INoCodeRefBillField) {
                    String refTableKey;
                    field = (INoCodeRefBillField)item;
                    f.setEntityId(field.getBillEntityId());
                    f.setDisplayProp(field.getPropsDisplay());
                    f.setMulti(field.isMultiSelect());
                    if (item instanceof NoCodeMulRefBillField && StringUtils.isNotEmpty((CharSequence)(refTableKey = ((NoCodeMulRefBillField)item).getRefTableKey()))) {
                        NoCodeRefBillTable table = (NoCodeRefBillTable)key2Item.get(refTableKey);
                        f.setInnerTable(table != null && "1".equals(table.getSourceForm()));
                    }
                } else if (item instanceof IDateFormatSupport) {
                    f.setFormatType(((IDateFormatSupport)item).getFormatType());
                } else if (item instanceof NoCodeAttachmentUploadField) {
                    f.setFilterFields(ListConfigUtils.getAttachmentFilterFields((NoCodeAttachmentUploadField)item));
                } else if (item instanceof NoCodeDecimalField) {
                    NoCodeDecimalField decimalField = (NoCodeDecimalField)item;
                    f.setPrecision(decimalField.getPrecision());
                    f.setScale(decimalField.getScale());
                    f.setDataRange(decimalField.getDataRange());
                } else if (item instanceof NoCodeTextAreaField) {
                    f.setMaxLength(((NoCodeTextAreaField)item).getMaxLength());
                }
                String fieldKey = ListConfigUtils.getKey(f);
                if (noEditFieldPermSet.contains(fieldKey)) {
                    f.setStatus(FieldStatusEnum.HIDDEN.getCode());
                } else {
                    f.setStatus(fieldKey2Status.getOrDefault(fieldKey, FieldStatusEnum.NORMAL.getCode()));
                }
            }
        });
    }

    private static String getKey(DispProp f) {
        if (f.getType().equalsIgnoreCase(NoCodeDateRangeField.class.getSimpleName().toLowerCase())) {
            int lastIndex = f.getProperyKey().lastIndexOf("_");
            return f.getProperyKey().substring(0, lastIndex);
        }
        return f.getProperyKey();
    }

    private static List<NoCodeFilterField> getAttachmentFilterFields(NoCodeAttachmentUploadField item) {
        ArrayList subFieldSuffixList = Lists.newArrayList((Object[])new String[]{".fbasedataid.size", ".fbasedataid.name", ".fbasedataid.type"});
        ArrayList subFieldSuffixNameList = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)".\u5927\u5c0f", (String)"ListConfigUtils_1", (String)"bos-nocode-core", (Object[])new Object[0]), ResManager.loadKDString((String)".\u540d\u79f0", (String)"ListConfigUtils_2", (String)"bos-nocode-core", (Object[])new Object[0]), ResManager.loadKDString((String)".\u7c7b\u578b", (String)"ListConfigUtils_3", (String)"bos-nocode-core", (Object[])new Object[0])});
        ArrayList subFieldSuffixTypeList = Lists.newArrayList((Object[])new String[]{ListConfigUtils.getTypeByClass(NoCodeDecimalField.class), ListConfigUtils.getTypeByClass(NoCodeTextField.class), ListConfigUtils.getTypeByClass(NoCodeSelectItemField.class)});
        ArrayList<NoCodeFilterField> targetFilterFields = new ArrayList<NoCodeFilterField>(4);
        for (int i = 0; i < subFieldSuffixList.size(); ++i) {
            String suffix = (String)subFieldSuffixList.get(i);
            String suffixName = (String)subFieldSuffixNameList.get(i);
            String suffixType = (String)subFieldSuffixTypeList.get(i);
            NoCodeFilterField noCodeFilterField = new NoCodeFilterField();
            noCodeFilterField.setNumber(item.getKey() + suffix);
            noCodeFilterField.setName(item.getName().getLocaleValue() + suffixName);
            noCodeFilterField.setType(suffixType);
            targetFilterFields.add(noCodeFilterField);
        }
        return targetFilterFields;
    }

    private static String getTypeByClass(Class<?> clazz) {
        return clazz.getSimpleName().toLowerCase();
    }

    public static Map<String, IDataEntityProperty> getAllFields(String formId) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        Map fields = dt.getAllFields();
        LinkedHashMap<String, IDataEntityProperty> newFields = new LinkedHashMap<String, IDataEntityProperty>(fields.size());
        List hideFields = FormMetadataUtils.getHideFields((String)dt.getName(), (boolean)true);
        for (IDataEntityProperty property : fields.values()) {
            String fieldName = property.getName();
            if (hideFields.contains(fieldName) || property instanceof IFieldHandle && ((IFieldHandle)property).isSysField()) continue;
            newFields.put(fieldName, property);
        }
        return newFields;
    }

    public static String buildOrderInfo(List<Map<String, Object>> orderInfo) {
        if (CollectionUtils.isEmpty(orderInfo)) {
            return "id desc";
        }
        return orderInfo.stream().map(ListConfigUtils::toComposite).collect(Collectors.joining(","));
    }

    private static String toComposite(Map<String, Object> fieldSortInfo) {
        Boolean isAsc;
        String number = (String)fieldSortInfo.get(NUMBER);
        if (fieldSortInfo.containsKey("isAsc") && !(isAsc = (Boolean)fieldSortInfo.getOrDefault("isAsc", Boolean.TRUE)).booleanValue()) {
            return number + " desc";
        }
        if (fieldSortInfo.containsKey("asc") && !(isAsc = (Boolean)fieldSortInfo.getOrDefault("asc", Boolean.TRUE)).booleanValue()) {
            return number + " desc";
        }
        return number;
    }

    public static List<Map<String, Object>> getWfNodeApproverListConfig() {
        ArrayList<Map<String, Object>> listItemConfig = new ArrayList<Map<String, Object>>(2);
        listItemConfig.add(ListConfigUtils.buildListItem("fieldName", ResManager.loadKDString((String)"\u8282\u70b9\u5185\u5bb9", (String)"ListConfigUtils_4", (String)"bos-nocode-core", (Object[])new Object[0]), NoCodeTextField.class.getSimpleName().toLowerCase()));
        listItemConfig.add(ListConfigUtils.buildListItem("fieldType", ResManager.loadKDString((String)"\u8282\u70b9\u5185\u5bb9\u7c7b\u578b", (String)"ListConfigUtils_5", (String)"bos-nocode-core", (Object[])new Object[0]), NoCodeTextField.class.getSimpleName().toLowerCase()));
        return listItemConfig;
    }

    public static List<Map<String, Object>> getWfAppRoleApproverListConfig() {
        ArrayList<Map<String, Object>> listItemConfig = new ArrayList<Map<String, Object>>(2);
        listItemConfig.add(ListConfigUtils.buildListItem("roleName", ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"ListConfigUtils_6", (String)"bos-nocode-core", (Object[])new Object[0]), NoCodeTextField.class.getSimpleName().toLowerCase()));
        listItemConfig.add(ListConfigUtils.buildListItem("roleDesc", ResManager.loadKDString((String)"\u89d2\u8272\u63cf\u8ff0", (String)"ListConfigUtils_7", (String)"bos-nocode-core", (Object[])new Object[0]), NoCodeTextField.class.getSimpleName().toLowerCase()));
        return listItemConfig;
    }

    public static List<Map<String, Object>> getWfUserApproverListConfig() {
        ArrayList<Map<String, Object>> listItemConfig = new ArrayList<Map<String, Object>>(16);
        listItemConfig.add(ListConfigUtils.buildListItem("name", ResManager.loadKDString((String)"\u5458\u5de5\u59d3\u540d", (String)"ListConfigUtils_8", (String)"bos-nocode-core", (Object[])new Object[0]), "mulilangtextfield"));
        listItemConfig.add(ListConfigUtils.buildListItem(NUMBER, ResManager.loadKDString((String)"\u5458\u5de5\u7f16\u53f7", (String)"ListConfigUtils_9", (String)"bos-nocode-core", (Object[])new Object[0]), "textfield"));
        List comboItems = ((ComboProp)EntityMetadataCache.getDataEntityType((String)"bos_user").getProperty("gender")).getComboItems();
        List valueMapItemVOS = ComboItemUtils.buildComboItemsVO((List)comboItems);
        listItemConfig.add(ListConfigUtils.buildListComboItem("gender", ResManager.loadKDString((String)"\u6027\u522b", (String)"ListConfigUtils_10", (String)"bos-nocode-core", (Object[])new Object[0]), "combofield", valueMapItemVOS));
        listItemConfig.add(ListConfigUtils.buildListItem("phone", ResManager.loadKDString((String)"\u624b\u673a", (String)"ListConfigUtils_11", (String)"bos-nocode-core", (Object[])new Object[0]), "textfield"));
        listItemConfig.add(ListConfigUtils.buildListItem("email", ResManager.loadKDString((String)"\u90ae\u7bb1", (String)"ListConfigUtils_12", (String)"bos-nocode-core", (Object[])new Object[0]), "emailfield"));
        return listItemConfig;
    }

    public static List<Map<String, Object>> getWfOrgApproverListConfig() {
        ArrayList<Map<String, Object>> listItemConfig = new ArrayList<Map<String, Object>>(4);
        listItemConfig.add(ListConfigUtils.buildListItem("name", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"ListConfigUtils_13", (String)"bos-nocode-core", (Object[])new Object[0]), "textfield"));
        listItemConfig.add(ListConfigUtils.buildListItem(NUMBER, ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u53f7", (String)"ListConfigUtils_14", (String)"bos-nocode-core", (Object[])new Object[0]), "textfield"));
        return listItemConfig;
    }

    private static Map<String, Object> buildListItem(String number, String name, String type) {
        HashMap<String, Object> listItem = new HashMap<String, Object>(16);
        listItem.put(NUMBER, number);
        listItem.put("name", name);
        listItem.put("type", NoCodeTextField.class.getSimpleName().toLowerCase());
        return listItem;
    }

    private static Map<String, Object> buildListComboItem(String number, String name, String type, List<ValueMapItemVO> items) {
        Map<String, Object> listItem = ListConfigUtils.buildListItem(number, name, type);
        listItem.put("items", items);
        return listItem;
    }
}

