/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveRowErrorData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import org.apache.commons.collections4.MapUtils;

public class MenuMetaUtils {
    private static final String KEY_SUCCESS = "success";
    private static final String MESSAGE = "message";
    private static final String PROP_NAME = "name";
    private static final String PROP_FORMID = "formId";
    private static final String PROP_FORMNUMBER = "formNumber";
    private static final String PROP_PARENTID = "parentId";
    private static final String PROP_SEQ = "seq";

    public static String saveMenuInfo(String formName, String formId, AppMetadata appMetadata, Map<String, Object> menuInfo) {
        if (MapUtils.isEmpty(menuInfo)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u83dc\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"MenuMetaUtils_0", (String)"bos-nocode-core", (Object[])new Object[0]));
        }
        menuInfo.put(PROP_FORMID, formId);
        menuInfo.put(PROP_NAME, formName);
        ArrayList<Map<String, Object>> sourceList = new ArrayList<Map<String, Object>>(1);
        sourceList.add(menuInfo);
        RestApiSaveItemData saveMenuItemData = MenuMetaUtils.executeSave(sourceList, true, appMetadata).get(0);
        if (Objects.isNull(saveMenuItemData)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u4fdd\u5b58\u83dc\u5355\u5f02\u5e38", (String)"MenuMetaUtils_1", (String)"bos-nocode-core", (Object[])new Object[0]));
        }
        if (!saveMenuItemData.isBillStatus()) {
            String errMsg = saveMenuItemData.getErrors().stream().flatMap(e -> e.getRowMsg().stream()).collect(Collectors.joining(","));
            throw new RestApiException(ResManager.loadKDString((String)"\u4fdd\u5b58\u83dc\u5355\u5f02\u5e38: ", (String)"MenuMetaUtils_2", (String)"bos-nocode-core", (Object[])new Object[0]) + errMsg);
        }
        Map saveMenuResult = AppMetaServiceHelper.save((AppMetadata)appMetadata);
        if (saveMenuResult.size() > 0 && !Boolean.parseBoolean(saveMenuResult.get(KEY_SUCCESS).toString())) {
            throw new RestApiException(saveMenuResult.get(MESSAGE).toString());
        }
        return saveMenuItemData.getId();
    }

    public static List<RestApiSaveItemData> executeSave(List<Map<String, Object>> sourceDatas, boolean isInsert, AppMetadata appMetadata) {
        ArrayList<RestApiSaveItemData> results = new ArrayList<RestApiSaveItemData>(sourceDatas.size());
        String id = null;
        int len = sourceDatas.size();
        for (int i = 0; i < len; ++i) {
            RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
            Map<String, Object> dataMap = sourceDatas.get(i);
            try {
                String propName = StringUtil.cleanXSSParam((String)((String)dataMap.get(PROP_NAME)));
                propName = propName.length() > 50 ? propName.substring(0, 47) + "..." : propName;
                LocaleString name = new LocaleString(propName);
                Pair<String, String> idAndNumber = MenuMetaUtils.parseFormIdAndNumber(dataMap);
                String formId = (String)idAndNumber.getKey();
                String formNumber = (String)idAndNumber.getValue();
                AppMenuElement appMenuElement = null;
                if (isInsert) {
                    appMenuElement = new AppMenuElement();
                    id = FormMetaUtil.genIdUrlFriendly();
                    appMenuElement.setId(id);
                    appMenuElement.setVisible(Boolean.TRUE.toString());
                    Boolean enabled = (Boolean)dataMap.get("enabled");
                    if (Objects.nonNull(enabled)) {
                        appMenuElement.setVisible(enabled.toString());
                    }
                    appMenuElement.setNumber(id);
                    boolean custom = (Boolean)dataMap.getOrDefault("custom", false);
                    if (custom) {
                        appMenuElement.setMenuType("custom");
                    }
                } else {
                    id = (String)dataMap.get("id");
                    appMenuElement = (AppMenuElement)appMetadata.getMapMenus().get(id);
                }
                if (!isInsert && !propName.equalsIgnoreCase(appMenuElement.getName().getLocaleValue()) && FormMetadataUtils.existByFormNumber((String)formNumber)) {
                    FormMetadataUtils.setFormName((String)formId, (LocaleString)name, (String)appMenuElement.getMenuType());
                }
                appMenuElement.setFormNumber(formNumber);
                appMenuElement.setFormId(formId);
                appMenuElement.setParameter(MenuMetaUtils.getParameter(dataMap));
                appMenuElement.setCaption(name);
                appMenuElement.setName(name);
                appMenuElement.setDescription(name);
                String parentId = MenuMetaUtils.parseParentId(dataMap, isInsert, appMetadata);
                if (parentId == null) {
                    apiSaveData.setBillStatus(false);
                    RestApiSaveRowErrorData rowError = new RestApiSaveRowErrorData();
                    HashSet<String> msg = new HashSet<String>(1);
                    msg.add(ResManager.loadKDString((String)"parentId\u6709\u8bef:", (String)"MenuMetaUtils_3", (String)"bos-nocode-core", (Object[])new Object[0]) + parentId);
                    rowError.setRowMsg(msg);
                    apiSaveData.getErrors().add(rowError);
                    break;
                }
                appMenuElement.setParentId(parentId);
                Short seq = MenuMetaUtils.parseSeq(dataMap, isInsert, appMetadata);
                appMenuElement.setSeq(seq.shortValue());
                appMetadata.getAppMenus().add(appMenuElement);
                apiSaveData.setId(id);
                apiSaveData.setBillStatus(true);
            }
            catch (Exception e) {
                apiSaveData.addError(e);
                apiSaveData.setBillStatus(false);
            }
            results.add(apiSaveData);
        }
        return results;
    }

    private static String getParameter(Map<String, Object> dataMap) {
        String image = "image";
        if (dataMap.containsKey("image")) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
            paramMap.put("image", dataMap.get("image"));
            return SerializationUtils.toJsonString(paramMap);
        }
        return "";
    }

    private static Pair<String, String> parseFormIdAndNumber(Map<String, Object> dataMap) {
        String formId = (String)dataMap.get(PROP_FORMID);
        String formNumber = (String)dataMap.get(PROP_FORMNUMBER);
        if (StringUtils.isNotBlank((CharSequence)formId) && StringUtils.isNotBlank((CharSequence)formNumber)) {
            return new Pair((Object)formId, (Object)formNumber);
        }
        if (StringUtils.isBlank((CharSequence)formId) && StringUtils.isBlank((CharSequence)formNumber)) {
            return new Pair((Object)"", (Object)"");
        }
        if (StringUtils.isBlank((CharSequence)formId)) {
            formId = FormMetaUtil.getFormIdByNumber((String)formNumber);
            if (StringUtils.isBlank((CharSequence)formId)) {
                formId = formNumber;
                formNumber = FormMetaUtil.getFormNumberById((String)formId);
                return new Pair((Object)formId, (Object)formNumber);
            }
            return new Pair((Object)formId, (Object)formNumber);
        }
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            formNumber = FormMetaUtil.getFormNumberById((String)formId);
            if (StringUtils.isBlank((CharSequence)formNumber)) {
                formNumber = formId;
                formId = FormMetaUtil.getFormIdByNumber((String)formNumber);
                return new Pair((Object)formId, (Object)formNumber);
            }
            return new Pair((Object)formId, (Object)formNumber);
        }
        return new Pair((Object)"", (Object)"");
    }

    private static String parseParentId(Map<String, Object> dataMap, boolean isInsert, AppMetadata appMetadata) {
        String parentId = (String)dataMap.get(PROP_PARENTID);
        if (StringUtils.isBlank((CharSequence)parentId) && isInsert) {
            return appMetadata.getId();
        }
        if (StringUtils.isBlank((CharSequence)parentId) && !isInsert) {
            String id = (String)dataMap.get("id");
            AppMenuElement appMenuElement = (AppMenuElement)appMetadata.getMapMenus().get(id);
            if (appMenuElement == null) {
                return null;
            }
            return appMenuElement.getParentId();
        }
        AppMenuElement parentAppMenuElement = (AppMenuElement)appMetadata.getMapMenus().get(parentId);
        if (parentId.equalsIgnoreCase(appMetadata.getBizappId())) {
            return parentId;
        }
        if (parentAppMenuElement == null) {
            return null;
        }
        return parentId;
    }

    private static Short parseSeq(Map<String, Object> dataMap, boolean isInsert, AppMetadata appMetadata) {
        String parentId = (String)dataMap.get(PROP_PARENTID);
        if (dataMap.containsKey(PROP_SEQ) && dataMap.get(PROP_SEQ) != null) {
            Integer seq = (Integer)dataMap.get(PROP_SEQ);
            return Short.parseShort(seq.toString());
        }
        if (isInsert) {
            if (StringUtils.isBlank((CharSequence)parentId)) {
                Set seqs = appMetadata.getAppMenus().stream().filter(m -> appMetadata.getId().equalsIgnoreCase(m.getParentId())).map(AppMenuElement::getSeq).collect(Collectors.toSet());
                Short maxSeq = seqs.isEmpty() ? Short.valueOf((short)0) : (Short)Collections.max(seqs);
                int iSeq = maxSeq + 1;
                return Short.parseShort(Integer.toString(iSeq));
            }
            Set seqs = appMetadata.getAppMenus().stream().filter(m -> parentId.equalsIgnoreCase(m.getParentId())).map(AppMenuElement::getSeq).collect(Collectors.toSet());
            Short maxSeq = seqs.isEmpty() ? Short.valueOf((short)0) : (Short)Collections.max(seqs);
            int iSeq = maxSeq + 1;
            return Short.parseShort(Integer.toString(iSeq));
        }
        String id = (String)dataMap.get("id");
        AppMenuElement appMenuElement = (AppMenuElement)appMetadata.getMapMenus().get(id);
        if (StringUtils.isNotBlank((CharSequence)parentId) && !parentId.equalsIgnoreCase(appMenuElement.getParentId())) {
            Set seqs = appMetadata.getAppMenus().stream().filter(m -> parentId.equalsIgnoreCase(m.getParentId())).map(AppMenuElement::getSeq).collect(Collectors.toSet());
            Short maxSeq = seqs.isEmpty() ? Short.valueOf((short)0) : (Short)Collections.max(seqs);
            int iSeq = maxSeq + 1;
            return Short.parseShort(Integer.toString(iSeq));
        }
        return appMenuElement.getSeq();
    }
}

