/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.nocode.constant.TemplateTypeEnum;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.NcAppVersionUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;

public class NoCodeTemplateUtil {
    public static final String PROP_TYPE = "type";
    public static final String TYPE_FORM = TemplateTypeEnum.FORM.getCode();
    public static final String TYPE_APP = TemplateTypeEnum.APP.getCode();
    private static final String PROP_ID = "id";
    private static final String PROP_APPID = "appid";
    private static final String PROP_FORMID = "formid";
    private static final String PROP_NAME = "name";
    private static final String PROP_DESC = "desc";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_ICON = "icon";
    private static final String PROP_TAG = "tag";
    private static final String PROP_ORG = "org";
    private static final String PROP_DOMAINS = "domains";
    private static final String PROP_TRADES = "trades";
    private static final Log log = LogFactory.getLog(NoCodeTemplateUtil.class);

    public static void saveFormTemplate(Map<String, Object> content) {
        NoCodePermHelper.verifyPlatManage();
        Map config = (Map)content.get("templateConfig");
        config.put(PROP_APPID, content.get("bizappid"));
        config.put(PROP_FORMID, content.get(PROP_ID));
        config.put(PROP_TYPE, TYPE_FORM);
        NoCodeTemplateUtil.saveTemplate(config);
    }

    public static void saveAppTemplate(Map<String, Object> dataMap) {
        dataMap.put(PROP_TYPE, TYPE_APP);
        NoCodeTemplateUtil.saveTemplate(dataMap);
    }

    public static void saveTemplate(Map<String, Object> config) {
        DynamicObject td;
        DynamicObject dao;
        boolean add = false;
        if (config.containsKey(PROP_ID)) {
            Object id = config.get(PROP_ID);
            dao = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_nocode_templateconfig");
            if (dao == null) {
                throw new RestApiException("template id: " + id + " not found");
            }
        } else {
            add = true;
            dao = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_templateconfig");
            dao.set(PROP_ID, (Object)DBServiceHelper.genGlobalLongId());
            dao.set("sourceid", config.get("sourceId"));
            dao.set(PROP_APPID, config.get(PROP_APPID));
            dao.set(PROP_FORMID, config.get(PROP_FORMID));
            dao.set("createdate", (Object)System.currentTimeMillis());
            dao.set("creator", (Object)RequestContext.get().getCurrUserId());
            dao.set(PROP_TYPE, config.get(PROP_TYPE));
            if (RequestContext.get().getUserName().equals("IERP")) {
                dao.set(PROP_ORG, (Object)ResManager.loadKDString((String)"\u91d1\u8776\u5b98\u65b9", (String)"NoCodeTemplateUtil_0", (String)"bos-nocode-core", (Object[])new Object[0]));
            } else {
                long org = OrgUnitServiceHelper.getRootOrgId();
                DynamicObject bosOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)org, (String)"bos_org");
                dao.set(PROP_ORG, (Object)bosOrg.getLocaleString(PROP_NAME).toString());
            }
        }
        String name = StringUtil.cleanXSSParam((String)((String)config.get(PROP_NAME)));
        if (name.length() > 50) {
            name = name.substring(0, 47) + "...";
        }
        Object type = dao.get(PROP_TYPE);
        String desc = (String)config.get(PROP_DESC);
        if (StringUtils.isNotEmpty((String)desc) && (desc = StringUtil.cleanXSSParam((String)desc)).length() > 500) {
            desc = desc.substring(0, 497) + "...";
        }
        dao.set(PROP_NAME, (Object)name);
        dao.set(PROP_DESC, (Object)desc);
        if (config.containsKey(PROP_DOMAINS)) {
            DynamicObjectCollection domains = dao.getDynamicObjectCollection(PROP_DOMAINS);
            domains.clear();
            for (String domain : (Iterable)config.get(PROP_DOMAINS)) {
                td = new DynamicObject(domains.getDynamicObjectType());
                td.set("fbasedataid_id", (Object)domain);
                domains.add((Object)td);
            }
        }
        if (config.containsKey(PROP_TRADES)) {
            DynamicObjectCollection trades = dao.getDynamicObjectCollection(PROP_TRADES);
            trades.clear();
            for (String trade : (Iterable)config.get(PROP_TRADES)) {
                td = new DynamicObject(trades.getDynamicObjectType());
                td.set("fbasedataid_id", (Object)trade);
                trades.add((Object)td);
            }
        }
        if (config.containsKey(PROP_IMAGE)) {
            dao.set(PROP_IMAGE, config.get(PROP_IMAGE));
        }
        if (config.containsKey(PROP_ICON)) {
            dao.set(PROP_ICON, config.get(PROP_ICON));
        }
        if (config.containsKey(PROP_TAG)) {
            dao.set(PROP_TAG, config.get(PROP_TAG));
        }
        Set<Long> oids = new HashSet<Long>();
        Set<Long> uids = new HashSet<Long>();
        if (config.containsKey("users")) {
            List users = (List)config.get("users");
            uids = users.stream().map(u -> (String)u.get(PROP_ID)).map(Long::parseLong).collect(Collectors.toSet());
        }
        if (config.containsKey("orgs")) {
            List orgs = (List)config.get("orgs");
            oids = orgs.stream().map(u -> (String)u.get(PROP_ID)).map(Long::parseLong).collect(Collectors.toSet());
        }
        NoCodeTemplateUtil.saveNoCodeTemplate(dao, uids, oids);
        if (add && TYPE_FORM.equals(dao.getString(PROP_TYPE))) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
                    String appid = dao.getString(PROP_APPID);
                    AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)appid, (boolean)false);
                    AppFunctionPacketElement appFunctionPacketElement = (AppFunctionPacketElement)appMetadata.getAppFunctionPackets().get(0);
                    String bizUnitId = appFunctionPacketElement.getId();
                    dObject.set("bizapp", (Object)appid);
                    dObject.set("bizunit", (Object)bizUnitId);
                    dObject.set("form", dao.get(PROP_FORMID));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
                }
                catch (Exception e) {
                    h.markRollback();
                    throw new RestApiException((Throwable)e);
                }
            }
        }
    }

    public static void getUserTemplates(Set<Long> ret) {
        long userId = RequestContext.get().getCurrUserId();
        QFilter filter = new QFilter("userId", "=", (Object)userId);
        DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_nocode_tpl_user", (String)"templateid", (QFilter[])filter.toArray());
        Set ids = Arrays.stream(users).map(e -> e.getLong("templateid")).collect(Collectors.toSet());
        ret.addAll(ids);
    }

    public static void getOrgTemplates(Set<Long> ret) {
        long orgId = RequestContext.get().getOrgId();
        QFilter filter = new QFilter("templateid", "not in", ret);
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bos_nocode_tpl_org", (String)"orgId,templateid", (QFilter[])new QFilter[]{filter});
        Set collect = Arrays.stream(orgs).map(dy -> dy.getLong("orgId")).collect(Collectors.toSet());
        Map orgmap = OrgUnitServiceHelper.getAllSubordinateOrgMap((long)1L, new ArrayList(collect), (boolean)true);
        for (DynamicObject org : orgs) {
            Long oid = org.getLong("orgId");
            Long templateid = org.getLong("templateid");
            if (ret.contains(templateid) || !((List)orgmap.get(oid)).contains(orgId)) continue;
            ret.add(templateid);
        }
    }

    private static void saveNoCodeTemplate(DynamicObject dao, Set<Long> uids, Set<Long> oids) {
        try (TXHandle handle = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dao});
            ArrayList<DynamicObject> orgs = new ArrayList<DynamicObject>(oids.size());
            ArrayList<DynamicObject> users = new ArrayList<DynamicObject>(uids.size());
            for (Long oid : oids) {
                DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_tpl_org");
                org.set("orgid", (Object)oid);
                org.set("templateid", (Object)dao.getLong(PROP_ID));
                orgs.add(org);
            }
            for (Long uid : uids) {
                DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_tpl_user");
                user.set("userid", (Object)uid);
                user.set("templateid", (Object)dao.getLong(PROP_ID));
                users.add(user);
            }
            DeleteServiceHelper.delete((String)"bos_nocode_tpl_org", (QFilter[])new QFilter[]{new QFilter("templateid", "=", (Object)dao.getLong(PROP_ID))});
            DeleteServiceHelper.delete((String)"bos_nocode_tpl_user", (QFilter[])new QFilter[]{new QFilter("templateid", "=", (Object)dao.getLong(PROP_ID))});
            SaveServiceHelper.save((DynamicObject[])orgs.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])users.toArray(new DynamicObject[0]));
        }
    }

    public static boolean exist(Object name, Object type) {
        QFilter filter1 = new QFilter(PROP_NAME, "=", name);
        QFilter filter2 = new QFilter(PROP_TYPE, "=", type);
        return QueryServiceHelper.exists((String)"bos_nocode_templateconfig", (QFilter[])new QFilter[]{filter1, filter2});
    }

    public static Set<String> queryTemplateAppIds() {
        return NcEntityTypeUtil.queryTemplateAppIds();
    }

    public static boolean isTemplate(String appid) {
        return NoCodeTemplateUtil.queryTemplateAppIds().contains(appid);
    }

    public static void templateCheck(RestApiParam param) {
        String appid = param.getAppNumber();
        Set<String> templates = NoCodeTemplateUtil.queryTemplateAppIds();
        if (templates.contains(appid)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u6a21\u677f\u5e94\u7528\u4e0d\u652f\u6301\u4fee\u6539", (String)"NoCodeTemplateUtil_1", (String)"bos-nocode-core", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String queryFormTemplateAppId() {
        QFilter filter = new QFilter(PROP_NUMBER, "=", (Object)"nocode_fromtemplate_app");
        DynamicObject app = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (String)PROP_ID, (QFilter[])new QFilter[]{filter});
        if (app == null) {
            Class<NoCodeTemplateUtil> clazz = NoCodeTemplateUtil.class;
            // MONITORENTER : kd.bos.nocode.util.NoCodeTemplateUtil.class
            QFilter f = new QFilter(PROP_NUMBER, "=", (Object)"nocode_fromtemplate_app");
            boolean exists = QueryServiceHelper.exists((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{f});
            if (!exists) {
                // MONITOREXIT : clazz
                return NoCodeTemplateUtil.createFormTemplateApp();
            }
            // MONITOREXIT : clazz
        }
        if ($assertionsDisabled) return app.getString(PROP_ID);
        if (app != null) return app.getString(PROP_ID);
        throw new AssertionError();
    }

    private static String createFormTemplateApp() {
        QFilter filter = new QFilter(PROP_NUMBER, "=", (Object)"nocode");
        DynamicObject noCodeCloud = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizcloud", (String)PROP_ID, (QFilter[])new QFilter[]{filter});
        DynamicObject app = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_bizapp");
        String version = NcAppVersionUtil.getAppVersion();
        app.set("version", (Object)version);
        app.set("dbroute", (Object)"secd");
        app.set("bizcloud", (Object)noCodeCloud);
        app.set("usertype", (Object)1);
        app.set("deploystatus", (Object)2);
        app.set("mainformtype", (Object)0);
        app.set("isv", (Object)ISVService.getISVInfo().getId());
        app.set(PROP_NUMBER, (Object)"nocode_fromtemplate_app");
        String id = FormMetaUtil.genIdUrlFriendly();
        app.set(PROP_ID, (Object)id);
        app.set(PROP_NAME, (Object)ResManager.loadKDString((String)"\u65e0\u4ee3\u7801\u8868\u5355\u6a21\u677f\u9690\u85cf\u5e94\u7528", (String)"NoCodeTemplateUtil_2", (String)"bos-nocode-core", (Object[])new Object[0]));
        app.set("description", (Object)ResManager.loadKDString((String)"\u65e0\u4ee3\u7801\u8868\u5355\u6a21\u677f\u9690\u85cf\u5e94\u7528", (String)"NoCodeTemplateUtil_2", (String)"bos-nocode-core", (Object[])new Object[0]));
        AppMetadata appMetadata = FormMetaUtil.createNewAppMeta((DynamicObject)app);
        Map resultMap = AppMetaServiceHelper.save((AppMetadata)appMetadata);
        if (resultMap.size() > 0 && !Boolean.parseBoolean(resultMap.get("success").toString())) {
            throw new RestApiException(resultMap.get("message").toString());
        }
        return id;
    }

    public static void addUseTimes(String templateid) {
        try {
            String sql = "update t_nocode_template_config set ffrequency = ffrequency + 1 where fid = ?";
            DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[]{Long.parseLong(templateid)});
        }
        catch (Exception e) {
            log.debug("\u6a21\u677f\u4f7f\u7528\u6b21\u6570\u589e\u52a0\u5931\u8d25:" + e.getMessage());
        }
    }
}

