/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class OpenApiAliasHelper {
    private static final Log logger = LogFactory.getLog(OpenApiAliasHelper.class);

    public static String getFormIdByFormAlias(String alias) {
        return OpenApiAliasHelper.getSourceByAlias(alias, "bos_nc_forminfo_alias");
    }

    public static String getWfModelIdByWfModelAlias(String alias) {
        return OpenApiAliasHelper.getSourceByAlias(alias, "bos_nc_wfinfo_alias");
    }

    private static String getSourceByAlias(String alias, String aliasEntityNumber) {
        try {
            DynamicObject[] loaded = BusinessDataServiceHelper.load((String)aliasEntityNumber, (String)"source,alias", (QFilter[])new QFilter("type", "=", (Object)"1").toArray());
            Map<String, String> alias2Source = Arrays.stream(loaded).filter(e -> StringUtils.isNotEmpty((CharSequence)e.getString("alias"))).collect(Collectors.toMap(e -> e.getString("alias"), e -> e.getString("source")));
            String source = alias2Source.get(alias);
            if (StringUtils.isEmpty((CharSequence)source)) {
                return alias;
            }
            return source;
        }
        catch (Exception e2) {
            logger.warn("\u66ff\u6362\u522b\u540d\u5f02\u5e38\uff1a{}", (Object)e2.getMessage(), (Object)e2);
            return alias;
        }
    }

    public static List<Map<String, Object>> replaceAlias2Field(String entityNumber, List<Map<String, Object>> dataList) {
        Map<String, String> alias2Source = OpenApiAliasHelper.getAlias2FieldSource(entityNumber);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(dataList.size());
        for (Map<String, Object> data : dataList) {
            HashMap target = new HashMap(data.size());
            data.forEach((k, v) -> target.put(alias2Source.getOrDefault(k, (String)k), v));
            resultList.add(target);
        }
        return resultList;
    }

    @NotNull
    public static Map<String, String> getAlias2FieldSource(String entityNumber) {
        DynamicObject[] loaded = BusinessDataServiceHelper.load((String)"bos_nc_forminfo_alias", (String)"source,alias", (QFilter[])new QFilter("type", "=", (Object)"0").and(new QFilter("entityNumber", "=", (Object)entityNumber)).toArray());
        return Arrays.stream(loaded).filter(e -> StringUtils.isNotEmpty((CharSequence)e.getString("alias"))).collect(Collectors.toMap(e -> e.getString("alias"), e -> e.getString("source")));
    }

    public static List<Map<String, Object>> replaceField2Alias(String entityNumber, List<Map<String, Object>> dataList) {
        Map<String, String> source2Alias = OpenApiAliasHelper.getFieldSource2Alias(entityNumber);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(dataList.size());
        for (Map<String, Object> data : dataList) {
            HashMap target = new HashMap(data.size());
            data.forEach((k, v) -> target.put(source2Alias.getOrDefault(k, (String)k), v));
            resultList.add(target);
        }
        return resultList;
    }

    @NotNull
    public static Map<String, String> getFieldSource2Alias(String entityNumber) {
        DynamicObject[] loaded = BusinessDataServiceHelper.load((String)"bos_nc_forminfo_alias", (String)"source,alias", (QFilter[])new QFilter("type", "=", (Object)"0").and(new QFilter("entityNumber", "=", (Object)entityNumber)).toArray());
        return Arrays.stream(loaded).filter(e -> StringUtils.isNotEmpty((CharSequence)e.getString("alias"))).collect(Collectors.toMap(e -> e.getString("source"), e -> e.getString("alias")));
    }
}

