/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.converter.FormMetadataConverter;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.nocode.design.NoCodeDesignerData;
import kd.bos.nocode.ext.metadata.entity.NoCodeBillEntity;
import kd.bos.nocode.ext.metadata.entity.NoCodeRefBillTable;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeAttachmentUploadField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDateRangeField;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.mservice.NoCodeRefBillTableService;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.servicehelper.ServiceFactory;
import kd.bos.nocode.util.FormMetaUtils;
import kd.bos.nocode.util.MenuMetaUtils;
import kd.bos.nocode.utils.BlackFormUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TableMetaUtils {
    public static final String BOS_NC_REFTABLE = "bos_nc_reftable";
    private static final List<String> BLACK_PROPS = Arrays.asList("Id", "Key", "ParentId", "FieldRequired", "Status", "Visibility", "NoCodeDefValue", "UploadDefValue", "PictureDefValue", "DateRangeDefValue", "StartDateFieldKey", "EndDateFieldKey", "FieldId");
    private static final Log log = LogFactory.getLog(TableMetaUtils.class);

    public static void saveRefTableMetas(Map<String, Object> content, FormMetadata formMetadata, EntityMetadata oldEntityMetadata) {
        FormMetadataConverter converter = new FormMetadataConverter();
        FormMetadata formMetadata_bak = (FormMetadata)converter.convertTo(content);
        Map<String, Object> refFields = TableMetaUtils.getRefFields(content);
        EntityMetadata entityMetadata = formMetadata.getEntityMetadata();
        Map<String, NoCodeRefBillTable> oldRelationMap = TableMetaUtils.analysisRefTable(oldEntityMetadata);
        Map<String, NoCodeRefBillTable> relationMap = TableMetaUtils.analysisRefTable(entityMetadata);
        if (!oldRelationMap.isEmpty()) {
            TableMetaUtils.deleteOldTableForm(oldRelationMap, relationMap);
        }
        TableMetaUtils.linkFormTable(formMetadata.getId(), relationMap);
        if (!relationMap.isEmpty()) {
            TableMetaUtils.saveMetas(formMetadata, relationMap, refFields, formMetadata_bak);
        }
        for (Map.Entry<String, Object> formInfo : refFields.entrySet()) {
            String formId = formInfo.getKey();
            Map fieldInfos = (Map)formInfo.getValue();
            if (fieldInfos.isEmpty()) continue;
            new NoCodeDesignerData().updateOrDel(formId, fieldInfos);
        }
    }

    public static void asyncUpdateTableMeta(String formId) {
        QFilter filter = new QFilter("refformid", "=", (Object)formId);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)BOS_NC_REFTABLE, (String)"formid,refformid", (QFilter[])new QFilter[]{filter});
        if (objs == null || objs.length == 0) {
            return;
        }
        ArrayList<String> formIds = new ArrayList<String>(10);
        for (DynamicObject obj : objs) {
            formIds.add(obj.getString("formid"));
        }
        NoCodeRefBillTableService refBillTableService = (NoCodeRefBillTableService)ServiceFactory.getService((String)"NoCodeRefBillTableService");
        refBillTableService.updateTableMetas(formIds, formId);
    }

    public static void updateTableMetas(List<String> formIds, String refFormId) {
        FormMetadataConverter converter = new FormMetadataConverter();
        String localeId = RequestContext.get().getLang().toString();
        Map refContent = MetadataDao.loadDesignerMetadata((String)refFormId, (String)localeId);
        List<Map<String, Object>> ref_formmeta_items = TableMetaUtils.getMetas(refContent, "formmeta");
        List<Map<String, Object>> ref_entitymeta_items = TableMetaUtils.getMetas(refContent, "entitymeta");
        Map<String, Map<String, Object>> key2FormMeta = ref_formmeta_items.stream().collect(Collectors.toMap(map -> (String)map.get("Key"), Function.identity()));
        Map<String, Map<String, Object>> key2EntityMeta = ref_entitymeta_items.stream().collect(Collectors.toMap(map -> (String)map.get("Key"), Function.identity()));
        for (String formId : formIds) {
            Map content = MetadataDao.loadDesignerMetadata((String)formId, (String)localeId);
            if (content == null) continue;
            FormMetadata formMeta = (FormMetadata)converter.convertTo(content);
            EntityMetadata entityMetadata = formMeta.getEntityMetadata();
            List items = entityMetadata.getItems();
            ArrayList<String> tableIds = new ArrayList<String>(10);
            for (EntityItem entityItem : items) {
                NoCodeRefBillTable table;
                if (!(entityItem instanceof NoCodeRefBillTable) || "1".equals((table = (NoCodeRefBillTable)entityItem).getSourceForm()) || "1".equals(table.getShowType()) || !refFormId.equals(table.getBillEntityIdEx())) continue;
                tableIds.add(entityItem.getId());
            }
            List<Map<String, Object>> formmeta_items = TableMetaUtils.getMetas(content, "formmeta");
            List<Map<String, Object>> entitymeta_items = TableMetaUtils.getMetas(content, "entitymeta");
            ArrayList<Map<String, Object>> deleted_entity_items = new ArrayList<Map<String, Object>>(10);
            ArrayList<Map<String, Object>> deleted_form_items = new ArrayList<Map<String, Object>>(10);
            TableMetaUtils.copyMetas(formmeta_items, tableIds, key2FormMeta, deleted_form_items);
            TableMetaUtils.copyMetas(entitymeta_items, tableIds, key2EntityMeta, deleted_entity_items);
            formmeta_items.removeAll(deleted_form_items);
            entitymeta_items.removeAll(deleted_entity_items);
            new NoCodeDesignerData().save((Map<String, Object>)content, content, false);
        }
    }

    private static List<Map<String, Object>> getMetas(Map<String, Object> content, String type) {
        return (ArrayList)((Map)content.get(type)).get("Items");
    }

    private static void copyMetas(List<Map<String, Object>> metas, List<String> tableIds, Map<String, Map<String, Object>> key2Meta, List<Map<String, Object>> deletedItems) {
        for (Map<String, Object> item : metas) {
            String parentId = item.get("ParentId") == null ? "" : (String)item.get("ParentId");
            if (!tableIds.contains(parentId)) continue;
            String table_item_Key = (String)item.get("Key");
            String form_item_Key = table_item_Key.substring(0, table_item_Key.lastIndexOf("_"));
            Map<String, Object> ref_Item = key2Meta.get(form_item_Key);
            if (ref_Item == null) {
                deletedItems.add(item);
                continue;
            }
            TableMetaUtils.copyProps(item, ref_Item);
        }
    }

    private static void copyProps(Map<String, Object> tableItem, Map<String, Object> sourceFormItem) {
        for (Map.Entry<String, Object> entry : sourceFormItem.entrySet()) {
            String key2 = entry.getKey();
            if (BLACK_PROPS.contains(key2)) continue;
            tableItem.put(entry.getKey(), entry.getValue());
        }
        tableItem.keySet().removeIf(key -> !BLACK_PROPS.contains(key) && !sourceFormItem.containsKey(key));
    }

    private static void linkFormTable(String formId, Map<String, NoCodeRefBillTable> relationMap) {
        try (TXHandle tx = TX.requiresNew((String)"linkFormTable");){
            DeleteServiceHelper.delete((String)BOS_NC_REFTABLE, (QFilter[])new QFilter[]{new QFilter("formid", "=", (Object)formId)});
            ArrayList<DynamicObject> relations = new ArrayList<DynamicObject>(10);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)BOS_NC_REFTABLE);
            for (Map.Entry<String, NoCodeRefBillTable> entry : relationMap.entrySet()) {
                NoCodeRefBillTable refBillTable = entry.getValue();
                if ("1".equals(refBillTable.getSourceForm()) && !refBillTable.isInner2Outer() || BlackFormUtil.isCosmicForm((String)refBillTable.getBillEntityIdEx()) || formId.equals(refBillTable.getBillEntityIdEx())) continue;
                DynamicObject dy = new DynamicObject((DynamicObjectType)entityType);
                dy.set("formid", (Object)formId);
                dy.set("refformid", (Object)entry.getKey());
                relations.add(dy);
            }
            SaveServiceHelper.save((DynamicObject[])relations.toArray(new DynamicObject[0]));
        }
    }

    private static Map<String, Object> getRefFields(Map<String, Object> content) {
        Map formmeta = (Map)content.get("formmeta");
        List items = (List)formmeta.get("Items");
        Map<String, Object> refFields = new HashMap<String, Object>(16);
        if (((Map)items.get(0)).containsKey("refFieldEdit")) {
            if (((Map)items.get(0)).get("refFieldEdit") instanceof Map) {
                refFields = (Map)((Map)items.get(0)).get("refFieldEdit");
            }
            ((Map)items.get(0)).remove("refFieldEdit");
        }
        return refFields;
    }

    private static Map<String, NoCodeRefBillTable> analysisRefTable(EntityMetadata entityMetadata) {
        HashMap<String, NoCodeRefBillTable> relationMap = new HashMap<String, NoCodeRefBillTable>();
        List entities = entityMetadata.getEntitys();
        for (Entity entity : entities) {
            if (!(entity instanceof NoCodeRefBillTable)) continue;
            NoCodeRefBillTable refBillTable = (NoCodeRefBillTable)entity;
            relationMap.put(refBillTable.getBillEntityIdEx(), refBillTable);
        }
        return relationMap;
    }

    private static void deleteOldTableForm(Map<String, NoCodeRefBillTable> oldRelationMap, Map<String, NoCodeRefBillTable> relationMap) {
        try (TXHandle h = TX.requiresNew();){
            for (Map.Entry<String, NoCodeRefBillTable> entry : oldRelationMap.entrySet()) {
                NoCodeRefBillTable refBillTable = entry.getValue();
                if ("2".equals(refBillTable.getSourceForm()) || relationMap.containsKey(entry.getKey())) continue;
                FormMetadataUtils.deleteForm((String)entry.getKey(), (String)refBillTable.getAppId());
            }
        }
    }

    private static void saveMetas(FormMetadata metadata, Map<String, NoCodeRefBillTable> relationMap, Map<String, Object> refFields, FormMetadata bakMetadata) {
        Map<String, String> originType = TableMetaUtils.saveInnerForm(relationMap, metadata);
        ArrayList<String> processList = new ArrayList<String>(10);
        EntityMetadata entityMetadata = metadata.getEntityMetadata();
        for (Map.Entry<String, NoCodeRefBillTable> entry : relationMap.entrySet()) {
            NoCodeRefBillTable refBillTable = entry.getValue();
            if (metadata.getId().equals(refBillTable.getBillEntityIdEx()) || "2".equals(refBillTable.getSourceForm()) && BlackFormUtil.isBlackBill((String)refBillTable.getBillEntityIdEx(), (String)refBillTable.getAppId()) || processList.contains(refBillTable.getBillEntityIdEx())) continue;
            processList.add(refBillTable.getBillEntityIdEx());
            NoCodeRefBillTable table_bak = (NoCodeRefBillTable)bakMetadata.getEntityMetadata().getItemById(refBillTable.getId());
            List entityList = table_bak.getItems();
            LinkedHashMap field2FieldAp = new LinkedHashMap();
            for (EntityItem item : entityList) {
                NoCodeDateRangeField newSave_field;
                if (!(item instanceof Field) || item instanceof NoCodeBillEntity) continue;
                Field field = (Field)item;
                if (StringUtils.isBlank((CharSequence)field.getFieldName())) {
                    if (field instanceof NoCodeDateRangeField) {
                        newSave_field = (NoCodeDateRangeField)entityMetadata.getItemById(field.getId());
                        ((NoCodeDateRangeField)field).setStartDateFieldName(newSave_field.getStartDateFieldName());
                        ((NoCodeDateRangeField)field).setEndDateFieldName(newSave_field.getEndDateFieldName());
                    } else {
                        newSave_field = (Field)entityMetadata.getItemById(field.getId());
                        field.setFieldName(newSave_field.getFieldName());
                    }
                }
                if (item instanceof NoCodeAttachmentUploadField) {
                    newSave_field = (NoCodeAttachmentUploadField)entityMetadata.getItemById(field.getId());
                    ((NoCodeAttachmentUploadField)item).setTableName(newSave_field.getTableName());
                }
                String key = field.getKey();
                String string = field.getId();
                FieldAp ap = (FieldAp)bakMetadata.getItem(field.getId());
                if (ap == null) continue;
                String refTableId = string;
                if (string.contains("_")) {
                    refTableId = string.substring(0, string.lastIndexOf("_"));
                }
                String refTableKey = key;
                if (key.contains("_")) {
                    refTableKey = key.substring(0, key.lastIndexOf("_"));
                }
                if (field instanceof NoCodeDateRangeField) {
                    ((NoCodeDateRangeField)field).setStartDateFieldKey((String)refTableKey + "_startdate");
                    ((NoCodeDateRangeField)field).setEndDateFieldKey((String)refTableKey + "_enddate");
                    ap.getCustomProperties().remove("StartDateFieldKey");
                    ap.getCustomProperties().remove("EndDateFieldKey");
                }
                field.setKey(refTableKey);
                field.setId(refTableId);
                ap.setKey(refTableKey);
                ap.setFieldId(refTableId);
                ap.setId(refTableId);
                ap.setField(field);
                field2FieldAp.put(field, ap);
            }
            if ("2".equals(refBillTable.getSourceForm())) {
                String sourceForm;
                ArrayList<String> deleteKeys = new ArrayList<String>();
                ArrayList<Map<String, String>> editKeys = new ArrayList<Map<String, String>>(10);
                if (refFields.containsKey(refBillTable.getBillEntityIdEx())) {
                    Map fieldsStatus = (Map)refFields.get(refBillTable.getBillEntityIdEx());
                    for (Map.Entry entry2 : fieldsStatus.entrySet()) {
                        String operateType = (String)((Map)entry2.getValue()).get("status");
                        if ("delete".equals(operateType)) {
                            deleteKeys.add((String)entry2.getKey());
                            continue;
                        }
                        HashMap map = new HashMap(16);
                        map.put("fieldKey", entry2.getKey());
                        map.put("fieldCaption", (String)((Map)entry2.getValue()).get("title"));
                        editKeys.add(map);
                    }
                    refFields.remove(refBillTable.getBillEntityIdEx());
                }
                boolean inner2Outer = !"2".equals(sourceForm = originType.get(entry.getKey()));
                new NoCodeDesignerData().updateFieldItem(refBillTable.getBillEntityIdEx(), field2FieldAp, deleteKeys, editKeys, inner2Outer);
                continue;
            }
            new NoCodeDesignerData().deleteAndAddFields2Root(refBillTable.getBillEntityIdEx(), field2FieldAp);
        }
    }

    private static Map<String, String> saveInnerForm(Map<String, NoCodeRefBillTable> relationMap, FormMetadata metadata) {
        HashMap<String, String> originType = new HashMap<String, String>(16);
        for (Map.Entry<String, NoCodeRefBillTable> entry : relationMap.entrySet()) {
            NoCodeRefBillTable refBillTable = entry.getValue();
            originType.put(entry.getKey(), refBillTable.getSourceForm());
            if ("2".equals(refBillTable.getSourceForm())) continue;
            Map content = MetadataDao.loadDesignerMetadata((String)refBillTable.getBillEntityIdEx(), (String)RequestContext.get().getLang().toString());
            String name = refBillTable.getName().toString();
            name = StringUtil.cleanXSSParam((String)name);
            if (content != null && !content.isEmpty()) {
                NoCodeRefBillTable oldTable;
                if (!refBillTable.isInner2Outer()) continue;
                FormMetadataConverter converter = new FormMetadataConverter();
                Map oldContent = MetadataDao.loadDesignerMetadata((String)metadata.getId(), (String)RequestContext.get().getLang().toString());
                FormMetadata formMetadata = (FormMetadata)converter.convertTo(oldContent);
                EntityItem item = formMetadata.getEntityMetadata().getItemById(refBillTable.getId());
                if (item instanceof NoCodeRefBillTable && "2".equals((oldTable = (NoCodeRefBillTable)item).getSourceForm())) {
                    refBillTable.setSourceForm("2");
                    originType.put(entry.getKey(), refBillTable.getSourceForm());
                    continue;
                }
                AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)refBillTable.getAppId(), (boolean)false);
                HashMap<String, Object> menuInfo = new HashMap<String, Object>();
                int svgIndex = 10;
                String color = TableMetaUtils.randomColor();
                menuInfo.put("image", "nocode/v2/nocode_sys/common/svgs/create_svg_line?color=%23" + color + "&svg=svg" + svgIndex);
                menuInfo.put("parentId", "");
                long count = appMetadata.getAppMenus().stream().filter(m -> m.getFormId().equals(entry.getKey())).count();
                if (count <= 0L) {
                    MenuMetaUtils.saveMenuInfo(name, entry.getKey(), appMetadata, menuInfo);
                }
                refBillTable.setSourceForm("2");
                continue;
            }
            RestApiSaveItemData saveItemData = new RestApiSaveItemData();
            HashMap<String, Object> parameters = new HashMap<String, Object>(10);
            parameters.put("name", name.length() > 50 ? name.substring(0, 47) + "..." : name);
            parameters.put("id", entry.getKey());
            parameters.put("bizappid", refBillTable.getAppId());
            if (refBillTable.isInner2Outer()) {
                HashMap<String, String> menuInfo = new HashMap<String, String>();
                int svgIndex = 10;
                String color = TableMetaUtils.randomColor();
                menuInfo.put("image", "nocode/v2/nocode_sys/common/svgs/create_svg_line?color=%23" + color + "&svg=svg" + svgIndex);
                menuInfo.put("parentId", "");
                parameters.put("menuInfo", menuInfo);
                refBillTable.setSourceForm("2");
            }
            FormMetaUtils.createModel(parameters, saveItemData);
        }
        return originType;
    }

    private static String randomColor() {
        int red = Integer.parseInt(kd.bos.util.StringUtils.randomNumber((int)3)) % 256;
        int green = Integer.parseInt(kd.bos.util.StringUtils.randomNumber((int)3)) % 256;
        int blue = Integer.parseInt(kd.bos.util.StringUtils.randomNumber((int)3)) % 256;
        return String.format("#%02X%02X%02X", red, green, blue);
    }
}

