/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.operate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.nocode.ext.property.NoCodeBillNoProp;
import kd.bos.nocode.ext.property.NoCodeCreateDateProp;
import kd.bos.nocode.ext.property.NoCodeCreatorProp;
import kd.bos.nocode.ext.property.NoCodeDateTimeProp;
import kd.bos.nocode.ext.property.NoCodeModifierProp;
import kd.bos.nocode.ext.property.NoCodeModifyDateProp;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.servicehelper.AssociationServiceHelper;
import kd.bos.nocode.utils.BlackFormUtil;
import kd.bos.nocode.utils.DateTimeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class NoCodeOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String BOS_NOCODE_OPPLUGIN = "bos-nocode-opplugin";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        if (e.getDataEntities().length == 1 && e.getOperationKey().equals("save")) {
            this.saveRefBillData(e.getDataEntities()[0]);
        } else if (e.getDataEntities().length >= 1 && e.getOperationKey().equals("delete")) {
            this.delRefBillData(e);
        }
        if (e.getDataEntities().length >= 1 && (e.getOperationKey().equals("delete") || e.getOperationKey().equals("save"))) {
            this.updateAssociatedForm(e);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }

    private void delRefBillData(BeginOperationTransactionArgs e) {
        DynamicObjectType dt = e.getDataEntities()[0].getDynamicObjectType();
        HashMap<String, Set> formPkMap = new HashMap<String, Set>(16);
        ArrayList<Object> sourcePks = new ArrayList<Object>(10);
        for (DynamicObject dynamicObject : e.getDataEntities()) {
            sourcePks.add(dynamicObject.getPkValue());
        }
        if (sourcePks.isEmpty()) {
            return;
        }
        MainEntityType sourceEntityType = EntityMetadataCache.getDataEntityType((String)dt.getName());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])sourcePks.toArray(), (DynamicObjectType)sourceEntityType);
        for (DynamicObject obj : dynamicObjects) {
            DynamicObjectType fullDt = obj.getDynamicObjectType();
            DataEntityPropertyCollection properties = fullDt.getProperties();
            for (IDataEntityProperty property : properties) {
                String str;
                NoCodeRefBillTableProp prop;
                String billEntityId = "";
                if (!(property instanceof NoCodeRefBillTableProp) || "2".equals((prop = (NoCodeRefBillTableProp)property).getSourceForm())) continue;
                String refBillKey = prop.getRefBillKey();
                DynamicProperty dp = fullDt.getProperty(refBillKey);
                if (dp instanceof NoCodeRefBillProp) {
                    DynamicObject dy;
                    if (StringUtils.isBlank((CharSequence)billEntityId)) {
                        billEntityId = ((NoCodeRefBillProp)dp).getBillEntityId();
                    }
                    if ((dy = obj.getDynamicObject(refBillKey)) == null) continue;
                    formPkMap.computeIfAbsent(billEntityId, k -> new HashSet()).add(Long.parseLong(dy.getPkValue().toString()));
                    continue;
                }
                if (!(dp instanceof NoCodeMulRefBillProp)) continue;
                if (StringUtils.isBlank((CharSequence)billEntityId)) {
                    billEntityId = ((NoCodeMulRefBillProp)dp).getBillEntityId();
                }
                if (StringUtils.isBlank((CharSequence)(str = obj.getString(refBillKey)))) continue;
                String[] pkArray = str.split(",");
                for (int i = 0; i < pkArray.length; ++i) {
                    formPkMap.computeIfAbsent(billEntityId, k -> new HashSet()).add(Long.parseLong(pkArray[i]));
                }
            }
        }
        for (Map.Entry entry : formPkMap.entrySet()) {
            String billEntityId = (String)entry.getKey();
            Set pks = (Set)entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)billEntityId) || pks.isEmpty()) continue;
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billEntityId);
            DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])pks.toArray(new Object[0]));
        }
    }

    private void saveRefBillData(DynamicObject dataEntity) {
        DynamicObjectType dt = dataEntity.getDynamicObjectType();
        DataEntityPropertyCollection properties = dt.getProperties();
        for (IDataEntityProperty property : properties) {
            NoCodeRefBillTableProp prop;
            if (!(property instanceof NoCodeRefBillTableProp) || "1".equals((prop = (NoCodeRefBillTableProp)property).getCustomProperty("showType"))) continue;
            DynamicObjectCollection cols = dataEntity.getDynamicObjectCollection((IDataEntityProperty)prop);
            String fieldKey = prop.getRefBillKey();
            DynamicProperty dp = dt.getProperty(fieldKey);
            INoCodeRefBillProp refBillProp = (INoCodeRefBillProp)dp;
            String billEntityId = refBillProp.getBillEntityId();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billEntityId);
            if ("1".equals(prop.getSourceForm())) {
                ArrayList<Long> oldIds = new ArrayList<Long>(10);
                Object currentBillPk = dataEntity.getPkValue();
                if (StringUtils.isNotBlank((Object)currentBillPk) && QueryServiceHelper.exists((String)dt.getName(), (Object)currentBillPk)) {
                    Iterator oldDataEntity = BusinessDataServiceHelper.loadSingle((Object)currentBillPk, (DynamicObjectType)dt);
                    if (refBillProp.isMultiSelect()) {
                        String value;
                        String string = value = dp.getValue((Object)oldDataEntity) == null ? null : dp.getValue((Object)oldDataEntity).toString();
                        if (value != null && !StringUtils.isBlank((CharSequence)value)) {
                            String[] pkArray = value.split(",");
                            for (int i = 0; i < pkArray.length; ++i) {
                                oldIds.add(Long.valueOf(pkArray[i]));
                            }
                        }
                    } else {
                        DynamicObject oldObj;
                        DynamicObject dynamicObject = oldObj = dp.getValue((Object)oldDataEntity) == null ? null : (DynamicObject)dp.getValue((Object)oldDataEntity);
                        if (oldObj != null) {
                            oldIds.add(Long.valueOf(oldObj.getPkValue().toString()));
                        }
                    }
                }
                if (!cols.isEmpty()) {
                    for (DynamicObject dobj : cols) {
                        Long pk = Long.valueOf(dobj.getPkValue().toString());
                        if (pk == 0L || !oldIds.contains(pk)) continue;
                        oldIds.remove(pk);
                    }
                }
                if (!oldIds.isEmpty()) {
                    DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])oldIds.toArray(new Object[0]));
                }
            }
            if (cols.isEmpty()) {
                dp.setDTValueFast(dataEntity, null);
                continue;
            }
            DynamicObjectType entryType = cols.getDynamicObjectType();
            ArrayList<Long> pks = new ArrayList<Long>();
            ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>();
            Map<Long, DynamicObject> datas = this.loadData(cols, (DynamicObjectType)entityType);
            String billNoKey = "";
            String creatorName = "";
            String creatorTime = "";
            String modifyName = "";
            String modifyTime = "";
            for (IDataEntityProperty tempProp : entityType.getProperties()) {
                if (tempProp instanceof NoCodeCreatorProp) {
                    creatorName = tempProp.getName();
                }
                if (tempProp instanceof NoCodeCreateDateProp) {
                    creatorTime = tempProp.getName();
                }
                if (tempProp instanceof NoCodeModifierProp) {
                    modifyName = tempProp.getName();
                }
                if (!(tempProp instanceof NoCodeModifyDateProp)) continue;
                modifyTime = tempProp.getName();
            }
            for (Object dobj : cols) {
                long pk = 0L;
                if (Long.parseLong(dobj.getPkValue().toString()) != 0L) {
                    pk = Long.parseLong(dobj.getPkValue().toString());
                } else if ("1".equals(prop.getSourceForm()) || !BlackFormUtil.isCosmicForm((String)billEntityId)) {
                    pk = ID.genLongId();
                }
                pks.add(pk);
                if (!"1".equals(prop.getSourceForm()) && BlackFormUtil.isCosmicForm((String)billEntityId)) continue;
                DynamicObject obj = datas.get(pk);
                if (obj == null) {
                    obj = new DynamicObject((DynamicObjectType)entityType);
                    if (StringUtils.isNotBlank((CharSequence)creatorName)) {
                        obj.set(creatorName, (Object)RequestContext.get().getCurrUserId());
                    }
                    if (StringUtils.isNotBlank((CharSequence)creatorTime)) {
                        obj.set(creatorTime, (Object)DateTimeUtils.getNow());
                    }
                    obj.set("id", (Object)pk);
                }
                for (IDataEntityProperty entryProp : entryType.getProperties()) {
                    if (entryProp instanceof PKFieldProp || entryProp instanceof IntegerProp && "seq".equals(entryProp.getName())) continue;
                    String key = entryProp.getName();
                    String refTableKey = key.substring(0, key.lastIndexOf("_"));
                    if (entryProp instanceof NoCodeDateTimeProp && (key.endsWith("_startdate") || key.endsWith("_enddate"))) {
                        refTableKey = entityType.getProperty(key) != null ? key : refTableKey.substring(0, refTableKey.lastIndexOf("_")) + key.substring(key.lastIndexOf("_"));
                    }
                    Object val = dobj.get(entryProp.getName());
                    if (entryProp instanceof NoCodeBillNoProp) {
                        billNoKey = refTableKey;
                    }
                    if (entityType.getProperty(refTableKey) == null) {
                        String message = entryType.getDisplayName().toString() + ResManager.loadKDString((String)"\u8868\u683c\u7684", (String)"NoCodeOpPlugin_0", (String)BOS_NOCODE_OPPLUGIN, (Object[])new Object[0]) + entryType.getProperty(key).getDisplayName().toString() + ResManager.loadKDString((String)"\u5b57\u6bb5\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u53d1\u5e03\u5f53\u524d\u8868\u5355", (String)"NoCodeOpPlugin_1", (String)BOS_NOCODE_OPPLUGIN, (Object[])new Object[0]);
                        throw new KDBizException(message);
                    }
                    obj.set(refTableKey, val);
                }
                if (StringUtils.isNotBlank((CharSequence)modifyName)) {
                    obj.set(modifyName, (Object)RequestContext.get().getCurrUserId());
                }
                if (StringUtils.isNotBlank((CharSequence)modifyTime)) {
                    obj.set(modifyTime, (Object)DateTimeUtils.getNow());
                }
                objects.add(obj);
            }
            if (!StringUtils.isBlank((CharSequence)billNoKey)) {
                Object dobj;
                List billNos = CodeRuleServiceHelper.getNumbers((String)entityType.getName(), objects);
                dobj = objects.iterator();
                while (dobj.hasNext()) {
                    DynamicObject dynamicObject = (DynamicObject)dobj.next();
                    String string = dynamicObject.getString(billNoKey);
                    if (!StringUtils.isBlank((CharSequence)string)) continue;
                    dynamicObject.set(billNoKey, billNos.get(0));
                    billNos.remove(0);
                }
            }
            String val = "";
            StringBuffer res = new StringBuffer();
            for (Object e : pks) {
                res.append(e).append(",");
            }
            if (StringUtils.isNotBlank((CharSequence)res)) {
                val = res.toString().substring(0, res.length() - 1);
            }
            if (StringUtils.isBlank((CharSequence)val)) {
                dp.setDTValueFast(dataEntity, null);
            } else if (dp instanceof NoCodeRefBillProp) {
                dataEntity.set(fieldKey + "_id", (Object)Long.parseLong(val));
            } else {
                dp.setDTValueFast(dataEntity, (Object)val);
            }
            if (!"1".equals(prop.getSourceForm()) && BlackFormUtil.isCosmicForm((String)billEntityId)) continue;
            SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
        }
    }

    private Map<Long, DynamicObject> loadData(DynamicObjectCollection cols, DynamicObjectType entityType) {
        DynamicObject[] objs;
        ArrayList<Long> pks = new ArrayList<Long>(10);
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dobj : cols) {
            if (Long.parseLong(dobj.getPkValue().toString()) == 0L) continue;
            pks.add(Long.parseLong(dobj.getPkValue().toString()));
        }
        for (DynamicObject o : objs = BusinessDataServiceHelper.load((Object[])pks.toArray(new Long[pks.size()]), (DynamicObjectType)entityType)) {
            map.put(Long.parseLong(o.getPkValue().toString()), o);
        }
        return map;
    }

    private OperateErrorInfo addTargetIds(DynamicObject dataEntity, Map<Long, Set<String>> idFieldMap, String sourceKey, List<Long> targetIds, Map<Long, List<Long>> idValueMap, String targetKey) {
        ArrayList<Long> old_pks = new ArrayList<Long>();
        ArrayList<Long> new_pks = new ArrayList<Long>();
        DynamicProperty property = dataEntity.getDynamicObjectType().getProperty(sourceKey);
        if (property instanceof NoCodeRefBillProp) {
            DynamicObject dynamicObject;
            DynamicObject obj_old;
            DynamicObject[] dynamicObjects;
            Object oldVal = dataEntity.get(sourceKey);
            if (oldVal == null) {
                oldVal = dataEntity.get(sourceKey + "_id");
            }
            if (oldVal instanceof Long && Long.parseLong(oldVal.toString()) == 0L) {
                oldVal = null;
            }
            Long pk = 0L;
            if (oldVal instanceof DynamicObject) {
                DynamicObject obj = (DynamicObject)oldVal;
                pk = (Long)obj.getPkValue();
            } else if (oldVal instanceof Long || oldVal instanceof String) {
                pk = Long.parseLong(oldVal.toString());
            }
            if (Long.parseLong(dataEntity.getPkValue().toString()) != 0L && (dynamicObjects = BusinessDataServiceHelper.load((Object[])new Object[]{dataEntity.getPkValue()}, (DynamicObjectType)this.billEntityType)) != null && dynamicObjects.length > 0 && (obj_old = (dynamicObject = dynamicObjects[0]).getDynamicObject(sourceKey)) != null) {
                Long old_pk = (Long)obj_old.getPkValue();
                old_pks.add(old_pk);
            }
            if (pk != 0L) {
                NoCodeRefBillProp mulRefBillProp = (NoCodeRefBillProp)property;
                String targetFormId = mulRefBillProp.getBillEntityId();
                MainEntityType targetType = EntityMetadataCache.getDataEntityType((String)targetFormId);
                DynamicProperty targetProp = targetType.getProperty(targetKey);
                if (targetProp instanceof NoCodeRefBillProp) {
                    DynamicObject[] temps;
                    ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
                    filters.add(new QFilter(sourceKey, "=", (Object)pk));
                    if (Long.parseLong(dataEntity.getPkValue().toString()) != 0L) {
                        filters.add(new QFilter("id", "!=", dataEntity.getPkValue()));
                    }
                    if ((temps = BusinessDataServiceHelper.load((String)this.billEntityType.getName(), (String)"id", (QFilter[])filters.toArray(new QFilter[0]))).length > 0) {
                        OperateErrorInfo errorInfo = new OperateErrorInfo();
                        errorInfo.setMessage(ResManager.loadKDString((String)"\u5173\u8054\u5173\u7cfb\u5df2\u8fbe\u4e0a\u9650\uff01", (String)"NoCodeOpPlugin_2", (String)BOS_NOCODE_OPPLUGIN, (Object[])new Object[0]));
                        errorInfo.setLevel(ErrorLevel.Error);
                        return errorInfo;
                    }
                }
                new_pks.add(pk);
            }
        } else {
            NoCodeMulRefBillProp mulRefBillProp;
            String targetFormId;
            MainEntityType targetType;
            DynamicProperty targetProp;
            String obj;
            DynamicObject[] dynamicObjects;
            if (Long.parseLong(dataEntity.getPkValue().toString()) != 0L && (dynamicObjects = BusinessDataServiceHelper.load((Object[])new Object[]{dataEntity.getPkValue()}, (DynamicObjectType)this.billEntityType)) != null && dynamicObjects.length > 0) {
                DynamicObject dynamicObject = dynamicObjects[0];
                String obj_old = dynamicObject.getString(sourceKey);
                this.addTargetIds(obj_old, old_pks);
            }
            if (StringUtils.isNotBlank((CharSequence)(obj = dataEntity.getString(sourceKey))) && obj != null && (targetProp = (targetType = EntityMetadataCache.getDataEntityType((String)(targetFormId = (mulRefBillProp = (NoCodeMulRefBillProp)property).getBillEntityId()))).getProperty(targetKey)) instanceof NoCodeRefBillProp) {
                ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
                String[] ids = obj.split(",");
                List pks = Arrays.stream(ids).map(Long::parseLong).collect(Collectors.toList());
                filters.add(new QFilter("id", "in", pks));
                DynamicObject[] temps = BusinessDataServiceHelper.load((String)targetType.getName(), (String)("id," + targetKey), (QFilter[])filters.toArray(new QFilter[0]));
                if (temps.length > 0) {
                    for (DynamicObject temp : temps) {
                        Long currentPk;
                        DynamicObject targetVal = temp.getDynamicObject(targetKey);
                        if (StringUtils.isBlank((Object)targetVal) || (currentPk = Long.valueOf(Long.parseLong(dataEntity.getPkValue().toString()))) != 0L && currentPk.equals(Long.parseLong(targetVal.getPkValue().toString()))) continue;
                        OperateErrorInfo errorInfo = new OperateErrorInfo();
                        errorInfo.setMessage(ResManager.loadKDString((String)"\u5173\u8054\u5173\u7cfb\u5df2\u8fbe\u4e0a\u9650\uff01", (String)"NoCodeOpPlugin_2", (String)BOS_NOCODE_OPPLUGIN, (Object[])new Object[0]));
                        errorInfo.setLevel(ErrorLevel.Error);
                        return errorInfo;
                    }
                }
            }
            this.addTargetIds(obj, new_pks);
        }
        List deleted_list = old_pks.stream().filter(e -> !new_pks.contains(e)).collect(Collectors.toList());
        List new_list = new_pks.stream().filter(e -> !old_pks.contains(e)).collect(Collectors.toList());
        for (Long pk : new_list) {
            idValueMap.computeIfAbsent(pk, k -> new ArrayList()).add(Long.parseLong(dataEntity.getPkValue().toString()));
            idFieldMap.computeIfAbsent(pk, k -> new HashSet()).add(sourceKey + "__new");
            targetIds.add(pk);
        }
        for (Long pk : deleted_list) {
            idValueMap.computeIfAbsent(pk, k -> new ArrayList()).add(Long.parseLong(dataEntity.getPkValue().toString()));
            idFieldMap.computeIfAbsent(pk, k -> new HashSet()).add(sourceKey + "__delete");
            targetIds.add(pk);
        }
        return null;
    }

    private void addTargetIds(String obj, List<Long> list) {
        if (StringUtils.isNotBlank((CharSequence)obj) && obj != null) {
            String[] pks;
            for (String s : pks = obj.split(",")) {
                Long pk = Long.parseLong(s);
                list.add(pk);
            }
        }
    }

    private void updateAssociatedForm(BeginOperationTransactionArgs e) {
        if ("true".equals(this.operateOption.getVariableValue("ignoreAssociation", "false"))) {
            return;
        }
        boolean isBatch = false;
        if (e.getDataEntities().length > 1) {
            isBatch = true;
        }
        String formId = this.billEntityType.getName();
        DynamicObject dataEntity = e.getDataEntities()[0];
        if (dataEntity == null) {
            return;
        }
        try {
            Map formMap = AssociationServiceHelper.getAssociationFields((String)formId);
            for (Map.Entry form : formMap.entrySet()) {
                DynamicObject[] dy_objs;
                Object id;
                Map fields = (Map)form.getValue();
                String targetFormId = (String)form.getKey();
                HashMap<Long, Set<String>> idFieldMap = new HashMap<Long, Set<String>>(16);
                HashMap<Long, List<Long>> idValueMap = new HashMap<Long, List<Long>>(16);
                ArrayList<Long> targetIds = new ArrayList<Long>();
                for (Map.Entry entry : fields.entrySet()) {
                    ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>(10);
                    for (int i = 0; i < e.getDataEntities().length; ++i) {
                        DynamicObject dynamicObject = e.getDataEntities()[i];
                        OperateErrorInfo errorInfo = this.addTargetIds(dynamicObject, idFieldMap, (String)entry.getKey(), targetIds, idValueMap, (String)entry.getValue());
                        if (errorInfo != null) {
                            errorInfo.setDataEntityIndex(i);
                            this.getOperationResult().addErrorInfo(errorInfo);
                            continue;
                        }
                        successObjs.add(dynamicObject);
                    }
                    e.setDataEntities(successObjs.toArray(new DynamicObject[0]));
                }
                if (targetIds.isEmpty()) continue;
                ISimpleProperty pkProp = this.billEntityType.getPrimaryKey();
                if (pkProp instanceof PKFieldProp && e.getOperationKey().equals("save") && Long.parseLong(dataEntity.getPkValue().toString()) == 0L && (id = ((PKFieldProp)pkProp).genPKValue()) != null) {
                    pkProp.setValue((Object)dataEntity, id);
                }
                MainEntityType targetEntityType = EntityMetadataCache.getDataEntityType((String)targetFormId);
                for (DynamicObject obj : dy_objs = BusinessDataServiceHelper.load((Object[])targetIds.toArray(new Long[targetIds.size()]), (DynamicObjectType)targetEntityType)) {
                    Long pk = (Long)obj.getPkValue();
                    List valueList = (List)idValueMap.get(pk);
                    Set sourceKeys = (Set)idFieldMap.get(pk);
                    if (sourceKeys.isEmpty()) continue;
                    for (String sourceKey : sourceKeys) {
                        String oldValue;
                        String[] arrays = sourceKey.split("__");
                        String targetKey = (String)fields.get(arrays[0]);
                        String operationType = arrays[1];
                        DynamicProperty property = obj.getDynamicObjectType().getProperty(targetKey);
                        if (property instanceof NoCodeRefBillProp) {
                            if (operationType.equals("new")) {
                                if (isBatch) {
                                    oldValue = obj.getDynamicObject(targetKey);
                                    if (oldValue != null && !oldValue.getPkValue().equals(dataEntity.getPkValue())) {
                                        this.rollBack(e);
                                        return;
                                    }
                                    obj.set(targetKey, valueList.get(valueList.size() - 1));
                                    continue;
                                }
                                obj.set(targetKey, dataEntity.getPkValue());
                                continue;
                            }
                            if (!operationType.equals("delete")) continue;
                            obj.set(targetKey, null);
                            continue;
                        }
                        if (!(property instanceof NoCodeMulRefBillProp)) continue;
                        oldValue = obj.getString(targetKey);
                        String newValue = valueList.stream().map(Object::toString).collect(Collectors.joining(","));
                        if (StringUtils.isBlank((CharSequence)oldValue)) {
                            if (!operationType.equals("new")) continue;
                            if (isBatch) {
                                obj.set(targetKey, (Object)newValue);
                                continue;
                            }
                            obj.set(targetKey, dataEntity.getPkValue());
                            continue;
                        }
                        String[] oldPks = oldValue.split(",");
                        if (operationType.equals("new")) {
                            if (isBatch) {
                                newValue = Stream.concat(Arrays.stream(newValue.split(",")), Arrays.stream(oldPks)).distinct().collect(Collectors.joining(","));
                                obj.set(targetKey, (Object)newValue);
                                continue;
                            }
                            NoCodeMulRefBillProp prop = (NoCodeMulRefBillProp)property;
                            int max = Integer.parseInt(prop.getDataRange().getMax());
                            if (oldPks.length >= max && !oldValue.contains(dataEntity.getPkValue().toString())) {
                                this.rollBack(e);
                                return;
                            }
                            if (!oldValue.contains(dataEntity.getPkValue().toString())) {
                                oldValue = oldValue + "," + dataEntity.getPkValue();
                            }
                            obj.set(targetKey, (Object)oldValue);
                            continue;
                        }
                        if (!operationType.equals("delete")) continue;
                        if (isBatch) {
                            List oldList = Arrays.stream(oldPks).map(Long::valueOf).collect(Collectors.toList());
                            for (Long l : valueList) {
                                if (!oldList.contains(l)) continue;
                                oldList.remove(l);
                            }
                            String oldV = oldList.stream().map(Object::toString).collect(Collectors.joining(","));
                            obj.set(targetKey, (Object)oldV);
                            continue;
                        }
                        CharSequence[] newPks = (String[])Arrays.stream(oldPks).filter(str -> !str.equals(dataEntity.getPkValue().toString())).toArray(String[]::new);
                        String newVal = String.join((CharSequence)",", newPks);
                        obj.set(targetKey, (Object)newVal);
                    }
                }
                SaveServiceHelper.update((DynamicObject[])dy_objs);
            }
        }
        catch (Exception exc) {
            if (exc instanceof KDBizException) {
                throw exc;
            }
            try (EntityTraceSpan span = EntityTracer.create((String)"NoCodeOpPlugin", (String)"updateAssociatedForm");){
                span.throwException((Throwable)exc);
            }
        }
    }

    private void rollBack(BeginOperationTransactionArgs e) {
        e.setCancelOperation(true);
    }
}

