/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.form;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillViewPluginProxy;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.nocode.NoCodeBillShowParameter;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.constant.WfTaskActionEnum;
import kd.bos.nocode.ext.form.control.NoCodeBizButton;
import kd.bos.nocode.ext.metadata.form.control.NoCodeBizButtonAp;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaHelper;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeUserInput;
import kd.bos.nocode.ext.util.WfProcessUtils;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import kd.bos.nocode.servicehelper.ServiceFactory;
import kd.bos.nocode.util.BizButtonUtil;
import kd.bos.nocode.util.NoCodeTemplateUtil;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.nocode.utils.ShareInputMode;
import kd.bos.nocode.wf.NoCodeWfRecordApiService;
import kd.bos.nocode.wf.NoCodeWfService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.useragent.util.UserAgentUtils;
import kd.bos.workflow.api.model.ProcessDefinitionInfo;
import kd.bos.workflow.api.model.ProcessModel;

public class NoCodeBillContainerPlugin
extends AbstractFormPlugin {
    private static final String CONTENT_PANEL = "contentpanel";
    private static final String OPERATE_PANEL = "operatepanel";
    private static final String STD_BTN_PREFIX = "btn";
    private static final String BTN_SAVE = "btnsave";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_SUBMIT = "btnsubmit";
    private static final String BTN_SAVE_AND_NEW = "btnsaveandnew";
    private static final String BTN_SAVE_AND_COPY = "btnsaveandcopy";
    private static final String BTN_COPY = "btncopy";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_DEL = "btndel";
    private static final String OPERATE_KEY_COPY = "copy";
    private static final String OPERATE_KEY_DELETE = "delete";
    private static final String OPT_SAVEANDNEW = "saveandnew";
    private static final String OPT_NEW = "new";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String NAME = "name";
    private static final String TARGET_FORM_ID = "targetFormId";
    private static final String APPID = "appid";
    private static final String TARGET_PK_ID = "pkId";
    private static final String STATUS = "Status";
    private static final String STATUS_VIEW = "view";
    private static final String STATUS_COPY = "copy";
    private static final String TARGET_FORM_PAGE_ID = "targetFormPageId";
    private static final String BOS_NOCODE_FORMPLUGIN = "bos-nocode-formplugin";
    private static final String BIZ_BTN = "bizbtn_";
    private static final Log LOG = LogFactory.getLog(NoCodeBillContainerPlugin.class);
    public static final String API_SAVE_0 = "ApiSave_0";
    public static final String UNDEFINED = "undefined";
    private final String PASS_EDIT_PERM = "passEditPermCheck";
    private final String PASS_VIEW_PERM = "passViewPermCheck";
    CallBackAfterSave addShareInputRecord;

    private String getWfLockMessage() {
        return "\u6d41\u7a0b\u9501\u5b9a\u4e2d\uff0c\u4e0d\u53ef\u7f16\u8f91";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SAVE, BTN_SUBMIT, BTN_SAVE_AND_NEW, BTN_SAVE_AND_COPY, BTN_COPY, BTN_DEL, BTN_NEW, BTN_EDIT});
    }

    public void click(EventObject evt) {
        LOG.debug("\u89e6\u53d1\u70b9\u51fb\u4e8b\u4ef6\uff1a", (Object)evt);
        super.click(evt);
        Button btn = (Button)evt.getSource();
        switch (btn.getKey()) {
            case "btnsave": 
            case "btnsubmit": {
                this.saveData();
                break;
            }
            case "btnsaveandnew": {
                this.saveAndNewData();
                break;
            }
            case "btnsaveandcopy": {
                this.saveAndCopy();
                break;
            }
            case "btncopy": {
                this.copy();
                break;
            }
            case "btnnew": {
                this.add();
                break;
            }
            case "btndel": {
                this.del();
                break;
            }
            case "btnedit": {
                this.edit();
                break;
            }
        }
    }

    private IFormView getTargetView() {
        String pageId = this.getPageCache().get(TARGET_FORM_PAGE_ID);
        return SessionManager.getCurrent().getView(pageId);
    }

    private String getAppIdFromCache() {
        String appid = this.getPageCache().get(APPID);
        if (appid == null) {
            String formid = this.getPageCache().get(TARGET_FORM_ID);
            appid = FormMetaUtil.getAppIdByFormId((String)formid);
            this.getPageCache().put(APPID, appid);
        }
        return appid;
    }

    private void saveData() {
        OperationResult operationResult;
        boolean mobile;
        LOG.debug("\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c");
        LOG.debug("\u5f53\u524dpageCache={}", (Object)this.getPageCache());
        String targetFormId = this.getPageCache().get(TARGET_FORM_ID);
        IFormView view = this.getTargetView();
        if (view == null) {
            return;
        }
        if (!view.getModel().isDataLoaded()) {
            return;
        }
        OperationStatus status = this.getTargetOperationStatus();
        WfConsts.WfLockStatusEnum wfLockStatus = this.getWfLockStatus();
        if (wfLockStatus == WfConsts.WfLockStatusEnum.LOCKED && status == OperationStatus.EDIT && !this.isUserTask()) {
            this.getView().showErrorNotification(this.getWfLockMessage());
            return;
        }
        boolean isCurrentInputUser = this.isCurrentInputUser();
        String appid = this.getAppIdFromCache();
        String formid = this.getTargetFormId();
        boolean check = false;
        if (!isCurrentInputUser) {
            if (status == OperationStatus.EDIT || status == OperationStatus.VIEW) {
                String pass = this.getPageCache().get("passEditPermCheck");
                check = "true".equals(pass) ? true : NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.edit, (String)formid) && NoCodePermHelper.checkDataEditPermInNoCode((String)formid, (Object)this.getPkId());
            } else if (status == OperationStatus.ADDNEW) {
                String shareId = this.getShareId();
                if (NoCodePermHelper.isShare((String)appid, (String)formid, (String)shareId)) {
                    check = true;
                    ShareInputMode mode = NoCodePermHelper.getAddShareMode((String)shareId);
                    if (this.addShareInputRecord == null && mode != ShareInputMode.ALWAYS) {
                        this.addShareInputRecord = this.newShareInputRecord();
                    }
                } else {
                    check = NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.input, (String)formid);
                }
            }
            if (!check) {
                this.getView().showErrorNotification("\u6743\u9650\u4e0d\u8db3");
                return;
            }
        }
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)targetFormId);
        LOG.debug("\u83b7\u53d6FormConfig\uff0ctargetFormId: {}\uff0cformConfig: {}", (Object)targetFormId, (Object)formConfig);
        LOG.debug("\u83b7\u53d6FormConfig\uff0cformConfig json\uff1a{}", (Object)SerializationUtils.toJsonString((Object)formConfig));
        String entityTypeId = formConfig.getEntityTypeId();
        Operations operations = EntityMetadataCache.getDataEntityOperations((String)entityTypeId);
        String save = operations.getSave();
        if (StringUtils.isBlank((CharSequence)save)) {
            throw new KDException(ResManager.loadKDString((String)"%s \u4e1a\u52a1\u5bf9\u8c61\u672a\u914d\u7f6e\u4fdd\u5b58\u64cd\u4f5c", (String)API_SAVE_0, (String)"", (Object[])new Object[]{targetFormId}));
        }
        String taskId = this.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId) && status == OperationStatus.EDIT) {
            try {
                LOG.debug("\u9875\u9762\u63d0\u4ea4\uff0ctaskId={}", (Object)taskId);
                if (Objects.equals("0", taskId)) {
                    this.getView().showErrorNotification("\u60a8\u5df2\u7ecf\u4e0d\u662f\u4efb\u52a1\u7684\u5904\u7406\u4eba\uff0c\u4e0d\u80fd\u64cd\u4f5c");
                    return;
                }
            }
            catch (Exception e) {
                LOG.debug("\u5b8c\u6210\u4efb\u52a1\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                this.getView().showErrorNotification(e.getMessage());
                return;
            }
        }
        if (mobile = this.isMobile()) {
            view.getFormShowParameter().setCustomParam("ignoreRules", (Object)"true");
        }
        if ((operationResult = view.invokeOperation(save)).isSuccess()) {
            List successPkIds;
            if (StringUtils.isNotBlank((CharSequence)taskId) && !"0".equalsIgnoreCase(taskId) && status == OperationStatus.EDIT) {
                NoCodeWfRecordApiService noCodeWfRecordApiService = (NoCodeWfRecordApiService)ServiceFactory.getService((String)"NoCodeWfRecordApiService");
                noCodeWfRecordApiService.completeTask(Long.valueOf(Long.parseLong(taskId)), WfTaskActionEnum.handle.toString());
            }
            if (!mobile) {
                this.getView().sendFormAction(view);
            }
            if (mobile) {
                ((IClientViewProxy)view.getService(IClientViewProxy.class)).removeAction("ShowNotificationMsg");
                this.getView().sendFormAction(view);
                view.getModel().updateCache();
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("mobSaveSuccess", null);
            }
            if ((successPkIds = operationResult.getSuccessPkIds()).size() > 0) {
                ArrayList pkIds = new ArrayList(successPkIds.size());
                successPkIds.forEach(pk -> pkIds.add(pk.toString()));
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("setPkId", pkIds);
                this.getPageCache().put(TARGET_PK_ID, (String)pkIds.get(0));
            }
            this.afterSave(view);
        } else {
            this.getView().sendFormAction(view);
        }
    }

    private CallBackAfterSave newShareInputRecord() {
        return () -> {
            Object pkId = this.getPkId();
            String ip = RequestContext.get().getLoginIP();
            QFilter f1 = new QFilter("ip", "=", (Object)ip);
            String shareId = this.getShareId();
            QFilter f2 = new QFilter("shareid", "=", (Object)shareId.split("_")[0]);
            DynamicObject record = BusinessDataServiceHelper.loadSingle((String)"bos_nocode_share_record", (QFilter[])new QFilter[]{f1, f2});
            if (record == null) {
                record = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_share_record");
            }
            LOG.warn("ip={},shareid={},recordid={}.", new Object[]{ip, shareId, pkId});
            record.set("ip", (Object)ip);
            record.set("shareid", (Object)shareId.split("_")[0]);
            record.set("recordid", pkId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        };
    }

    private void afterSave(IFormView view) {
        boolean nested = Boolean.parseBoolean(this.getPageCache().get("nested"));
        if (nested) {
            String type;
            if (this.isMobile()) {
                this.getView().sendFormAction(view);
            }
            switch (type = this.getPageCache().get("nestedType")) {
                case "showInfo": {
                    this.getView().getParentView().updateView();
                    this.getView().sendFormAction(this.getView().getParentView());
                    IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    proxy.addAction("closeWindow", (Object)Maps.of((Object)"pageId", (Object)this.getView().getPageId()));
                    break;
                }
                case "addRef": 
                case "editF7": {
                    String props = this.getPageCache().get("saveCallbackProps");
                    String key = this.getPageCache().get("controlKey");
                    HashMap<String, String> ret = new HashMap<String, String>();
                    String pkId = this.getPageCache().get(TARGET_PK_ID);
                    String formId = this.getPageCache().get(TARGET_FORM_ID);
                    DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)formId);
                    Set select = dy.getDataEntityType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet());
                    Map map = PropertyHandleUtil.toMap((Object)pkId, (String)formId, (String)"$", (DynamicObject)dy, select, (boolean)true);
                    ret.put(TARGET_PK_ID, pkId);
                    if (!props.isEmpty()) {
                        if (props.contains(",")) {
                            for (String prop : props.split(",")) {
                                ret.put(prop, (String)map.get(prop));
                            }
                        } else {
                            ret.put(props, (String)map.get(props));
                        }
                    }
                    IFormView parentView = this.getView().getParentView();
                    IClientViewProxy proxy1 = (IClientViewProxy)parentView.getService(IClientViewProxy.class);
                    proxy1.addAction("InvokeControlMethod", (Object)Maps.of((Object)"key", (Object)key, (Object)"methodname", (Object)"refreshRefList", (Object)"args", Collections.singletonList(ret)));
                    IClientViewProxy proxy2 = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    proxy2.addAction("closeWindow", (Object)Maps.of((Object)"pageId", (Object)this.getView().getPageId()));
                    this.getView().sendFormAction(parentView);
                    break;
                }
                case "wfAddRef": {
                    String wfPageId = this.getPageCache().get("saveCallbackProps");
                    String key = this.getPageCache().get("controlKey");
                    IFormView wfView = SessionManager.getCurrent().getView(wfPageId);
                    String formid = this.getPageCache().get(TARGET_FORM_ID);
                    IClientViewProxy proxy = (IClientViewProxy)wfView.getService(IClientViewProxy.class);
                    proxy.addAction("InvokeControlMethod", (Object)Maps.of((Object)"key", (Object)key, (Object)"methodname", (Object)"refreshRefList", (Object)"args", (Object)formid));
                    IClientViewProxy proxy2 = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    proxy2.addAction("closeWindow", (Object)Maps.of((Object)"pageId", (Object)this.getView().getPageId()));
                    this.getView().sendFormAction(wfView);
                }
            }
        }
        if (this.addShareInputRecord != null) {
            this.addShareInputRecord.exec();
        }
    }

    private boolean isCurrentInputUser() {
        String userTaskCurrentUserId = this.getUserTaskCurrentUserId();
        return StringUtils.isNotBlank((CharSequence)userTaskCurrentUserId) && userTaskCurrentUserId.indexOf(RequestContext.get().getUserId()) != -1;
    }

    private void saveAndNewData() {
        String targetFormId = this.getPageCache().get(TARGET_FORM_ID);
        IFormView view = this.getTargetView();
        if (view == null) {
            return;
        }
        String formid = this.getPageCache().get(TARGET_FORM_ID);
        boolean check = NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.input, (String)formid);
        if (!check) {
            this.getView().showErrorNotification("\u6743\u9650\u4e0d\u8db3");
            return;
        }
        String entityTypeId = FormMetadataCache.getFormConfig((String)targetFormId).getEntityTypeId();
        Map operate = EntityMetadataCache.getDataEntityOperate((String)entityTypeId, (String)OPT_SAVEANDNEW);
        if (operate == null) {
            throw new KDException(ResManager.loadKDString((String)"%s \u4e1a\u52a1\u5bf9\u8c61\u672a\u914d\u7f6e\u4fdd\u5b58\u5e76\u65b0\u5efa\u64cd\u4f5c", (String)API_SAVE_0, (String)"", (Object[])new Object[]{targetFormId}));
        }
        view.invokeOperation(OPT_SAVEANDNEW);
        this.getView().sendFormAction(view);
    }

    private void add() {
        String targetFormId = this.getPageCache().get(TARGET_FORM_ID);
        IFormView view = this.getTargetView();
        if (view == null) {
            return;
        }
        String formid = this.getPageCache().get(TARGET_FORM_ID);
        boolean check = NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.input, (String)formid);
        if (!check) {
            this.getView().showErrorNotification("\u6743\u9650\u4e0d\u8db3");
            return;
        }
        String entityTypeId = FormMetadataCache.getFormConfig((String)targetFormId).getEntityTypeId();
        Map operate = EntityMetadataCache.getDataEntityOperate((String)entityTypeId, (String)OPT_NEW);
        if (operate == null) {
            throw new KDException(ResManager.loadKDString((String)"%s \u4e1a\u52a1\u5bf9\u8c61\u672a\u914d\u7f6e\u65b0\u5efa\u64cd\u4f5c", (String)API_SAVE_0, (String)"", (Object[])new Object[]{targetFormId}));
        }
        view.invokeOperation(OPT_NEW);
        this.getView().sendFormAction(view);
    }

    private void saveAndCopy() {
        String targetFormId = this.getPageCache().get(TARGET_FORM_ID);
        IFormView view = this.getTargetView();
        if (view == null) {
            return;
        }
        String formid = this.getPageCache().get(TARGET_FORM_ID);
        boolean check = NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.input, (String)formid);
        if (!check) {
            this.getView().showErrorNotification("\u6743\u9650\u4e0d\u8db3");
            return;
        }
        String entityTypeId = FormMetadataCache.getFormConfig((String)targetFormId).getEntityTypeId();
        Operations operations = EntityMetadataCache.getDataEntityOperations((String)entityTypeId);
        String save = operations.getSave();
        if (StringUtils.isBlank((CharSequence)save)) {
            throw new KDException(ResManager.loadKDString((String)"%s \u4e1a\u52a1\u5bf9\u8c61\u672a\u914d\u7f6e\u4fdd\u5b58\u64cd\u4f5c", (String)API_SAVE_0, (String)"", (Object[])new Object[]{targetFormId}));
        }
        OperationResult operationResult = view.invokeOperation(save);
        if (operationResult.isSuccess()) {
            view.invokeOperation("copy");
        }
        this.getView().sendFormAction(view);
    }

    private void copy() {
        String entityTypeId;
        Map operate;
        IFormView view = this.getTargetView();
        if (view == null) {
            return;
        }
        String formid = this.getPageCache().get(TARGET_FORM_ID);
        boolean check = NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.input, (String)formid);
        if (!check) {
            this.getView().showErrorNotification("\u6743\u9650\u4e0d\u8db3");
            return;
        }
        OperationStatus targetOperationStatus = this.getTargetOperationStatus();
        if (targetOperationStatus == OperationStatus.VIEW) {
            NoCodeBillShowParameter noCodeBillShowParameter = (NoCodeBillShowParameter)view.getFormShowParameter();
            noCodeBillShowParameter.setNocodeBillStatus(OperationStatus.ADDNEW);
            view.cacheFormShowParameter();
        }
        if ((operate = EntityMetadataCache.getDataEntityOperate((String)(entityTypeId = FormMetadataCache.getFormConfig((String)formid).getEntityTypeId()), (String)"copy")) == null) {
            throw new KDException("\u8868\u5355\u9700\u8981\u91cd\u65b0\u53d1\u5e03");
        }
        view.getFormShowParameter().setCustomParam("ignoreRules", (Object)"true");
        view.invokeOperation("copy");
        this.getView().sendFormAction(view);
    }

    private void del() {
        boolean check;
        IFormView view = this.getTargetView();
        if (view == null) {
            return;
        }
        String formid = this.getPageCache().get(TARGET_FORM_ID);
        boolean bl = check = NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.delete, (String)formid) && NoCodePermHelper.checkDataDelPermInNoCode((String)formid, (Object)this.getPkId());
        if (!check) {
            this.getView().showErrorNotification("\u6743\u9650\u4e0d\u8db3");
            return;
        }
        WfConsts.WfLockStatusEnum wfLockStatus = this.getWfLockStatus();
        if (wfLockStatus == WfConsts.WfLockStatusEnum.LOCKED) {
            this.getView().showErrorNotification("\u6d41\u7a0b\u9501\u5b9a\u4e2d\uff0c\u4e0d\u53ef\u5220\u9664");
            this.getView().setStatus(OperationStatus.VIEW);
            return;
        }
        OperationResult operationResult = view.invokeOperation(OPERATE_KEY_DELETE);
        this.getView().sendFormAction(view);
        if (operationResult.isSuccess()) {
            HashMap<String, String> arg = new HashMap<String, String>(1);
            arg.put("pageId", this.getView().getPageId());
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
            NoCodeWfService noCodeWfService = (NoCodeWfService)ServiceFactory.getService((String)"NoCodeWfService");
            noCodeWfService.deleteWfInfoByEntityNumberAndBusinessKey(formid, String.valueOf(this.getPkId()));
        }
    }

    private void edit() {
        boolean check;
        IFormView view = this.getTargetView();
        if (view == null) {
            return;
        }
        String formid = this.getPageCache().get(TARGET_FORM_ID);
        boolean isCurrentInputUser = this.isCurrentInputUser();
        boolean bl = check = isCurrentInputUser || NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.edit, (String)formid) && NoCodePermHelper.checkDataEditPermInNoCode((String)formid, (Object)this.getPkId());
        if (!check) {
            String pass = this.getPageCache().get("passEditPermCheck");
            check = "true".equals(pass);
        }
        if (!check) {
            this.getView().showErrorNotification("\u6743\u9650\u4e0d\u8db3");
            return;
        }
        WfConsts.WfLockStatusEnum wfLockStatus = this.getWfLockStatus();
        OperationStatus operationStatus = this.getContainerOperationStatus();
        if (wfLockStatus == WfConsts.WfLockStatusEnum.LOCKED) {
            this.getView().showErrorNotification(this.getWfLockMessage());
            this.getView().setStatus(OperationStatus.VIEW);
            return;
        }
        NoCodeBillShowParameter noCodeBillShowParameter = (NoCodeBillShowParameter)view.getFormShowParameter();
        noCodeBillShowParameter.setStatus(OperationStatus.EDIT);
        noCodeBillShowParameter.setBillStatus(BillOperationStatus.EDIT);
        noCodeBillShowParameter.setNocodeBillStatus(OperationStatus.EDIT);
        view.cacheFormShowParameter();
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.removeAction("setFormStatus");
        this.getView().setStatus(OperationStatus.EDIT);
        this.reloadBill(view, formid);
        view.setStatus(OperationStatus.EDIT);
        this.getView().sendFormAction(view);
    }

    private void reloadBill(IFormView view, String formid) {
        IBillModel billModel = (IBillModel)view.getModel();
        billModel.beginInit();
        Object pkId = this.getPkId();
        billModel.setPKValue(pkId);
        billModel.load(pkId);
        ((BillViewPluginProxy)view.getService(FormViewPluginProxy.class)).fireAfterLoadData(new EventObject(view));
        billModel.endInit();
        this.setButtonStatus(OperationStatus.EDIT.toString(), view.getParentView());
        Set hides = NoCodePermHelper.getNoViewFieldPermSet((String)formid);
        if (!hides.isEmpty()) {
            List args = hides.stream().map(f -> Maps.of((Object)"k", (Object)f, (Object)"v", (Object)"1")).collect(Collectors.toList());
            IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            proxy.addAction("setControlState", args);
        }
        view.updateView();
    }

    public void afterBindData(EventObject e) {
        long startTime = System.currentTimeMillis();
        String targetFormId = this.getTargetFormId();
        if (StringUtils.isBlank((CharSequence)targetFormId)) {
            throw new KDBizException("need targetFormId param");
        }
        this.getPageCache().put(TARGET_FORM_ID, targetFormId);
        String appId = FormMetaUtil.getAppIdByFormId((String)targetFormId);
        if (StringUtils.isBlank((CharSequence)appId)) {
            throw new KDBizException("\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664");
        }
        String sErrorPkId = this.checkAndCachePkId(targetFormId);
        if (StringUtils.isNotBlank((CharSequence)sErrorPkId)) {
            this.getView().showErrorNotification(sErrorPkId);
            return;
        }
        this.getPageCache().put(APPID, appId);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        WfConsts.WfLockStatusEnum wfLockStatus = this.getWfLockStatus();
        this.getView().getPageCache().put("wflock", wfLockStatus.getCode());
        OperationStatus operationStatus = this.getContainerOperationStatus();
        if (wfLockStatus == WfConsts.WfLockStatusEnum.LOCKED && operationStatus == OperationStatus.EDIT && !this.isUserTask()) {
            operationStatus = OperationStatus.VIEW;
            this.getView().showTipNotification(this.getWfLockMessage());
        }
        String userTaskCurrentUserId = this.getUserTaskCurrentUserId();
        boolean isCurrentInputUser = this.isCurrentInputUser();
        long uid = RequestContext.get().getCurrUserId();
        if (StringUtils.isNotBlank((CharSequence)userTaskCurrentUserId) && !isCurrentInputUser) {
            LOG.debug(String.format("\u5f55\u5165\u4eba\uff1a%s \u5f53\u524d\u7528\u6237\uff1a%s", userTaskCurrentUserId, uid));
            operationStatus = OperationStatus.VIEW;
        }
        clientViewProxy.removeAction("setFormStatus");
        this.getView().setStatus(operationStatus);
        long startTimePerm = System.currentTimeMillis();
        boolean pass = "true".equals(this.getPageCache().get("passViewPermCheck"));
        boolean isFormTemplate = this.isFormTemplate(targetFormId);
        boolean isCheckFuncPerm = isFormTemplate || pass || isCurrentInputUser || this.checkPermAfterBindData(operationStatus);
        long endTimePerm = System.currentTimeMillis();
        if (!isCheckFuncPerm) {
            this.getView().showErrorNotification("\u6743\u9650\u4e0d\u8db3");
            return;
        }
        if (operationStatus == OperationStatus.VIEW) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{OPERATE_PANEL});
        }
        Object pkId = this.getPkId();
        this.showBillForm(targetFormId, pkId, operationStatus, appId);
        long endTime = System.currentTimeMillis();
        LOG.debug(String.format("nocode: afterBindData time- start2Perm:%s perm:%s perm2End:%s", startTimePerm - startTime, endTimePerm - startTimePerm, endTime - endTimePerm));
    }

    private boolean isFormTemplate(String formId) {
        QFilter filter1 = new QFilter("formid", "=", (Object)formId);
        QFilter filter2 = new QFilter("type", "=", (Object)"0");
        return QueryServiceHelper.exists((String)"bos_nocode_templateconfig", (QFilter[])new QFilter[]{filter1, filter2});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String shareId = this.getShareId();
        FormShowParameter containerShowParameter = this.getView().getFormShowParameter();
        String status = (String)containerShowParameter.getCustomParam(STATUS);
        this.isShareInput(shareId, containerShowParameter, status);
        this.getView().getPageCache().put("noCodeShareId", shareId);
        boolean nested = this.getView().getFormShowParameter().getCustomParams().getOrDefault("nested", false);
        this.getView().getPageCache().put("nested", String.valueOf(nested));
        if (nested) {
            String nestedType = this.getView().getFormShowParameter().getCustomParams().getOrDefault("nestedType", "");
            this.getView().getPageCache().put("nestedType", nestedType);
        }
        String saveCallbackProps = this.getView().getFormShowParameter().getCustomParams().getOrDefault("saveCallbackProps", "");
        this.getView().getPageCache().put("saveCallbackProps", saveCallbackProps);
        String controlKey = this.getView().getFormShowParameter().getCustomParams().getOrDefault("controlKey", "");
        this.getView().getPageCache().put("controlKey", controlKey);
        IFormView view = this.getView();
        this.setButtonStatus(status, view);
    }

    private void isShareInput(String shareId, FormShowParameter containerShowParameter, String status) {
        if ("ADDNEW".equalsIgnoreCase(status) && NoCodePermHelper.isShare(null, null, (String)shareId)) {
            String r;
            ShareInputMode mode = NoCodePermHelper.getAddShareMode((String)shareId);
            if (mode == ShareInputMode.INPUT_EDIT) {
                String r2 = this.getRecord(shareId);
                this.getPageCache().put("passEditPermCheck", "true");
                if (StringUtils.isNotEmpty((CharSequence)r2)) {
                    this.getPageCache().put("passViewPermCheck", "true");
                    containerShowParameter.getCustomParams().put(TARGET_PK_ID, r2);
                    containerShowParameter.getCustomParams().put(STATUS, "VIEW");
                }
            } else if (mode == ShareInputMode.INPUT_ONCE && StringUtils.isNotEmpty((CharSequence)(r = this.getRecord(shareId)))) {
                this.getPageCache().put("passViewPermCheck", "true");
                containerShowParameter.getCustomParams().put(TARGET_PK_ID, r);
                containerShowParameter.getCustomParams().put(STATUS, "VIEW");
            }
        }
    }

    private String getRecord(String shareId) {
        String fid;
        boolean exists;
        String recordid;
        QFilter f2;
        String ip = RequestContext.get().getLoginIP();
        QFilter f1 = new QFilter("ip", "=", (Object)ip);
        DynamicObject record = BusinessDataServiceHelper.loadSingle((String)"bos_nocode_share_record", (QFilter[])new QFilter[]{f1, f2 = new QFilter("shareid", "=", (Object)shareId.split("_")[0])});
        if (record != null && StringUtils.isNotEmpty((CharSequence)(recordid = record.getString("recordid"))) && (exists = QueryServiceHelper.exists((String)(fid = this.getTargetFormId()), (Object)recordid))) {
            return recordid;
        }
        return null;
    }

    private void setButtonStatus(String operationStatus, IFormView view) {
        boolean nested = Boolean.parseBoolean(this.getView().getPageCache().get("nested"));
        if (nested) {
            HashSet<String> hides = new HashSet<String>();
            HashSet all = Sets.newHashSet((Object[])new String[]{BTN_EDIT, BTN_SAVE, BTN_SUBMIT});
            String formid = this.getTargetFormId();
            FormShowParameter containerShowParameter = this.getView().getFormShowParameter();
            String userTaskBusinessKey = this.getUserTaskBusinessKey();
            String sPkId = StringUtils.isNotBlank((CharSequence)userTaskBusinessKey) ? userTaskBusinessKey : (String)containerShowParameter.getCustomParam(TARGET_PK_ID);
            switch (operationStatus) {
                case "EDIT": {
                    hides.add(BTN_EDIT);
                    hides.add(BTN_SUBMIT);
                    break;
                }
                case "VIEW": {
                    boolean check;
                    hides.add(BTN_SAVE);
                    hides.add(BTN_SUBMIT);
                    boolean share = this.getView().getFormShowParameter().getCustomParams().getOrDefault("share", false);
                    if (share) {
                        hides.add(BTN_EDIT);
                    }
                    boolean bl = check = NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.edit, (String)formid) && NoCodePermHelper.checkDataEditPermInNoCode((String)formid, (Object)sPkId);
                    if (check) break;
                    hides.add(BTN_EDIT);
                    break;
                }
                case "ADDNEW": {
                    hides.add(BTN_EDIT);
                    hides.add(BTN_SAVE);
                }
            }
            IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            List args = hides.stream().map(s -> Maps.of((Object)"k", (Object)s, (Object)"v", (Object)"4")).collect(Collectors.toList());
            all.removeAll(hides);
            all.stream().map(s -> Maps.of((Object)"k", (Object)s, (Object)"v", (Object)"1")).forEach(args::add);
            clientViewProxy.addAction("setControlState", args);
        }
    }

    private void showBillForm(String targetFormId, Object pkId, OperationStatus operationStatus, String appId) {
        try {
            NoCodeBillShowParameter parameter = new NoCodeBillShowParameter();
            parameter.setFormId(targetFormId);
            parameter.setStatus(operationStatus);
            parameter.setNocodeBillStatus(operationStatus);
            parameter.setAppId(appId);
            parameter.setPkId(pkId);
            parameter.setCustomParam("checkRightAppId", (Object)appId);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(CONTENT_PANEL);
            if ("copy".equalsIgnoreCase(this.getCustomParamStatus())) {
                parameter.getCustomParams().put("iscopy", true);
            }
            boolean nested = this.getView().getFormShowParameter().getCustomParams().getOrDefault("nested", false);
            parameter.setCustomParam("nested", (Object)nested);
            boolean skip = this.getView().getFormShowParameter().getCustomParams().getOrDefault("skip", false);
            parameter.setCustomParam("skip", (Object)skip);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "close");
            parameter.setCloseCallBack(closeCallBack);
            String pageId = parameter.getPageId();
            this.getPageCache().put(TARGET_FORM_PAGE_ID, pageId);
            this.getView().showForm((FormShowParameter)parameter);
        }
        catch (KDException ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private String checkAndCachePkId(String targetFormId) {
        FormShowParameter containerShowParameter = this.getView().getFormShowParameter();
        String userTaskBusinessKey = this.getUserTaskBusinessKey();
        String sPkId = StringUtils.isNotBlank((CharSequence)userTaskBusinessKey) ? userTaskBusinessKey : (String)containerShowParameter.getCustomParam(TARGET_PK_ID);
        if (StringUtils.isBlank((CharSequence)sPkId)) {
            return null;
        }
        if (!StringUtils.isNumeric((CharSequence)sPkId)) {
            return "\u6570\u636e\u4e0d\u5b58\u5728";
        }
        String formNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)targetFormId);
        if (!QueryServiceHelper.exists((String)formNumber, (Object)Long.parseLong(sPkId))) {
            return "\u6570\u636e\u4e0d\u5b58\u5728";
        }
        this.getPageCache().put(TARGET_PK_ID, sPkId);
        return null;
    }

    protected String getTargetFormId() {
        String formId;
        String userTaskActivityId = this.getUserTaskActivityId();
        if (StringUtils.isNotBlank((CharSequence)userTaskActivityId)) {
            formId = this.getFormIdFromUserTaskActivity(userTaskActivityId);
        } else {
            FormShowParameter containerShowParameter = this.getView().getFormShowParameter();
            formId = (String)containerShowParameter.getCustomParam(TARGET_FORM_ID);
        }
        return formId;
    }

    protected String getFormIdFromUserTaskActivity(String userTaskActivityId) {
        NoCodeWfNodeUserInput userTaskActivityNode = this.getUserTaskActivityNode(userTaskActivityId);
        if (userTaskActivityNode == null) {
            return null;
        }
        return userTaskActivityNode.getFormId();
    }

    protected NoCodeWfNodeUserInput getUserTaskActivityNode(String userTaskActivityId) {
        String noCodeWfNodeUserInputStr = this.getPageCache().get("NoCodeWfNodeUserInput");
        if (StringUtils.isNotBlank((CharSequence)noCodeWfNodeUserInputStr)) {
            NoCodeWfNodeUserInput node = (NoCodeWfNodeUserInput)SerializationUtils.fromJsonString((String)noCodeWfNodeUserInputStr, NoCodeWfNodeUserInput.class);
            return node;
        }
        String procInstId = this.getProcInstId();
        if (StringUtils.isBlank((CharSequence)procInstId)) {
            throw new KDBizException("need procInstId param");
        }
        long lProcInstId = Long.parseLong(procInstId);
        ProcessModel procModel = new ProcessModel();
        ProcessDefinitionInfo procDefInfo = NoCodeWorkflowServiceHelper.getProcessDefinitionInfoByProcInstId((Long)lProcInstId);
        String entityId = procDefInfo.getEntityId();
        procModel.setEntityId(entityId);
        String appIdByFormId = FormMetaUtil.getAppIdByFormId((String)entityId);
        procModel.setAppId(appIdByFormId);
        procModel.setData(procDefInfo.getData());
        if (StringUtils.isBlank((CharSequence)procModel.getData())) {
            throw new KDBizException("\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u6a21\u578b\u5931\u8d25\uff1a" + procDefInfo.getId());
        }
        Map loadModel = (Map)SerializationUtils.fromJsonString((String)procModel.getData(), Map.class);
        NoCodeWfMetaData noCodeWfMetaData = NoCodeWfMetaHelper.deserializeFromMap((Map)loadModel, null);
        NoCodeWfNodeUserInput node = noCodeWfMetaData.getNodes().stream().filter(NoCodeWfNodeUserInput.class::isInstance).map(NoCodeWfNodeUserInput.class::cast).filter(u -> u.getId().equalsIgnoreCase(userTaskActivityId)).findFirst().orElse(null);
        this.getPageCache().put("NoCodeWfNodeUserInput", SerializationUtils.toJsonString((Object)node));
        this.getPageCache().put("NoCodeWfNodeUserInputContent", SerializationUtils.toJsonString((Object)node.getInputContent()));
        return node;
    }

    protected String getProcInstId() {
        FormShowParameter containerShowParameter = this.getView().getFormShowParameter();
        return (String)containerShowParameter.getCustomParam("procInstId");
    }

    protected String getUserTaskCurrentUserId() {
        FormShowParameter containerShowParameter = this.getView().getFormShowParameter();
        return (String)containerShowParameter.getCustomParam("userTaskCurrentUserId");
    }

    protected String getTaskId() {
        String procInstId = this.getProcInstId();
        String userTaskActivityId = this.getUserTaskActivityId();
        String userTaskBusinessKey = this.getUserTaskBusinessKey();
        if (StringUtils.isNotEmpty((CharSequence)procInstId) && StringUtils.isNotEmpty((CharSequence)userTaskBusinessKey) && StringUtils.isNotEmpty((CharSequence)userTaskActivityId)) {
            return NoCodeWorkflowServiceHelper.getTaskIdByProcessInstanceIdAndActivityIdAndUserId((Long)Long.parseLong(procInstId), (String)userTaskActivityId, (Long)RequestContext.get().getCurrUserId()) + "";
        }
        return "";
    }

    protected String getUserTaskActivityId() {
        FormShowParameter containerShowParameter = this.getView().getFormShowParameter();
        String userTaskActivityId = (String)containerShowParameter.getCustomParam("userTaskActivityId");
        if (UNDEFINED.equalsIgnoreCase(userTaskActivityId)) {
            return null;
        }
        return userTaskActivityId;
    }

    private boolean isUserTask() {
        String userTaskActivityId = this.getUserTaskActivityId();
        return StringUtils.isNotBlank((CharSequence)userTaskActivityId);
    }

    protected String getUserTaskBusinessKey() {
        FormShowParameter containerShowParameter = this.getView().getFormShowParameter();
        String userTaskBusinessKey = (String)containerShowParameter.getCustomParam("userTaskBusinessKey");
        if (UNDEFINED.equalsIgnoreCase(userTaskBusinessKey)) {
            return null;
        }
        return userTaskBusinessKey;
    }

    protected Object getPkId() {
        String sPkId = this.getPageCache().get(TARGET_PK_ID);
        if (StringUtils.isBlank((CharSequence)sPkId)) {
            return null;
        }
        return Long.parseLong(sPkId);
    }

    protected WfConsts.WfLockStatusEnum getWfLockStatus() {
        String targetFormId = this.getTargetFormId();
        Object pkId = this.getPkId();
        return WfProcessUtils.getWfLockStatus((String)targetFormId, (Object)pkId);
    }

    protected OperationStatus getContainerOperationStatus() {
        String status = this.getCustomParamStatus();
        if (StringUtils.isNotBlank((CharSequence)status) && STATUS_VIEW.equalsIgnoreCase(status)) {
            return OperationStatus.VIEW;
        }
        if (Objects.isNull(this.getPkId()) || "copy".equalsIgnoreCase(status)) {
            return OperationStatus.ADDNEW;
        }
        return OperationStatus.EDIT;
    }

    private String getCustomParamStatus() {
        FormShowParameter containerShowParameter = this.getView().getFormShowParameter();
        return (String)containerShowParameter.getCustomParam(STATUS);
    }

    protected OperationStatus getTargetOperationStatus() {
        IFormView view = this.getTargetView();
        if (view == null) {
            return OperationStatus.VIEW;
        }
        FormShowParameter showParameter = view.getFormShowParameter();
        return showParameter.getStatus();
    }

    protected boolean checkPermAfterBindData(OperationStatus operationStatus) {
        String procInstId = this.getProcInstId();
        if (StringUtils.isNotBlank((CharSequence)procInstId)) {
            return true;
        }
        String appid = this.getAppIdFromCache();
        if (NoCodeTemplateUtil.queryTemplateAppIds().contains(appid)) {
            return true;
        }
        String formid = this.getTargetFormId();
        String shareId = this.getShareId();
        if (operationStatus == OperationStatus.VIEW) {
            if (NoCodePermHelper.isShare((String)appid, (String)formid, (String)shareId) && NoCodePermHelper.isViewShare((String)shareId)) {
                return true;
            }
            return NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.view, (String)formid) && NoCodePermHelper.checkDataPermInNoCode((String)formid, (Object)this.getPkId());
        }
        if (operationStatus == OperationStatus.ADDNEW) {
            if (NoCodePermHelper.isShare((String)appid, (String)formid, (String)shareId) && NoCodePermHelper.isAddShare((String)shareId)) {
                return true;
            }
            return NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.input, (String)formid);
        }
        if (operationStatus == OperationStatus.EDIT) {
            if (NoCodePermHelper.isShare((String)appid, (String)formid, (String)shareId) && NoCodePermHelper.isAddShare((String)shareId)) {
                return true;
            }
            return NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.edit, (String)formid) && NoCodePermHelper.checkDataEditPermInNoCode((String)formid, (Object)this.getPkId());
        }
        return true;
    }

    private String getShareId() {
        String queryString = RequestContext.get().getQueryString();
        if (queryString.contains("noCodeShareId")) {
            if (queryString.contains("&")) {
                Optional<String> first = Arrays.stream(queryString.split("&")).filter(s -> s.contains("noCodeShareId")).findFirst();
                if (first.isPresent()) {
                    return first.get().split("=")[1];
                }
            } else {
                return queryString.split("=")[1];
            }
        }
        return null;
    }

    protected long getCurrentUserId() {
        return RequestContext.get().getCurrUserId();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("close".equals(closedCallBackEvent.getActionId())) {
            this.getView().close();
        }
    }

    private boolean isMobile() {
        String userAgent = RequestContext.get().getUserAgent();
        return UserAgentUtils.parseUserAgentString((String)userAgent).getOperatingSystem().isMobileDevice();
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key.startsWith(STD_BTN_PREFIX)) {
            return;
        }
        String targetFormId = this.getTargetFormId();
        NoCodeBizButtonAp noCodeBizButtonAp = BizButtonUtil.getBizButtonDesignMeta((String)targetFormId, (String)key);
        if (noCodeBizButtonAp != null) {
            NoCodeBizButton bizButton = (NoCodeBizButton)noCodeBizButtonAp.buildRuntimeControl();
            bizButton.setPkId(this.getPkId());
            bizButton.setOperationCaption(noCodeBizButtonAp.getName().toString());
            bizButton.setView(this.getView());
            bizButton.setParentPageId(this.getPageCache().get(TARGET_FORM_PAGE_ID));
            e.setControl((Control)bizButton);
        }
    }

    public static interface CallBackAfterSave {
        public void exec();
    }
}

