/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.nocode.NoCodeBillShowParameter;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.useragent.util.UserAgentUtils;

public class NoCodeNestedBillContainerPlugin
extends AbstractFormPlugin {
    private static final String CONTENT_PANEL = "contentpanel";
    private static final String OPERATE_PANEL = "operatepanel";
    private static final String BTN_SAVE = "btnsave";
    private static final String BTN_SUBMIT = "btnsubmit";
    private static final String TARGET_FORM_ID = "targetFormId";
    private static final String APPID = "appid";
    private static final String TARGET_PK_ID = "pkId";
    private static final String STATUS = "Status";
    private static final String STATUS_VIEW = "view";
    private static final String STATUS_COPY = "copy";
    private static final String TARGET_FORM_PAGE_ID = "targetFormPageId";
    private static final String BOS_NOCODE_FORMPLUGIN = "bos-nocode-formplugin";
    private static final Log LOG = LogFactory.getLog(NoCodeNestedBillContainerPlugin.class);
    public static final String API_SAVE_0 = "ApiSave_0";
    private static final String TRIGGER = "trigger";
    private static final String TRIGGER_PROCESS = "triggerProcess";
    private static final String TRIGGER_PKID = "triggerPkId";
    private static final String UPDATE = "update";
    private static final String PARENT_FORM_ID = "parentFormId";
    private static final String PARENT_PK_ID = "parentPkId";
    private static final String UPDATE_FIELD = "updateField";
    private static final String REFRESH = "refresh";
    private static final String PARENT_PAGE_ID = "parentPageId";
    private static final String REFRESH_ALL = "refreshAll";
    private static final Log log = LogFactory.getLog(NoCodeNestedBillContainerPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SAVE});
        this.addClickListeners(new String[]{BTN_SUBMIT});
    }

    public void click(EventObject evt) {
        LOG.debug("\u89e6\u53d1\u70b9\u51fb\u4e8b\u4ef6\uff1a", (Object)evt);
        super.click(evt);
        Button btn = (Button)evt.getSource();
        if (btn.getKey().equals(BTN_SAVE) || btn.getKey().equals(BTN_SUBMIT)) {
            this.saveData();
        }
    }

    private IFormView getTargetView() {
        String pageId = this.getPageCache().get(TARGET_FORM_PAGE_ID);
        return SessionManager.getCurrent().getView(pageId);
    }

    private void saveData() {
        LOG.debug("\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c");
        LOG.debug("\u5f53\u524dpageCache={}", (Object)this.getPageCache());
        String targetFormId = this.getPageCache().get(TARGET_FORM_ID);
        IFormView view = this.getTargetView();
        if (view == null) {
            return;
        }
        if (!view.getModel().isDataLoaded()) {
            return;
        }
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)targetFormId);
        LOG.debug("\u83b7\u53d6FormConfig\uff0ctargetFormId: {}\uff0cformConfig: {}", (Object)targetFormId, (Object)formConfig);
        LOG.debug("\u83b7\u53d6FormConfig\uff0cformConfig json\uff1a{}", (Object)SerializationUtils.toJsonString((Object)formConfig));
        String entityTypeId = formConfig.getEntityTypeId();
        Operations operations = EntityMetadataCache.getDataEntityOperations((String)entityTypeId);
        String save = operations.getSave();
        if (StringUtils.isBlank((CharSequence)save)) {
            throw new KDBizException(ResManager.loadKDString((String)"%s \u4e1a\u52a1\u5bf9\u8c61\u672a\u914d\u7f6e\u4fdd\u5b58\u64cd\u4f5c", (String)API_SAVE_0, (String)"", (Object[])new Object[]{targetFormId}));
        }
        OperationResult operationResult = view.invokeOperation(save);
        if (operationResult.isSuccess()) {
            HashMap<String, String> arg = new HashMap<String, String>(1);
            this.getView().sendFormAction(view);
            boolean success = true;
            try {
                this.updateParentForm(operationResult.getSuccessPkIds().get(0));
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                success = false;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u5173\u8054\u8868\u5355\u8bb0\u5f55\u503c\u5931\u8d25", (String)"NoCodeNestedBillContainerPlugin_1", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (success) {
                try {
                    this.triggerProcess();
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89e6\u53d1\u5f55\u5165\u540e\u6d41\u7a0b\u5931\u8d25", (String)"NoCodeNestedBillContainerPlugin_2", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
                }
            }
            arg.put("pageId", this.getView().getPageId());
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
        } else {
            this.getView().sendFormAction(view);
        }
    }

    private void triggerProcess() {
        FormShowParameter containerShowParameter = this.getView().getFormShowParameter();
        boolean trigger = (Boolean)containerShowParameter.getCustomParam(TRIGGER);
        if (trigger) {
            String triggerProcess = (String)containerShowParameter.getCustomParam(TRIGGER_PROCESS);
            Object triggerPkId = containerShowParameter.getCustomParam(TRIGGER_PKID);
            long modelId = Long.parseLong(triggerProcess);
            if (triggerPkId == null) {
                LOG.debug("getPkId invalid");
                throw new KDBizException("getPkId invalid");
            }
            NoCodeWorkflowServiceHelper.tryTriggerProcess((Long)modelId, (String)triggerPkId.toString(), (String)"bizOperate");
        }
    }

    private void updateParentForm(Object pkId) {
        boolean refresh;
        FormShowParameter containerShowParameter = this.getView().getFormShowParameter();
        boolean update = (Boolean)containerShowParameter.getCustomParam(UPDATE);
        if (update) {
            String parentFormId = (String)containerShowParameter.getCustomParam(PARENT_FORM_ID);
            Object parentPkId = containerShowParameter.getCustomParam(PARENT_PK_ID);
            String updateField = (String)containerShowParameter.getCustomParam(UPDATE_FIELD);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)parentPkId, (String)parentFormId);
            dynamicObject.set(updateField, pkId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        if (refresh = ((Boolean)containerShowParameter.getCustomParam(REFRESH)).booleanValue()) {
            boolean refreshAll;
            String parentPageId = (String)containerShowParameter.getCustomParam(PARENT_PAGE_ID);
            IFormView view = SessionManager.getCurrent().getView(parentPageId);
            IDataModel model = view.getModel();
            String updateField = (String)containerShowParameter.getCustomParam(UPDATE_FIELD);
            if (updateField != null) {
                model.setValue(updateField, pkId);
            }
            if (refreshAll = ((Boolean)containerShowParameter.getCustomParam(REFRESH_ALL)).booleanValue()) {
                model.beginInit();
                List fields = model.getDataEntityType().getAllEntities().values().stream().map(f -> f.getFields().keySet()).flatMap(Collection::stream).collect(Collectors.toList());
                ((IBillModel)model).syncDataFromDB(fields);
                model.endInit();
                model.setDataChanged(false);
            }
            view.updateView();
            this.getView().sendFormAction(view);
        }
    }

    public void beforeBindData(EventObject e) {
        OperationStatus operationStatus = this.getContainerOperationStatus();
        ArrayList<Map> args = new ArrayList<Map>();
        if (operationStatus == OperationStatus.ADDNEW) {
            args.add(Maps.of((Object)"k", (Object)BTN_SAVE, (Object)"v", (Object)"4"));
            args.add(Maps.of((Object)"k", (Object)BTN_SUBMIT, (Object)"v", (Object)"1"));
        } else if (operationStatus == OperationStatus.EDIT) {
            args.add(Maps.of((Object)"k", (Object)BTN_SAVE, (Object)"v", (Object)"1"));
            args.add(Maps.of((Object)"k", (Object)BTN_SUBMIT, (Object)"v", (Object)"4"));
        }
        IFormView view = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        clientViewProxy.addAction("setControlState", args);
    }

    public void afterBindData(EventObject e) {
        String targetFormId = this.getTargetFormId();
        if (StringUtils.isBlank((CharSequence)targetFormId)) {
            throw new KDBizException("need targetFormId param");
        }
        this.getPageCache().put(TARGET_FORM_ID, targetFormId);
        String appId = FormMetaUtil.getAppIdByFormId((String)targetFormId);
        if (StringUtils.isBlank((CharSequence)appId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"NoCodeNestedBillContainerPlugin_3", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
        }
        String sErrorPkId = this.checkAndCachePkId(targetFormId);
        if (StringUtils.isNotBlank((CharSequence)sErrorPkId)) {
            this.getView().showErrorNotification(sErrorPkId);
            return;
        }
        this.getPageCache().put(APPID, appId);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        OperationStatus operationStatus = this.getContainerOperationStatus();
        clientViewProxy.removeAction("setFormStatus");
        this.getView().setStatus(operationStatus);
        Object pkId = this.getPkId();
        this.showBillForm(targetFormId, pkId, operationStatus, appId);
    }

    private void showBillForm(String targetFormId, Object pkId, OperationStatus operationStatus, String appId) {
        NoCodeBillShowParameter parameter = new NoCodeBillShowParameter();
        parameter.setFormId(targetFormId);
        parameter.setStatus(operationStatus);
        parameter.setNocodeBillStatus(operationStatus);
        parameter.setAppId(appId);
        parameter.setPkId(pkId);
        parameter.setCustomParam("checkRightAppId", (Object)appId);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(CONTENT_PANEL);
        if (STATUS_COPY.equalsIgnoreCase(this.getCustomParamStatus())) {
            parameter.getCustomParams().put("iscopy", true);
        }
        parameter.getCustomParams().put("nested", true);
        parameter.getCustomParams().put("buttonRules", this.anaButtonRules());
        String pageId = parameter.getPageId();
        this.getPageCache().put(TARGET_FORM_PAGE_ID, pageId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private String getCustomParamStatus() {
        FormShowParameter containerShowParameter = this.getView().getFormShowParameter();
        return (String)containerShowParameter.getCustomParam(STATUS);
    }

    private JSONArray anaButtonRules() {
        FormShowParameter containerShowParameter = this.getView().getFormShowParameter();
        String inputContent = (String)containerShowParameter.getCustomParam("inputContent");
        if (StringUtils.isEmpty((CharSequence)inputContent)) {
            return null;
        }
        JSONArray array = JSON.parseObject((String)inputContent).getJSONArray("value");
        if (array.size() == 0) {
            return null;
        }
        JSONArray ret = new JSONArray();
        HashSet<String> displayFields = new HashSet<String>();
        HashMap<String, String> fieldStatus = new HashMap<String, String>();
        for (int i = 0; i < array.size(); ++i) {
            String value;
            String compareType;
            JSONObject object = array.getJSONObject(i);
            String field2 = object.getString("fieldName");
            displayFields.add(field2);
            JSONObject rule = new JSONObject();
            switch (compareType = object.getString("compareType")) {
                case "edit": {
                    fieldStatus.put(field2, "1");
                    break;
                }
                case "mustinput": {
                    fieldStatus.put(field2, "5");
                    break;
                }
                case "disabled": {
                    fieldStatus.put(field2, "2");
                    break;
                }
                case "readonly": {
                    fieldStatus.put(field2, "3");
                }
            }
            if (!object.containsKey((Object)"value") || !StringUtils.isNotEmpty((CharSequence)(value = object.getString("value")))) continue;
            try {
                JSONArray values = JSON.parseArray((String)value);
                for (int j = 0; j < values.size(); ++j) {
                    JSONObject exp = values.getJSONObject(j);
                    if (exp.containsKey((Object)"valueType")) {
                        if (exp.getInteger("valueType") == 1) {
                            if (exp.containsKey((Object)"value")) {
                                rule.put("expression", (Object)exp);
                                continue;
                            }
                            NoCodeNestedBillContainerPlugin.buildExp(rule, exp.getString("fieldValue"));
                            continue;
                        }
                        if (exp.getInteger("valueType") != 2 || !exp.containsKey((Object)"rule")) continue;
                        rule.put("expression", (Object)exp.getJSONObject("rule"));
                        continue;
                    }
                    NoCodeNestedBillContainerPlugin.buildExp(rule, exp.getString("fieldValue"));
                }
            }
            catch (Exception e2) {
                log.warn((Throwable)e2);
                NoCodeNestedBillContainerPlugin.buildExp(rule, value);
            }
            rule.put("affectfldkeys", (Object)field2);
            rule.put("formid", (Object)this.getTargetFormId());
            rule.put("ruletype", (Object)"1");
            if (!rule.containsKey((Object)"expression") || !StringUtils.isNotEmpty((CharSequence)rule.getString("expression"))) continue;
            ret.add((Object)rule);
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)this.getTargetFormId());
        DataEntityPropertyCollection properties = dt.getProperties();
        Set<String> hideFields = properties.stream().map(IMetadata::getName).map(f -> {
            if (f.endsWith("_startdate")) {
                return f.replace("_startdate", "");
            }
            if (f.endsWith("_enddate")) {
                return f.replace("_enddate", "");
            }
            return f;
        }).filter(e -> !displayFields.contains(e)).collect(Collectors.toSet());
        Set dataRangeField = displayFields.stream().filter(f -> f.endsWith("_startdate") || f.endsWith("_enddate")).map(f -> {
            if (f.endsWith("_startdate")) {
                return f.replace("_startdate", "");
            }
            return f.replace("_enddate", "");
        }).collect(Collectors.toSet());
        hideFields.removeAll(dataRangeField);
        String fields = String.join((CharSequence)",", hideFields);
        JSONObject rule = new JSONObject();
        rule.put("affectfldkeys", (Object)fields);
        StringBuilder exp = new StringBuilder();
        exp.append("[");
        hideFields.forEach(field -> exp.append("{\"actionType\":4,\"fieldName\":\"").append((String)field).append("\"},"));
        fieldStatus.forEach((k, v) -> exp.append("{\"actionType\":").append((String)v).append(",\"fieldName\":\"").append((String)k).append("\"},"));
        exp.deleteCharAt(exp.length() - 1);
        exp.append("]");
        rule.put("trueaction", (Object)exp.toString());
        rule.put("expression", (Object)"force:true");
        rule.put("formid", (Object)this.getTargetFormId());
        rule.put("ruletype", (Object)"0");
        ret.add((Object)rule);
        containerShowParameter.getCustomParams().put("displayFields", displayFields);
        return ret;
    }

    private static void buildExp(JSONObject rule, String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return;
        }
        JSONObject exp = new JSONObject();
        exp.put("valueType", (Object)1);
        if (value.contains("@")) {
            exp.put("value", (Object)value);
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("'").append(value).append("'@@'").append(value).append("'@@").append("1");
            exp.put("value", (Object)builder.toString());
        }
        rule.put("expression", (Object)exp.toJSONString());
    }

    private String checkAndCachePkId(String targetFormId) {
        FormShowParameter containerShowParameter = this.getView().getFormShowParameter();
        String sPkId = (String)containerShowParameter.getCustomParam(TARGET_PK_ID);
        if (StringUtils.isBlank((CharSequence)sPkId)) {
            return null;
        }
        if (!StringUtils.isNumeric((CharSequence)sPkId)) {
            return ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728", (String)"NoCodeNestedBillContainerPlugin_4", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]);
        }
        String formNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)targetFormId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(sPkId), (String)formNumber);
        if (dynamicObject == null) {
            return ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728", (String)"NoCodeNestedBillContainerPlugin_4", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]);
        }
        this.getPageCache().put(TARGET_PK_ID, sPkId);
        return null;
    }

    protected String getTargetFormId() {
        FormShowParameter containerShowParameter = this.getView().getFormShowParameter();
        return (String)containerShowParameter.getCustomParam(TARGET_FORM_ID);
    }

    protected Object getPkId() {
        String sPkId = this.getPageCache().get(TARGET_PK_ID);
        if (StringUtils.isBlank((CharSequence)sPkId)) {
            return null;
        }
        return Long.parseLong(sPkId);
    }

    protected OperationStatus getContainerOperationStatus() {
        FormShowParameter containerShowParameter = this.getView().getFormShowParameter();
        return containerShowParameter.getStatus();
    }

    private boolean isMobile() {
        String userAgent = RequestContext.get().getUserAgent();
        return UserAgentUtils.parseUserAgentString((String)userAgent).getOperatingSystem().isMobileDevice();
    }
}

