/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.form.designer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.designer.AbstractFormDesignerPlugin;
import kd.bos.designer.ExchangeRateGroupCreateUIElemntListener;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.events.NameCombineCreateUIElemntListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.DesignerBarListener;
import kd.bos.form.control.DesignerCallListener;
import kd.bos.form.control.events.CreateUIElemntListener;
import kd.bos.form.control.events.DesignerBarAction;
import kd.bos.form.control.events.DesignerBarEvent;
import kd.bos.form.control.events.DesignerCallEvent;
import kd.bos.form.control.events.KeyPressArgs;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.form.control.events.ShortCutKeyListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.isv.ISVService;
import kd.bos.lang.Lang;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.AlterTableUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetaType;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.metadata.domainmodel.Category;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BillNoField;
import kd.bos.metadata.entity.businessfield.RefBillField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mservice.svc.attach.IAttachmentField;
import kd.bos.nocode.constant.CommonConstants;
import kd.bos.nocode.design.NoCodeDesignerData;
import kd.bos.nocode.ext.ExtEntityItemTypes;
import kd.bos.nocode.ext.defvalue.NoCodeFilterConfigEvent;
import kd.bos.nocode.ext.defvalue.NoCodeFilterConfigListener;
import kd.bos.nocode.ext.defvalue.RuleListener;
import kd.bos.nocode.ext.form.control.NoCodeFormDesigner;
import kd.bos.nocode.ext.metadata.entity.NoCodeRefBillTable;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDateRangeField;
import kd.bos.nocode.ext.metadata.entity.filter.NoCodeFilterMetadata;
import kd.bos.nocode.ext.metadata.entity.helper.DispProp;
import kd.bos.nocode.ext.metadata.form.control.NoCodeBizButtonAp;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.ext.wf.control.events.WfDesignerCommonEvent;
import kd.bos.nocode.metadata.INoCodeRefBillField;
import kd.bos.nocode.mservice.NoCodeDesignMetadataService;
import kd.bos.nocode.mservice.NoCodeRuleService;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.RestApiWrap;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.servicehelper.AssociationServiceHelper;
import kd.bos.nocode.servicehelper.DispatchApiServiceHelper;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.util.NoCodeTemplateUtil;
import kd.bos.nocode.utils.FieldTreeBuilder;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NcErrorUtil;
import kd.bos.nocode.utils.NcRetryUtil;
import kd.bos.nocode.utils.NoCodeTreeNode;
import kd.bos.nocode.utils.NoCodeWorkflowServiceUtil;
import kd.bos.nocode.utils.ShowColumnInfo;
import kd.bos.nocode.wf.designer.helper.ExpressDesignMetaHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.util.ExceptionUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class NoCodeFormDesignerPlugin
extends AbstractFormDesignerPlugin
implements TabSelectListener,
ShortCutKeyListener,
DesignerBarListener,
DesignerCallListener,
NoCodeFilterConfigListener,
RuleListener {
    public static final String EXPRESSION = "expression";
    public static final String FORM_ISV = "FORM_ISV";
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"NoCodeFormDesignerPlugin", (int)3);
    private static Log log = LogFactory.getLog(NoCodeFormDesignerPlugin.class);
    private static final String BIZ_APPID = "bizappid";
    private static final String GET_USER_THEME = "getUserTheme";
    public static final String NUMBER = "number";
    private static final String DB_ROUTE_R = "dbRoute";
    private static final String COMPATIBLE_TYPE = "CompatibleType";
    private static final String COMPATIBLE_TYPE_DATE = "date";
    private static final String COMPATIBLE_TYPE_REFBILL = "refbill";
    private static final String COMPATIBLE_TYPE_NUMBER = "number";
    private static final String CATEGORY_GENERAL_CONTENT = "CategoryGeneralContent";
    private static final String CATEGORY_BIZ_CONTENT = "CategoryBizContent";
    private static final String CALL_ACTION_SETLISTCONFIG = "setListConfig";
    private static final String CALL_ACTION_SETLISTTREECONFIG = "setListTreeConfig";
    private static final String CALL_ACTION_FILTERITEMLOOK = "filterItemLook";
    private static final String ARGS = "args";
    private static final String DATA = "data";
    private static final String PREVIEW = "preview";
    private static final String PC_PREVIEW = "pc_preview";
    private static final String MOBILE_PREVIEW = "mobile_preview";
    private static final String EXPORT = "export";
    private static final String PUBLISH = "publish";
    private static final String SAVE = "save";
    private static final String SAVE_AND_VISIT = "saveandvisit";
    private static final String BTN_PC = "btnpc";
    private static final String BTN_MOBILE = "btnmobile";
    private static final String BTN_PC_LIST = "btnpclist";
    private static final String BTN_MOBILE_LIST = "btnmobilelist";
    private static final String BTN_XML = "btnxml";
    private static final String BTN_USER = "btnuser";
    private static final String NO_CODE_FORM_DESIGNER = "nocodeformdesigner";
    private static final String DESIGNER = "designer";
    private static final String MERGE_VERSION = "mergeVersion";
    private static final String CACHE_KEY_OLD_FORM_NUM = "cache_oldformnum";
    private static final String FORM_META = "formmeta";
    private static final String TABLE_NAME = "TableName";
    private static final String ENTITY_META = "entitymeta";
    private static final String ITEMS = "Items";
    private static final String MULTI = "Multi";
    private static final String TYPE = "_Type_";
    private static final String NOCODE_MUL_REF_BILL_FIELD = "NoCodeMulRefBillField";
    private static final String BillEntityId = "BillEntityId";
    private static final String BillEntityIdEx = "BillEntityIdEx";
    private static final String DEFAULT = "default";
    private static final String PropsDisplay = "PropsDisplay";
    public static final String CACHE_KEY_ALLMETADATA = "cache_all_metadata";
    public static final String BOS_NOCODE_PREVIEW = "bos_nocode_preview";
    private static final String TARGET_FORM_ID = "targetFormId";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String MODEL_TYPE_U = "ModelType";
    private static final String ENTITY_ID = "entityId";
    private static final String KEY_SUCCESS = "success";
    private static final String MESSAGE = "message";
    private static final String SAVEASTEMPLATE = "saveAsTemplate";
    private static final String TEMPLATECONFIG = "templateConfig";
    private static final String BOS_NOCODE_FORMPLUGIN = "bos-nocode-formplugin";
    private static final String BILL_ENTITY_ID = "BillEntityIdEx";
    private static final String ITEM_KEY = "itemKey";
    private static final String PROPS_DISPLAY = "PropsDisplay";
    private static final String PROPS_INPUT_FORM = "InputForm";
    private static final String CALL_ACTION_SET_REF_BILL_DATA = "setRefBillData";
    private static final String CALL_ACTION_SET_REF_PROP_DISP = "setRefPropDisp";
    private static final String CALL_ACTION_SET_INPUT_FORM = "setInputForm";
    private static final String CALL_ACTION_SET_INPUT_CONTENT = "setInputContent";
    private static final String CALL_ACTION_CAN_SWITCH_FIELD_TYPES = "canSwitchFieldTypes";
    private static final String CALL_ACTION_SET_SWITCH_FIELD_TYPES = "setSwitchFieldTypes";
    private static final String CALL_ACTION_GET_TRIGGER_PROCESS = "getTriggerProcess";
    private static final String CALL_ACTION_GET_INPUT_CONTENT = "getInputContent";
    private static final String CALL_ACTION_SET_TRIGGER_PROCESS = "setTriggerProcess";
    public static final int NUMBER_OF_MAP = 10;
    public static final int MAX_FORM_NUMBER_LENGTH = 25;
    private static final String DEP_FLD_KEYS = "depfldkeys";
    private static final String AFFECT_FLD_KEYS = "affectfldkeys";
    private static final String CALL_ACTION_SETQUERY = "setQuery";
    private static final String KINGDEE = "kingdee";
    private static final String ERRORS = "errors";
    private String listTree_formId;

    protected String getDesignerKey() {
        return NO_CODE_FORM_DESIGNER;
    }

    public void initialize() {
        String number;
        super.initialize();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String id = (String)showParameter.getCustomParam("id");
        if (id != null) {
            this.getPageCache().put("id", id);
        }
        if ((number = (String)showParameter.getCustomParam("number")) != null) {
            this.getPageCache().put("number", number);
        }
    }

    public void registerListener(EventObject e) {
        NoCodeFormDesigner designer = (NoCodeFormDesigner)this.getView().getControl(this.getDesignerKey());
        designer.addCreateUIElemntListener((CreateUIElemntListener)new NameCombineCreateUIElemntListener(this.getView()));
        designer.addBarListener((DesignerBarListener)this);
        designer.addCallListener((DesignerCallListener)this);
        super.registerListener(e);
        this.addClickListeners(new String[]{SAVE, SAVE_AND_VISIT, PREVIEW, PC_PREVIEW, MOBILE_PREVIEW, EXPORT, PUBLISH, BTN_PC, BTN_MOBILE, BTN_PC_LIST, BTN_MOBILE_LIST, BTN_XML, BTN_USER});
        designer.addShortCutKeyListener((ShortCutKeyListener)this);
        designer.addCreateUIElemntListener((CreateUIElemntListener)new ExchangeRateGroupCreateUIElemntListener());
        designer.addFormDesignerListeners((NoCodeFilterConfigListener)this);
        designer.addRuleListener((RuleListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        if (EnvTypeHelper.isDeploying()) {
            String msg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"NoCodeFormDesignerPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showMessage(msg);
        }
    }

    protected void beforeShowPropertyEdit(PropertyEvent e, FormShowParameter showParameter) {
        super.beforeShowPropertyEdit(e, showParameter);
        if ("BasdataNumber".equals(e.getPropertName())) {
            showParameter.setHasRight(true);
        }
        showParameter.setCustomParam("fromProFormDesigner", (Object)"true");
    }

    public void afterBindData(EventObject e) {
        String bizappId;
        String id = this.getPageCache().get("id");
        String modelType = "";
        Map designerMetadata = null;
        String dbRoute = "";
        if (id != null) {
            String oldFormNum = FormMetaUtil.getFormNumberById((String)id);
            this.getPageCache().put(CACHE_KEY_OLD_FORM_NUM, oldFormNum);
            designerMetadata = MetadataDao.loadDesignerMetadata((String)id, (String)RequestContext.get().getLang().toString());
            this.clearInvalidRefProp(designerMetadata);
            Map formMeta = (Map)designerMetadata.get(FORM_META);
            Object formIsv = formMeta.get("Isv");
            dbRoute = (String)((Map)((List)formMeta.get(ITEMS)).get(0)).get(DB_ROUTE_R);
            this.getPageCache().put(FORM_ISV, StringUtils.isBlank(formIsv) ? "" : formIsv.toString());
            this.getPageCache().put(MERGE_VERSION, (String)designerMetadata.get(MERGE_VERSION));
            modelType = (String)designerMetadata.get("modelType");
            this.getPageCache().put("modelType", modelType);
            designerMetadata.put("subSystem", 1);
            designerMetadata.put("isv", ISVService.getISVInfo().getId());
            bizappId = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_APPID);
            if (StringUtils.isBlank((CharSequence)bizappId)) {
                bizappId = FormMetaUtil.getAppIdByFormId((String)id);
            }
        } else {
            throw new KDBizException("formId is empty");
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PUBLISH});
        designerMetadata.put("appNum", AppReader.getAppNumberById((String)bizappId));
        designerMetadata.put(BIZ_APPID, bizappId);
        this.getPageCache().put(BIZ_APPID, bizappId);
        HashMap<String, Object> formData = new HashMap<String, Object>();
        formData.put("id", FORM_META);
        Object formName = designerMetadata.get("caption");
        formData.put("name", String.valueOf(formName));
        formData.put("isPC", true);
        formData.put(DATA, designerMetadata);
        formData.put("type", ResManager.loadKDString((String)"\u8868\u5355", (String)"NoCodeFormDesignerPlugin_1", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
        List tableMetas = FormMetadataUtils.getTableMetas((Map)designerMetadata);
        HashMap<String, List> tableMetaData = new HashMap<String, List>();
        tableMetaData.put("tableMetas", tableMetas);
        HashMap<String, Map<String, Object>> immutableCtx = new HashMap<String, Map<String, Object>>();
        Map<String, Object> expressDesignMeta = ExpressDesignMetaHelper.getExpressDesignMeta(ENTITY_META, null, false);
        immutableCtx.put(EXPRESSION, expressDesignMeta);
        HashMap<String, NoCodeTreeNode> refBillData = new HashMap<String, NoCodeTreeNode>();
        NoCodeTreeNode root = NcEntityTypeUtil.buildRefBillTreeData((String)bizappId, (String)"", (String)"true");
        refBillData.put("refBillData", root);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getDesignerKey(), "open", new Object[]{modelType, true, formData, immutableCtx, refBillData, tableMetaData});
        this.getPageCache().put("localeItems", SerializationUtils.toJsonString(designerMetadata.remove("localeItems")));
        this.getPageCache().put(DB_ROUTE_R, dbRoute);
        String entityId = ((Map)designerMetadata.get(FORM_META)).get("EntityId").toString();
        String entityModelType = modelType;
        if (designerMetadata.get(ENTITY_META) != null) {
            entityModelType = ((Map)designerMetadata.get(ENTITY_META)).getOrDefault("modelType", modelType).toString();
        }
        this.getPageCache().put("entityModelType", entityModelType);
        this.getPageCache().put(ENTITY_ID, entityId);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"back"});
        this.getPageCache().remove(DESIGNER);
        this.getPageCache().put("oldmetadata", SerializationUtils.toJsonString((Object)designerMetadata));
        if (!designerMetadata.isEmpty()) {
            this.resourceCheck(designerMetadata);
        }
        this.switchPreviewLang(RequestContext.get().getLang().toString());
        String caption = ResManager.loadKDString((String)"\u914d\u7f6e\uff1a%s", (String)"NoCodeFormDesignerPlugin_2", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[]{designerMetadata.get("caption")});
        this.getView().executeClientCommand("setCaption", new Object[]{caption});
    }

    private void clearInvalidRefProp(Map<String, Object> designerMetadata) {
        Map entityMeta = (Map)designerMetadata.get(ENTITY_META);
        List items = (List)entityMeta.get(ITEMS);
        for (Map item : items) {
            if (!item.containsKey("PropsDisplay") || !item.containsKey(BillEntityId)) continue;
            String propsDisplay = (String)item.get("PropsDisplay");
            String[] props = propsDisplay.split(",");
            ArrayList<String> validProps = new ArrayList<String>(props.length);
            try {
                String realBillEntityId = NcEntityTypeUtil.getRealBillEntityId((String)((String)item.get(BillEntityId)));
                MainEntityType dt = EntityMetadataCache.getDataEntityTypeById((String)realBillEntityId);
                for (String prop : props) {
                    if (!NcEntityTypeUtil.existProperty((DynamicObjectType)dt, (String)prop)) continue;
                    validProps.add(prop);
                }
            }
            catch (KDException e) {
                log.warn((Throwable)e);
                continue;
            }
            item.put("PropsDisplay", String.join((CharSequence)",", validProps));
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey()) {
            case "save": {
                this.saveData(false);
                break;
            }
            case "preview": {
                this.doPcPreview();
                break;
            }
            case "saveandvisit": {
                this.doSaveAndVisit();
                break;
            }
        }
    }

    public void designerBarClick(DesignerBarEvent e) {
        if (DesignerBarAction.Click == e.getActionId()) {
            String barItemKey;
            switch (barItemKey = e.getBarItemKey().toLowerCase(Locale.ENGLISH)) {
                case "save": {
                    this.saveData(false);
                    break;
                }
                case "preview": 
                case "pc_preview": 
                case "mobile_preview": {
                    this.doPcPreview();
                    break;
                }
                case "saveandvisit": {
                    this.doSaveAndVisit();
                    break;
                }
            }
        }
    }

    private void doPcPreview() {
        boolean saveSuccess = this.saveData(true);
        if (saveSuccess) {
            String id = this.getPageCache().get("id");
            String domainContextUrl = UrlService.getDomainContextUrlByTenantCode((String)RequestContext.get().getTenantCode());
            String url = String.format("%s?formId=%s&%s=%s", domainContextUrl, BOS_NOCODE_PREVIEW, TARGET_FORM_ID, id);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), "showPreview", new Object[]{url});
        }
    }

    private void doSaveAndVisit() {
        boolean saveSuccess = this.saveData(false);
        if (saveSuccess) {
            String bizappId = this.getPageCache().get(BIZ_APPID);
            String id = this.getPageCache().get("id");
            String domainContextUrl = UrlService.getDomainContextUrlByTenantCode((String)RequestContext.get().getTenantCode());
            String url = String.format("%s/nocode/%s/detail/%s", domainContextUrl, bizappId, id);
            this.getView().openUrl(url);
        }
    }

    private boolean resourceCheck(Map<String, Object> content) {
        Boolean isDeveloper;
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isBlank((CharSequence)currentIsv)) {
            currentIsv = KINGDEE;
        }
        String metadataIsv = this.getPageCache().get(FORM_ISV);
        if (KINGDEE.equalsIgnoreCase(currentIsv) && StringUtils.isBlank((CharSequence)metadataIsv)) {
            metadataIsv = currentIsv;
        }
        if (null != (isDeveloper = (Boolean)content.get("isDeveloper")) && !isDeveloper.booleanValue()) {
            return true;
        }
        if (StringUtils.equals((CharSequence)currentIsv, (CharSequence)metadataIsv)) {
            return true;
        }
        return true;
    }

    private Map<String, Object> getOldContent() {
        String oldContent = this.getPageCache().get("oldmetadata");
        if (Objects.isNull(oldContent)) {
            oldContent = this.cacheFallback();
        }
        return (Map)SerializationUtils.fromJsonString((String)oldContent, Map.class);
    }

    private boolean saveData(boolean fromPreview) {
        NoCodeFormDesigner designer = (NoCodeFormDesigner)this.getView().getControl(NO_CODE_FORM_DESIGNER);
        Map content = designer.getContent();
        if (!this.saveDataCheck(content)) {
            return false;
        }
        this.fixupContent(content);
        String modelType = (String)content.get("modelType");
        Map formMetaContent = (Map)content.get(FORM_META);
        if (formMetaContent.get(MODEL_TYPE_U) == null) {
            formMetaContent.put(MODEL_TYPE_U, modelType);
        }
        NoCodeDesignerData designerData = new NoCodeDesignerData();
        Map allLocaleData = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("localeItems"), Map.class);
        content.put("localeItems", allLocaleData);
        Boolean isTemplate = (Boolean)content.remove(SAVEASTEMPLATE);
        Map templateConfig = (Map)content.remove(TEMPLATECONFIG);
        Map<String, Object> oldContentMap = this.getOldContent();
        designerData.setSaveTableMetas(true);
        designerData.setSyncTableMetas(true);
        Map result = designerData.save(content, oldContentMap, fromPreview);
        if (((Boolean)result.get(KEY_SUCCESS)).booleanValue() && isTemplate != null && isTemplate.booleanValue()) {
            Map<String, Object> copy;
            String sourceId = (String)content.get("id");
            String id = FormMetaUtil.genIdUrlFriendly();
            String local = RequestContext.get().getLang().toString();
            Map metadata = MetadataDao.loadDesignerMetadata((String)sourceId, (String)local);
            FormMetadata formMeta = designerData.generateTemplateMeta(metadata, id);
            try {
                copy = this.setUpTemplate(isTemplate, templateConfig, sourceId, formMeta);
            }
            catch (Exception e) {
                NcErrorUtil.showErrorNotificationDuplicatePerTrace((IFormView)this.getView(), (String)e.getMessage());
                return false;
            }
            try {
                result = designerData.save(copy, true, fromPreview);
            }
            catch (Exception e) {
                log.debug("designerData.save error: {}", (Object)e.getMessage(), (Object)e);
                NcErrorUtil.showErrorNotificationDuplicatePerTrace((IFormView)this.getView(), (String)e.getMessage());
                return false;
            }
        }
        if (result.containsKey(KEY_SUCCESS) && ((Boolean)result.get(KEY_SUCCESS)).booleanValue()) {
            ArrayList<String> refBillKeys = new ArrayList<String>();
            List<Map<String, Object>> deletedKeys = this.getDeletedFieldKeys(content, oldContentMap);
            for (Map<String, Object> item : deletedKeys) {
                String fieldType = item.get(TYPE) == null ? "" : item.get(TYPE).toString();
                if (!StringUtils.isNotBlank((CharSequence)fieldType) || !fieldType.equals(NOCODE_MUL_REF_BILL_FIELD)) continue;
                refBillKeys.add((String)item.get("Key"));
            }
            if (!refBillKeys.isEmpty()) {
                AssociationServiceHelper.deleteAssociations((String)this.getEntityId(), refBillKeys);
            }
        }
        if (result.containsKey(KEY_SUCCESS) && ((Boolean)result.get(KEY_SUCCESS)).booleanValue()) {
            String refreshPage;
            String string = refreshPage = result.get("refreshPage") == null ? "false" : result.get("refreshPage").toString();
            if (StringUtils.equals((CharSequence)"true", (CharSequence)refreshPage)) {
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                proxy.addAction("f5Refresh", null);
            }
        }
        return this.analyseSaveResult(content, result, fromPreview, isTemplate);
    }

    private List<Map<String, Object>> getDeletedFieldKeys(Map<String, Object> content, Map<String, Object> oldContent) {
        Map oldEntityMeta = (Map)oldContent.get(ENTITY_META);
        Map entityMeta = (Map)content.get(ENTITY_META);
        List oldItems = (List)oldEntityMeta.get(ITEMS);
        List items = (List)entityMeta.get(ITEMS);
        List<Map<String, Object>> deletedKeys = oldItems.stream().filter(oldItem -> !oldItem.containsKey("ParentId")).filter(oldItem -> items.stream().noneMatch(item -> item.get("Key").equals(oldItem.get("Key")))).collect(Collectors.toList());
        return deletedKeys;
    }

    private void fixupContent(Map<String, Object> content) {
        Map em = (Map)content.get(ENTITY_META);
        List entityItems = (List)em.get(ITEMS);
        List bizFieldItems = entityItems.stream().filter(i -> i.get(TYPE) != null && ((String)i.get(TYPE)).startsWith("NoCodeMulRefBillField_")).collect(Collectors.toList());
        if (!bizFieldItems.isEmpty()) {
            String entityId = this.getPageCache().get(ENTITY_ID);
            DomainModelType noCodeDomainModelType = this.getNoCodeDomainModelType(entityId, false);
            for (Map entityItem : bizFieldItems) {
                Optional<Property> firstPropsDisplayProperty;
                Property property;
                Object defaultValue;
                Optional<Property> firstBillEntityIdExProperty;
                String type = (String)entityItem.get(TYPE);
                entityItem.put(TYPE, NOCODE_MUL_REF_BILL_FIELD);
                if (entityItem.get("BillEntityIdEx") != null && entityItem.get("PropsDisplay") != null) continue;
                ElementType elementType = noCodeDomainModelType.getElementType(type);
                if (elementType == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"NoCodeFormDesignerPlugin_3", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
                }
                if (entityItem.get("BillEntityIdEx") == null && (firstBillEntityIdExProperty = elementType.getProperties().stream().filter(p -> "BillEntityIdEx".equalsIgnoreCase(p.getPropertyName())).findFirst()).isPresent() && (defaultValue = (property = firstBillEntityIdExProperty.get()).getEditor().get(DEFAULT)) != null) {
                    entityItem.put("BillEntityIdEx", defaultValue);
                    entityItem.put(BillEntityId, defaultValue);
                }
                if (entityItem.get("PropsDisplay") != null || !(firstPropsDisplayProperty = elementType.getProperties().stream().filter(p -> "PropsDisplay".equalsIgnoreCase(p.getPropertyName())).findFirst()).isPresent() || (defaultValue = (property = firstPropsDisplayProperty.get()).getEditor().get(DEFAULT)) == null) continue;
                entityItem.put("PropsDisplay", defaultValue);
            }
        }
    }

    private DomainModelType getNoCodeDomainModelType(String targetFormId, boolean isSimple) {
        return (DomainModelType)ThreadCache.get((Object)("nc.domainModelType." + targetFormId), () -> {
            String modelTypeStr = (String)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)"nocode_sys", (String)NoCodeDesignMetadataService.class.getSimpleName(), (String)(isSimple ? "getNoCodeDomainModelSimple" : "getNoCodeDomainModel"), (Object[])new Object[]{"NoCodeModel", targetFormId});
            Map map = (Map)SerializationUtils.fromJsonString((String)modelTypeStr, Map.class);
            List dts = DomainModelType.getDomainModelTypeEntityTypes();
            DcJsonSerializer jser = new DcJsonSerializer((Iterable)dts);
            String locale = Lang.get().getLocale().toString();
            jser.getBinder().setLCId(locale);
            DomainModelType modelType = (DomainModelType)jser.deserializeFromMap(map, null);
            return modelType;
        });
    }

    private String cacheFallback() {
        String id = this.getPageCache().get("id");
        if (id != null) {
            String oldFormNum = FormMetaUtil.getFormNumberById((String)id);
            this.getPageCache().put(CACHE_KEY_OLD_FORM_NUM, oldFormNum);
            Map designerMetadata = MetadataDao.loadDesignerMetadata((String)id, (String)RequestContext.get().getLang().toString());
            this.clearInvalidRefProp(designerMetadata);
            Map formMeta = (Map)designerMetadata.get(FORM_META);
            Object formIsv = formMeta.get("Isv");
            this.getPageCache().put(FORM_ISV, StringUtils.isBlank(formIsv) ? "" : formIsv.toString());
            this.getPageCache().put(MERGE_VERSION, (String)designerMetadata.get(MERGE_VERSION));
            String modelType = (String)designerMetadata.get("modelType");
            this.getPageCache().put("modelType", modelType);
            designerMetadata.put("subSystem", 1);
            designerMetadata.put("isv", ISVService.getISVInfo().getId());
            String bizappId = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_APPID);
            if (StringUtils.isBlank((CharSequence)bizappId)) {
                bizappId = FormMetaUtil.getAppIdByFormId((String)id);
            }
            designerMetadata.put("appNum", AppReader.getAppNumberById((String)bizappId));
            designerMetadata.put(BIZ_APPID, bizappId);
            this.getPageCache().put(BIZ_APPID, bizappId);
            String oldContent = SerializationUtils.toJsonString((Object)designerMetadata);
            this.getPageCache().put("oldmetadata", oldContent);
            return oldContent;
        }
        throw new KDBizException("formId is empty");
    }

    private boolean saveDataCheck(Map<String, Object> content) {
        if (EnvTypeHelper.isDeploying()) {
            String errorMsg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"NoCodeFormDesignerPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            NcErrorUtil.showErrorNotificationDuplicatePerTrace((IFormView)this.getView(), (String)errorMsg);
            return false;
        }
        return !content.isEmpty() && this.resourceCheck(content);
    }

    private Map<String, Object> setUpTemplate(Boolean isTemplate, Map<String, Object> templateConfig, String sourceId, FormMetadata formMeta) {
        formMeta.getItems().stream().filter(i -> i instanceof NoCodeBizButtonAp).forEach(i -> {
            ((NoCodeBizButtonAp)i).setTriggerProcess("");
            ((NoCodeBizButtonAp)i).setTriggerProcessAfterInput("");
            ((NoCodeBizButtonAp)i).setInputForm("");
            ((NoCodeBizButtonAp)i).setInputContent("");
        });
        String bizappId = NoCodeTemplateUtil.queryFormTemplateAppId();
        formMeta.setBizappId(bizappId);
        formMeta.getEntityMetadata().setBizappId(bizappId);
        Map copy = formMeta.buildDesignMeta("zh_CN");
        Map em = (Map)copy.get(ENTITY_META);
        List entityItems = (List)em.get(ITEMS);
        Map noCodeBillEntity = (Map)entityItems.get(0);
        noCodeBillEntity.remove(TABLE_NAME);
        Map fm = (Map)copy.get(FORM_META);
        List formItems = (List)fm.get(ITEMS);
        Map noCodeBillForm = (Map)formItems.get(0);
        noCodeBillForm.remove(TABLE_NAME);
        for (Map entityItem : entityItems) {
            Object bill;
            if (entityItem.containsKey(TYPE) && (entityItem.get(TYPE).equals("NoCodeRefBillField") || entityItem.get(TYPE).equals(NOCODE_MUL_REF_BILL_FIELD) || entityItem.get(TYPE).equals("NoCodeRefBillTable")) && !"bos_user".equals(bill = entityItem.get(BillEntityId)) && !"bos_adminorg".equals(bill)) {
                if (bill != null) {
                    String refTableId;
                    ErrorInfo e = new ErrorInfo(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u5b58\u5728\u5173\u8054\u8868\u5355\u6216\u8868\u683c\uff0c\u65e0\u6cd5\u4fdd\u5b58\u4e3a\u6a21\u677f", (String)"NoCodeFormDesignerPlugin_4", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
                    String showType = entityItem.get("ShowType") == null ? null : (String)entityItem.get("ShowType");
                    String string = refTableId = entityItem.get("RefTableId") == null ? null : (String)entityItem.get("RefTableId");
                    if (StringUtils.isNotBlank((CharSequence)refTableId) && "2".equals(showType)) {
                        e.setItemId(refTableId);
                    } else {
                        e.setItemId((String)entityItem.get("Id"));
                    }
                    this.showDesignerError(Lists.newArrayList((Object[])new ErrorInfo[]{e}));
                    throw new RestApiException(e.getError());
                }
                entityItem.remove("BillEntityIdEx");
                entityItem.remove(BillEntityId);
                entityItem.remove("PropsDisplay");
            }
            if (!entityItem.containsKey(TYPE) || !entityItem.get(TYPE).equals("NoCodeAttachmentUploadField") && !entityItem.get(TYPE).equals("NoCodeEntryEntity")) continue;
            entityItem.remove(TABLE_NAME);
        }
        for (Map formItem : formItems) {
            if (!formItem.containsKey(TYPE) || !formItem.get(TYPE).equals("NoCodeAttachmentUploadFieldAp")) continue;
            formItem.remove(TABLE_NAME);
        }
        templateConfig.put("sourceId", sourceId);
        copy.put(TEMPLATECONFIG, templateConfig);
        copy.put(SAVEASTEMPLATE, isTemplate);
        return copy;
    }

    private boolean analyseSaveResult(Map<String, Object> content, Map<String, Object> result, boolean fromPreview, Boolean isTemplate) {
        NoCodeFormDesigner designer = (NoCodeFormDesigner)this.getView().getControl(NO_CODE_FORM_DESIGNER);
        boolean success = (Boolean)result.get(KEY_SUCCESS);
        if (success) {
            this.getPageCache().put("oldmetadata", SerializationUtils.toJsonString(content));
            String openformId = (String)((Map)content.get(FORM_META)).get("Key");
            Map contentMap = (Map)content.get(FORM_META);
            HashMap<String, String> cacheValues = new HashMap<String, String>(10);
            cacheValues.put("id", (String)contentMap.get("Id"));
            cacheValues.put("number", (String)contentMap.get("Key"));
            this.getPageCache().put(cacheValues);
            String formName = (String)contentMap.get("Name");
            String bizappId = this.getPageCache().get(BIZ_APPID);
            NcRetryUtil.withRetry(() -> this.syncMenuName(bizappId, openformId, formName), (int)3, r -> !r.isEmpty() && Boolean.parseBoolean(r.get(KEY_SUCCESS).toString()));
            pool.execute(() -> {
                this.buildLogInfo(openformId);
                this.writeLog((String)contentMap.get("Id"), openformId);
            }, RequestContext.get());
            if (Boolean.TRUE.equals(result.get("warning"))) {
                this.getView().showTipNotification((String)result.get(MESSAGE));
                this.showDesignerError(new ArrayList<ErrorInfo>());
            } else {
                String successMsg = ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f", (String)"NoCodeFormDesignerPlugin_5", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]);
                if (isTemplate != null && isTemplate.booleanValue()) {
                    successMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"NoCodeFormDesignerPlugin_6", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]);
                }
                this.getView().showSuccessNotification(successMsg);
                this.showDesignerError(new ArrayList<ErrorInfo>());
            }
            return true;
        }
        List errorList = (List)result.get(ERRORS);
        NcErrorUtil.showErrorNotificationDuplicatePerTrace((IFormView)this.getView(), (String)this.buildErrMsg(errorList));
        this.showDesignerError(errorList);
        return false;
    }

    private void showDesignerError(List<ErrorInfo> errorList) {
        NoCodeFormDesigner designer = (NoCodeFormDesigner)this.getView().getControl(NO_CODE_FORM_DESIGNER);
        Map<String, List<ErrorInfo>> formatErrMsgMap = this.formatErrMsg(errorList);
        String strError = SerializationUtils.toJsonString(formatErrMsgMap);
        Map errorMap = (Map)SerializationUtils.fromJsonString((String)strError, Map.class);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(designer.getKey(), "showDesignerError", new Object[]{errorMap});
    }

    private Map<String, List<ErrorInfo>> formatErrMsg(List<ErrorInfo> buildErrors) {
        return buildErrors.stream().collect(Collectors.groupingBy(e -> Optional.ofNullable(e.getItemId()).orElse("")));
    }

    private Map<String, Object> syncMenuName(String bizappId, String openformId, String formName) {
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)bizappId);
        Optional<AppMenuElement> first = appMetadata.getAppMenus().stream().filter(m -> openformId.equalsIgnoreCase(m.getFormId())).findFirst();
        if (!first.isPresent()) {
            return Collections.emptyMap();
        }
        AppMenuElement appMenuElement = first.get();
        LocaleString name = appMenuElement.getName();
        if (!formName.equalsIgnoreCase(name.toString())) {
            name.setLocaleValue(formName);
            appMenuElement.setName(name);
            return AppMetaServiceHelper.save((AppMetadata)appMetadata);
        }
        return Collections.emptyMap();
    }

    private String buildErrMsg(List<ErrorInfo> errorList) {
        log.debug("\u53d1\u5e03\u5b58\u5728\u9519\u8bef\uff1a{}", (Object)SerializationUtils.toJsonString(errorList));
        return ResManager.loadKDString((String)"\u5b58\u5728\u6709%s\u6761\u9519\u8bef\uff0c\u8bf7\u4fee\u590d\u540e\u518d\u53d1\u5e03", (String)"NoCodeFormDesignerPlugin_7", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[]{errorList.size()});
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String userIDStr = null;
        String themeIDStr = null;
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        switch (key) {
            case "getUserTheme": {
                Long userID;
                userIDStr = RequestContext.get().getUserId();
                try {
                    userID = Long.parseLong(userIDStr);
                }
                catch (Exception ex) {
                    log.warn((Throwable)ex);
                    return;
                }
                Map theme = UserServiceHelper.getUserTheme((Long)userID);
                clientViewProxy.invokeControlMethod(this.getView().getPageId(), GET_USER_THEME, new Object[]{theme});
                break;
            }
            case "setUserTheme": {
                Long themeID;
                Long userID;
                userIDStr = RequestContext.get().getUserId();
                themeIDStr = e.getEventArgs();
                try {
                    userID = Long.parseLong(userIDStr);
                }
                catch (Exception ex) {
                    log.warn((Throwable)ex);
                    return;
                }
                try {
                    themeID = Long.parseLong(themeIDStr);
                }
                catch (Exception ex) {
                    log.warn((Throwable)ex);
                    themeID = 0L;
                }
                if (themeID == 0L) {
                    UserServiceHelper.setUserTheme((Long)userID, (String)themeIDStr);
                } else {
                    UserServiceHelper.setUserTheme((Long)userID, (Long)themeID);
                }
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("themeNum", themeIDStr);
                AppCache.get((String)"bos").put("theme" + userID, (Object)SerializationUtils.toJsonString(result));
                break;
            }
            case "getThemeCSS": {
                String themeNum = e.getEventArgs();
                if (StringUtils.isEmpty((CharSequence)themeNum)) {
                    String errorMessage = ResManager.loadKDString((String)"\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a \u4e0d\u5b58\u5728\u53c2\u6570 themeNum", (String)"NoCodeFormDesignerPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                    clientViewProxy.invokeControlMethod(this.getView().getPageId(), GET_USER_THEME, new Object[]{errorMessage});
                    return;
                }
                String css = UserServiceHelper.getThemeCSS((String)themeNum);
                clientViewProxy.invokeControlMethod(this.getView().getPageId(), "getThemeCSS", new Object[]{css});
                break;
            }
        }
    }

    public void keyDown(KeyPressArgs keys) {
        if (keys.isCtrlKey() && keys.getKeyCode() == 83) {
            this.saveData(false);
        }
    }

    private void buildLogInfo(String formId) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        String msg = ResManager.loadKDString((String)"\u8868\u5355\u5143\u6570\u636e\u4fdd\u5b58\u6210\u529f", (String)"NoCodeFormDesignerPlugin_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        OpLogAppInfo logInfo = this.doBuildLogInfo(formId, msg);
        logService.addLog((AppLogInfo)logInfo);
    }

    private OpLogAppInfo doBuildLogInfo(String formId, String msg) {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        logInfo.setBizAppID(BizAppServiceHelp.getAppIdByAppNumber((String)"ide"));
        logInfo.setBizObjID(formId);
        logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(SAVE, ResManager.loadKDString((String)"\u4fdd\u5b58\u8868\u5355\u5143\u6570\u636e", (String)"NoCodeFormDesignerPlugin_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        logInfo.setOpDescription(msg);
        return logInfo;
    }

    private void writeLog(String formId, String formNumber) {
        try {
            long fid = DB.genGlobalLongId();
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            logService.addMetaLog(formId, formNumber, (int)MetaLogType.FormDesign.getValue(), fid, (int)MetaType.Form.getValue());
        }
        catch (Exception e) {
            log.debug("\u4fdd\u5b58\u5143\u6570\u636e\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public String autoFormNumber(String formNumber, String tag, String formId, String masterId) {
        int formCounts = this.getExtFormCounts(formId, masterId);
        if (formNumber.length() <= 25) {
            if (formCounts > 0) {
                formNumber = formNumber + formCounts;
            }
        } else {
            int tagLen = tag.length();
            formNumber = formNumber.substring(0, 25 - tagLen) + tag;
            if (formCounts > 0) {
                int iLen = String.valueOf(formCounts).length();
                formNumber = formNumber.substring(0, 25 - tagLen - iLen) + tag + formCounts;
            }
        }
        return formNumber;
    }

    public int getExtFormCounts(String formId, String masterId) {
        String sql = String.format("select 1 from %s where FMASTERID = ? ", "T_META_FORMDESIGN");
        Object[] params = new SqlParameter[]{StringUtils.isBlank((CharSequence)masterId) ? new SqlParameter(":FMASTERID", 12, (Object)formId) : new SqlParameter(":FMASTERID", 12, (Object)masterId)};
        return (Integer)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                int isvcount = 0;
                if (rs.next()) {
                    isvcount = rs.getInt(1);
                }
                return isvcount;
            }
        });
    }

    public void click(PropertyEvent e) {
        String propertName = e.getPropertName();
        Map param = e.getParam();
        String bizappId = this.getPageCache().get(BIZ_APPID);
        String entityId = this.getPageCache().get(ENTITY_ID);
        if ("BillEntityIdEx".equalsIgnoreCase(propertName)) {
            if (param.get("showTree") != null && param.get("showTree").toString().equals("true")) {
                String parentId = param.get("parentId") == null ? null : param.get("parentId").toString();
                String ignoreCosmicForm = param.get("ignoreCosmicForm") == null ? null : param.get("ignoreCosmicForm").toString();
                NoCodeTreeNode root = NcEntityTypeUtil.buildRefBillTreeData((String)bizappId, (String)parentId, (String)ignoreCosmicForm);
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.invokeControlMethod(this.getDesignerKey(), "setRefBillTreeData", new Object[]{root});
            } else {
                JSONObject data = NcEntityTypeUtil.buildRefBillData((Map)param, (String)bizappId);
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SET_REF_BILL_DATA, new Object[]{data});
            }
        } else if ("PropsDisplay".equalsIgnoreCase(propertName)) {
            String billEntityId = (String)param.get("BillEntityIdEx");
            billEntityId = NcEntityTypeUtil.getRealBillEntityId((String)billEntityId);
            String itemKey = (String)param.get(ITEM_KEY);
            if (StringUtils.isNotBlank((CharSequence)billEntityId)) {
                boolean valid = this.checkBillEntityIdInvalid(billEntityId);
                if (valid) {
                    JSONArray data = this.buildRefPropDisplayData(billEntityId, itemKey);
                    IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SET_REF_PROP_DISP, new Object[]{data});
                } else {
                    NcErrorUtil.showErrorNotificationDuplicatePerTrace((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"NoCodeFormDesignerPlugin_3", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
                }
            }
        } else if (PROPS_INPUT_FORM.equalsIgnoreCase(propertName)) {
            if (StringUtils.isNotBlank((CharSequence)entityId)) {
                boolean valid = this.checkBillEntityIdInvalid(entityId);
                if (valid) {
                    NoCodeTreeNode root = this.buildInputFormList(entityId);
                    IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SET_INPUT_FORM, new Object[]{root});
                } else {
                    NcErrorUtil.showErrorNotificationDuplicatePerTrace((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"NoCodeFormDesignerPlugin_3", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
                }
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private NoCodeTreeNode buildInputFormList(String entityId) {
        NoCodeTreeNode root = new NoCodeTreeNode(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355", (String)"NoCodeFormDesignerPlugin_11", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]), "$" + entityId, null, new ArrayList());
        NoCodeFormDesigner designer = (NoCodeFormDesigner)this.getView().getControl(NO_CODE_FORM_DESIGNER);
        Map content = designer.getContent();
        this.queryChildren(root, content);
        root.getChildren().forEach(e -> this.queryChildren((NoCodeTreeNode)e, null));
        String bizappId = this.getPageCache().get(BIZ_APPID);
        NoCodeTreeNode ret = NcEntityTypeUtil.buildRefBillTreeData((String)bizappId, null, (String)"true");
        ret.getChildren().removeIf(n -> n.getValue().equals("bos_user"));
        ret.getChildren().removeIf(n -> n.getValue().equals("bos_adminorg"));
        Optional<NoCodeTreeNode> first = ret.getChildren().stream().filter(s -> s.getValue().equals(bizappId)).findFirst();
        if (first.isPresent()) {
            NoCodeTreeNode node = first.get();
            for (int i = 0; i < node.getChildren().size(); ++i) {
                if (!((NoCodeTreeNode)node.getChildren().get(i)).getValue().equals(entityId)) continue;
                node.getChildren().set(i, root);
                break;
            }
        }
        ret.setSelectable(false);
        ret.getChildren().forEach(n -> n.setSelectable(false));
        return ret;
    }

    private void queryChildren(NoCodeTreeNode root, Map<String, Object> content) {
        Map meta;
        String path = root.getValue();
        String formId = path;
        if (formId.contains(".")) {
            String[] split = path.split("\\.");
            formId = split[split.length - 1];
        }
        if (formId.contains("[")) {
            formId = formId.substring(0, formId.indexOf(91));
        }
        if (formId.contains("$")) {
            formId = formId.replace("$", "");
        }
        if ((meta = MapUtils.isEmpty(content) ? MetadataDao.loadDesignerMetadata((String)formId) : content) == null) {
            return;
        }
        Map entityMeta = (Map)meta.get(ENTITY_META);
        List items = (List)entityMeta.get(ITEMS);
        Set tables = items.stream().filter(i -> i.get(TYPE).equals("NoCodeEntryEntity")).map(i -> i.get("Id")).collect(Collectors.toSet());
        List collect = items.stream().filter(i -> !i.containsKey("ParentId") || !tables.contains(i.get("ParentId"))).filter(i -> {
            Object type = i.get(TYPE);
            if (type instanceof String) {
                String typeStr = (String)type;
                return typeStr.startsWith("NoCodeRefBillField") || typeStr.startsWith(NOCODE_MUL_REF_BILL_FIELD);
            }
            return false;
        }).peek(i -> {
            String[] split;
            String type = (String)i.get(TYPE);
            if (!i.containsKey("BillEntityIdEx") && type.contains("_") && (split = type.split("_")).length > 1) {
                i.put("BillEntityIdEx", split[1]);
            }
        }).filter(i -> i.getOrDefault(MULTI, "0").equals("0")).filter(i -> i.containsKey("BillEntityIdEx")).filter(i -> !i.get("BillEntityIdEx").equals("bos_user")).filter(i -> !i.get("BillEntityIdEx").equals("bos_adminorg")).map(i -> Maps.of((Object)"ref", (Object)((String)i.get("BillEntityIdEx")), (Object)"field", (Object)((String)i.get("Key")), (Object)"name", (Object)((String)i.get("Name")))).collect(Collectors.toList());
        for (Map map : collect) {
            String ref = (String)map.get("ref");
            if (!StringUtils.isNotEmpty((CharSequence)ref)) continue;
            String fieldName = (String)map.get("name");
            if (ref.contains(",")) {
                ref = ref.split(",")[1];
            }
            try {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ref);
                String formName = dt.getDisplayName().getLocaleValue();
                StringBuilder name = new StringBuilder();
                name.append("[").append(formName).append("]").append(fieldName);
                String value = root.getValue() + "." + ref + "[" + (String)map.get("field") + "]";
                NoCodeTreeNode node = new NoCodeTreeNode(name.toString(), value, root.getValue(), new ArrayList());
                root.getChildren().add(node);
            }
            catch (Exception e) {
                log.warn((Throwable)e);
            }
        }
    }

    private JSONArray buildRefPropDisplayData(String billEntityId, String itemKey) {
        JSONArray data = new JSONArray();
        String entityId = this.getPageCache().get(ENTITY_ID);
        FieldTreeBuilder fieldTreeBuilder = new FieldTreeBuilder(billEntityId);
        List showColumns = fieldTreeBuilder.withFeature(new FieldTreeBuilder.Feature[]{FieldTreeBuilder.Feature.AttachmentDetail, FieldTreeBuilder.Feature.UseRealType}).withoutFieldTypes(new FieldTreeBuilder.FieldType[]{FieldTreeBuilder.FieldType.NoCodeRichTextField, FieldTreeBuilder.FieldType.NoCodeGraphicDisplayField, FieldTreeBuilder.FieldType.NoCodeAttachmentUploadField, FieldTreeBuilder.FieldType.NoCodeImageUploadField, FieldTreeBuilder.FieldType.NoCodeBillNoField, FieldTreeBuilder.FieldType.EntryField}).build();
        if (showColumns != null && !showColumns.isEmpty()) {
            for (ShowColumnInfo showColumn : showColumns) {
                if (billEntityId.equalsIgnoreCase(entityId) && StringUtils.isNotBlank((CharSequence)itemKey) && itemKey.equalsIgnoreCase(showColumn.getId())) continue;
                DispProp dispProp = new DispProp();
                dispProp.setProperyKey(showColumn.getId());
                dispProp.setPropertyCaption(showColumn.getCaption());
                data.add((Object)dispProp);
            }
        }
        ListConfigUtils.addExtraFieldsForRefBill((String)billEntityId, (JSONArray)data);
        return data;
    }

    private boolean checkBillEntityIdInvalid(String billEntityId) {
        return NcEntityTypeUtil.isFormExist((String)billEntityId);
    }

    public void tabSelected(TabSelectEvent evt) {
        throw new UnsupportedOperationException();
    }

    public void doCall(DesignerCallEvent e) {
        IClientViewProxy clientViewProxy;
        List fieldKeys;
        if (CALL_ACTION_CAN_SWITCH_FIELD_TYPES.equalsIgnoreCase(e.getActionId()) && !(fieldKeys = (List)e.getParam()).isEmpty()) {
            String keyStr = String.join((CharSequence)".", fieldKeys);
            Map ret = (Map)ThreadCache.get((Object)("nc.canSwitch." + keyStr), () -> this.getCanSwitchFieldTypes(fieldKeys));
            clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SET_SWITCH_FIELD_TYPES, new Object[]{ret});
        }
        if (CALL_ACTION_GET_TRIGGER_PROCESS.equalsIgnoreCase(e.getActionId())) {
            String entityId = this.getEntityId();
            List ret = NoCodeWorkflowServiceUtil.getProcessesByEntityNumber((String)entityId);
            IClientViewProxy clientViewProxy2 = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy2.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SET_TRIGGER_PROCESS, new Object[]{ret});
        }
        if (CALL_ACTION_GET_INPUT_CONTENT.equalsIgnoreCase(e.getActionId())) {
            boolean valid;
            String target = (String)e.getParam();
            if (StringUtils.isEmpty((CharSequence)target)) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5b57\u6bb5\u4e2d\u7684\u5c5e\u6027\u201c%s\u201d\u4e0d\u53ef\u4e3a\u7a7a", (String)"NoCodeFormDesignerPlugin_12", (String)"nocode_system", (Object[])new Object[]{BOS_NOCODE_FORMPLUGIN});
                NcErrorUtil.showErrorNotificationDuplicatePerTrace((IFormView)this.getView(), (String)errorMsg);
                return;
            }
            if (target.contains(".")) {
                String[] split = target.split("\\.");
                target = split[split.length - 1];
                target = target.substring(0, target.indexOf(91));
            }
            if (target.contains("$")) {
                target = target.replace("$", "");
            }
            if (valid = this.checkBillEntityIdInvalid(target)) {
                Map metadata = MetadataDao.loadDesignerMetadata((String)target);
                clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SET_INPUT_CONTENT, new Object[]{metadata});
            } else {
                NcErrorUtil.showErrorNotificationDuplicatePerTrace((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"NoCodeFormDesignerPlugin_3", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    private Map<String, List<String>> getCanSwitchFieldTypes(List<String> fieldKeys) {
        int size = fieldKeys.size();
        if (size > 1) {
            size = Math.floorDiv(size, 2);
        }
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>(size);
        String entityId = this.getPageCache().get(ENTITY_ID);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        DomainModelType domainModelType = this.getNoCodeDomainModelType(entityId, true);
        String dbRoute = this.getPageCache().get(DB_ROUTE_R);
        if (StringUtils.isBlank((CharSequence)dbRoute)) {
            dbRoute = entityMetadata.getDBRouteKey();
        }
        List entitys = entityMetadata.getEntitys();
        List<ElementType> allFieldElementTypes = NoCodeFormDesignerPlugin.getAllFieldElementTypes(domainModelType);
        for (int i = 0; i < size; ++i) {
            boolean isEntryField;
            Optional<EntityItem> optional;
            String fieldKey = fieldKeys.get(i * 2);
            String fieldTypeFromClient = fieldKeys.size() <= i * 2 + 1 ? null : fieldKeys.get(i * 2 + 1);
            String searchKey = fieldKey;
            if ("NoCodeRefBillTable".equals(fieldKeys.get(i * 2 + 1)) && (optional = entityMetadata.getItems().stream().filter(e -> fieldKey.equals(e.getKey())).findFirst()).isPresent()) {
                NoCodeRefBillTable item = (NoCodeRefBillTable)optional.get();
                searchKey = item.getRefBillKey();
                fieldTypeFromClient = NOCODE_MUL_REF_BILL_FIELD;
            }
            Tuple<String, Field<?>> tableFieldInfo = this.getTableFieldInfo(searchKey, entitys);
            String tableName = (String)tableFieldInfo.item1;
            Field field = (Field)tableFieldInfo.item2;
            if (field == null) continue;
            ArrayList<String> theFldCanSwitchTypes = new ArrayList<String>(10);
            boolean existData = this.existBizValue(field, tableName, dbRoute);
            if (existData) {
                for (ElementType allFieldElementType : this.getCompatibleFieldElementTypes(field, fieldTypeFromClient, allFieldElementTypes)) {
                    theFldCanSwitchTypes.add(allFieldElementType.getId());
                }
            } else {
                for (ElementType fieldElementType : this.getAllOtherFieldElementTypes(field, fieldTypeFromClient, allFieldElementTypes)) {
                    theFldCanSwitchTypes.add(fieldElementType.getId());
                }
            }
            if (isEntryField = this.isEntryField(fieldKey, entityMetadata)) {
                theFldCanSwitchTypes.removeIf(t -> t.equalsIgnoreCase("NoCodeRichTextField"));
            }
            ret.put(fieldKey, theFldCanSwitchTypes);
        }
        return ret;
    }

    private boolean isEntryField(String fieldKey, EntityMetadata entityMetadata) {
        Field fieldByKey = entityMetadata.getFieldByKey(fieldKey);
        if (fieldByKey == null) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)fieldByKey.getParentId())) {
            return false;
        }
        EntryEntity entry = entityMetadata.getEntryById(fieldByKey.getParentId());
        return entry != null;
    }

    private static List<ElementType> getAllFieldElementTypes(DomainModelType domainModelType) {
        Category categoryBiz;
        ArrayList<ElementType> result = new ArrayList<ElementType>(10);
        Category categoryGeneral = domainModelType.getCategories().stream().filter(c -> CATEGORY_GENERAL_CONTENT.equalsIgnoreCase(c.getId())).findFirst().orElse(null);
        if (categoryGeneral != null) {
            for (ElementType elementType : categoryGeneral.getElementTypes()) {
                if (!"Field".equalsIgnoreCase(elementType.getBaseType()) || CommonConstants.isNonImplElement((String)elementType.getId())) continue;
                result.add(elementType);
            }
        }
        if ((categoryBiz = (Category)domainModelType.getCategories().stream().filter(c -> CATEGORY_BIZ_CONTENT.equalsIgnoreCase(c.getId())).findFirst().orElse(null)) != null) {
            for (ElementType elementType : categoryBiz.getElementTypes()) {
                if (!"Field".equalsIgnoreCase(elementType.getBaseType()) || CommonConstants.isNonImplElement((String)elementType.getId())) continue;
                result.add(elementType);
            }
        }
        return result;
    }

    private Tuple<String, Field<?>> getTableFieldInfo(String fieldKey, List<Entity<?, ?>> entitys) {
        String tableName = null;
        Field field = null;
        block0: for (Entity<?, ?> entity : entitys) {
            List items = entity.getItems();
            for (EntityItem item : items) {
                if (!fieldKey.equalsIgnoreCase(item.getKey())) continue;
                if (item instanceof NoCodeRefBillTable) {
                    return new Tuple(tableName, (Object)field);
                }
                field = (Field)item;
                if (entity instanceof NoCodeRefBillTable) {
                    NoCodeRefBillTable table = (NoCodeRefBillTable)entity;
                    tableName = "t_nc_" + table.getBillEntityIdEx();
                    continue block0;
                }
                tableName = field.getTableName(entity);
                continue block0;
            }
        }
        return new Tuple(tableName, field);
    }

    private boolean existBizValue(Field<?> field, String tableName, String dbRoute) {
        if (StringUtils.isBlank((CharSequence)tableName)) {
            return false;
        }
        DbMetadataTable table = AlterTableUtil.getTableSchema((String)dbRoute, (String)tableName, (boolean)false);
        if (table == null || table.getColumns().isEmpty() || field == null) {
            return false;
        }
        String fieldName = field.getFieldName();
        if (field instanceof NoCodeDateRangeField) {
            fieldName = ((NoCodeDateRangeField)field).getStartDateFieldName();
        } else if (field instanceof IAttachmentField) {
            return this.existBizValue2AttachmentField((IAttachmentField)field, dbRoute);
        }
        if (StringUtils.isBlank((CharSequence)fieldName) || table.getColumns().get(fieldName) == null) {
            return false;
        }
        String whereClause = field instanceof DecimalField ? String.format("isnull(%s,0) <> 0", fieldName) : (field instanceof BasedataField || field instanceof RefBillField ? String.format("isnull(%s,0) <> 0", fieldName) : fieldName + " is not null");
        String sql = String.format("select top 1 %s from %s where %s;", fieldName, tableName, whereClause);
        return (Boolean)DB.query((DBRoute)new DBRoute(dbRoute), (String)sql, null, rs -> {
            if (rs.next()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
    }

    private boolean existBizValue2AttachmentField(IAttachmentField attachmentField, String dbRoute) {
        String sql = String.format("select top 1 fpkid from %s ;", attachmentField.getTableName());
        return (Boolean)DB.query((DBRoute)new DBRoute(dbRoute), (String)sql, null, rs -> {
            if (rs.next()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
    }

    private List<ElementType> getAllOtherFieldElementTypes(Field<?> field, String fieldTypeFromClient, List<ElementType> allFieldElementTypes) {
        ArrayList<ElementType> result = new ArrayList<ElementType>(allFieldElementTypes.size());
        ElementType currentFieldElementType = this.getElementTypeByField(field, fieldTypeFromClient, allFieldElementTypes);
        if (currentFieldElementType == null) {
            return result;
        }
        for (ElementType fieldElementType : allFieldElementTypes) {
            if (fieldElementType.getId().equalsIgnoreCase(currentFieldElementType.getId()) || this.isIncompatibleEvenNoData(currentFieldElementType, fieldElementType)) continue;
            result.add(fieldElementType);
        }
        return result;
    }

    private boolean isIncompatibleEvenNoData(ElementType srcElement, ElementType targetElement) {
        if (srcElement == null || srcElement.getAccept() == null || !srcElement.getAccept().containsKey(COMPATIBLE_TYPE) || targetElement == null || targetElement.getAccept() == null || !targetElement.getAccept().containsKey(COMPATIBLE_TYPE)) {
            return false;
        }
        String srcCompatibleType = (String)srcElement.getAccept().get(COMPATIBLE_TYPE);
        String targeCompatibleType = (String)targetElement.getAccept().get(COMPATIBLE_TYPE);
        if (COMPATIBLE_TYPE_DATE.equalsIgnoreCase(srcCompatibleType) && "number".equalsIgnoreCase(targeCompatibleType) || "number".equalsIgnoreCase(srcCompatibleType) && COMPATIBLE_TYPE_DATE.equalsIgnoreCase(targeCompatibleType)) {
            return true;
        }
        return COMPATIBLE_TYPE_DATE.equalsIgnoreCase(srcCompatibleType) && COMPATIBLE_TYPE_REFBILL.equalsIgnoreCase(targeCompatibleType) || COMPATIBLE_TYPE_REFBILL.equalsIgnoreCase(srcCompatibleType) && COMPATIBLE_TYPE_DATE.equalsIgnoreCase(targeCompatibleType);
    }

    private List<ElementType> getCompatibleFieldElementTypes(Field<?> field, String fieldTypeFromClient, List<ElementType> allFieldElementTypes) {
        ArrayList<ElementType> result = new ArrayList<ElementType>(allFieldElementTypes.size());
        ElementType currentFieldElementType = this.getElementTypeByField(field, fieldTypeFromClient, allFieldElementTypes);
        if (currentFieldElementType == null || currentFieldElementType.getAccept() == null || !currentFieldElementType.getAccept().containsKey(COMPATIBLE_TYPE)) {
            return result;
        }
        String compatibleType = (String)currentFieldElementType.getAccept().get(COMPATIBLE_TYPE);
        if (COMPATIBLE_TYPE_REFBILL.equalsIgnoreCase(compatibleType)) {
            return result;
        }
        for (ElementType fieldElementType : allFieldElementTypes) {
            Map accept = fieldElementType.getAccept();
            if (accept == null || !accept.containsKey(COMPATIBLE_TYPE) || fieldElementType.getId().equalsIgnoreCase(currentFieldElementType.getId()) || !compatibleType.equalsIgnoreCase((String)accept.get(COMPATIBLE_TYPE))) continue;
            result.add(fieldElementType);
        }
        return result;
    }

    private ElementType getElementTypeByField(Field<?> field, String fieldTypeFromClient, List<ElementType> allFieldElementTypes) {
        String fieldTypeName = fieldTypeFromClient;
        if (StringUtils.isBlank((CharSequence)fieldTypeName)) {
            fieldTypeName = field.getClass().getSimpleName();
        }
        for (ElementType fieldElementType : allFieldElementTypes) {
            if (!fieldElementType.getId().equalsIgnoreCase(fieldTypeName)) continue;
            return fieldElementType;
        }
        return null;
    }

    public void getFilterItemLook(NoCodeFilterConfigEvent arg) {
        try {
            Map result = (Map)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)"nocode_sys", (String)RestApiWrap.class.getSimpleName(), (String)"getFilterItemLook", (Object[])new Object[]{arg.getRealFormId(), arg.getParam()});
            result.put(ARGS, arg);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_FILTERITEMLOOK, new Object[]{result});
        }
        catch (Exception e) {
            NcErrorUtil.showErrorNotificationDuplicatePerTrace((IFormView)this.getView(), (String)e.getMessage());
        }
    }

    public void listconfig(NoCodeFilterConfigEvent arg) {
        try {
            if (NcEntityTypeUtil.isFormExist((String)arg.getRealFormId())) {
                Map result = (Map)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)"nocode_sys", (String)RestApiWrap.class.getSimpleName(), (String)"listConfig", (Object[])new Object[]{arg.getRealFormId(), arg.getParam()});
                result.put(ARGS, arg);
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SETLISTCONFIG, new Object[]{result});
            }
        }
        catch (Exception e) {
            NcErrorUtil.showErrorNotificationDuplicatePerTrace((IFormView)this.getView(), (String)e.getMessage());
        }
    }

    public void listTreeConfig(NoCodeFilterConfigEvent arg) {
        try {
            List showColumns;
            String sourceType;
            String formId;
            String finalFormId = formId = arg.getRealFormId();
            String string = sourceType = arg.getParam().get("sourceType") == null ? null : (String)arg.getParam().get("sourceType");
            if (StringUtils.isNotBlank((CharSequence)formId) && NcEntityTypeUtil.isFormExist((String)formId)) {
                this.listTree_formId = formId;
                FieldTreeBuilder fieldTreeBuilder = new FieldTreeBuilder(formId);
                showColumns = fieldTreeBuilder.withFeature(new FieldTreeBuilder.Feature[]{FieldTreeBuilder.Feature.GroupContainer, FieldTreeBuilder.Feature.AttachmentDetail, FieldTreeBuilder.Feature.ExpMulRefBill, FieldTreeBuilder.Feature.UseRealType}).withoutFieldTypes(new FieldTreeBuilder.FieldType[]{FieldTreeBuilder.FieldType.NoCodeBillNoField, FieldTreeBuilder.FieldType.EntryField}).withCustomInfo(ctx -> this.customInfo(finalFormId, ctx.getField(), ctx.getFormMeta(), ctx.getInfo(), null, this.isFormula(sourceType)), false, null).withLevel(4).build();
            } else {
                NoCodeFormDesigner designer = (NoCodeFormDesigner)this.getView().getControl(NO_CODE_FORM_DESIGNER);
                Map content = designer.getContent();
                if (content != null) {
                    NoCodeDesignerData designerData = new NoCodeDesignerData();
                    this.fixupContent(content);
                    Map<String, Object> oldContentMap = this.getOldContent();
                    Map fixupedContent = designerData.fixupContent(content, oldContentMap);
                    FormMetadata formMeta = (FormMetadata)designerData.convertTo(fixupedContent, "NoCodeModel");
                    FieldTreeBuilder fieldTreeBuilder = new FieldTreeBuilder(formMeta);
                    showColumns = fieldTreeBuilder.withFeature(new FieldTreeBuilder.Feature[]{FieldTreeBuilder.Feature.GroupContainer, FieldTreeBuilder.Feature.AttachmentDetail, FieldTreeBuilder.Feature.ExpMulRefBill, FieldTreeBuilder.Feature.UseRealType}).withoutFieldTypes(new FieldTreeBuilder.FieldType[]{FieldTreeBuilder.FieldType.NoCodeBillNoField, FieldTreeBuilder.FieldType.EntryField}).withCustomInfo(ctx -> this.customInfo(finalFormId, ctx.getField(), ctx.getFormMeta(), ctx.getInfo(), null, this.isFormula(sourceType)), false, null).withLevel(4).build();
                } else {
                    formId = this.getPageCache().get(ENTITY_ID);
                    FieldTreeBuilder fieldTreeBuilder = new FieldTreeBuilder(formId);
                    showColumns = fieldTreeBuilder.withFeature(new FieldTreeBuilder.Feature[]{FieldTreeBuilder.Feature.GroupContainer, FieldTreeBuilder.Feature.AttachmentDetail, FieldTreeBuilder.Feature.ExpMulRefBill, FieldTreeBuilder.Feature.UseRealType}).withoutFieldTypes(new FieldTreeBuilder.FieldType[]{FieldTreeBuilder.FieldType.NoCodeBillNoField, FieldTreeBuilder.FieldType.EntryField}).withCustomInfo(ctx -> this.customInfo(finalFormId, ctx.getField(), ctx.getFormMeta(), ctx.getInfo(), null, this.isFormula(sourceType)), false, null).withLevel(4).build();
                }
            }
            NoCodeFormDesignerPlugin.handleEncryptOrDesensitizeField(showColumns);
            if (showColumns != null && !showColumns.isEmpty()) {
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(ARGS, arg);
                result.put(DATA, showColumns);
                clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SETLISTTREECONFIG, new Object[]{result});
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            String msg = e.getMessage();
            if (StringUtils.isBlank((CharSequence)msg)) {
                msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            }
            NcErrorUtil.showErrorNotificationDuplicatePerTrace((IFormView)this.getView(), (String)msg);
        }
    }

    private boolean isFormula(String sourceType) {
        return "formula".equals(sourceType);
    }

    private static void handleEncryptOrDesensitizeField(List<ShowColumnInfo> showColumns) {
        showColumns.forEach(sc -> {
            if (sc.getOption().containsKey("isDesensitizeField")) {
                sc.getOption().put("compareTypes", new ArrayList(0));
            } else if (sc.getOption().containsKey("isEncryptField")) {
                sc.getOption().put("compareTypes", NoCodeFilterMetadata.get().getCompareTypes("13"));
            }
            List children = (List)sc.getOption().get("children");
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                NoCodeFormDesignerPlugin.handleEncryptOrDesensitizeField(children);
            }
        });
    }

    private List<ShowColumnInfo> getShowColumns(String formId, String parentKey, boolean isFormula, String rootFormId) {
        FieldTreeBuilder fieldTreeBuilder = new FieldTreeBuilder(formId);
        List showColumns = fieldTreeBuilder.withRootFormId(rootFormId).withFeature(new FieldTreeBuilder.Feature[]{FieldTreeBuilder.Feature.GroupContainer, FieldTreeBuilder.Feature.AttachmentDetail, FieldTreeBuilder.Feature.ExpMulRefBill, FieldTreeBuilder.Feature.UseRealType}).withoutFieldTypes(new FieldTreeBuilder.FieldType[]{FieldTreeBuilder.FieldType.NoCodeBillNoField, FieldTreeBuilder.FieldType.EntryField}).withCustomInfo(ctx -> this.customInfo(rootFormId, ctx.getField(), ctx.getFormMeta(), ctx.getInfo(), parentKey, isFormula), false, parentKey).withLevel(4).build();
        return showColumns;
    }

    private void customTableInfo2(String rootFormId, INoCodeRefBillField refBillField, FormMetadata formMeta, ShowColumnInfo info, String parentKey, boolean isFormula) {
        ArrayList<ShowColumnInfo> resColumns;
        List<ShowColumnInfo> refColumns;
        boolean isNeedExp;
        boolean bl = isNeedExp = parentKey == null || parentKey.split("\\.").length < 3;
        if (!isNeedExp) {
            return;
        }
        EntityMetadata entityMetadata = formMeta.getEntityMetadata();
        String tableId = null;
        String tableKey = refBillField.getRefTableKey();
        Optional<EntityItem> tableOpt = entityMetadata.getItems().stream().filter(i -> i.getKey().equals(tableKey)).findFirst();
        if (!tableOpt.isPresent()) {
            return;
        }
        NoCodeRefBillTable refBillTable = (NoCodeRefBillTable)tableOpt.get();
        tableId = refBillTable.getId();
        info.getOption().put("sourceForm", refBillTable.getSourceForm());
        ArrayList<EntityItem> tableItems = new ArrayList<EntityItem>(10);
        for (EntityItem item : entityMetadata.getItems()) {
            if (tableId == null || !tableId.equalsIgnoreCase(item.getParentId())) continue;
            tableItems.add(item);
        }
        if (tableItems.isEmpty()) {
            return;
        }
        if (info.getTypeCaption().indexOf("[]") != -1) {
            String typeCaption = info.getTypeCaption().replace("[]", "[" + refBillField.getName().toString() + "]");
            info.setTypeCaption(typeCaption);
        }
        if (isFormula) {
            info.setType("NoCodeRefBillTable");
            info.setId(tableKey);
            String string = parentKey = parentKey == null ? refBillTable.getKey() : parentKey + "." + refBillTable.getKey();
            if (parentKey.split("\\.").length >= 3) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)refBillField.getBillEntityId())) {
                refColumns = this.getShowColumns(refBillField.getBillEntityId(), parentKey, true, rootFormId);
                resColumns = new ArrayList();
                for (EntityItem item : tableItems) {
                    ShowColumnInfo refColumn3;
                    if (item instanceof NoCodeDateRangeField) {
                        NoCodeDateRangeField dateRangeField = (NoCodeDateRangeField)item;
                        Object startKey = dateRangeField.getStartDateFieldKey();
                        if (StringUtils.isNotBlank((CharSequence)item.getParentId())) {
                            startKey = ((String)startKey).replace("_" + item.getParentId().toLowerCase(), "");
                        }
                        String endKey = dateRangeField.getEndDateFieldKey();
                        if (StringUtils.isNotBlank((CharSequence)item.getParentId())) {
                            endKey = endKey.replace("_" + item.getParentId().toLowerCase(), "");
                        }
                        for (ShowColumnInfo refColumn2 : refColumns) {
                            if (refColumn2.getId().equalsIgnoreCase((String)startKey)) {
                                refColumn2.setId(dateRangeField.getStartDateFieldKey());
                                refColumn2.setCaption(item.getName() == null ? "" : item.getName().toString() + ResManager.loadKDString((String)".\u5f00\u59cb", (String)"NoCodeFormDesignerPlugin_13", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
                                resColumns.add(refColumn2);
                                NoCodeFormDesignerPlugin.setIdWithParentKey(refColumn2, parentKey, null);
                                continue;
                            }
                            if (!refColumn2.getId().equalsIgnoreCase(endKey)) continue;
                            refColumn2.setId(dateRangeField.getEndDateFieldKey());
                            refColumn2.setCaption(item.getName() == null ? "" : item.getName().toString() + "." + ResManager.loadKDString((String)"\u7ed3\u675f", (String)"NoCodeFormDesignerPlugin_14", (String)"BOS_NOCODE", (Object[])new Object[0]));
                            resColumns.add(refColumn2);
                            NoCodeFormDesignerPlugin.setIdWithParentKey(refColumn2, parentKey, null);
                        }
                        continue;
                    }
                    boolean isExists = false;
                    for (ShowColumnInfo refColumn3 : refColumns) {
                        if (!(refColumn3.getId() + "_" + tableId).equalsIgnoreCase(item.getKey())) continue;
                        refColumn3.setId(item.getKey());
                        refColumn3.setCaption(item.getName() == null ? "" : item.getName().toString());
                        resColumns.add(refColumn3);
                        NoCodeFormDesignerPlugin.setIdWithParentKey(refColumn3, parentKey, null);
                        NcEntityTypeUtil.addAttachmentSubProps(resColumns, (ShowColumnInfo)refColumn3);
                        isExists = true;
                        break;
                    }
                    if (isExists) continue;
                    Field<?> field = this.findField(entityMetadata, item.getKey());
                    refColumn3 = this.addCustomInfo(rootFormId, field, formMeta, parentKey, resColumns);
                    NcEntityTypeUtil.addAttachmentSubProps(resColumns, (ShowColumnInfo)refColumn3);
                }
                info.getOption().put("children", resColumns);
            } else {
                ArrayList<ShowColumnInfo> resColumns2 = new ArrayList<ShowColumnInfo>();
                for (EntityItem item : tableItems) {
                    if (item instanceof NoCodeDateRangeField) {
                        Field<?> startField = this.findField(entityMetadata, item.getKey() + "_startdate");
                        this.addCustomInfo(rootFormId, startField, formMeta, parentKey, resColumns2);
                        Field<?> endField = this.findField(entityMetadata, item.getKey() + "_enddate");
                        ShowColumnInfo refColumn = this.addCustomInfo(rootFormId, endField, formMeta, parentKey, resColumns2);
                        NcEntityTypeUtil.addAttachmentSubProps(resColumns2, (ShowColumnInfo)refColumn);
                        continue;
                    }
                    Field<?> field = this.findField(entityMetadata, item.getKey());
                    ShowColumnInfo refColumn = this.addCustomInfo(rootFormId, field, formMeta, parentKey, resColumns2);
                    NcEntityTypeUtil.addAttachmentSubProps(resColumns2, (ShowColumnInfo)refColumn);
                }
                info.getOption().put("children", resColumns2);
            }
        } else {
            String string = parentKey = parentKey == null ? refBillField.getKey() : parentKey + "." + refBillField.getKey();
            if (parentKey.split("\\.").length >= 3) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)refBillField.getBillEntityId()) || !NcEntityTypeUtil.isFormExist((String)refBillField.getBillEntityId())) {
                return;
            }
            refColumns = this.getShowColumns(refBillField.getBillEntityId(), parentKey, false, rootFormId);
            resColumns = new ArrayList<ShowColumnInfo>(refColumns.size());
            for (ShowColumnInfo refColumn : refColumns) {
                resColumns.add(refColumn);
                NoCodeFormDesignerPlugin.setIdWithParentKey(refColumn, parentKey, null);
                NcEntityTypeUtil.addAttachmentSubProps(resColumns, (ShowColumnInfo)refColumn);
            }
            info.getOption().put("children", resColumns);
        }
    }

    private Field<?> findField(EntityMetadata entityMetadata, String fieldKey) {
        Optional<EntityItem> first = entityMetadata.getItems().stream().filter(i -> i.getKey().equals(fieldKey)).findFirst();
        if (first.isPresent()) {
            return (Field)first.get();
        }
        return null;
    }

    private ShowColumnInfo addCustomInfo(String rootFormId, Field<?> field, FormMetadata formMeta, String parentKey, List<ShowColumnInfo> resColumns) {
        if (field == null) {
            log.debug("\u65e0\u6548\u7684\u5b57\u6bb5");
            return null;
        }
        String dataType = ExtEntityItemTypes.getFieldType(field);
        if (StringUtils.isBlank((CharSequence)dataType)) {
            dataType = NcEntityTypeUtil.getDataType(field);
        }
        String dataTypeCaption = NcEntityTypeUtil.getDataTypeCaption(field);
        ShowColumnInfo columnInfo = new ShowColumnInfo();
        columnInfo.setId(field.getKey());
        columnInfo.setCaption(field.getName() == null ? "" : field.getName().toString());
        columnInfo.setVisible(true);
        columnInfo.setType(dataType);
        columnInfo.setTypeCaption(dataTypeCaption);
        if (field instanceof INoCodeRefBillField) {
            INoCodeRefBillField refBillField = (INoCodeRefBillField)field;
            columnInfo.getOption().put("isMulti", refBillField.isMultiSelect());
            columnInfo.getOption().put("editorType", NOCODE_MUL_REF_BILL_FIELD);
            columnInfo.getOption().put("displayProp", refBillField.getPropsDisplay());
            columnInfo.getOption().put("billEntityId", refBillField.getBillEntityId());
            this.customInfo(rootFormId, field, formMeta, columnInfo, parentKey + "." + refBillField.getKey(), true);
        }
        resColumns.add(columnInfo);
        NoCodeFormDesignerPlugin.setIdWithParentKey(columnInfo, parentKey, null);
        return columnInfo;
    }

    private void customInfo(String rootFormId, Field<?> field, FormMetadata formMeta, ShowColumnInfo info, String parentKey, boolean isFormula) {
        if (field instanceof INoCodeRefBillField) {
            INoCodeRefBillField refBillField = (INoCodeRefBillField)field;
            String showType = refBillField.getShowType();
            if ("2".equals(showType)) {
                info.getOption().put("sourceForm", "2");
            }
            if (rootFormId.equalsIgnoreCase(refBillField.getBillEntityId())) {
                info.getOption().put("refSelf", true);
                return;
            }
            if ("2".equals(showType) && !StringUtils.isNotBlank((CharSequence)parentKey)) {
                this.customTableInfo2(rootFormId, refBillField, formMeta, info, parentKey, isFormula);
            }
        }
    }

    private void addAttachmentProp() {
    }

    private static void setIdWithParentKey(ShowColumnInfo column, String parentKey, String tableId) {
        List refColumns;
        Object optionChildren;
        if (column.getId().startsWith(parentKey) && !column.getId().equalsIgnoreCase(parentKey)) {
            return;
        }
        String id = parentKey + "." + column.getId();
        if (StringUtils.isNotEmpty((CharSequence)tableId)) {
            id = id + "_" + tableId;
        }
        column.setId(id);
        if ("group".equalsIgnoreCase(column.getType())) {
            id = parentKey;
        }
        if ((optionChildren = column.getOption().get("children")) instanceof List && (refColumns = (List)optionChildren) != null && !refColumns.isEmpty()) {
            for (ShowColumnInfo refColumn : refColumns) {
                NoCodeFormDesignerPlugin.setIdWithParentKey(refColumn, id, tableId);
            }
        }
    }

    private static boolean propertyPredicate(IDataEntityProperty property) {
        return !(property instanceof BillNoField) && !(property.getParent() instanceof EntryType);
    }

    public void query(WfDesignerCommonEvent arg) {
        try {
            Map result = (Map)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)"nocode_sys", (String)RestApiWrap.class.getSimpleName(), (String)"query", (Object[])new Object[]{arg.getRealFormId(), arg.getParam()});
            result.put(ARGS, arg);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SETQUERY, new Object[]{result});
        }
        catch (Exception ex) {
            if (StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                NcErrorUtil.showErrorNotificationDuplicatePerTrace((IFormView)this.getView(), (String)ex.getMessage());
            }
            log.warn((Throwable)ex);
        }
    }

    public void getSvgLine() {
        try {
            Map result = (Map)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)"nocode_sys", (String)RestApiWrap.class.getSimpleName(), (String)"getSvgLine", (Object[])new Object[0]);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), "getSvgLine", new Object[]{result});
        }
        catch (Exception ex) {
            if (StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                NcErrorUtil.showErrorNotificationDuplicatePerTrace((IFormView)this.getView(), (String)ex.getMessage());
            }
            log.warn((Throwable)ex);
        }
    }

    private static boolean isNoCodeForm(String formId) {
        return kd.bos.util.StringUtils.isNumeric((String)formId);
    }

    public void getBizRule(Map<String, Object> data) {
        String billEntityId = (String)data.get("formId");
        billEntityId = NcEntityTypeUtil.getRealBillEntityId((String)billEntityId);
        String fieldKey = (String)data.get("fieldKey");
        QFilter[] qFilters = new QFilter[]{new QFilter("formid", "=", (Object)billEntityId), new QFilter(AFFECT_FLD_KEYS, "=", (Object)fieldKey), new QFilter("ruletype", "=", (Object)"1"), new QFilter("valuetype", "=", (Object)"1")};
        Map<String, Object> map = this.getDependencyRules(qFilters, fieldKey);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getDesignerKey(), "setDefValueForFormula", new Object[]{map});
    }

    private Map<String, Object> getDependencyRules(QFilter[] filters, String fieldKey) {
        String selectFields = "id,expression,affectfldkeys";
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_nocode_rule", (String)selectFields, (QFilter[])filters);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (DynamicObject obj : collection) {
            map.put("bizRule", obj.getString(EXPRESSION));
            map.put("bizRuleId", obj.getPkValue());
            map.put("fieldKey", fieldKey);
            map.put(AFFECT_FLD_KEYS, obj.getString(AFFECT_FLD_KEYS));
        }
        return map;
    }

    private List<Map<String, Object>> getRules(String billEntityId, QFilter[] filters, String fieldKey, int type) {
        Object sortedFldKeys;
        String selectFields = "id,name,expression,depfldkeys,trueaction,affectfldkeys";
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_nocode_rule", (String)selectFields, (QFilter[])filters);
        if (StringUtils.isNotBlank((CharSequence)fieldKey)) {
            sortedFldKeys = new ArrayList();
            ArrayList<DynamicObject> depFldKeys = new ArrayList<DynamicObject>(collection.size());
            ArrayList<DynamicObject> affectFldKeys = new ArrayList<DynamicObject>(collection.size());
            ArrayList<DynamicObject> otherFldKeys = new ArrayList<DynamicObject>(collection.size());
            for (DynamicObject obj : collection) {
                if (obj.getString(DEP_FLD_KEYS) != null && obj.getString(DEP_FLD_KEYS).contains(fieldKey)) {
                    depFldKeys.add(obj);
                    continue;
                }
                if (obj.getString(AFFECT_FLD_KEYS) != null && obj.getString(AFFECT_FLD_KEYS).contains(fieldKey)) {
                    affectFldKeys.add(obj);
                    continue;
                }
                otherFldKeys.add(obj);
            }
            sortedFldKeys.addAll(depFldKeys);
            sortedFldKeys.addAll(affectFldKeys);
            sortedFldKeys.addAll(otherFldKeys);
        } else {
            sortedFldKeys = collection;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(sortedFldKeys.size());
        Iterator iterator = sortedFldKeys.iterator();
        while (iterator.hasNext()) {
            DynamicObject obj = (DynamicObject)iterator.next();
            HashMap<String, Object> map = new HashMap<String, Object>();
            Object pkId = obj.get("id");
            map.put("ruleId", pkId.toString());
            map.put("ruleName", obj.getString("name"));
            map.put(AFFECT_FLD_KEYS, obj.getString(AFFECT_FLD_KEYS));
            String expression = obj.getString(EXPRESSION);
            if (StringUtils.isNotBlank((CharSequence)expression) && type == 2) {
                map.put(EXPRESSION, SerializationUtils.fromJsonString((String)expression, List.class));
            } else {
                map.put("ruleInfo", expression);
            }
            String realDepKeys = obj.getString(DEP_FLD_KEYS);
            if (type == 1) {
                realDepKeys = this.setRefPropField(billEntityId, expression, realDepKeys);
            }
            map.put(DEP_FLD_KEYS, realDepKeys);
            String trueAction = obj.getString("trueaction");
            if (StringUtils.isNotBlank((CharSequence)trueAction)) {
                map.put("trueaction", SerializationUtils.fromJsonString((String)trueAction, List.class));
            }
            list.add(map);
        }
        return list;
    }

    public void getBizRules(Map<String, Object> data) {
        String billEntityId = (String)data.get("formId");
        QFilter[] qFilters = new QFilter[]{new QFilter("formid", "=", (Object)billEntityId), new QFilter("ruletype", "=", (Object)"1"), new QFilter("valuetype", "=", (Object)"0")};
        String fieldKey = data.get("fieldKey") == null ? null : (String)data.get("fieldKey");
        List<Map<String, Object>> list = this.getRules(billEntityId, qFilters, fieldKey, 1);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getDesignerKey(), "setBizRules", new Object[]{list});
    }

    public void getFormRules(Map<String, Object> data) {
        String billEntityId = (String)data.get("formId");
        billEntityId = NcEntityTypeUtil.getRealBillEntityId((String)billEntityId);
        QFilter[] qFilters = new QFilter[]{new QFilter("formid", "=", (Object)billEntityId), new QFilter("ruletype", "=", (Object)"0")};
        String fieldKey = data.get("fieldKey") == null ? null : (String)data.get("fieldKey");
        List<Map<String, Object>> list = this.getRules(billEntityId, qFilters, fieldKey, 2);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getDesignerKey(), "setFormRules", new Object[]{list});
    }

    public void saveBizRule(Map<String, Object> data) {
        block5: {
            try {
                this.saveRule(data, 1);
            }
            catch (KDBizException e) {
                if ("relationFormId is null".equals(e.getMessage())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u67e5\u627e\u7684\u8868\u5355", (String)"NoCodeFormDesignerPlugin_15", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
                }
                if ("filterInfos is null".equals(e.getMessage())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7b5b\u9009\u6761\u4ef6", (String)"NoCodeFormDesignerPlugin_16", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
                }
                if ("result is null".equals(e.getMessage())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u8d4b\u503c\u5b57\u6bb5", (String)"NoCodeFormDesignerPlugin_17", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
                }
                if (!e.getErrorCode().getCode().equalsIgnoreCase("5001")) break block5;
                this.getView().showErrorNotification(e.getErrorCode().getMessage());
            }
        }
    }

    private String setRefPropField(String formId, String ruleInfo, String targetKey) {
        String[] array;
        Map valMap;
        try {
            valMap = (Map)SerializationUtils.fromJsonString((String)ruleInfo, Map.class);
        }
        catch (Exception e) {
            return targetKey;
        }
        if (!valMap.containsKey("valueType")) {
            return targetKey;
        }
        int valueType = (Integer)valMap.get("valueType");
        if (valueType != 2) {
            return targetKey;
        }
        Map configs = (Map)valMap.get("value");
        String relateFormId = (String)configs.get("relationFormId");
        if (!formId.equals(relateFormId)) {
            return targetKey;
        }
        NoCodeFormDesigner designer = (NoCodeFormDesigner)this.getView().getControl(NO_CODE_FORM_DESIGNER);
        Map content = designer.getContent();
        if (content == null) {
            return targetKey;
        }
        NoCodeDesignerData designerData = new NoCodeDesignerData();
        this.fixupContent(content);
        FormMetadata formMeta = (FormMetadata)designerData.convertTo(content, "NoCodeModel");
        MainEntityType entityType = formMeta.getEntityMetadata().getRootEntity().buildDataEntityType();
        ArrayList<String> keys = new ArrayList<String>(10);
        for (String s : array = targetKey.split(",")) {
            if (s.indexOf(".") == -1) {
                keys.add(s);
                continue;
            }
            String[] sp = s.split("\\.");
            if ("2".equals(entityType.getProperty(sp[0]).getCustomProperty("showType"))) {
                INoCodeRefBillProp refProp = (INoCodeRefBillProp)entityType.getProperty(sp[0]);
                NoCodeRefBillTableProp tableProp = (NoCodeRefBillTableProp)entityType.getProperty(refProp.getRefTableKey());
                keys.add(tableProp.getName() + "." + sp[1] + "_" + tableProp.getId().toLowerCase());
                continue;
            }
            keys.add(s);
        }
        return keys.stream().collect(Collectors.joining(","));
    }

    private void saveRule(Map<String, Object> data, int type) {
        NoCodeRuleService ruleService = (NoCodeRuleService)kd.bos.nocode.servicehelper.ServiceFactory.getService((String)"NoCodeRuleService");
        DynamicObject obj = ruleService.genRule(data, type);
        if (obj == null) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String ruleInfo = (String)data.get("ruleInfo");
        String realDepKeys = obj.getString(DEP_FLD_KEYS);
        if (type == 1) {
            String formId = (String)data.get("formId");
            realDepKeys = this.setRefPropField(formId, ruleInfo, realDepKeys);
        }
        map.put(DEP_FLD_KEYS, realDepKeys);
        map.put(AFFECT_FLD_KEYS, obj.getString(AFFECT_FLD_KEYS));
        Object[] objects = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        Object pk = "";
        for (Object o : objects) {
            if (!(o instanceof DynamicObject)) continue;
            pk = ((DynamicObject)o).get("id");
        }
        map.put("ruleId", pk.toString());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"NoCodeFormDesignerPlugin_6", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getDesignerKey(), "setRuleInfo", new Object[]{map});
    }

    public void saveFormRule(Map<String, Object> data) {
        block4: {
            try {
                this.saveRule(data, 2);
            }
            catch (KDBizException e) {
                if ("name is null".equals(e.getMessage())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u89c4\u5219\u540d\u79f0", (String)"NoCodeFormDesignerPlugin_18", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
                }
                if ("name is too long".equals(e.getMessage())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0\u6700\u957f\u652f\u630150\u4e2a\u5b57\u7b26", (String)"NoCodeFormDesignerPlugin_19", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
                }
                if (!e.getErrorCode().getCode().equalsIgnoreCase("5001")) break block4;
                this.getView().showErrorNotification(e.getErrorCode().getMessage());
            }
        }
    }

    public void deleteFormRule(Long ruleId) {
        DeleteServiceHelper.delete((String)"bos_nocode_rule", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ruleId)});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"NoCodeFormDesignerPlugin_20", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getDesignerKey(), "deleteFormRule", new Object[]{ruleId.toString()});
    }

    private String getAppId() {
        return this.getPageCache().get(BIZ_APPID);
    }

    private String getEntityId() {
        return this.getPageCache().get(ENTITY_ID);
    }

    public void deleteBizRule(Map<String, Object> data) {
        Object ruleId = data.get("ruleId");
        if (StringUtils.isBlank((Object)ruleId)) {
            String formId = (String)data.get("formId");
            String fieldKey = (String)data.get("fieldKey");
            QFilter[] qFilters = new QFilter[]{new QFilter("formid", "=", (Object)formId), QFilter.like((String)AFFECT_FLD_KEYS, (String)fieldKey), new QFilter("ruletype", "=", (Object)"1"), new QFilter("valuetype", "=", (Object)"1")};
            DeleteServiceHelper.delete((String)"bos_nocode_rule", (QFilter[])qFilters);
        } else {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bos_nocode_rule");
            DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])new Object[]{ruleId});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"NoCodeFormDesignerPlugin_20", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), "deleteBizRule", new Object[]{ruleId.toString()});
        }
    }

    public void getAvailableAssociationFields(String sourceFormId, String sourceFieldKey, String targetFormId) {
        try {
            ArrayList<ShowColumnInfo> list = new ArrayList<ShowColumnInfo>();
            Map boundfieldKeys = AssociationServiceHelper.getAssociatedFields((String)targetFormId);
            FieldTreeBuilder fieldTreeBuilder = new FieldTreeBuilder(targetFormId);
            List columnInfos = fieldTreeBuilder.withFeature(new FieldTreeBuilder.Feature[]{FieldTreeBuilder.Feature.AttachmentDetail, FieldTreeBuilder.Feature.UseRealType}).build();
            for (ShowColumnInfo columnInfo : columnInfos) {
                if (!NcEntityTypeUtil.isRefBill((String)columnInfo.getType()) || !sourceFormId.equals(columnInfo.getOption().get("billEntityId")) || sourceFieldKey.equals(columnInfo.getId())) continue;
                if (!boundfieldKeys.containsKey(columnInfo.getId())) {
                    Tuple tuple = AssociationServiceHelper.existAssociation((String)targetFormId, (String)columnInfo.getId());
                    if (((Boolean)tuple.item1).booleanValue()) continue;
                    list.add(columnInfo);
                    continue;
                }
                if (!sourceFieldKey.equals(boundfieldKeys.get(columnInfo.getId()))) continue;
                list.add(columnInfo);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            Tuple tuple = AssociationServiceHelper.existAssociation((String)sourceFormId, (String)sourceFieldKey);
            if (((Boolean)tuple.item1).booleanValue()) {
                result.put("selected", tuple.item2);
            }
            result.put(DATA, list);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), "setAvailableAssociationFields", new Object[]{result});
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            String msg = e.getMessage();
            if (StringUtils.isBlank((CharSequence)msg)) {
                msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            }
            NcErrorUtil.showErrorNotificationDuplicatePerTrace((IFormView)this.getView(), (String)msg);
        }
    }

    public void updateAssociation(String sourceFormId, String sourceFieldKey, String targetFormId, String targetFieldKey) {
        block4: {
            try {
                if (StringUtils.isBlank((CharSequence)targetFormId) || StringUtils.isBlank((CharSequence)targetFieldKey)) {
                    AssociationServiceHelper.deleteAssociation((String)sourceFormId, (String)sourceFieldKey);
                } else {
                    AssociationServiceHelper.updateAssociation((String)sourceFormId, (String)sourceFieldKey, (String)targetFormId, (String)targetFieldKey);
                }
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("state", KEY_SUCCESS);
                clientViewProxy.invokeControlMethod(this.getDesignerKey(), "updateAssociation", new Object[]{result});
            }
            catch (Exception e) {
                if (!"targetFieldKey has data".equals(e.getMessage())) break block4;
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("state", "failure");
                result.put(MESSAGE, ResManager.loadKDString((String)"\u8868\u5355\u5185\u5bb9\u5df2\u5b58\u5728\u6570\u636e\uff0c\u65e0\u6cd5\u5173\u8054", (String)"NoCodeFormDesignerPlugin_21", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
                clientViewProxy.invokeControlMethod(this.getDesignerKey(), "updateAssociation", new Object[]{result});
            }
        }
    }

    public void getDesignerMetadata(String formId) {
        if (NcEntityTypeUtil.isFormExist((String)formId)) {
            Map formData = FormMetadataUtils.getMetadataById((String)formId);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), "loadDesignerMetadata", new Object[]{formData});
        }
    }
}

