/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.CommonConstants;
import kd.bos.nocode.constant.MessageType;
import kd.bos.nocode.ext.util.WfProcessUtils;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.wf.wrap.NoCodeWorkflowServiceHelperWrapper;
import kd.bos.nocode.ws.WebSocketConstants;
import kd.bos.nocode.ws.WsMessageSender;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.workflow.api.model.ProcessDefinitionInfo;
import kd.bos.workflow.engine.task.TaskInfo;

public class CreateTaskNoticePlugin
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(CreateTaskNoticePlugin.class);
    private static final String USER_IDS = "userIds";
    private static final String TASK_ID = "taskId";
    private final NoCodeWorkflowServiceHelperWrapper noCodeWorkflowServiceHelperWrapper;

    public CreateTaskNoticePlugin() {
        this(NoCodeWorkflowServiceHelperWrapper.create());
    }

    public CreateTaskNoticePlugin(NoCodeWorkflowServiceHelperWrapper noCodeWorkflowServiceHelperWrapper) {
        this.noCodeWorkflowServiceHelperWrapper = noCodeWorkflowServiceHelperWrapper;
    }

    private String getMsgFmtWithSubject() {
        return "\u5f85\u529e\u4efb\u52a1\uff1a\u60a8\u6709\u4e00\u6761\u3010%s\u3011\u7684%s\u5f85\u5904\u7406\uff0c\u4efb\u52a1\u4e3b\u9898\uff1a\u3010%s\u3011";
    }

    private String getMsgFmtWithOutSubject() {
        return "\u5f85\u529e\u4efb\u52a1\uff1a\u60a8\u6709\u4e00\u6761\u3010%s\u3011\u7684%s\u5f85\u5904\u7406";
    }

    public Object handleEvent(KDBizEvent evt) {
        long currUserId = RequestContext.get().getCurrUserId();
        LicenseCheckResult licenseCheckResult = LicenseServiceHelper.checkUserInGroup((Long)currUserId, (Long)CommonConstants.LICENSE_NOCODE_GROUP_ID);
        if (!licenseCheckResult.getHasLicense().booleanValue()) {
            logger.info("There is no NoCode License Group, userId = {}.", (Object)currUserId);
            return null;
        }
        logger.info("lang={}", (Object)RequestContext.get().getLang());
        String LISTEN_TASK_CREATED_EVENT = ResManager.loadKDString((String)"\u5f85\u529e\u4efb\u52a1\u521b\u5efa\u901a\u77e5\u4e8b\u4ef6\uff1asource=%s\uff0cid=%s", (String)"CreateTaskNoticePlugin_2", (String)"BOS_NOCODE", (Object[])new Object[]{evt.getSource(), evt.getEventId()});
        logger.debug(LISTEN_TASK_CREATED_EVENT);
        String source = evt.getSource();
        JSONArray jsons = JSON.parseArray((String)source);
        Map map = (Map)JSON.parse((String)jsons.getString(0));
        List userIds = (List)map.getOrDefault(USER_IDS, new JSONArray());
        Set<Long> longUserIds = userIds.stream().map(e -> Long.parseLong(String.valueOf(e))).collect(Collectors.toSet());
        TaskInfo taskInfo = this.noCodeWorkflowServiceHelperWrapper.findTaskById(Long.parseLong(String.valueOf(map.get(TASK_ID))));
        if (Objects.isNull(taskInfo) || !Objects.equals(taskInfo.getProcessType(), "NoCodeFlow")) {
            return null;
        }
        Long processDefinitionId = taskInfo.getProcessDefinitionId();
        ProcessDefinitionInfo processDefinitionInfo = this.noCodeWorkflowServiceHelperWrapper.getProcessDefinitionInfoById(processDefinitionId);
        if (Objects.isNull(processDefinitionInfo)) {
            String PROCESS_DEFINITION_INFO_NOT_EXIST = ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9a\u4e49\u4fe1\u606f\u4e3a\u7a7a\uff0cprocessDefinitionId=%s", (String)"CreateTaskNoticePlugin_3", (String)"BOS_NOCODE", (Object[])new Object[]{processDefinitionId});
            logger.debug(PROCESS_DEFINITION_INFO_NOT_EXIST);
            return null;
        }
        String processName = processDefinitionInfo.getName().toString();
        String taskTypeDesc = WfProcessUtils.getToHandleTaskTypeDesc((String)taskInfo.getCategory());
        String taskSubject = taskInfo.getSubject().toString();
        String messageContent = StringUtils.isNotBlank((Object)taskInfo.getSubject()) && StringUtils.isNotBlank((CharSequence)taskSubject) ? String.format(this.getMsgFmtWithSubject(), processName, taskTypeDesc, taskSubject) : String.format(this.getMsgFmtWithOutSubject(), processName, taskTypeDesc);
        HashMap<String, String> showParams = new HashMap<String, String>(8);
        showParams.put("targetFormId", processDefinitionInfo.getEntityNumber());
        showParams.put("appId", FormMetaUtil.getAppIdByFormNumber((String)taskInfo.getEntityNumber()));
        showParams.put("pkId", this.noCodeWorkflowServiceHelperWrapper.getBusinessKeyByProcessInstanceId(taskInfo.getProcessInstanceId()));
        showParams.put("procInstId", String.valueOf(taskInfo.getProcessInstanceId()));
        if ("UserTask".equalsIgnoreCase(taskInfo.getCategory())) {
            showParams.put("activityId", taskInfo.getTaskDefinitionKey());
            showParams.put("nodeBusinessKey", taskInfo.getBusinessKey());
            showParams.put("userTaskCurrentUserId", longUserIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        longUserIds.forEach(userId -> WsMessageSender.sendMessageNotice((long)userId, (long)taskInfo.getId(), (String)WebSocketConstants.getMessageCenterDesc(), (String)messageContent, (MessageType)MessageType.WF_TO_HANDLED_TASK, (Map)showParams));
        return null;
    }
}

