/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NcErrorUtil;

public class NoCodeApprovalPlugin
extends AbstractFormPlugin {
    private static final String IFRAMEAP = "iframeap";
    private static final String CLOSEWINDOW = "CloseWindow";
    private static final String CONTENT = "content";
    private Log logger = LogFactory.getLog(NoCodeApprovalPlugin.class);

    public void afterCreateNewData(EventObject e) {
        IFrame iframe = (IFrame)this.getView().getControl(IFRAMEAP);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entityNumber = (String)parameter.getCustomParam("entityNumber");
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11\u53c2\u6570:entityNumber", (String)"NoCodeApprovalPlugin_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
        }
        String formId = NcEntityTypeUtil.getRealBillEntityIdByNumber((String)entityNumber);
        Object businessKey = parameter.getCustomParam("businessKey");
        if (businessKey == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11\u53c2\u6570:businessKey", (String)"NoCodeApprovalPlugin_1", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
        }
        Object procInstId = parameter.getCustomParam("procInstId");
        if (procInstId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11\u53c2\u6570:procInstId", (String)"NoCodeApprovalPlugin_2", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
        }
        Object taskId = parameter.getCustomParam("taskId");
        String formAppId = FormMetaUtil.getAppIdByFormId((String)formId);
        String pageId = this.getView().getPageId();
        Object userTaskActivityId = parameter.getCustomParam("userTaskActivityId");
        Object userTaskBusinessKey = parameter.getCustomParam("userTaskBusinessKey");
        Object userTaskCurrentUserId = parameter.getCustomParam("userTaskCurrentUserId");
        String userTaskUrl = "";
        boolean isHandled = false;
        if (userTaskActivityId != null) {
            userTaskUrl = "/" + userTaskActivityId.toString();
            if (userTaskBusinessKey != null) {
                userTaskUrl = userTaskUrl + "/" + userTaskBusinessKey.toString();
            }
            userTaskUrl = StringUtils.isNotBlank((Object)userTaskCurrentUserId) ? userTaskUrl + "/" + userTaskCurrentUserId.toString() : userTaskUrl + "/" + String.valueOf(RequestContext.get().getCurrUserId());
            String handleState = (String)parameter.getCustomParam("handleState");
            isHandled = "handled".equalsIgnoreCase(handleState);
        }
        String url = StringUtils.isBlank((CharSequence)userTaskUrl) ? String.format("nocode/%s/detail/%s/%s/view/flow/%s/task/%s/cosmic?pageId=%s", formAppId, formId, businessKey.toString(), procInstId.toString(), taskId == null ? "" : taskId.toString(), pageId) : String.format("nocode/%s/detail/%s/%s/%s/flow/%s/cosmic%s?pageId=%s", formAppId, formId, businessKey.toString(), isHandled ? "view" : "edit", procInstId.toString(), userTaskUrl, pageId);
        iframe.setSrc(url);
    }

    public void customEvent(CustomEventArgs args) {
        super.customEvent(args);
        try {
            JSONObject obj = JSONObject.parseObject((String)args.getEventArgs());
            this.logger.debug("NoCodeFlowApprovalPlugin obj:" + obj);
            if (obj == null || obj.isEmpty()) {
                this.logger.debug("NoCodeFlowApprovalPlugin obj is null");
                return;
            }
            JSONObject contentObj = obj.getJSONObject(CONTENT);
            if (contentObj == null || contentObj.isEmpty()) {
                return;
            }
            Object closeWindow = contentObj.get((Object)CLOSEWINDOW);
            if (StringUtils.isBlank((Object)closeWindow)) {
                return;
            }
            if (Boolean.parseBoolean((String)closeWindow)) {
                this.getView().close();
            }
        }
        catch (Exception e) {
            this.logger.debug("NoCodeFlowApprovalPlugin is error: " + NcErrorUtil.getStackTrace((Exception)e));
        }
    }
}

