/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.IMsgEventListener;
import kd.bos.nocode.constant.CommonConstants;
import kd.bos.nocode.constant.MessageType;
import kd.bos.nocode.wf.wrap.WfMessageServiceWrapper;
import kd.bos.nocode.ws.WebSocketConstants;
import kd.bos.nocode.ws.WsMessageSender;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import org.apache.commons.collections4.CollectionUtils;

public class NoCodeFlowMsgEventListener
implements IMsgEventListener {
    private static final Log logger = LogFactory.getLog(NoCodeFlowMsgEventListener.class);
    public final WfMessageServiceWrapper wfMessageServiceWrapper;
    public static final String USER_IDS = "userIds";

    public NoCodeFlowMsgEventListener() {
        this(WfMessageServiceWrapper.create());
    }

    public NoCodeFlowMsgEventListener(WfMessageServiceWrapper wfMessageServiceWrapper) {
        this.wfMessageServiceWrapper = wfMessageServiceWrapper;
    }

    public void subFailMsgInfo(Long msgId, Map<String, Object> data) {
        try {
            if (!CommonConstants.getBosNocodeDesc().equalsIgnoreCase((String)data.get("tag"))) {
                return;
            }
            List userIds = (List)data.getOrDefault(USER_IDS, new JSONArray());
            Set<Long> longUserIds = userIds.stream().map(e -> Long.parseLong(String.valueOf(e))).collect(Collectors.toSet());
            String MESSAGE_RECEIVER = ResManager.loadKDString((String)"\u6d88\u606f\u63a5\u53d7\u4eba\uff1a%s", (String)"NoCodeFlowMsgEventListener_0", (String)"BOS_NOCODE", (Object[])new Object[]{longUserIds});
            logger.debug(MESSAGE_RECEIVER);
            Map<String, Object> messageMap = this.wfMessageServiceWrapper.getMessageById(Lists.newArrayList((Object[])new Long[]{msgId}));
            List messageInfos = (List)messageMap.get("messageInfos");
            if (CollectionUtils.isNotEmpty((Collection)messageInfos)) {
                MessageInfo messageInfo = (MessageInfo)messageInfos.get(0);
                logger.debug("messageInfo: {}", (Object)messageInfo);
                longUserIds.forEach(userId -> WsMessageSender.sendMessageNotice((long)userId, (long)messageInfo.getId(), (String)WebSocketConstants.getMessageCenterDesc(), (String)messageInfo.getContent(), (MessageType)MessageType.WF_MESSAGE_NODE, new HashMap(0)));
            }
        }
        catch (Exception e2) {
            logger.debug("handle message event exception: {}", (Object)e2.getMessage(), (Object)e2);
        }
    }
}

