/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import de.odysseus.nocode.ExpressionFactoryImpl;
import de.odysseus.nocode.util.SimpleContext;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.el.ELContext;
import javax.el.ValueExpression;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.datatype.StringType;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.form.control.events.PropertyListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.CommonConstants;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.entity.WorkflowHttpResponse;
import kd.bos.nocode.entity.WorkflowTestApiRequestInfo;
import kd.bos.nocode.entity.WorkflowTestApiResponse;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfGraphCell;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaHelper;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.info.ParameterSetting;
import kd.bos.nocode.ext.metadata.wf.info.RequestBody;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeApiInvoke;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeStart;
import kd.bos.nocode.ext.util.WfProcessUtils;
import kd.bos.nocode.ext.wf.control.NoCodeWfDesigner;
import kd.bos.nocode.ext.wf.control.NoCodeWfDesignerListener;
import kd.bos.nocode.ext.wf.control.WfDesignerSyncListener;
import kd.bos.nocode.ext.wf.control.events.WfDesignerApproverEvent;
import kd.bos.nocode.ext.wf.control.events.WfDesignerBarEvent;
import kd.bos.nocode.ext.wf.control.events.WfDesignerCommonEvent;
import kd.bos.nocode.ext.wf.control.events.WfDesignerMetaSyncEvent;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.RestApiWrap;
import kd.bos.nocode.restapi.api.model.ApprovalRecord;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.common.constant.HttpMethodEnum;
import kd.bos.nocode.restapi.common.constant.RequestBodyTypeEnum;
import kd.bos.nocode.restapi.common.util.NameValueTypePair;
import kd.bos.nocode.servicehelper.DispatchApiServiceHelper;
import kd.bos.nocode.servicehelper.ServiceFactory;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.utils.FieldTreeBuilder;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NcErrorUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.nocode.utils.NoCodeTreeNode;
import kd.bos.nocode.utils.NoCodeWorkflowServiceUtil;
import kd.bos.nocode.utils.OpenApiUtil;
import kd.bos.nocode.utils.ShowColumnInfo;
import kd.bos.nocode.utils.WorkflowHttpClientUtils;
import kd.bos.nocode.wf.NoCodeWfRecordApiService;
import kd.bos.nocode.wf.designer.convert.WfModelConvert;
import kd.bos.nocode.wf.designer.helper.ExpressDesignMetaHelper;
import kd.bos.nocode.wf.designer.helper.ParticipantHelper;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtxManager;
import kd.bos.nocode.wf.designer.pojo.HandlerFieldSuffixEnum;
import kd.bos.nocode.wf.designer.pojo.UserOrOrgFieldInfo;
import kd.bos.nocode.wf.designer.sync.WfModelSync;
import kd.bos.nocode.wf.designer.sync.node.NoCodeWfNodeApiInvokeSync;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.workflow.api.model.ProcPublishResult;
import kd.bos.workflow.api.model.ProcessDefinitionInfo;
import kd.bos.workflow.api.model.ProcessModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.NotImplementedException;
import org.jetbrains.annotations.NotNull;

public class NoCodeWfDesignerPlugin
extends AbstractFormPlugin
implements NoCodeWfDesignerListener,
WfDesignerSyncListener,
PropertyListener {
    private static final Log log = LogFactory.getLog(NoCodeWfDesignerPlugin.class);
    private static final String ID = "id";
    private static final String WF_MODEL_ID = "wfmodelId";
    private static final String WF_PROC_INST_ID = "wfProcInstId";
    private static final String WF_PROC_PK_ID = "wfProcPkId";
    private static final String INIT_ERROR = "initError";
    private static final String WF_PROC_DEFINE_ID = "wfProcDefineId";
    private static final String TARGET_FORM_ID = "targetFormId";
    private static final String NO_CODE_WF_DESIGNER = "nocodewfdesigner";
    private static final String SAVE = "save";
    private static final String BOS_NOCODE_FORMPLUGIN = "bos-nocode-formplugin";
    private static final String CALL_ACTION_SET_REF_BILL_DATA = "setRefBillData";
    private static final String CALL_ACTION_GET_REF_BILL_PROPS = "refbillProps";
    private static final String CALL_ACTION_SET_REF_BILL_PROPS = "setRefbillProps";
    private static final String CALL_ACTION_SETSYNCDATA = "setSyncData";
    private static final String CALL_ACTION_CLOSEWFSAVELOADING = "closeWfSaveLoading";
    private static final String CALL_ACTION_SETQUERY = "setQuery";
    private static final String CALL_ACTION_SETLISTCONFIG = "setListConfig";
    private static final String CALL_ACTION_FILTERITEMLOOK = "filterItemLook";
    private static final String CALL_ACTION_APPROVER_MENU = "approverMenu";
    private static final String WF_MODEL_OLD_DATA = "wf_model_old_data";
    private static final String BIZ_APPID = "bizappid";
    public static final int NUMBER_OF_MAP = 10;
    public static final int MAX_FORM_NUMBER_LENGTH = 25;
    private static final String META_TYPE_ENTITY_META = "entitymeta";
    private static final String ARGS = "args";
    private static final String DATA = "data";
    private static final String SEPARATOR = "-";
    private static final String PKID = "pkid";
    private static final String CALL_ACTION_SET_TRIGGER_PROCESS = "setTriggerProcess";
    private static final String CALL_ACTION_SET_TEST_API = "setTestApi";
    private static final String CALL_ACTION_SET_NOCODE_IP_LIST = "setNoCodeIpList";
    private static final String CALL_ACTION_SETLISTTREECONFIG = "setListTreeConfig";

    protected String getDesignerKey() {
        return NO_CODE_WF_DESIGNER;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        NoCodeWfDesigner designer = this.getDesigner();
        designer.addWfDesignerListeners((NoCodeWfDesignerListener)this);
        designer.addPropertyButtonClickListener((PropertyListener)this);
        designer.addSyncListener((WfDesignerSyncListener)this);
    }

    public void initialize() {
        super.initialize();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String wfModelId = (String)showParameter.getCustomParam(WF_MODEL_ID);
        if (StringUtils.isBlank((CharSequence)wfModelId)) {
            wfModelId = (String)showParameter.getCustomParam(ID);
        }
        if (StringUtils.isBlank((CharSequence)wfModelId)) {
            wfModelId = (String)showParameter.getCustomParam(TARGET_FORM_ID);
        }
        String wfProcDefineId = null;
        String wfProcInstId = null;
        String wfProcPkId = null;
        if (wfModelId != null) {
            if (wfModelId.indexOf(SEPARATOR) > -1) {
                String[] split = wfModelId.split(SEPARATOR);
                wfProcInstId = split[0];
                wfProcPkId = split[1];
                try {
                    ProcessDefinitionInfo processInfo = NoCodeWorkflowServiceHelper.getProcessDefinitionInfoByProcInstId((Long)Long.parseLong(wfProcInstId));
                    if (processInfo == null) {
                        this.getPageCache().put(INIT_ERROR, ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728", (String)"NoCodeWfDesignerPlugin_0", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
                    } else {
                        wfProcDefineId = String.valueOf(processInfo.getId());
                        wfModelId = String.valueOf(processInfo.getModelId());
                    }
                }
                catch (Exception ex) {
                    log.error((Throwable)ex);
                    this.getPageCache().put(INIT_ERROR, ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728", (String)"NoCodeWfDesignerPlugin_0", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
                }
            }
            this.getPageCache().put(WF_MODEL_ID, wfModelId);
            this.getPageCache().put(WF_PROC_DEFINE_ID, wfProcDefineId);
            this.getPageCache().put(WF_PROC_INST_ID, wfProcInstId);
            this.getPageCache().put(WF_PROC_PK_ID, wfProcPkId);
        }
    }

    public void afterBindData(EventObject e) {
        ProcessModel procModel;
        long startTime = System.currentTimeMillis();
        super.afterBindData(e);
        long modelId = this.getModelId();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        try {
            String sInitError = this.getPageCache().get(INIT_ERROR);
            if (StringUtils.isNotBlank((CharSequence)sInitError)) {
                this.getView().showErrorNotification(sInitError);
                return;
            }
            String wfProcDefineId = this.getPageCache().get(WF_PROC_DEFINE_ID);
            if (StringUtils.isNotBlank((CharSequence)wfProcDefineId)) {
                long lWfProcDefineId = Long.parseLong(wfProcDefineId);
                procModel = new ProcessModel();
                ProcessDefinitionInfo procDefInfo = NoCodeWorkflowServiceHelper.getProcessDefinitionInfoById((Long)lWfProcDefineId);
                String entityId = procDefInfo.getEntityId();
                procModel.setEntityId(entityId);
                String appIdByFormId = FormMetaUtil.getAppIdByFormId((String)entityId);
                procModel.setAppId(appIdByFormId);
                String procInstId = this.getPageCache().get(WF_PROC_INST_ID);
                NoCodeWfMetaData noCodeWfMetaData = NoCodeWfMetaHelper.deserializeFromMap((Map)((Map)SerializationUtils.fromJsonString((String)procDefInfo.getData(), Map.class)), null);
                List nodes = noCodeWfMetaData.getNodes();
                this.addNodeHandleStatusField(entityId, procInstId, nodes);
                noCodeWfMetaData.setProcInstId(procInstId);
                String data = NoCodeWfMetaHelper.serializeToString((Object)noCodeWfMetaData);
                procModel.setData(data);
                if (StringUtils.isBlank((CharSequence)procModel.getData())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u6a21\u578b\u5931\u8d25\uff1a", (String)"NoCodeWfDesignerPlugin_1", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]) + procDefInfo.getId());
                }
                proxy.removeAction("setFormStatus");
                this.getView().setStatus(OperationStatus.VIEW);
            } else {
                procModel = NoCodeWorkflowServiceHelper.getProcess((Long)modelId);
            }
        }
        catch (Exception ex) {
            log.warn((Throwable)ex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u52a0\u8f7d\u6d41\u7a0b\u6a21\u578b\u5931\u8d25", (String)"NoCodeWfDesignerPlugin_2", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (procModel == null) {
            return;
        }
        long endLoadModeItem = System.currentTimeMillis();
        log.debug(String.format("nocode: loadMode - %s", endLoadModeItem - startTime));
        this.getPageCache().put(BIZ_APPID, procModel.getAppId());
        WfDesignerCtx ctx = WfDesignerCtxManager.use(this.getPageCache());
        NoCodeWfMetaData noCodeWfMetaData = null;
        if ("{\"properties\":{}}".equalsIgnoreCase(procModel.getData())) {
            noCodeWfMetaData = new NoCodeWfMetaData();
            noCodeWfMetaData.setId(String.valueOf(procModel.getId()));
            noCodeWfMetaData.setName(procModel.getName().toString());
            noCodeWfMetaData.setKey(procModel.getNumber());
            Map content = NoCodeWfMetaHelper.serializeToMap((Object)noCodeWfMetaData);
            procModel.setData(SerializationUtils.toJsonString((Object)content));
        } else {
            Map loadModel = (Map)SerializationUtils.fromJsonString((String)procModel.getData(), Map.class);
            noCodeWfMetaData = NoCodeWfMetaHelper.deserializeFromMap((Map)loadModel, null);
        }
        this.getPageCache().put(WF_MODEL_OLD_DATA, SerializationUtils.toJsonString((Object)procModel));
        long endDeserializeTime = System.currentTimeMillis();
        log.debug(String.format("nocode: deserialize to NoCodeWfMetaData - %s", endDeserializeTime - endLoadModeItem));
        try {
            HashMap<String, Map<String, Object>> immutableCtx = new HashMap<String, Map<String, Object>>();
            String xmlFuncs = (String)this.getView().getFormShowParameter().getCustomParam("functiontypes");
            Map<String, Object> expressDesignMeta = ExpressDesignMetaHelper.getExpressDesignMeta(META_TYPE_ENTITY_META, xmlFuncs, true);
            immutableCtx.put("expression", expressDesignMeta);
            WfModelConvert.fixupOutParams(ctx, noCodeWfMetaData);
            long fixupOutParamsTime = System.currentTimeMillis();
            log.debug(String.format("nocode: fixupOutParams - %s", fixupOutParamsTime - endDeserializeTime));
            try {
                List macros = NoCodeWorkflowServiceHelper.getNodeMacros((String)NoCodeWfMetaHelper.serializeToString((Object)noCodeWfMetaData), (String)"ExecuteResult");
                ctx.setMacros(macros);
                ctx.setNodeNameMacros(NoCodeWorkflowServiceHelper.getNodeMacros((Long)modelId, (String)"NodeName"));
                ctx.setAssigneeMacros(NoCodeWorkflowServiceHelper.getNodeMacros((Long)modelId, (String)"Assignee"));
            }
            catch (Exception exc) {
                log.warn((Throwable)exc);
            }
            JSONObject initSyncData = WfModelSync.buildSyncData(ctx, noCodeWfMetaData, noCodeWfMetaData, this.getAllSyncArgs(WfConsts.SyncTypeEnum.ALL, true));
            long initSyncDataTime = System.currentTimeMillis();
            log.debug(String.format("nocode: initSyncData - %s", initSyncDataTime - fixupOutParamsTime));
            WfModelConvert.onAfterLoad(ctx, noCodeWfMetaData);
            long onAfterLoadTime = System.currentTimeMillis();
            log.debug(String.format("nocode: onAfterLoad - %s", onAfterLoadTime - initSyncDataTime));
            Map content = NoCodeWfMetaHelper.serializeToMap((Object)noCodeWfMetaData);
            proxy.invokeControlMethod(this.getDesignerKey(), "open", new Object[]{content, immutableCtx, initSyncData});
            WfDesignerCtxManager.endUse(this.getPageCache(), ctx);
            long endTime = System.currentTimeMillis();
            log.debug(String.format("nocode: serializeToMap - %s", endTime - onAfterLoadTime));
        }
        catch (KDException ex) {
            log.warn((Throwable)ex);
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private Long getModelId() {
        long modelId;
        String wfModelId = this.getPageCache().get(WF_MODEL_ID);
        if (StringUtils.isBlank((CharSequence)wfModelId)) {
            throw new KDBizException("targetFormId is empty");
        }
        try {
            modelId = Long.parseLong(wfModelId);
        }
        catch (Exception ex) {
            log.warn((Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u9875\u9762\uff0c\u8bf7\u68c0\u67e5", (String)"NoCodeWfDesignerPlugin_3", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
        }
        return modelId;
    }

    private void addNodeHandleStatusField(String entityId, String procInstId, List<NoCodeWfNode> nodes) {
        String pkId;
        NoCodeWfRecordApiService noCodeWfRecordApiService = (NoCodeWfRecordApiService)ServiceFactory.getService((String)"NoCodeWfRecordApiService");
        Map approvalRecordMap = noCodeWfRecordApiService.getApprovalRecords(entityId, pkId = this.getPageCache().get(WF_PROC_PK_ID));
        List approvalRecordList = (List)approvalRecordMap.get(Long.parseLong(procInstId));
        if (CollectionUtils.isEmpty((Collection)approvalRecordList)) {
            return;
        }
        Map<String, String> nodeId2StatusMap = this.getNodeId2StatusMap(approvalRecordList);
        for (NoCodeWfNode node : nodes) {
            String nodeId = node.getId();
            nodeId2StatusMap.put(nodeId, nodeId2StatusMap.getOrDefault(nodeId, "todo"));
            node.setHandleStatus(nodeId2StatusMap.get(nodeId));
        }
    }

    private Map<String, String> getNodeId2StatusMap(List<ApprovalRecord> approvalRecordList) {
        HashMap<String, String> nodeId2StatusMap = new HashMap<String, String>(approvalRecordList.size());
        for (ApprovalRecord approvalRecord : approvalRecordList) {
            String nodeId = approvalRecord.getNodeId();
            if (nodeId2StatusMap.containsKey(nodeId)) continue;
            nodeId2StatusMap.put(nodeId, approvalRecord.getFlowChartStatus().toString());
        }
        return nodeId2StatusMap;
    }

    public void designerBarClick(WfDesignerBarEvent e) {
        String barItemKey = e.getBarItemKey();
        if (barItemKey.equals(SAVE)) {
            boolean isExecuteImmediatelyForSchedule;
            boolean isExecuteImmediately = e.getParam().get(PKID) != null;
            boolean bl = isExecuteImmediatelyForSchedule = e.getParam().get(PKID) != null && "timer".equalsIgnoreCase((String)e.getParam().get(PKID));
            if (isExecuteImmediatelyForSchedule) {
                boolean saveSuccess = this.saveData(e.getParam());
                if (saveSuccess && isExecuteImmediately) {
                    this.executeImmediately(e.getParam());
                }
            } else if (isExecuteImmediately) {
                this.executeImmediately(e.getParam());
            } else {
                this.saveData(e.getParam());
            }
        } else {
            throw new NotImplementedException();
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_CLOSEWFSAVELOADING, null);
    }

    private boolean saveData(Map<String, Object> param) {
        boolean isSaveWithExecuteImmediately = param.get(PKID) != null;
        NoCodeWfDesigner designer = this.getDesigner();
        Map content = designer.getContent();
        WfDesignerCtx ctx = WfDesignerCtxManager.use(this.getPageCache());
        NoCodeWfMetaData noCodeWfMetaData = NoCodeWfMetaHelper.deserializeFromMap((Map)content, null);
        Tuple<ProcessModel, NoCodeWfMetaData> oldWfMetaData = this.getOldWfMetaData();
        ProcessModel oldProcessModel = (ProcessModel)oldWfMetaData.item1;
        NoCodeWfMetaData oldNoCodeWfMetaData = (NoCodeWfMetaData)oldWfMetaData.item2;
        WfModelConvert.onBeforeSave(ctx, noCodeWfMetaData, oldNoCodeWfMetaData);
        if (!this.saveDataCheck(ctx, noCodeWfMetaData, oldNoCodeWfMetaData)) {
            WfDesignerCtxManager.endUse(this.getPageCache(), ctx);
            return false;
        }
        try {
            ProcessModel processModel = NoCodeWfDesignerPlugin.getProcessMode(noCodeWfMetaData, oldProcessModel);
            processModel.setBusinessId(noCodeWfMetaData.getKey());
            processModel.setOrgId(Long.valueOf(this.getCurrentUserAdminOrg()));
            Map noCodeWfMetaDataMap = NoCodeWfMetaHelper.serializeToMap((Object)noCodeWfMetaData);
            processModel.setData(SerializationUtils.toJsonString((Object)noCodeWfMetaDataMap));
            Long modelId = NoCodeWorkflowServiceHelper.saveProcess((ProcessModel)processModel);
            if (modelId > 0L) {
                ProcessModel processModelReLoad = NoCodeWorkflowServiceHelper.getProcess((Long)modelId);
                this.getPageCache().put(WF_MODEL_OLD_DATA, SerializationUtils.toJsonString((Object)processModelReLoad));
                this.publishProcess(noCodeWfMetaData, modelId, ctx, isSaveWithExecuteImmediately);
            }
            WfDesignerCtxManager.endUse(this.getPageCache(), ctx, true);
            return true;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
            WfDesignerCtxManager.endUse(this.getPageCache(), ctx);
            return false;
        }
    }

    private void executeImmediately(Map<String, Object> param) {
        String pkid = (String)param.get(PKID);
        long modelId = this.getModelId();
        if ("timer".equalsIgnoreCase(pkid)) {
            NoCodeWorkflowServiceHelper.tryTriggerProcess((Long)modelId, null, (String)"timer");
        } else {
            NoCodeWorkflowServiceHelper.tryTriggerProcess((Long)modelId, (String)pkid, (String)"bizOperate");
        }
        String successMsg = ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"NoCodeWfDesignerPlugin_4", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]);
        this.getView().showSuccessNotification(successMsg);
    }

    private boolean publishProcess(NoCodeWfMetaData noCodeWfMetaData, Long modelId, WfDesignerCtx ctx, boolean isExecuteImmediately) {
        boolean publishSuccess = false;
        try {
            if (!noCodeWfMetaData.isNeedPublishNewVersion()) {
                try {
                    NoCodeWorkflowServiceHelper.updateLatestProcessDefaultScheme((Long)modelId);
                    if (!isExecuteImmediately) {
                        String successMsg = ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"NoCodeWfDesignerPlugin_5", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]);
                        this.getView().showSuccessNotification(successMsg);
                    }
                    return true;
                }
                catch (KDException ex) {
                    log.warn((Throwable)ex);
                    publishSuccess = false;
                }
            }
            HashMap<String, Boolean> config = new HashMap<String, Boolean>();
            config.put("ignoreValidateInfo", true);
            ProcPublishResult procPublishResult = NoCodeWorkflowServiceHelper.publishProcess((Long)modelId, config);
            if (procPublishResult.isSuccess()) {
                if (!isExecuteImmediately) {
                    String successMsg = ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f", (String)"NoCodeWfDesignerPlugin_6", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]);
                    this.getView().showSuccessNotification(successMsg);
                }
                publishSuccess = true;
            } else {
                JSONObject errData = WfModelSync.buildSyncDataFromPublish(noCodeWfMetaData, procPublishResult, ctx);
                int errorCount = WfModelSync.calcErrorCount(errData);
                String errorMsg = ResManager.loadKDString((String)"\u5b58\u5728\u6709%s\u6761\u9519\u8bef\uff0c\u8bf7\u4fee\u590d\u540e\u518d\u53d1\u5e03", (String)"NoCodeWfDesignerPlugin_7", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[]{String.valueOf(errorCount)});
                this.getView().showErrorNotification(errorMsg);
                NoCodeWfNodeStart startNode = NoCodeWfMetaHelper.getStartNode((NoCodeWfMetaData)noCodeWfMetaData);
                WfModelSync.showErrorNotificationNonProp((NoCodeWfGraphCell)startNode, errData, this.getView());
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SETSYNCDATA, new Object[]{errData});
                publishSuccess = false;
            }
            return publishSuccess;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            String errer = e.getMessage();
            if (StringUtils.isBlank((CharSequence)errer)) {
                errer = NcErrorUtil.getStackTrace((Exception)e);
            }
            errer = ResManager.loadKDString((String)"\u6d41\u7a0b\u53d1\u5e03\u5931\u8d25\uff0c\u7a0b\u5e8f\u9519\u8bef:", (String)"NoCodeWfDesignerPlugin_8", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]) + errer;
            this.getView().showErrorNotification(errer);
            return false;
        }
    }

    public static ProcessModel getProcessMode(NoCodeWfMetaData ncMetaData, ProcessModel oldProcessModel) {
        oldProcessModel.setName(new LocaleString(ncMetaData.getName()));
        oldProcessModel.setNumber(ncMetaData.getKey());
        oldProcessModel.setData("{\"properties\":{}}");
        return oldProcessModel;
    }

    private boolean saveDataCheck(WfDesignerCtx ctx, NoCodeWfMetaData noCodeWfMetaData, NoCodeWfMetaData oldNoCodeWfMetaData) {
        String bizappId = this.getPageCache().get(BIZ_APPID);
        NoCodePermHelper.verifyManage((String)bizappId);
        JSONObject errData = WfModelSync.buildSyncData(ctx, noCodeWfMetaData, oldNoCodeWfMetaData, this.getAllSyncArgs(WfConsts.SyncTypeEnum.ALL, false));
        int errorCount = WfModelSync.calcErrorCount(errData);
        if (errorCount > 0) {
            String errorMsg = ResManager.loadKDString((String)"\u5b58\u5728\u6709%s\u6761\u9519\u8bef\uff0c\u8bf7\u4fee\u590d\u540e\u518d\u53d1\u5e03", (String)"NoCodeWfDesignerPlugin_7", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[]{String.valueOf(errorCount)});
            this.getView().showErrorNotification(errorMsg);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SETSYNCDATA, new Object[]{errData});
            return false;
        }
        return true;
    }

    public void click(PropertyEvent e) {
        String propertName = e.getPropertName();
        Map param = e.getParam();
        String editorType = e.getMetaType();
        String bizappId = this.getPageCache().get(BIZ_APPID);
        if (CALL_ACTION_GET_REF_BILL_PROPS.equalsIgnoreCase(editorType)) {
            String formId = propertName;
            if (StringUtils.isBlank((CharSequence)formId)) {
                return;
            }
            FieldTreeBuilder fieldTreeBuilder = new FieldTreeBuilder(formId);
            List data = fieldTreeBuilder.withoutFieldTypes(new FieldTreeBuilder.FieldType[]{FieldTreeBuilder.FieldType.EntryField, FieldTreeBuilder.FieldType.NoCodeImageUploadField, FieldTreeBuilder.FieldType.NoCodeAttachmentUploadField, FieldTreeBuilder.FieldType.NoCodeRichTextField, FieldTreeBuilder.FieldType.NoCodeGraphicDisplayField}).build();
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SET_REF_BILL_PROPS, new Object[]{data});
        } else if ("refbilltype".equalsIgnoreCase(editorType) || "formId".equalsIgnoreCase(propertName)) {
            if (param.get("showTree") != null && param.get("showTree").toString().equals("true")) {
                String parentId = param.get("parentId") == null ? null : param.get("parentId").toString();
                String ignoreCosmicForm = param.get("ignoreCosmicForm") == null ? null : param.get("ignoreCosmicForm").toString();
                String isOpenApiStr = param.get("isOpenApi") == null ? null : param.get("isOpenApi").toString();
                NoCodeTreeNode root = !StringUtils.isBlank((CharSequence)isOpenApiStr) && Boolean.parseBoolean(isOpenApiStr) ? OpenApiUtil.buildRefOpenApiTreeData((String)"0") : NcEntityTypeUtil.buildRefBillTreeData((String)bizappId, (String)parentId, (String)ignoreCosmicForm);
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.invokeControlMethod(this.getDesignerKey(), "setRefBillTreeData", new Object[]{root});
            } else {
                JSONObject data = NcEntityTypeUtil.buildRefBillData((Map)param, (String)bizappId);
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SET_REF_BILL_DATA, new Object[]{data});
            }
        }
    }

    public void getPropertyAlias(PropertyEvent e) {
        throw new NotImplementedException();
    }

    private NoCodeWfDesigner getDesigner() {
        return (NoCodeWfDesigner)this.getView().getControl(this.getDesignerKey());
    }

    public void sync(WfDesignerMetaSyncEvent syncArgs) {
        NoCodeWfDesigner designer = this.getDesigner();
        Map content = designer.getContent();
        if (content == null || content.isEmpty()) {
            return;
        }
        try {
            NoCodeWfMetaData noCodeWfMetaData = NoCodeWfMetaHelper.deserializeFromMap((Map)content, null);
            Tuple<ProcessModel, NoCodeWfMetaData> oldWfMetaData = this.getOldWfMetaData();
            NoCodeWfMetaData oldNoCodeWfMetaData = (NoCodeWfMetaData)oldWfMetaData.item2;
            WfDesignerCtx ctx = WfDesignerCtxManager.use(this.getPageCache());
            WfModelConvert.onBeforeSave(ctx, noCodeWfMetaData, oldNoCodeWfMetaData);
            JSONObject data = WfModelSync.buildSyncData(ctx, noCodeWfMetaData, oldNoCodeWfMetaData, syncArgs);
            if (data != null) {
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SETSYNCDATA, new Object[]{data});
            }
            WfDesignerCtxManager.endUse(this.getPageCache(), ctx);
        }
        catch (KDException ex) {
            log.warn((Throwable)ex);
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private WfDesignerMetaSyncEvent getAllSyncArgs(WfConsts.SyncTypeEnum syncType, boolean init) {
        ArrayList<String> types = new ArrayList<String>();
        switch (syncType) {
            case VARIABLES: {
                types.add(WfConsts.SyncTypeEnum.VARIABLES.getCode());
                break;
            }
            case ERRORS: {
                types.add(WfConsts.SyncTypeEnum.ERRORS.getCode());
                break;
            }
            default: {
                types.clear();
            }
        }
        return new WfDesignerMetaSyncEvent(new ArrayList(), types, new ArrayList(), new HashMap(), init);
    }

    public void query(WfDesignerCommonEvent arg) {
        try {
            Map result = (Map)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)"nocode_sys", (String)RestApiWrap.class.getSimpleName(), (String)"query", (Object[])new Object[]{arg.getRealFormId(), arg.getParam()});
            result.put(ARGS, arg);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SETQUERY, new Object[]{result});
        }
        catch (KDException ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    public void getFilterItemLook(WfDesignerCommonEvent arg) {
        try {
            Map result = (Map)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)"nocode_sys", (String)RestApiWrap.class.getSimpleName(), (String)"getFilterItemLook", (Object[])new Object[]{arg.getRealFormId(), arg.getParam()});
            result.put(ARGS, arg);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_FILTERITEMLOOK, new Object[]{result});
        }
        catch (Exception ex) {
            if (StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                this.getView().showErrorNotification(ex.getMessage());
            }
            log.warn((Throwable)ex);
        }
    }

    public void participantMenu(String targetNodeId) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>(2);
        result.put(DATA, this.getParticipantMenuData(targetNodeId));
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_APPROVER_MENU, new Object[]{result});
    }

    private List<Map<String, Object>> getParticipantMenuData(String targetNodeId) {
        ArrayList<Map<String, Object>> menus = new ArrayList<Map<String, Object>>(16);
        String userSelectProperties = NcEntityTypeUtil.getDisplayProperties((String)"bos_user");
        String orgSelectProperties = NcEntityTypeUtil.getDisplayProperties((String)"bos_adminorg");
        String appRoleSelectProperties = "id,roleName,roleDesc";
        menus.add(ParticipantHelper.buildMenuItem("bos_user", CommonConstants.getUserDesc(), "user", "bos_user", userSelectProperties, ListConfigUtils.getWfUserApproverListConfig()));
        menus.add(ParticipantHelper.buildMenuItem("bos_adminorg", CommonConstants.getOrgDesc(), "org", "bos_adminorg", orgSelectProperties, ListConfigUtils.getWfOrgApproverListConfig()));
        menus.add(ParticipantHelper.buildMenuItem("org_manager", CommonConstants.getOrgManagerDesc(), "org_manager", "bos_adminorg", orgSelectProperties, ListConfigUtils.getWfOrgApproverListConfig()));
        menus.add(ParticipantHelper.buildMenuItem("appRole", CommonConstants.getAppRoleDesc(), "appRole", "appRole", appRoleSelectProperties, ListConfigUtils.getWfAppRoleApproverListConfig()));
        menus.addAll(this.buildWfNodeMenus(targetNodeId));
        return menus;
    }

    private List<Map<String, Object>> buildWfNodeMenus(String targetNodeId) {
        WfDesignerCtx ctx = WfDesignerCtxManager.use(this.getPageCache());
        try {
            NoCodeWfMetaData noCodeWfMetaData = NoCodeWfMetaHelper.deserializeFromMap((Map)this.getDesigner().getContent(), null);
            Tuple<ProcessModel, NoCodeWfMetaData> oldWfMetaData = this.getOldWfMetaData();
            NoCodeWfMetaData oldNoCodeWfMetaData = (NoCodeWfMetaData)oldWfMetaData.item2;
            WfModelConvert.onBeforeSave(ctx, noCodeWfMetaData, oldNoCodeWfMetaData);
            List nodes = noCodeWfMetaData.getNodes();
            String rootId = (String)this.getDesigner().getContent().get(ID);
            List parentNodes = WfProcessUtils.getParentNodes((String)targetNodeId, (String)rootId, (List)nodes);
            List<NoCodeWfNode> menuNodes = ParticipantHelper.getMenuNodes(nodes, node -> parentNodes.contains(node.getId()));
            List<Map<String, Object>> nodeMenus = menuNodes.stream().map(ParticipantHelper::wrapNode2MenuItem).filter(Objects::nonNull).collect(Collectors.toList());
            WfDesignerCtxManager.endUse(this.getPageCache(), ctx);
            return nodeMenus;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Object)e);
            WfDesignerCtxManager.endUse(this.getPageCache(), ctx);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u4eba\u5458\u5931\u8d25\uff1a", (String)"NoCodeWfDesignerPlugin_9", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]) + e.getMessage());
            return Lists.newArrayList();
        }
    }

    public void queryParticipantData(WfDesignerApproverEvent arg) {
        String type;
        switch (type = arg.getType()) {
            case "user": 
            case "org": 
            case "org_manager": {
                this.queryParticipant(arg);
                break;
            }
            case "node": {
                String formNumber = arg.getFormNumber();
                if (Objects.equals(formNumber, "auditNode")) {
                    this.queryAuditNodeField(arg);
                    break;
                }
                this.queryFormUserOrOrgField(arg);
                break;
            }
            case "appRole": {
                this.queryAppRole(arg);
                break;
            }
        }
    }

    private void queryAuditNodeField(WfDesignerApproverEvent arg) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{ID, "fieldName", "fieldType", "name"}, (DataType[])new DataType[]{new StringType(), new StringType(), new StringType(), new StringType()});
        Object[] rowData = this.getAssigneeRowData(arg.getNodeId(), ResManager.loadKDString((String)"\u5ba1\u6279\u4eba", (String)"NoCodeWfDesignerPlugin_10", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
        ArrayList rows = Lists.newArrayList();
        rows.add(rowData);
        this.handlePageAndSearchQuery(arg, rowMeta, rows);
    }

    private Object[] getAssigneeRowData(String nodeId, String assigneeDesc) {
        WfDesignerCtx ctx = WfDesignerCtxManager.use(this.getPageCache());
        NoCodeWfMetaData noCodeWfMetaData = NoCodeWfMetaHelper.deserializeFromMap((Map)this.getDesigner().getContent(), null);
        String assigneeVar = VariableHelper.getNodeAssigneeVar(nodeId, ctx, noCodeWfMetaData);
        WfDesignerCtxManager.endUse(this.getPageCache(), ctx);
        return new Object[]{assigneeVar, assigneeDesc, ResManager.loadKDString((String)"\u5173\u8054\u8868\u5355\uff1a\u4eba\u5458", (String)"NoCodeWfDesignerPlugin_11", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]), assigneeDesc};
    }

    /*
     * Exception decompiling
     */
    private void queryAppRole(WfDesignerApproverEvent arg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void queryParticipant(WfDesignerApproverEvent arg) {
        try {
            Map result = (Map)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)"nocode_sys", (String)RestApiWrap.class.getSimpleName(), (String)"query", (Object[])new Object[]{arg.getFormNumber(), arg.getParam()});
            result.put(ARGS, arg);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SETQUERY, new Object[]{result});
        }
        catch (Exception ex) {
            if (StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                this.getView().showErrorNotification(ex.getMessage());
            }
            log.warn((Throwable)ex);
        }
    }

    /*
     * Exception decompiling
     */
    private void queryFormUserOrOrgField(WfDesignerApproverEvent arg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handlePageAndSearchQuery(WfDesignerApproverEvent arg, RowMeta rowMeta, List<Object[]> rows) {
        Integer pageNo = (Integer)arg.getParam().get("page_no");
        Integer pageSize = (Integer)arg.getParam().get("page_size");
        String search = (String)arg.getParam().get("search");
        try (DataSet dataSet = Algo.create((String)"queryFormUserField").createDataSet(rows, rowMeta);
             DataSet filterDataSet = StringUtils.isNotBlank((CharSequence)search) ? dataSet.where(String.format("fieldName like '%s' OR fieldType like '%s'", "%" + search + "%", "%" + search + "%")) : dataSet;){
            int totalCount = filterDataSet.copy().count(ID, false);
            try (DataSet pageDataSet = filterDataSet.range((pageNo - 1) * pageSize, pageSize.intValue());){
                int totalPage = (totalCount - 1) / pageSize + 1;
                ArrayList resultRows = new ArrayList(rows.size());
                while (pageDataSet.hasNext()) {
                    Row next = pageDataSet.next();
                    HashMap<String, String> item = new HashMap<String, String>(4);
                    item.put(ID, next.getString(ID));
                    item.put("fieldName", next.getString("fieldName"));
                    item.put("fieldType", next.getString("fieldType"));
                    item.put("name", next.getString("name"));
                    resultRows.add(item);
                }
                HashMap<String, Object> result = new HashMap<String, Object>(16);
                result.put(ARGS, arg);
                RestApiQueryResult data = new RestApiQueryResult();
                data.setRows(resultRows);
                data.setLastPage(Boolean.valueOf(pageNo >= totalPage));
                data.setPageNo(pageNo.intValue());
                data.setPageSize(pageSize.intValue());
                data.setTotalCount(totalCount);
                result.put(DATA, data);
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SETQUERY, new Object[]{result});
            }
        }
    }

    @NotNull
    private List<UserOrOrgFieldInfo> getUserAndOrgFieldInfo(Stream<IDataEntityProperty> userAndOrgFields) {
        return userAndOrgFields.flatMap(e -> {
            String billEntityNumber = ((INoCodeRefBillProp)e).getBillEntityNumber();
            String fieldKey = e.getName();
            String displayName = e.getDisplayName().getLocaleValue();
            ArrayList<UserOrOrgFieldInfo> userAndOrgFieldInfos = new ArrayList<UserOrOrgFieldInfo>(2);
            if ("bos_user".equalsIgnoreCase(billEntityNumber)) {
                UserOrOrgFieldInfo userFieldInfo1 = new UserOrOrgFieldInfo();
                userFieldInfo1.setFieldName(displayName);
                userFieldInfo1.setFieldType(ResManager.loadKDString((String)"\u5173\u8054\u8868\u5355\uff1a\u4eba\u5458", (String)"NoCodeWfDesignerPlugin_11", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
                userFieldInfo1.setName(displayName);
                userFieldInfo1.setId(fieldKey);
                UserOrOrgFieldInfo userFieldInfo2 = new UserOrOrgFieldInfo();
                userFieldInfo2.setFieldName(displayName + HandlerFieldSuffixEnum.superior.getSuffixDesc());
                userFieldInfo2.setFieldType(ResManager.loadKDString((String)"\u5173\u8054\u8868\u5355\uff1a\u4eba\u5458", (String)"NoCodeWfDesignerPlugin_11", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
                userFieldInfo2.setName(displayName + HandlerFieldSuffixEnum.superior.getSuffixDesc());
                userFieldInfo2.setId(fieldKey + (Object)((Object)HandlerFieldSuffixEnum.superior));
                userAndOrgFieldInfos.add(userFieldInfo1);
                userAndOrgFieldInfos.add(userFieldInfo2);
                return userAndOrgFieldInfos.stream();
            }
            UserOrOrgFieldInfo orgFieldInfo1 = new UserOrOrgFieldInfo();
            orgFieldInfo1.setFieldName(displayName);
            orgFieldInfo1.setFieldType(ResManager.loadKDString((String)"\u5173\u8054\u8868\u5355\uff1a\u7ec4\u7ec7", (String)"NoCodeWfDesignerPlugin_13", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
            orgFieldInfo1.setName(displayName);
            orgFieldInfo1.setId(fieldKey + (Object)((Object)HandlerFieldSuffixEnum.org));
            UserOrOrgFieldInfo orgFieldInfo2 = new UserOrOrgFieldInfo();
            orgFieldInfo2.setFieldName(displayName + HandlerFieldSuffixEnum.org_manager.getSuffixDesc());
            orgFieldInfo2.setFieldType(ResManager.loadKDString((String)"\u5173\u8054\u8868\u5355\uff1a\u4eba\u5458", (String)"NoCodeWfDesignerPlugin_11", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
            orgFieldInfo2.setName(displayName + HandlerFieldSuffixEnum.org_manager.getSuffixDesc());
            orgFieldInfo2.setId(fieldKey + (Object)((Object)HandlerFieldSuffixEnum.org_manager));
            userAndOrgFieldInfos.add(orgFieldInfo1);
            userAndOrgFieldInfos.add(orgFieldInfo2);
            return userAndOrgFieldInfos.stream();
        }).collect(Collectors.toList());
    }

    private boolean filterUserAndOrgProp(Map.Entry<String, IDataEntityProperty> e) {
        String billEntityNumber;
        IDataEntityProperty prop = e.getValue();
        if (Objects.isNull(prop)) {
            log.debug("\u7b5b\u9009\u7528\u6237\u5b57\u6bb5\uff0c\u53d1\u73b0prop\u4e3a\u7a7a\uff0ckey={}\u3002", (Object)e.getKey());
        } else if (prop instanceof INoCodeRefBillProp && StringUtils.isBlank((CharSequence)(billEntityNumber = ((INoCodeRefBillProp)prop).getBillEntityNumber()))) {
            log.debug("\u7b5b\u9009\u7528\u6237\u5b57\u6bb5\uff0c\u53d1\u73b0entityNumber\u4e3a\u7a7a\uff0ckey={}\u3002", (Object)e.getKey());
        }
        return Objects.nonNull(prop) && prop instanceof INoCodeRefBillProp && ("bos_user".equalsIgnoreCase(((INoCodeRefBillProp)prop).getBillEntityNumber()) || "bos_adminorg".equalsIgnoreCase(((INoCodeRefBillProp)prop).getBillEntityNumber()));
    }

    public void listconfig(WfDesignerCommonEvent arg) {
        if (NcEntityTypeUtil.isFormExist((String)arg.getRealFormId())) {
            try {
                Map result = (Map)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)"nocode_sys", (String)RestApiWrap.class.getSimpleName(), (String)"listConfig", (Object[])new Object[]{arg.getRealFormId(), arg.getParam()});
                result.put(ARGS, arg);
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SETLISTCONFIG, new Object[]{result});
            }
            catch (Exception ex) {
                if (StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                    this.getView().showErrorNotification(ex.getMessage());
                }
                log.warn((Throwable)ex);
            }
        }
    }

    public void listTreeConfig(WfDesignerCommonEvent arg) {
        List showColumns;
        String formId = arg.getRealFormId();
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        if (NcEntityTypeUtil.isFormExist((String)formId)) {
            FieldTreeBuilder fieldTreeBuilder = new FieldTreeBuilder(formId);
            List showColumns2 = fieldTreeBuilder.withFeature(new FieldTreeBuilder.Feature[]{FieldTreeBuilder.Feature.GroupContainer, FieldTreeBuilder.Feature.UseRealType}).withoutFieldTypes(new FieldTreeBuilder.FieldType[]{FieldTreeBuilder.FieldType.NoCodeBillNoField, FieldTreeBuilder.FieldType.NoCodeRichTextField, FieldTreeBuilder.FieldType.NoCodeGraphicDisplayField, FieldTreeBuilder.FieldType.NoCodeAttachmentUploadField, FieldTreeBuilder.FieldType.NoCodeImageUploadField, FieldTreeBuilder.FieldType.NoCodeBillNoField, FieldTreeBuilder.FieldType.EntryField}).withLevel(4).build();
            if (showColumns2 != null && !showColumns2.isEmpty()) {
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(ARGS, arg);
                result.put(DATA, showColumns2);
                clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SETLISTTREECONFIG, new Object[]{result});
            }
        } else if (OpenApiUtil.isOpenApiListItem((String)formId) && (showColumns = OpenApiUtil.getOpenApiInParams((String)formId, (boolean)true)) != null && !showColumns.isEmpty()) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put(ARGS, arg);
            result.put(DATA, showColumns);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SETLISTTREECONFIG, new Object[]{result});
        }
    }

    private static List<ShowColumnInfo> getShowColumns2(String formId, String parentKey, String rootFormId) {
        FieldTreeBuilder fieldTreeBuilder = new FieldTreeBuilder(formId);
        List showColumns = fieldTreeBuilder.withFeature(new FieldTreeBuilder.Feature[]{FieldTreeBuilder.Feature.GroupContainer, FieldTreeBuilder.Feature.UseRealType}).withoutFieldTypes(new FieldTreeBuilder.FieldType[]{FieldTreeBuilder.FieldType.NoCodeBillNoField, FieldTreeBuilder.FieldType.NoCodeRichTextField, FieldTreeBuilder.FieldType.NoCodeGraphicDisplayField, FieldTreeBuilder.FieldType.NoCodeAttachmentUploadField, FieldTreeBuilder.FieldType.NoCodeImageUploadField, FieldTreeBuilder.FieldType.EntryField}).withLevel(4).build();
        return showColumns;
    }

    private static void setIdWithParentKey(ShowColumnInfo column, String parentKey) {
        List refColumns;
        Object optionChildren;
        if (column.getId().startsWith(parentKey)) {
            return;
        }
        String subParentKey = parentKey + "." + column.getId();
        column.setId(subParentKey);
        if ("group".equalsIgnoreCase(column.getType())) {
            subParentKey = parentKey;
        }
        if ((optionChildren = column.getOption().get("children")) instanceof List && (refColumns = (List)optionChildren) != null && !refColumns.isEmpty()) {
            for (ShowColumnInfo refColumn : refColumns) {
                NoCodeWfDesignerPlugin.setIdWithParentKey(refColumn, subParentKey);
            }
        }
    }

    private long getCurrentUserAdminOrg() {
        return UserServiceHelper.getUserMainOrgId((long)RequestContext.get().getCurrUserId());
    }

    private Tuple<ProcessModel, NoCodeWfMetaData> getOldWfMetaData() {
        String cacheOldData = this.getPageCache().get(WF_MODEL_OLD_DATA);
        if (StringUtils.isBlank((CharSequence)cacheOldData)) {
            return new Tuple(null, null);
        }
        ProcessModel oldProcessModel = (ProcessModel)SerializationUtils.fromJsonString((String)cacheOldData, ProcessModel.class);
        Map oldContent = (Map)SerializationUtils.fromJsonString((String)oldProcessModel.getData(), Map.class);
        NoCodeWfMetaData oldMetaData = NoCodeWfMetaHelper.deserializeFromMap((Map)oldContent, null);
        return new Tuple((Object)oldProcessModel, (Object)oldMetaData);
    }

    public void getTriggerProcess(WfDesignerCommonEvent arg) {
        super.getTriggerProcess(arg);
        String formId = arg.getRealFormId();
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        List ret = NoCodeWorkflowServiceUtil.getProcessesByEntityNumber((String)formId);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SET_TRIGGER_PROCESS, new Object[]{ret});
    }

    public void addNewRef(WfDesignerCommonEvent arg) {
        String formId = arg.getRealFormId();
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        if (!NcEntityTypeUtil.isFormExist((String)formId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"NoCodeWfDesignerPlugin_14", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String entityNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)formId);
        if (NcEntityTypeUtil.isNoCodeBill((String)entityNumber)) {
            boolean check = NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.input, (String)entityNumber);
            if (!check) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"NoCodeWfDesignerPlugin_15", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_nocode_bill_nested2");
            String appId = this.getModel().getDataEntityType().getAppId();
            parameter.setCustomParam("ServiceAppId", (Object)("bos." + appId));
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.setParentPageId(this.getView().getPageId());
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("isAddRef", (Object)true);
            parameter.setCustomParam(TARGET_FORM_ID, (Object)entityNumber);
            parameter.setCustomParam("saveCallbackProps", (Object)this.getView().getPageId());
            parameter.setCustomParam("controlKey", (Object)this.getDesignerKey());
            parameter.setCustomParam("nested", (Object)true);
            parameter.setCustomParam("nestedType", (Object)"wfAddRef");
            parameter.setCustomParam("Status", (Object)OperationStatus.ADDNEW);
            parameter.setCaption(ResManager.loadKDString((String)"\u5f55\u5165", (String)"NoCodeWfDesignerPlugin_16", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
            this.getView().showForm(parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u6682\u65f6\u65e0\u6cd5\u65b0\u589e", (String)"NoCodeWfDesignerPlugin_17", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    public void testApi(NoCodeWfNodeApiInvoke apiNodeInfo) {
        NoCodeWfDesigner designer = this.getDesigner();
        Map content = designer.getContent();
        NoCodeWfMetaData noCodeWfMetaData = content == null || content.isEmpty() ? (NoCodeWfMetaData)this.getOldWfMetaData().item2 : NoCodeWfMetaHelper.deserializeFromMap((Map)content, null);
        JSONArray errors = new JSONArray();
        NoCodeWfNodeApiInvokeSync.checkProperties(apiNodeInfo, errors, true);
        if (CollectionUtils.isNotEmpty((Collection)errors)) {
            String errorMessage = errors.stream().map(e -> NoCodeWfDesignerPlugin.getErrorMessage((JSONObject)e)).filter(StringUtils::isNotBlank).collect(Collectors.joining("\uff0c"));
            this.getView().showErrorNotification(errorMessage);
            return;
        }
        String method = apiNodeInfo.getMethod();
        String url = WfProcessUtils.removeVarSuffix((String)apiNodeInfo.getUrl());
        if (WfProcessUtils.isOAuth2Node((NoCodeWfNodeApiInvoke)apiNodeInfo)) {
            url = WfProcessUtils.removeVarSuffix((String)apiNodeInfo.getAccessTokenUrl());
        }
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            url = url.trim();
        }
        WfDesignerCtx ctx = WfDesignerCtxManager.use(this.getPageCache());
        Map<String, String> headers = this.getHeaders(apiNodeInfo, ctx, noCodeWfMetaData);
        RequestBody requestBody = apiNodeInfo.getRequestBody();
        int timeout = apiNodeInfo.getTimeout();
        boolean sslAuth = apiNodeInfo.isSslAuth();
        String queryNumber = apiNodeInfo.getQueryNumber();
        Instant startTime = Instant.now();
        WorkflowHttpResponse response = this.sendRequest(method, url, headers, requestBody, timeout * 1000, sslAuth);
        Instant endTime = Instant.now();
        double costSeconds = (double)Duration.between(startTime, endTime).toMillis() / 1000.0;
        WorkflowTestApiResponse testApiResponse = new WorkflowTestApiResponse();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(startTime, zoneId);
        WorkflowTestApiRequestInfo requestInfo = new WorkflowTestApiRequestInfo();
        requestInfo.setRequestTime(localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        requestInfo.setCost(String.valueOf(costSeconds));
        requestInfo.setStatusCode(response.getStatusCode());
        testApiResponse.setRequestInfo(requestInfo);
        Map originHeaders = response.getOriginHeaders();
        List header = originHeaders.entrySet().stream().map(e -> {
            String name = (String)e.getKey();
            Object value = e.getValue();
            String type = NcEntityTypeUtil.getText();
            return new NameValueTypePair(name, value == null ? "" : value.toString(), type);
        }).collect(Collectors.toList());
        testApiResponse.setHeader(header);
        String responseBody = response.getResponseBody();
        if (StringUtils.isBlank((CharSequence)responseBody)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SET_TEST_API, new Object[]{testApiResponse});
            return;
        }
        String responseBodyStr = responseBody.trim();
        Map<String, Object> bodyMap = WfConsts.ApiQueryNumberEnum.single.toString().equals(queryNumber) ? NoCodeWfDesignerPlugin.wrapSingleResult(responseBodyStr) : NoCodeWfDesignerPlugin.wrapMultiResult(responseBodyStr, apiNodeInfo.getMultiArgName());
        List body = bodyMap.entrySet().stream().map(e -> {
            String name = (String)e.getKey();
            Object value = e.getValue();
            String type = this.getValueType(value);
            if (value instanceof Collection || value instanceof Map) {
                value = SerializationUtils.toJsonString(value);
            }
            return new NameValueTypePair(name, value == null ? "" : value.toString(), type);
        }).collect(Collectors.toList());
        testApiResponse.setBody(body);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SET_TEST_API, new Object[]{testApiResponse});
    }

    private static String getErrorMessage(JSONObject errorObj) {
        Object o = errorObj.get((Object)"msg");
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof JSONObject) {
            return ((JSONObject)o).values().stream().map(JSONArray.class::cast).flatMap(Collection::stream).map(JSONObject.class::cast).map(e -> e.getString("msg")).filter(StringUtils::isNotBlank).collect(Collectors.joining("\uff0c"));
        }
        return o == null ? "" : o.toString();
    }

    private Map<String, String> getHeaders(NoCodeWfNodeApiInvoke apiNodeInfo, WfDesignerCtx ctx, NoCodeWfMetaData noCodeWfMetaData) {
        List requestHeader = apiNodeInfo.getRequestHeader();
        return requestHeader.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getName()) && StringUtils.isNotEmpty((CharSequence)e.getValue())).collect(Collectors.toMap(ParameterSetting::getName, settingItem -> this.parseVar(settingItem.getValue(), apiNodeInfo, ctx, noCodeWfMetaData)));
    }

    private String parseVar(String expression, NoCodeWfNodeApiInvoke apiNodeInfo, WfDesignerCtx ctx, NoCodeWfMetaData noCodeWfMetaData) {
        String parsedVar = ExpressDesignMetaHelper.tryMockAndParseExpression(expression, (NoCodeWfGraphCell)apiNodeInfo, ctx, noCodeWfMetaData);
        return WfProcessUtils.removeVarSuffix((String)parsedVar);
    }

    @NotNull
    private WorkflowHttpResponse sendRequest(String method, String url, Map<String, String> headers, RequestBody requestBody, int timeoutMillis, boolean sslAuth) {
        WorkflowHttpResponse workflowHttpResponse = new WorkflowHttpResponse();
        try {
            if (HttpMethodEnum.GET.toString().equalsIgnoreCase(method)) {
                workflowHttpResponse = WorkflowHttpClientUtils.get((String)url, headers, (int)timeoutMillis, (int)timeoutMillis, (boolean)sslAuth);
            } else if (HttpMethodEnum.POST.toString().equalsIgnoreCase(method)) {
                String enctype = requestBody.getEnctype();
                if (RequestBodyTypeEnum.json.toString().equalsIgnoreCase(enctype)) {
                    String json = WfProcessUtils.removeVarSuffix((String)requestBody.getJson());
                    workflowHttpResponse = WorkflowHttpClientUtils.postJson((String)url, headers, (String)json, (int)timeoutMillis, (int)timeoutMillis, (boolean)sslAuth);
                } else if (RequestBodyTypeEnum.formData.toString().equals(enctype)) {
                    List formDataList = requestBody.getFormData();
                    List formDataEntityList = formDataList.stream().map(e -> new WorkflowHttpClientUtils.FormDataEntity(e.getName(), WfProcessUtils.removeVarSuffix((String)e.getValue()))).collect(Collectors.toList());
                    workflowHttpResponse = WorkflowHttpClientUtils.postFormData((String)url, headers, formDataEntityList, (int)timeoutMillis, (int)timeoutMillis, (boolean)sslAuth);
                }
            }
        }
        catch (Exception e2) {
            log.debug("sendRequest Error: {}", (Object)e2.getMessage(), (Object)e2);
        }
        return workflowHttpResponse;
    }

    private String getValueType(Object value) {
        if (value instanceof String) {
            return ResManager.loadKDString((String)"\u6587\u672c", (String)"NoCodeWfDesignerPlugin_18", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]);
        }
        if (value instanceof Number) {
            return ResManager.loadKDString((String)"\u6570\u503c", (String)"NoCodeWfDesignerPlugin_19", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]);
        }
        if (value instanceof Collection) {
            return ResManager.loadKDString((String)"\u6570\u7ec4", (String)"NoCodeWfDesignerPlugin_20", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]);
        }
        if (value instanceof Map) {
            return ResManager.loadKDString((String)"\u5bf9\u8c61", (String)"NoCodeWfDesignerPlugin_21", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u6587\u672c", (String)"NoCodeWfDesignerPlugin_18", (String)BOS_NOCODE_FORMPLUGIN, (Object[])new Object[0]);
    }

    private static Map<String, Object> wrapMultiResult(String responseBodyStr, String multiArgName) {
        Map bodyMap = new HashMap(16);
        try {
            if (StringUtils.isEmpty((CharSequence)multiArgName)) {
                if (responseBodyStr.startsWith("[")) {
                    List items = SerializationUtils.fromJsonStringToList((String)responseBodyStr, Map.class);
                    if (CollectionUtils.isNotEmpty((Collection)items)) {
                        bodyMap = (Map)items.get(0);
                    }
                } else {
                    bodyMap = WfProcessUtils.buildErrorBodyMap((String)responseBodyStr);
                }
            } else {
                Object data = NoCodeWfDesignerPlugin.getMultiArgData((Map)SerializationUtils.fromJsonString((String)responseBodyStr, Map.class), multiArgName);
                if (data instanceof List) {
                    List rows = (List)data;
                    if (CollectionUtils.isNotEmpty((Collection)rows)) {
                        bodyMap = (Map)rows.get(0);
                    }
                } else {
                    bodyMap = WfProcessUtils.buildErrorBodyMap((String)responseBodyStr);
                }
            }
        }
        catch (Exception e) {
            bodyMap = WfProcessUtils.buildErrorBodyMap((String)responseBodyStr);
            log.debug("wrapSingleResult: {}", (Object)e.getMessage(), (Object)e);
        }
        return bodyMap;
    }

    private static Map<String, Object> wrapSingleResult(String responseBodyStr) {
        Map bodyMap;
        try {
            bodyMap = responseBodyStr.startsWith("{") ? (Map)SerializationUtils.fromJsonString((String)responseBodyStr, Map.class) : WfProcessUtils.buildErrorBodyMap((String)responseBodyStr);
        }
        catch (Exception e) {
            bodyMap = WfProcessUtils.buildErrorBodyMap((String)responseBodyStr);
            log.debug("wrapSingleResult error: {}", (Object)e.getMessage(), (Object)e);
        }
        return bodyMap;
    }

    private static Object getMultiArgData(Map<String, Object> data, String multiArgName) {
        Object value;
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        context.getVariableMapper().setVariable(DATA, factory.createValueExpression(data, Object.class));
        try {
            ValueExpression expression = factory.createValueExpression((ELContext)context, String.format("${data.%s}", multiArgName), Object.class);
            value = expression.getValue((ELContext)context);
        }
        catch (Throwable e) {
            log.debug("getMultiArgData Error: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        return value;
    }

    public void getNoCodeIpList() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SET_NOCODE_IP_LIST, new Object[]{"123.59.59.220,106.75.74.26,106.75.14.110"});
    }
}

