/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.convert;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfEdge;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfGraphCell;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeApiInvoke;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeAudit;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeCalculate;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeCustomJson;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeEnd;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeGateway;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeJudge;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeNewBill;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeNotify;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeQueryData;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeStart;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeUpdateBill;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeUserInput;
import kd.bos.nocode.wf.designer.convert.IWfModelConvert;
import kd.bos.nocode.wf.designer.convert.edge.WfModelSequenceEdgeConvert;
import kd.bos.nocode.wf.designer.convert.node.NoCodeWfNodeApiInvokeConvert;
import kd.bos.nocode.wf.designer.convert.node.WfModelAuditConvert;
import kd.bos.nocode.wf.designer.convert.node.WfModelCalculateConvert;
import kd.bos.nocode.wf.designer.convert.node.WfModelCommonConvert;
import kd.bos.nocode.wf.designer.convert.node.WfModelCustomJsonConvert;
import kd.bos.nocode.wf.designer.convert.node.WfModelEndConvert;
import kd.bos.nocode.wf.designer.convert.node.WfModelGatewayConvert;
import kd.bos.nocode.wf.designer.convert.node.WfModelJudgeConvert;
import kd.bos.nocode.wf.designer.convert.node.WfModelNewBillConvert;
import kd.bos.nocode.wf.designer.convert.node.WfModelNotifyConvert;
import kd.bos.nocode.wf.designer.convert.node.WfModelQueryDataConvert;
import kd.bos.nocode.wf.designer.convert.node.WfModelStartConvert;
import kd.bos.nocode.wf.designer.convert.node.WfModelUpdateBillConvert;
import kd.bos.nocode.wf.designer.convert.node.WfModelUserInputConvert;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.helper.WfModelIteratorHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WfModelConvert {
    public static void fixupOutParams(WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        Iterator<NoCodeWfGraphCell> iterator = WfModelIteratorHelper.getIterator(ncMetaData, ctx);
        while (iterator.hasNext()) {
            NoCodeWfGraphCell next = iterator.next();
            IWfModelConvert convert = WfModelConvert.getConvert(ctx, next, ncMetaData);
            convert.onFixupOutParams(next);
        }
    }

    public static void onAfterLoad(WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        Iterator<NoCodeWfGraphCell> iterator = WfModelIteratorHelper.getIterator(ncMetaData, ctx);
        while (iterator.hasNext()) {
            NoCodeWfGraphCell next = iterator.next();
            IWfModelConvert convert = WfModelConvert.getConvert(ctx, next, ncMetaData);
            convert.onAfterLoad(next);
        }
    }

    public static void onBeforeSave(WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData, NoCodeWfMetaData oldNcMetaData) {
        Iterator<NoCodeWfGraphCell> iterator = WfModelIteratorHelper.getIterator(ncMetaData, ctx);
        while (iterator.hasNext()) {
            NoCodeWfGraphCell node = iterator.next();
            IWfModelConvert convert = WfModelConvert.getConvert(ctx, node, ncMetaData);
            if (oldNcMetaData != null) {
                Iterator<NoCodeWfGraphCell> iteratorOld = WfModelIteratorHelper.getIterator(oldNcMetaData, ctx);
                NoCodeWfGraphCell oldNode = null;
                while (iteratorOld.hasNext()) {
                    NoCodeWfGraphCell oldNext = iteratorOld.next();
                    if (!node.getId().equalsIgnoreCase(oldNext.getId())) continue;
                    oldNode = oldNext;
                    break;
                }
                convert.onBeforeSave(node, oldNode);
                continue;
            }
            convert.onBeforeSave(node, null);
        }
        WfModelConvert.setNeedPublishNewVersionIfNecessary(ncMetaData, oldNcMetaData);
        WfModelConvert.removeUnUserNodeError(ctx, ncMetaData);
        WfModelConvert.removeUnUserNodeVariables(ctx, ncMetaData);
    }

    private static void setNeedPublishNewVersionIfNecessary(@NotNull NoCodeWfMetaData ncMetaData, @Nullable NoCodeWfMetaData oldNcMetaData) {
        Optional<NoCodeWfMetaData> oldNcMetaDataOp = Optional.ofNullable(oldNcMetaData);
        String oldProcessName = oldNcMetaDataOp.map(NoCodeWfMetaData::getName).orElse("");
        boolean isNeedPublishNewVersion = ncMetaData.isNeedPublishNewVersion();
        if (WfModelConvert.onlyExistStartNodeAndEndNode(ncMetaData, oldNcMetaData)) {
            isNeedPublishNewVersion = false;
        } else if (!ncMetaData.getName().equalsIgnoreCase(oldProcessName)) {
            isNeedPublishNewVersion = true;
        } else if (!isNeedPublishNewVersion && WfModelConvert.isDiff(ncMetaData, oldNcMetaData)) {
            isNeedPublishNewVersion = true;
        }
        ncMetaData.setNeedPublishNewVersion(isNeedPublishNewVersion);
    }

    private static boolean onlyExistStartNodeAndEndNode(@NotNull NoCodeWfMetaData ncMetaData, @Nullable NoCodeWfMetaData oldNcMetaData) {
        long oldBusinessNodeCount;
        long businessNodeCount = ncMetaData.getNodes().stream().filter(WfModelConvert::isNotStartNodeAndEndNode).count();
        return businessNodeCount == (oldBusinessNodeCount = Optional.ofNullable(oldNcMetaData).map(NoCodeWfMetaData::getNodes).map(Collection::stream).map(e -> e.filter(WfModelConvert::isNotStartNodeAndEndNode).count()).orElse(0L).longValue()) && businessNodeCount == 0L;
    }

    private static boolean isNotStartNodeAndEndNode(NoCodeWfNode node) {
        return !(node instanceof NoCodeWfNodeStart) && !(node instanceof NoCodeWfNodeEnd);
    }

    private static boolean isDiff(NoCodeWfMetaData ncMetaData, NoCodeWfMetaData oldNcMetaData) {
        if (ncMetaData.isNeedPublishNewVersion()) {
            return true;
        }
        if (ncMetaData == null || oldNcMetaData == null) {
            return true;
        }
        HashSet newCells = new HashSet();
        newCells.addAll(ncMetaData.getNodes().stream().map(NoCodeWfGraphCell::getId).collect(Collectors.toList()));
        HashSet oldCells = new HashSet();
        oldCells.addAll(oldNcMetaData.getNodes().stream().map(NoCodeWfGraphCell::getId).collect(Collectors.toList()));
        Sets.SetView difference = Sets.difference(newCells, oldCells);
        return !difference.isEmpty();
    }

    private static void removeUnUserNodeError(WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        HashSet errorNodeIds = new HashSet();
        errorNodeIds.addAll(ctx.getErrors().keySet());
        errorNodeIds.removeAll(ncMetaData.getNodes().stream().map(n -> n.getId()).collect(Collectors.toList()));
        while (!errorNodeIds.isEmpty()) {
            String theId = (String)errorNodeIds.iterator().next();
            ctx.getErrors().remove((Object)theId);
            errorNodeIds.remove(theId);
        }
    }

    private static void removeUnUserNodeVariables(WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        HashSet varNodeIds = new HashSet();
        varNodeIds.addAll(ctx.getVariables().keySet());
        varNodeIds.removeAll(ncMetaData.getNodes().stream().map(n -> n.getId()).collect(Collectors.toList()));
        while (!varNodeIds.isEmpty()) {
            String theId = (String)varNodeIds.iterator().next();
            ctx.getVariables().remove((Object)theId);
            varNodeIds.remove(theId);
        }
    }

    private static IWfModelConvert getConvert(WfDesignerCtx ctx, NoCodeWfGraphCell node, NoCodeWfMetaData ncMetaData) {
        if (node == null) {
            throw new KDBizException("no convert");
        }
        if (node instanceof NoCodeWfNodeStart) {
            return new WfModelStartConvert(ctx, ncMetaData);
        }
        if (node instanceof NoCodeWfEdge) {
            return new WfModelSequenceEdgeConvert(ctx, ncMetaData);
        }
        if (node instanceof NoCodeWfNodeNotify) {
            return new WfModelNotifyConvert(ctx, ncMetaData);
        }
        if (node instanceof NoCodeWfNodeEnd) {
            return new WfModelEndConvert(ctx, ncMetaData);
        }
        if (node instanceof NoCodeWfNodeAudit) {
            return new WfModelAuditConvert(ctx, ncMetaData);
        }
        if (node instanceof NoCodeWfNodeCalculate) {
            return new WfModelCalculateConvert(ctx, ncMetaData);
        }
        if (node instanceof NoCodeWfNodeUpdateBill) {
            return new WfModelUpdateBillConvert(ctx, ncMetaData);
        }
        if (node instanceof NoCodeWfNodeNewBill) {
            return new WfModelNewBillConvert(ctx, ncMetaData);
        }
        if (node instanceof NoCodeWfNodeQueryData) {
            return new WfModelQueryDataConvert(ctx, ncMetaData);
        }
        if (node instanceof NoCodeWfNodeGateway) {
            return new WfModelGatewayConvert(ctx, ncMetaData);
        }
        if (node instanceof NoCodeWfNodeJudge) {
            return new WfModelJudgeConvert(ctx, ncMetaData);
        }
        if (node instanceof NoCodeWfNodeUserInput) {
            return new WfModelUserInputConvert(ctx, ncMetaData);
        }
        if (node instanceof NoCodeWfNodeApiInvoke) {
            return new NoCodeWfNodeApiInvokeConvert(ctx, ncMetaData);
        }
        if (node instanceof NoCodeWfNodeCustomJson) {
            return new WfModelCustomJsonConvert(ctx, ncMetaData);
        }
        return new WfModelCommonConvert(ctx, ncMetaData);
    }
}

