/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.convert.node;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.message.api.MessageChannels;
import kd.bos.nocode.constant.WfTaskActionEnum;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.info.MsgItem;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeAudit;
import kd.bos.nocode.restapi.api.model.DecisionOption;
import kd.bos.nocode.wf.designer.convert.node.AbstractWfModelNodeConvert;
import kd.bos.nocode.wf.designer.helper.ParticipantHelper;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.pojo.WfAuditTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class WfModelAuditConvert
extends AbstractWfModelNodeConvert<NoCodeWfNodeAudit> {
    public WfModelAuditConvert(WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        super(ctx, ncMetaData);
    }

    @Override
    protected NoCodeWfNodeAudit convertTo_CreateNode() {
        return new NoCodeWfNodeAudit();
    }

    @Override
    protected boolean convertTo_disp(NoCodeWfNodeAudit node, NoCodeWfNodeAudit disp) {
        disp.setParticipant(node.getParticipant());
        return true;
    }

    @Override
    protected boolean isNeedPublishNewVersion(NoCodeWfNodeAudit node, NoCodeWfNodeAudit oldNode) {
        if (oldNode == null || node == null) {
            return true;
        }
        if (!StringUtils.equals((CharSequence)node.getTaskSubject(), (CharSequence)oldNode.getTaskSubject())) {
            return true;
        }
        if (this.isDiffMsgItem(node.getNotifyApproverMsg(), oldNode.getNotifyApproverMsg())) {
            return true;
        }
        if (ParticipantHelper.isDiff((NoCodeWfNode)node, node.getParticipant(), (NoCodeWfNode)oldNode, oldNode.getParticipant(), this.ctx, this.ncMetaData)) {
            return true;
        }
        return this.isDiffDecisionOptions(node.getDecisionOptions(), oldNode.getDecisionOptions());
    }

    @Override
    public void onBeforeSave(NoCodeWfNodeAudit node, NoCodeWfNodeAudit oldNode) {
        List decisionOptions = node.getDecisionOptions();
        if (CollectionUtils.isNotEmpty((Collection)decisionOptions)) {
            decisionOptions.forEach(e -> {
                if (StringUtils.isEmpty((CharSequence)e.getAuditType())) {
                    e.setAuditType(WfAuditTypeEnum.APPROVE.toString());
                }
                if (e.isTerminateFlow()) {
                    e.setAuditType(WfAuditTypeEnum.TERMINATE.toString());
                } else {
                    e.setAuditType(WfAuditTypeEnum.APPROVE.toString());
                }
                e.setNotifyType(MessageChannels.MC.getNumber());
                e.setMessage(VariableHelper.replaceAssigneeVar2Name(e.getMessage()));
            });
        }
        this.addDefaultRejectDecisionOption(node);
        this.addDefaultRejectDecisionOption(oldNode);
        if (StringUtils.isNotBlank((CharSequence)node.getTaskSubject())) {
            node.setTaskSubject(VariableHelper.replaceAssigneeVar2Name(node.getTaskSubject()));
        }
        if (node.getNotifyApproverMsg() != null) {
            node.getNotifyApproverMsg().setContent(VariableHelper.replaceAssigneeVar2Name(node.getNotifyApproverMsg().getContent()));
        }
        super.onBeforeSave(node, oldNode);
    }

    private void addDefaultRejectDecisionOption(NoCodeWfNodeAudit node) {
        Optional.ofNullable(node).map(NoCodeWfNodeAudit::getDecisionOptions).ifPresent(decisionOptions -> {
            DecisionOption rejectOption = new DecisionOption();
            rejectOption.setNumber(WfTaskActionEnum.Reject.toString());
            rejectOption.setName(ResManager.loadKDString((String)"\u9a73\u56de", (String)"WfModelAuditConvert_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
            rejectOption.setAuditType(WfAuditTypeEnum.REJECT.toString());
            rejectOption.setDefaultDecision(false);
            rejectOption.setAuditMessageMustInput(false);
            rejectOption.setTerminateFlow(false);
            rejectOption.setSendMessage(false);
            rejectOption.setMessage("");
            rejectOption.setNotifyType(MessageChannels.MC.getNumber());
            decisionOptions.add(rejectOption);
        });
    }

    private boolean isDiffMsgItem(MsgItem newItem, MsgItem oldItem) {
        if (newItem == null && oldItem == null) {
            return false;
        }
        if (newItem == null || oldItem == null) {
            return true;
        }
        if (newItem.isCheck() != oldItem.isCheck()) {
            return true;
        }
        return !StringUtils.equals((CharSequence)newItem.getContent(), (CharSequence)oldItem.getContent());
    }

    private boolean isDiffDecisionOptions(List<DecisionOption> decisionOptions, List<DecisionOption> oldDecisionOptions) {
        return !decisionOptions.equals(oldDecisionOptions);
    }
}

