/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.convert.node;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.nodes.IHasFormId;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.AutoService;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.InParam;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.NoCodeWfNodeAutoMicroSrv;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.OutParam;
import kd.bos.nocode.ext.util.WfFieldTypeUtils;
import kd.bos.nocode.utils.FieldTreeBuilder;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.ShowColumnInfo;
import kd.bos.nocode.wf.NoCodeWfService;
import kd.bos.nocode.wf.designer.convert.node.AbstractWfModelNodeConvert;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import org.jetbrains.annotations.NotNull;

public abstract class WfModelAutoMicroServiceConvert<T extends NoCodeWfNodeAutoMicroSrv>
extends AbstractWfModelNodeConvert<T> {
    private static final Log log = LogFactory.getLog(WfModelAutoMicroServiceConvert.class);

    public WfModelAutoMicroServiceConvert(WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        super(ctx, ncMetaData);
    }

    @Override
    public void onFixupOutParams(T node) {
        if (this.needFixupOutParams(node)) {
            node.getOutParams().clear();
            this.genOutParams(node, node);
        }
    }

    protected boolean needFixupOutParams(T node) {
        if (node.getOutParams().isEmpty()) {
            return false;
        }
        return node.getOutParams().stream().anyMatch(o -> o.getType() != null && o.getOption().isEmpty() && (o.getType().startsWith("combo") || o.getType().equalsIgnoreCase("refbill") || o.getType().equalsIgnoreCase("user") || o.getType().equalsIgnoreCase("org")));
    }

    @Override
    public void onAfterLoad(T node) {
        super.onAfterLoad(node);
        this.fixupOutParams(node);
    }

    protected void fixupOutParams(T node) {
        boolean needFixup;
        if (!node.getOutParams().isEmpty() && (needFixup = node.getOutParams().stream().anyMatch(p -> {
            log.debug("p: {}", (Object)SerializationUtils.toJsonString((Object)p));
            return Objects.nonNull(p) && Objects.nonNull(p.getType()) && (p.getType().startsWith("combo") || "refbill".equalsIgnoreCase(p.getType()));
        }))) {
            node.getOutParams().clear();
            this.genOutParams(node, node);
        }
    }

    @Override
    public void onBeforeSave(T node, T oldNode) {
        super.onBeforeSave(node, oldNode);
        this.genAutoService(node, oldNode);
        node.getInParams().clear();
        this.genInParams(node, oldNode);
        node.getOutParams().clear();
        this.genOutParams(node, oldNode);
    }

    protected void genAutoService(T node, T oldNode) {
        AutoService autoService = node.getAutoService();
        autoService.setCloudId("bos");
        autoService.setAppId("nocode");
        autoService.setServiceName(NoCodeWfService.class.getSimpleName());
    }

    protected abstract void genInParams(T var1, T var2);

    protected abstract void genOutParams(T var1, T var2);

    protected void genMultiQueryDataOutParam(List<OutParam> outParams, String title, IHasFormId hasFormIdNode) {
        OutParam outParamQueryDataSet = new OutParam();
        outParamQueryDataSet.setName(title);
        outParamQueryDataSet.setNumber("QueryDataSet");
        outParamQueryDataSet.setType(WfModelAutoMicroServiceConvert.getMultiQueryDataVarType(hasFormIdNode));
        String formId = hasFormIdNode.getTargetFormId();
        if (StringUtils.isNotEmpty((CharSequence)formId)) {
            FieldTreeBuilder fieldTreeBuilder = new FieldTreeBuilder(formId);
            List showColumnInfos = fieldTreeBuilder.withoutFieldTypes(new FieldTreeBuilder.FieldType[]{FieldTreeBuilder.FieldType.NoCodeRichTextField, FieldTreeBuilder.FieldType.NoCodeGraphicDisplayField, FieldTreeBuilder.FieldType.NoCodeAttachmentUploadField, FieldTreeBuilder.FieldType.NoCodeImageUploadField, FieldTreeBuilder.FieldType.NoCodeBillNoField, FieldTreeBuilder.FieldType.EntryField}).build();
            String displayProps = showColumnInfos.stream().limit(5L).map(ShowColumnInfo::getId).collect(Collectors.joining(","));
            outParamQueryDataSet.getOption().put("displayProp", displayProps);
            outParams.add(outParamQueryDataSet);
            outParams.add(this.addRefBillIdOutParam(outParamQueryDataSet, Boolean.TRUE));
        }
    }

    @NotNull
    private static String getMultiQueryDataVarType(IHasFormId hasFormIdNode) {
        String resultVarType = "refbill";
        if (Objects.equals(hasFormIdNode.getTargetFormId(), "bos_user")) {
            resultVarType = "user";
        } else if (Objects.equals(hasFormIdNode.getTargetFormId(), "bos_adminorg")) {
            resultVarType = "org";
        }
        return resultVarType;
    }

    protected OutParam addPkIdOutParam(List<OutParam> outParams, String formId) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return null;
        }
        BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)formId);
        if (dt != null) {
            OutParam pkIdOutParam = new OutParam();
            ISimpleProperty primaryKey = dt.getPrimaryKey();
            pkIdOutParam.setNumber(primaryKey.getName());
            pkIdOutParam.setName(primaryKey.getDisplayName() == null ? ResManager.loadKDString((String)"\u5185\u7801", (String)"WfModelAutoMicroServiceConvert_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]) : primaryKey.getDisplayName().toString());
            pkIdOutParam.setType("pk");
            pkIdOutParam.getOption().put("ownerFormId", formId);
            outParams.add(pkIdOutParam);
            return pkIdOutParam;
        }
        return null;
    }

    protected boolean isRefBill(String dataType) {
        return WfFieldTypeUtils.isRefBill((String)dataType);
    }

    protected OutParam addRefBillIdOutParam(OutParam outParam, boolean isMulti) {
        OutParam refId = new OutParam();
        refId.setNumber(outParam.getNumber() + "_id");
        refId.setName("visible");
        refId.setType("pk");
        refId.getOption().put("visible", false);
        refId.getOption().put("multiPk", isMulti);
        return refId;
    }

    protected String prepareExrpess(String expression, String dataType) {
        if (StringUtils.isBlank((CharSequence)expression) || StringUtils.isBlank((CharSequence)dataType)) {
            return expression;
        }
        CharSequence[] split = expression.split("@@");
        String realExpression = split[0].trim();
        if (this.isRefBill(dataType)) {
            if (WfConsts.varModelPattern.matcher(realExpression).find() && !WfConsts.varModelWithIdPattern.matcher(realExpression).find()) {
                realExpression = realExpression.replaceAll("(\\$\\{model\\..+?)(\\})", "$1.id$2");
            }
            if (WfConsts.varProcPattern.matcher(realExpression).find() && !WfConsts.varProcPattern_ASSIGNEE.matcher(realExpression).find() && !WfConsts.varProcWithIdPattern.matcher(realExpression).find()) {
                realExpression = realExpression.replaceAll("(\\$\\{proc\\..+?)(\\})", "$1_id$2");
            }
            split[0] = realExpression;
            expression = String.join((CharSequence)"@@", split);
        } else if ("text".equalsIgnoreCase(dataType)) {
            if (WfConsts.VAR_DISP_PATTERN.matcher(realExpression).find() && !WfConsts.VAR_DISP_PATTERN_WITH_USESTRFORMAT.matcher(realExpression).find()) {
                realExpression = realExpression.replaceAll("(disp\\(.+?)(\\))", "$1,'#useStrFormat'$2");
                split[0] = realExpression;
            }
            if (realExpression.indexOf("+") != -1 && realExpression.indexOf("\"") != -1 && WfConsts.varProcPattern.matcher(realExpression).find()) {
                CharSequence[] split1 = realExpression.split("\\+");
                for (int i = 0; i < split1.length; ++i) {
                    String proc = split1[i];
                    if (proc.trim().startsWith("\"") || proc.trim().startsWith("'") || !WfConsts.varProcPattern.matcher(split1[i]).find()) continue;
                    split1[i] = "\"" + proc + "\"";
                }
                split[0] = String.join((CharSequence)"+", split1);
            }
            expression = String.join((CharSequence)"@@", split);
        }
        return expression;
    }

    protected void addEntityNumberAndBusinessKeyParam(List<InParam> params) {
        InParam entityNumberParam = new InParam();
        entityNumberParam.setNumber("entityNumber");
        entityNumberParam.setValue((Object)String.format("${execution.%s}", "entityNumber"));
        params.add(entityNumberParam);
        InParam businessKeyParam = new InParam();
        businessKeyParam.setNumber("businessKey");
        businessKeyParam.setValue((Object)String.format("${execution.%s}", "businessKey"));
        params.add(businessKeyParam);
    }
}

