/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.convert.node;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaHelper;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.info.CalcSettingItem;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeCalculate;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeStart;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.AssignmentInfo;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.AutoService;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.InParam;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.InParams;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.OutParam;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.wf.designer.convert.node.WfModelAutoMicroServiceConvert;
import kd.bos.nocode.wf.designer.helper.AssignmentHelper;
import kd.bos.nocode.wf.designer.helper.ExpressDesignMetaHelper;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;

public class WfModelCalculateConvert
extends WfModelAutoMicroServiceConvert<NoCodeWfNodeCalculate> {
    public WfModelCalculateConvert(WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        super(ctx, ncMetaData);
    }

    @Override
    protected NoCodeWfNodeCalculate convertTo_CreateNode() {
        return new NoCodeWfNodeCalculate();
    }

    @Override
    protected boolean convertTo_disp(NoCodeWfNodeCalculate node, NoCodeWfNodeCalculate disp) {
        disp.setDocumentation(node.getDocumentation());
        List setting = node.getSetting();
        if (setting != null && !setting.isEmpty()) {
            ArrayList<CalcSettingItem> dispSetting = new ArrayList<CalcSettingItem>(setting.size());
            for (CalcSettingItem calcSettingItem : setting) {
                CalcSettingItem item = new CalcSettingItem();
                String expression = calcSettingItem.getExpression();
                if (calcSettingItem.isUpdateModel()) {
                    String assignmentTarget = calcSettingItem.getAssignment();
                    JSONObject varItem = VariableHelper.findVariable(node.getId(), assignmentTarget, this.ctx.getVariables(), this.ncMetaData, this.ctx);
                    if (varItem != null && !varItem.isEmpty()) {
                        String captionFromVars = (String)varItem.get((Object)"title");
                        item.setAssignment(captionFromVars);
                        String varType = (String)varItem.get((Object)"type");
                        if (this.isRefBill(varType) && StringUtils.isNotBlank((CharSequence)expression) && !ExpressDesignMetaHelper.isNeedCallExpressParse(expression)) {
                            Map option = (Map)varItem.get((Object)"option");
                            if (option != null) {
                                String entityId = (String)option.get("billEntityId");
                                String dispPropName = (String)option.get("displayProp");
                                if (StringUtils.isNotBlank((CharSequence)dispPropName)) {
                                    dispPropName = dispPropName.split(",")[0];
                                }
                                expression = NcEntityTypeUtil.getBillCaption((String)entityId, (Object)expression, (String)dispPropName);
                            } else {
                                logger.debug("WfModelCalculateConvert.convertTo_disp option is null");
                            }
                        }
                    }
                    item.setExpression(expression);
                } else {
                    item.setAssignment(calcSettingItem.getCustomVarName());
                }
                dispSetting.add(item);
            }
            disp.setSetting(dispSetting);
        }
        return true;
    }

    @Override
    protected boolean isNeedPublishNewVersion(NoCodeWfNodeCalculate node, NoCodeWfNodeCalculate oldNode) {
        String oldSetting;
        if (oldNode == null || node == null) {
            return true;
        }
        String newSetting = SerializationUtils.toJsonString((Object)node.getSetting());
        return !StringUtils.equals((CharSequence)newSetting, (CharSequence)(oldSetting = SerializationUtils.toJsonString((Object)oldNode.getSetting())));
    }

    @Override
    protected void genAutoService(NoCodeWfNodeCalculate node, NoCodeWfNodeCalculate oldNode) {
        super.genAutoService(node, oldNode);
        AutoService autoService = node.getAutoService();
        autoService.setMethodName("calc");
    }

    @Override
    protected void genInParams(NoCodeWfNodeCalculate node, NoCodeWfNodeCalculate oldNode) {
        List result = node.getInParams();
        List setting = node.getSetting();
        if (setting != null && !setting.isEmpty()) {
            for (CalcSettingItem calcSettingItem : setting) {
                InParams inParams = new InParams();
                ArrayList<InParam> params = new ArrayList<InParam>(10);
                InParam formIdInParam = new InParam();
                formIdInParam.setNumber("formId");
                formIdInParam.setValue((Object)this.getModelFormId());
                params.add(formIdInParam);
                InParam businessKeyParam = new InParam();
                businessKeyParam.setNumber("businessKey");
                businessKeyParam.setValue((Object)String.format("${execution.%s}", "businessKey"));
                params.add(businessKeyParam);
                String expression = calcSettingItem.getExpression();
                if (calcSettingItem.isUpdateModel()) {
                    InParam assignmentParam = new InParam();
                    AssignmentInfo assignmentInfo = AssignmentHelper.getAssignmentFieldInfoByCalc(calcSettingItem, this.ncMetaData);
                    if (assignmentInfo == null) continue;
                    assignmentParam.setNumber(assignmentInfo.getNumber());
                    assignmentParam.setValue(assignmentInfo.getValue());
                    expression = this.prepareExrpess(expression, assignmentInfo.getType());
                    params.add(assignmentParam);
                }
                InParam expressionInParam = new InParam();
                expressionInParam.setNumber("expression");
                expressionInParam.setValue((Object)expression);
                params.add(expressionInParam);
                inParams.setParams(params);
                result.add(inParams);
            }
        }
    }

    @Override
    protected void genOutParams(NoCodeWfNodeCalculate node, NoCodeWfNodeCalculate oldNode) {
        List outParams = node.getOutParams();
        List setting = node.getSetting();
        if (setting != null && !setting.isEmpty()) {
            for (CalcSettingItem calcSettingItem : setting) {
                OutParam outParam;
                if (calcSettingItem.isUpdateModel()) {
                    outParam = this.setupUpdateModelOutParam(node, calcSettingItem);
                    if (outParam == null) continue;
                    outParams.add(outParam);
                    if (!this.isRefBill(outParam.getType())) continue;
                    outParams.add(this.addRefBillIdOutParam(outParam, false));
                    continue;
                }
                outParam = new OutParam();
                outParam.setNumber(calcSettingItem.getAssignment() + "_" + calcSettingItem.getCalcId());
                outParam.setName(calcSettingItem.getCustomVarName());
                WfConsts.CustomVarTypeEnum customVarType = WfConsts.CustomVarTypeEnum.getByCode((String)calcSettingItem.getCustomVarType());
                outParam.setType(customVarType.getCode());
                outParams.add(outParam);
                if (!this.isRefBill(outParam.getType())) continue;
                outParams.add(this.addRefBillIdOutParam(outParam, false));
            }
        }
    }

    @Override
    protected boolean needFixupOutParams(NoCodeWfNodeCalculate node) {
        return true;
    }

    private String getModelFormId() {
        NoCodeWfNodeStart startNode = NoCodeWfMetaHelper.getStartNode((NoCodeWfMetaData)this.ncMetaData);
        return startNode.getFormId();
    }

    protected OutParam setupUpdateModelOutParam(NoCodeWfNodeCalculate node, CalcSettingItem calcSettingItem) {
        String assignment = calcSettingItem.getAssignment();
        if (StringUtils.isBlank((CharSequence)assignment)) {
            return null;
        }
        AssignmentInfo assignmentInfo = AssignmentHelper.getAssignmentFieldInfoByCalc(calcSettingItem, this.ncMetaData);
        if (assignmentInfo == null && !WfConsts.varProcPattern.matcher(assignment).matches()) {
            return null;
        }
        if (assignmentInfo == null && WfConsts.varProcPattern.matcher(assignment).matches()) {
            JSONObject variable = VariableHelper.findVariable(node.getId(), calcSettingItem.getAssignment(), this.ctx.getVariables(), this.ncMetaData, this.ctx);
            if (variable == null) {
                return null;
            }
            OutParam outParam = new OutParam();
            outParam.setNumber(assignment);
            outParam.setName((String)variable.get((Object)"title"));
            outParam.setType((String)variable.get((Object)"type"));
            outParam.setAssignment(assignment);
            return outParam;
        }
        if (assignmentInfo == null) {
            return null;
        }
        OutParam outParam = new OutParam();
        outParam.setNumber(assignmentInfo.getNumber());
        outParam.setName(assignmentInfo.getName());
        outParam.setType(assignmentInfo.getType());
        String toUpdate = calcSettingItem.getAssignment();
        this.ctx.addUpdateAssignment(outParam, (NoCodeWfNode)node, toUpdate);
        outParam.setAssignment(this.ctx.getCascadeUpdateAssignment(toUpdate));
        outParam.setOption(assignmentInfo.getOption());
        return outParam;
    }
}

