/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.convert.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.info.CustomJsonRow;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeCustomJson;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.AutoService;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.InParam;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.InParams;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.OutParam;
import kd.bos.nocode.utils.JsonVarHelper;
import kd.bos.nocode.wf.designer.convert.node.WfModelAutoMicroServiceConvert;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class WfModelCustomJsonConvert
extends WfModelAutoMicroServiceConvert<NoCodeWfNodeCustomJson> {
    public WfModelCustomJsonConvert(WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        super(ctx, ncMetaData);
    }

    @Override
    protected boolean convertTo_disp(NoCodeWfNodeCustomJson node, NoCodeWfNodeCustomJson disp) {
        return true;
    }

    @Override
    protected boolean isNeedPublishNewVersion(NoCodeWfNodeCustomJson node, NoCodeWfNodeCustomJson oldNode) {
        if (oldNode == null || node == null) {
            return true;
        }
        String s1 = SerializationUtils.toJsonString((Object)node.getSourceData());
        String s2 = SerializationUtils.toJsonString((Object)oldNode.getSourceData());
        return Objects.equals(s1, s2);
    }

    @Override
    protected NoCodeWfNodeCustomJson convertTo_CreateNode() {
        return new NoCodeWfNodeCustomJson();
    }

    @Override
    protected void genInParams(NoCodeWfNodeCustomJson node, NoCodeWfNodeCustomJson oldNode) {
        List result = node.getInParams();
        InParams inParams = new InParams();
        ArrayList<InParam> params = new ArrayList<InParam>(10);
        inParams.setParams(params);
        result.add(inParams);
        InParam sourceDataParam = new InParam();
        sourceDataParam.setNumber("sourceData");
        List rowList = node.getCustomJsonRowList();
        this.saveValueVarKeyToConfig(rowList);
        String sourceDataStr = SerializationUtils.toJsonString((Object)rowList);
        sourceDataParam.setValue((Object)JsonVarHelper.replaceProcVar2JsonVar((String)sourceDataStr));
        params.add(sourceDataParam);
        InParam sourceDataJsonVarParam = new InParam();
        sourceDataJsonVarParam.setNumber("sourceDataJsonVar");
        sourceDataJsonVarParam.setValue((Object)JsonVarHelper.extractJsonVar((String)sourceDataStr));
        params.add(sourceDataJsonVarParam);
        this.addEntityNumberAndBusinessKeyParam(params);
    }

    private void saveValueVarKeyToConfig(List<CustomJsonRow> rowList) {
        for (CustomJsonRow customJsonRow : rowList) {
            if (CustomJsonRow.ValueTypeEnum.var.toString().equals(customJsonRow.getValue().getType())) {
                String parentKey = customJsonRow.getValue().getConfig().getParentKey();
                customJsonRow.getValue().getConfig().setParentKey(WfModelCustomJsonConvert.replaceProcVariableIdentifier(parentKey));
                String valueVarKey = customJsonRow.getValue().getValue();
                customJsonRow.getValue().getConfig().setValueVarKey(WfModelCustomJsonConvert.replaceProcVariableIdentifier(valueVarKey));
            }
            if (!CollectionUtils.isNotEmpty((Collection)customJsonRow.getChildren())) continue;
            this.saveValueVarKeyToConfig(customJsonRow.getChildren());
        }
    }

    private static String replaceProcVariableIdentifier(String varKey) {
        return StringUtils.isBlank((CharSequence)varKey) ? "" : varKey.replace("${proc.", "${varKey.");
    }

    @Override
    protected void genOutParams(NoCodeWfNodeCustomJson node, NoCodeWfNodeCustomJson oldNode) {
        List outParams = node.getOutParams();
        OutParam customJsonParam = new OutParam();
        customJsonParam.setName(WfConsts.getCustomJsonName());
        customJsonParam.setNumber("CustomJson");
        customJsonParam.setType("text");
        outParams.add(customJsonParam);
    }

    @Override
    public void onBeforeSave(NoCodeWfNodeCustomJson node, NoCodeWfNodeCustomJson oldNode) {
        super.onBeforeSave(node, oldNode);
    }

    @Override
    protected void genAutoService(NoCodeWfNodeCustomJson node, NoCodeWfNodeCustomJson oldNode) {
        super.genAutoService(node, oldNode);
        AutoService autoService = node.getAutoService();
        autoService.setMethodName(WfConsts.AutoServiceMethod.parseCustomJson.toString());
    }
}

