/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.convert.node;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.info.FilterItem;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeJudge;
import kd.bos.nocode.ext.util.WfFieldTypeUtils;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.WfUtils;
import kd.bos.nocode.wf.designer.convert.node.AbstractWfModelNodeConvert;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import org.apache.commons.collections4.CollectionUtils;

public class WfModelJudgeConvert
extends AbstractWfModelNodeConvert<NoCodeWfNodeJudge> {
    private static final Log log = LogFactory.getLog(WfModelJudgeConvert.class);

    public WfModelJudgeConvert(WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        super(ctx, ncMetaData);
    }

    @Override
    protected NoCodeWfNodeJudge convertTo_CreateNode() {
        return new NoCodeWfNodeJudge();
    }

    @Override
    protected boolean convertTo_disp(NoCodeWfNodeJudge node, NoCodeWfNodeJudge disp) {
        List filter = node.getFilter();
        if (!filter.isEmpty()) {
            // empty if block
        }
        return true;
    }

    @Override
    protected boolean isNeedPublishNewVersion(NoCodeWfNodeJudge node, NoCodeWfNodeJudge oldNode) {
        String oldFilter;
        if (oldNode == null || node == null) {
            return true;
        }
        String newFilter = SerializationUtils.toJsonString((Object)node.getFilter());
        return !StringUtils.equals((CharSequence)newFilter, (CharSequence)(oldFilter = SerializationUtils.toJsonString((Object)oldNode.getFilter())));
    }

    @Override
    public void onBeforeSave(NoCodeWfNodeJudge node, NoCodeWfNodeJudge oldNode) {
        super.onBeforeSave(node, oldNode);
        List filter = node.getFilter();
        if (CollectionUtils.isNotEmpty((Collection)filter)) {
            List<FilterItem> filterCopy = filter.stream().map(e -> new FilterItem(e)).collect(Collectors.toList());
            this.attachFieldType(filterCopy, node);
            String filterStr = SerializationUtils.toJsonString(filterCopy);
            filterStr = filterStr.replaceAll("(?<!\\$)\\{", "%%(");
            node.setExpression(filterStr);
        } else {
            node.setExpression("");
        }
    }

    private void attachFieldType(List<FilterItem> filter, NoCodeWfNodeJudge node) {
        if (filter.isEmpty()) {
            return;
        }
        for (FilterItem filterItem : filter) {
            String fieldName = filterItem.getFieldName();
            if (StringUtils.isEmpty((CharSequence)fieldName)) continue;
            Matcher mValue = WfConsts.varPattern.matcher(fieldName);
            while (mValue.find()) {
                String varStr = mValue.group();
                String varType = this.getVarType(varStr, node.getId());
                filterItem.setFieldType(varType);
                if (!NcEntityTypeUtil.isRefBill((String)varType)) continue;
                filterItem.setFieldName(WfUtils.appendId((String)filterItem.getFieldName()));
            }
            String rightValue = filterItem.getValue();
            if (StringUtils.isEmpty((CharSequence)rightValue)) continue;
            Matcher rightValueMatcher = WfConsts.varPattern.matcher(rightValue);
            while (rightValueMatcher.find()) {
                String varStr = rightValueMatcher.group();
                String varType = this.getVarType(varStr, node.getId());
                if (!NcEntityTypeUtil.isRefBill((String)varType) && !WfFieldTypeUtils.isPk((String)filterItem.getFieldType())) continue;
                String appendedId = WfUtils.appendId((String)varStr);
                rightValue = rightValue.replace(varStr, appendedId);
            }
            filterItem.setValue(rightValue);
        }
    }

    private String getVarType(String varStr, String nodeId) {
        JSONObject variable = VariableHelper.findVariable(nodeId, varStr, this.ctx.getVariables(), this.ncMetaData, this.ctx);
        if (variable == null || variable.isEmpty()) {
            log.info("variable is empty");
            return "";
        }
        return VariableHelper.getVarType(variable);
    }
}

