/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.convert.node;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfGraphCell;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaHelper;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.info.NewSettingItem;
import kd.bos.nocode.ext.metadata.wf.nodes.IHasFormId;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeApiInvoke;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeNewBill;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeStart;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.AssignmentInfo;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.AutoService;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.InParam;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.InParams;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.NoCodeWfNodeAutoMicroSrv;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.OutParam;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.URLCodecUtils;
import kd.bos.nocode.wf.designer.convert.node.WfModelAutoMicroServiceConvert;
import kd.bos.nocode.wf.designer.helper.AssignmentHelper;
import kd.bos.nocode.wf.designer.helper.ExpressDesignMetaHelper;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.helper.WfModelIteratorHelper;

public class WfModelNewBillConvert
extends WfModelAutoMicroServiceConvert<NoCodeWfNodeNewBill> {
    public WfModelNewBillConvert(WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        super(ctx, ncMetaData);
    }

    @Override
    protected NoCodeWfNodeNewBill convertTo_CreateNode() {
        return new NoCodeWfNodeNewBill();
    }

    @Override
    protected boolean convertTo_disp(NoCodeWfNodeNewBill node, NoCodeWfNodeNewBill disp) {
        List setting;
        disp.setDocumentation(node.getDocumentation());
        String formId = node.getFormId();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            disp.setFormId(this.getFormCaption(node));
            if (StringUtils.isNotBlank((CharSequence)node.getTriggerProcess())) {
                disp.setTriggerProcess(node.getTriggerProcessDisp(formId));
            }
        }
        if ((setting = node.getSetting()) != null && !setting.isEmpty()) {
            ArrayList<NewSettingItem> dispSetting = new ArrayList<NewSettingItem>(setting.size());
            for (NewSettingItem newSettingItem : setting) {
                NewSettingItem item = new NewSettingItem();
                String expression = newSettingItem.getExpression();
                AssignmentInfo assignmentInfo = AssignmentHelper.getAssignmentFieldInfoByNewBill(node, newSettingItem);
                if (assignmentInfo != null) {
                    item.setAssignment(assignmentInfo.getName());
                    if (this.isRefBill(assignmentInfo.getType()) && StringUtils.isNotBlank((CharSequence)expression) && !ExpressDesignMetaHelper.isNeedCallExpressParse(expression) && assignmentInfo.getOption().containsKey("billEntityId")) {
                        String billEntityId = (String)assignmentInfo.getOption().get("billEntityId");
                        String dispPropName = (String)assignmentInfo.getOption().get("displayProp");
                        if (StringUtils.isNotBlank((CharSequence)dispPropName)) {
                            dispPropName = dispPropName.split(",")[0];
                        }
                        expression = NcEntityTypeUtil.getBillCaption((String)billEntityId, (Object)expression, (String)dispPropName);
                    } else if (assignmentInfo.getType().startsWith("combo") && StringUtils.isNotEmpty((CharSequence)expression)) {
                        expression = URLCodecUtils.decode((String)expression);
                    }
                }
                item.setExpression(expression);
                dispSetting.add(item);
            }
            disp.setSetting(dispSetting);
        }
        if (StringUtils.isNotBlank((CharSequence)node.getLoopby())) {
            disp.setLoopby(this.getLoopByRefNodeFormCaption(node));
        }
        disp.setNewMode(node.getNewMode());
        return true;
    }

    private String getFormCaption(NoCodeWfNodeNewBill node) {
        if (StringUtils.isNotBlank((CharSequence)node.getFormId())) {
            return NcEntityTypeUtil.getFormCaption((String)node.getFormId());
        }
        return "";
    }

    @Override
    protected boolean isNeedPublishNewVersion(NoCodeWfNodeNewBill node, NoCodeWfNodeNewBill oldNode) {
        String oldSetting;
        if (oldNode == null || node == null) {
            return true;
        }
        if (!StringUtils.equals((CharSequence)node.getFormId(), (CharSequence)oldNode.getFormId())) {
            return true;
        }
        String newSetting = SerializationUtils.toJsonString((Object)node.getSetting());
        return !StringUtils.equals((CharSequence)newSetting, (CharSequence)(oldSetting = SerializationUtils.toJsonString((Object)oldNode.getSetting())));
    }

    @Override
    protected void genAutoService(NoCodeWfNodeNewBill node, NoCodeWfNodeNewBill oldNode) {
        super.genAutoService(node, oldNode);
        AutoService autoService = node.getAutoService();
        autoService.setMethodName("newBill");
    }

    @Override
    protected void genInParams(NoCodeWfNodeNewBill node, NoCodeWfNodeNewBill oldNode) {
        List result = node.getInParams();
        String modelFormId = this.getModelFormId();
        String refNodeFormId = node.getFormId();
        List setting = node.getSetting();
        if (setting != null && !setting.isEmpty()) {
            for (NewSettingItem newSettingItem : setting) {
                InParams inParams = new InParams();
                ArrayList<InParam> params = new ArrayList<InParam>(10);
                InParam businessFormIdInParam = new InParam();
                businessFormIdInParam.setNumber("businessFormId");
                businessFormIdInParam.setValue((Object)modelFormId);
                params.add(businessFormIdInParam);
                InParam businessKeyParam = new InParam();
                businessKeyParam.setNumber("businessKey");
                businessKeyParam.setValue((Object)String.format("${execution.%s}", "businessKey"));
                params.add(businessKeyParam);
                InParam refFormIdInParam = new InParam();
                refFormIdInParam.setNumber("refFormId");
                refFormIdInParam.setValue((Object)refNodeFormId);
                params.add(refFormIdInParam);
                InParam triggerProcess = new InParam();
                triggerProcess.setNumber("triggerProcess");
                triggerProcess.setValue((Object)node.getTriggerProcess());
                params.add(triggerProcess);
                String expression = newSettingItem.getExpression();
                InParam assignmentParam = new InParam();
                AssignmentInfo assignmentInfo = AssignmentHelper.getAssignmentFieldInfoByNewBill(node, newSettingItem);
                if (assignmentInfo == null) continue;
                assignmentParam.setNumber(assignmentInfo.getNumber());
                assignmentParam.setValue(assignmentInfo.getValue());
                expression = this.prepareExrpess(expression, assignmentInfo.getType());
                params.add(assignmentParam);
                InParam expressionInParam = new InParam();
                expressionInParam.setNumber("expression");
                expressionInParam.setValue((Object)expression);
                params.add(expressionInParam);
                InParam newMode = new InParam();
                newMode.setNumber("newMode");
                newMode.setValue((Object)node.getNewMode());
                params.add(newMode);
                if (node.getNewMode() == WfConsts.NewModeEnum.multi) {
                    InParam loopBy = new InParam();
                    loopBy.setNumber("loopby");
                    loopBy.setValue((Object)this.getLoopByRefNodeQueryDataIDVar(node));
                    params.add(loopBy);
                }
                inParams.setParams(params);
                result.add(inParams);
            }
        }
    }

    @Override
    protected void genOutParams(NoCodeWfNodeNewBill node, NoCodeWfNodeNewBill oldNode) {
        List outParams = node.getOutParams();
        List setting = node.getSetting();
        if (setting == null || setting.isEmpty()) {
            return;
        }
        if (node.getNewMode() == WfConsts.NewModeEnum.one) {
            if (StringUtils.isNotBlank((CharSequence)node.getFormId()) && setting != null && !setting.isEmpty()) {
                for (NewSettingItem updateSettingItem : setting) {
                    OutParam outParam = this.setupUpdateModelOutParam(node, updateSettingItem);
                    if (outParam == null) continue;
                    outParams.add(outParam);
                    outParam.getOption().put("ownerFormId", node.getFormId());
                    if (!this.isRefBill(outParam.getType())) continue;
                    OutParam refBillIdOutParam = this.addRefBillIdOutParam(outParam, false);
                    refBillIdOutParam.getOption().put("ownerFormId", node.getFormId());
                    outParams.add(refBillIdOutParam);
                }
                this.addPkIdOutParam(outParams, node.getFormId());
            }
        } else {
            this.genMultiQueryDataOutParam(outParams, "\u65b0\u589e\u7684\u8bb0\u5f55", (IHasFormId)node);
        }
    }

    @Override
    protected boolean needFixupOutParams(NoCodeWfNodeNewBill node) {
        return true;
    }

    private String getModelFormId() {
        NoCodeWfNodeStart startNode = NoCodeWfMetaHelper.getStartNode((NoCodeWfMetaData)this.ncMetaData);
        return startNode.getFormId();
    }

    protected OutParam setupUpdateModelOutParam(NoCodeWfNodeNewBill node, NewSettingItem updateSettingItem) {
        String assignment = updateSettingItem.getAssignment();
        if (StringUtils.isBlank((CharSequence)assignment)) {
            return null;
        }
        AssignmentInfo assignmentInfo = AssignmentHelper.getAssignmentFieldInfoByNewBill(node, updateSettingItem);
        if (assignmentInfo == null) {
            return null;
        }
        OutParam outParam = new OutParam();
        outParam.setNumber(assignmentInfo.getNumber());
        outParam.setName(assignmentInfo.getName());
        outParam.setType(assignmentInfo.getType());
        outParam.setOption(assignmentInfo.getOption());
        return outParam;
    }

    private boolean isMultiRefNode(NoCodeWfNodeNewBill node) {
        NoCodeWfNode loopByRefNode = this.getLoopByRefNode(node);
        if (loopByRefNode == null || !(loopByRefNode instanceof NoCodeWfNodeAutoMicroSrv)) {
            return false;
        }
        List outParams = ((NoCodeWfNodeAutoMicroSrv)loopByRefNode).getOutParams();
        return outParams.stream().anyMatch(o -> "QueryDataSet".equalsIgnoreCase(o.getNumber()));
    }

    private String getLoopByRefNodeQueryDataIDVar(NoCodeWfNodeNewBill node) {
        if (!this.isMultiRefNode(node) || StringUtils.isBlank((CharSequence)node.getLoopby())) {
            return null;
        }
        Iterator<NoCodeWfGraphCell> iterator = WfModelIteratorHelper.getIterator(this.ncMetaData, this.ctx);
        while (iterator.hasNext()) {
            NoCodeWfGraphCell next = iterator.next();
            if (!node.getLoopby().equalsIgnoreCase(next.getId())) continue;
            JSONObject refVar = VariableHelper.findVarFromNodeContainNumber(next, "QueryDataSet_id", this.ctx.getVariables());
            if (refVar == null) {
                refVar = VariableHelper.findVarFromNodeContainNumber(next, "QueryDataSet", this.ctx.getVariables());
                if (refVar == null) {
                    return null;
                }
                String sValue = (String)refVar.get((Object)"value");
                if (StringUtils.isNotBlank((CharSequence)sValue)) {
                    if (WfConsts.varProcPattern.matcher(sValue).matches() && !WfConsts.varProcPattern_ASSIGNEE.matcher(sValue).find() && !WfConsts.varProcWithIdPattern.matcher(sValue).matches()) {
                        sValue = sValue.replaceAll("(\\$\\{proc\\..+?)(\\})", "$1_id$2");
                    }
                    return sValue;
                }
            }
            if (refVar == null) {
                return null;
            }
            return (String)refVar.get((Object)"value");
        }
        return null;
    }

    private NoCodeWfNode getLoopByRefNode(NoCodeWfNodeNewBill node) {
        String nodeId = node.getLoopby();
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return null;
        }
        Optional<NoCodeWfNode> first = this.ncMetaData.getNodes().stream().filter(n -> nodeId.equalsIgnoreCase(n.getId())).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        return null;
    }

    private String getLoopByRefNodeFormCaption(NoCodeWfNodeNewBill node) {
        NoCodeWfNode loopByRefNode = this.getLoopByRefNode(node);
        if (loopByRefNode == null) {
            return null;
        }
        if (loopByRefNode instanceof IHasFormId) {
            return String.format("%s\uff08%s\uff09", loopByRefNode.getName(), ((IHasFormId)loopByRefNode).getTargetFormCaption());
        }
        if (loopByRefNode instanceof NoCodeWfNodeApiInvoke) {
            return loopByRefNode.getName();
        }
        return null;
    }
}

