/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.convert.node;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.message.api.MessageChannels;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeNotify;
import kd.bos.nocode.wf.designer.convert.node.AbstractWfModelNodeConvert;
import kd.bos.nocode.wf.designer.helper.ParticipantHelper;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;

public class WfModelNotifyConvert
extends AbstractWfModelNodeConvert<NoCodeWfNodeNotify> {
    public WfModelNotifyConvert(WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        super(ctx, ncMetaData);
    }

    @Override
    protected NoCodeWfNodeNotify convertTo_CreateNode() {
        return new NoCodeWfNodeNotify();
    }

    @Override
    protected boolean convertTo_disp(NoCodeWfNodeNotify node, NoCodeWfNodeNotify disp) {
        disp.setNotifytype(node.getNotifytype());
        disp.setReceiver(node.getReceiver());
        return true;
    }

    @Override
    protected boolean isNeedPublishNewVersion(NoCodeWfNodeNotify node, NoCodeWfNodeNotify oldNode) {
        if (oldNode == null || node == null) {
            return true;
        }
        return !StringUtils.equals((CharSequence)node.getContent(), (CharSequence)oldNode.getContent()) || !StringUtils.equals((CharSequence)node.getNotifytype(), (CharSequence)oldNode.getNotifytype()) || !StringUtils.equals((CharSequence)node.getPhones(), (CharSequence)oldNode.getPhones()) || !StringUtils.equals((CharSequence)node.getEmails(), (CharSequence)oldNode.getEmails()) || ParticipantHelper.isDiff((NoCodeWfNode)node, node.getReceiver(), (NoCodeWfNode)oldNode, oldNode.getReceiver(), this.ctx, this.ncMetaData);
    }

    @Override
    public void onBeforeSave(NoCodeWfNodeNotify node, NoCodeWfNodeNotify oldNode) {
        super.onBeforeSave(node, oldNode);
        if (StringUtils.isNotBlank((CharSequence)node.getContent())) {
            node.setContent(VariableHelper.replaceAssigneeVar2Name(node.getContent()));
        }
    }

    @Override
    public void onAfterLoad(NoCodeWfNodeNotify node) {
        super.onAfterLoad(node);
        Map enableChannelMap = MessageCenterServiceHelper.getEnableChannel();
        Set<String> enableChannels = enableChannelMap.keySet();
        this.rebuildNotifyType(node, enableChannels);
        this.rebuildNotifyType((NoCodeWfNodeNotify)node.getDisp(), enableChannels);
    }

    private void rebuildNotifyType(NoCodeWfNodeNotify nodeNotify, Set<String> enableChannels) {
        String notifyType = nodeNotify.getNotifytype();
        if (StringUtils.isNotBlank((CharSequence)notifyType)) {
            notifyType = Arrays.stream(notifyType.split(",")).filter(type -> MessageChannels.MC.getNumber().equalsIgnoreCase((String)type) || enableChannels.contains(type)).collect(Collectors.joining(","));
            nodeNotify.setNotifytype(notifyType);
        }
    }
}

