/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.convert.node;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.nodes.IHasFormId;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeQueryData;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.AutoService;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.InParam;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.InParams;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.OutParam;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.OpenApiUtil;
import kd.bos.nocode.utils.ShowColumnInfo;
import kd.bos.nocode.wf.designer.convert.node.WfModelAutoMicroServiceConvert;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;

public class WfModelQueryDataConvert
extends WfModelAutoMicroServiceConvert<NoCodeWfNodeQueryData> {
    public WfModelQueryDataConvert(WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        super(ctx, ncMetaData);
    }

    @Override
    protected boolean needFixupOutParams(NoCodeWfNodeQueryData node) {
        return true;
    }

    @Override
    protected NoCodeWfNodeQueryData convertTo_CreateNode() {
        return new NoCodeWfNodeQueryData();
    }

    @Override
    protected boolean convertTo_disp(NoCodeWfNodeQueryData node, NoCodeWfNodeQueryData disp) {
        if (node.getQueryModel() == WfConsts.QueryModeEnum.byfilter) {
            if (StringUtils.isNotBlank((CharSequence)node.getFormId())) {
                disp.setFormId(NcEntityTypeUtil.getFormCaption((String)node.getFormId()));
            }
        } else if (node.getQueryModel() == WfConsts.QueryModeEnum.byapi) {
            if (StringUtils.isNotBlank((CharSequence)node.getApiId())) {
                disp.setApiId(OpenApiUtil.getFormCaptionByApiId((String)node.getApiId()));
            }
        } else {
            JSONObject variable = VariableHelper.findVariable(node.getId(), node.getRefbillField(), this.ctx.getVariables(), this.ncMetaData, this.ctx);
            if (variable != null && !variable.isEmpty()) {
                disp.setRefbillField((String)variable.get((Object)"title"));
            }
            disp.setQueryModel(WfConsts.QueryModeEnum.byrela);
        }
        disp.setQueryNumber(node.getQueryNumber());
        disp.setQueryModel(node.getQueryModel());
        return true;
    }

    private String getFormCaption(NoCodeWfNodeQueryData node) {
        if (node.getQueryModel() == WfConsts.QueryModeEnum.byfilter) {
            if (StringUtils.isNotBlank((CharSequence)node.getFormId())) {
                return NcEntityTypeUtil.getFormCaption((String)node.getFormId());
            }
        } else if (node.getQueryModel() == WfConsts.QueryModeEnum.byapi) {
            if (StringUtils.isNotBlank((CharSequence)node.getApiId())) {
                return OpenApiUtil.getFormCaptionByApiId((String)node.getApiId());
            }
        } else {
            String relaFormId = VariableHelper.getFormIdFromRefbillVariable(node.getId(), node.getRefbillField(), this.ctx.getVariables(), this.ncMetaData, this.ctx);
            if (StringUtils.isNotBlank((CharSequence)relaFormId)) {
                return NcEntityTypeUtil.getFormCaption((String)relaFormId);
            }
        }
        return "";
    }

    @Override
    protected boolean isNeedPublishNewVersion(NoCodeWfNodeQueryData node, NoCodeWfNodeQueryData oldNode) {
        if (oldNode == null || node == null) {
            return true;
        }
        if (node.getQueryModel() != oldNode.getQueryModel()) {
            return true;
        }
        if (node.getQueryNumber() != oldNode.getQueryNumber()) {
            return true;
        }
        if (node.getQueryModel() == WfConsts.QueryModeEnum.byfilter) {
            String oldFilter;
            if (!StringUtils.equals((CharSequence)node.getFormId(), (CharSequence)oldNode.getFormId())) {
                return true;
            }
            String newFilter = SerializationUtils.toJsonString((Object)node.getFilter());
            if (!StringUtils.equals((CharSequence)newFilter, (CharSequence)(oldFilter = SerializationUtils.toJsonString((Object)oldNode.getFilter())))) {
                return true;
            }
        } else if (node.getQueryModel() == WfConsts.QueryModeEnum.byapi) {
            String oldFilter;
            if (!StringUtils.equals((CharSequence)node.getApiId(), (CharSequence)oldNode.getApiId())) {
                return true;
            }
            String newFilter = SerializationUtils.toJsonString((Object)node.getApiFilter());
            if (!StringUtils.equals((CharSequence)newFilter, (CharSequence)(oldFilter = SerializationUtils.toJsonString((Object)oldNode.getApiFilter())))) {
                return true;
            }
        } else if (!StringUtils.equals((CharSequence)node.getRefbillField(), (CharSequence)oldNode.getRefbillField())) {
            return true;
        }
        return false;
    }

    @Override
    public void onBeforeSave(NoCodeWfNodeQueryData node, NoCodeWfNodeQueryData oldNode) {
        ThreeTuple<String, IDataEntityProperty, JSONObject> info;
        if (StringUtils.isNotBlank((CharSequence)node.getRefbillField()) && (info = VariableHelper.getInfoFromRefbillVariable(node.getId(), node.getRefbillField(), this.ctx.getVariables(), this.ncMetaData, this.ctx)) != null) {
            node.setRefBillFormId((String)info.item1);
            if (node.getQueryModel() == WfConsts.QueryModeEnum.byrela) {
                IDataEntityProperty prop = (IDataEntityProperty)info.item2;
                if (prop != null) {
                    if (prop instanceof INoCodeRefBillProp) {
                        if (((INoCodeRefBillProp)prop).isMultiSelect()) {
                            node.setQueryNumber(WfConsts.QueryNumberEnum.multi);
                        } else {
                            node.setQueryNumber(WfConsts.QueryNumberEnum.one);
                        }
                    }
                } else {
                    Map option;
                    JSONObject variable = (JSONObject)info.item3;
                    if (variable != null && variable.get((Object)"option") != null && (option = (Map)variable.get((Object)"option")).containsKey("isMulti")) {
                        if (((Boolean)option.get("isMulti")).booleanValue()) {
                            node.setQueryNumber(WfConsts.QueryNumberEnum.multi);
                        } else {
                            node.setQueryNumber(WfConsts.QueryNumberEnum.one);
                        }
                    }
                }
            }
        }
        super.onBeforeSave(node, oldNode);
    }

    @Override
    protected void genAutoService(NoCodeWfNodeQueryData node, NoCodeWfNodeQueryData oldNode) {
        super.genAutoService(node, oldNode);
        AutoService autoService = node.getAutoService();
        if (node.getQueryModel() == WfConsts.QueryModeEnum.byfilter) {
            autoService.setMethodName("queryByFilter");
        } else if (node.getQueryModel() == WfConsts.QueryModeEnum.byapi) {
            autoService.setMethodName("queryByApi");
        } else {
            autoService.setMethodName("queryByRela");
        }
    }

    @Override
    protected void genInParams(NoCodeWfNodeQueryData node, NoCodeWfNodeQueryData oldNode) {
        List result = node.getInParams();
        InParams inParams = new InParams();
        ArrayList<InParam> params = new ArrayList<InParam>(10);
        InParam entityNumberParam = new InParam();
        entityNumberParam.setNumber("entityNumber");
        entityNumberParam.setValue((Object)String.format("${execution.%s}", "entityNumber"));
        params.add(entityNumberParam);
        InParam businessKeyParam = new InParam();
        businessKeyParam.setNumber("businessKey");
        businessKeyParam.setValue((Object)String.format("${execution.%s}", "businessKey"));
        params.add(businessKeyParam);
        if (node.getQueryModel() == WfConsts.QueryModeEnum.byfilter) {
            InParam formIdInParam = new InParam();
            formIdInParam.setNumber("formId");
            formIdInParam.setValue((Object)node.getFormId());
            params.add(formIdInParam);
            InParam filterInParam = new InParam();
            filterInParam.setNumber("filter");
            filterInParam.setValue((Object)node.getFilter());
            params.add(filterInParam);
            InParam orderbyInParam = new InParam();
            orderbyInParam.setNumber("orderby");
            orderbyInParam.setValue((Object)node.getOrderby());
            params.add(orderbyInParam);
            InParam topNumberInParam = new InParam();
            topNumberInParam.setNumber("topNumber");
            int topNumber = 1;
            if (StringUtils.isNotBlank((CharSequence)node.getTopNumber())) {
                topNumber = Integer.parseInt(node.getTopNumber());
            }
            topNumberInParam.setValue((Object)topNumber);
            params.add(topNumberInParam);
            InParam fetchTypeInParam = new InParam();
            fetchTypeInParam.setNumber("fetchType");
            fetchTypeInParam.setValue((Object)WfConsts.QueryDataFetchType.DYNAMIC.getCode());
            params.add(fetchTypeInParam);
        } else if (node.getQueryModel() == WfConsts.QueryModeEnum.byapi) {
            InParam apiIdInParam = new InParam();
            apiIdInParam.setNumber("apiId");
            apiIdInParam.setValue((Object)node.getApiId());
            params.add(apiIdInParam);
            InParam filterInParam = new InParam();
            filterInParam.setNumber("apiFilter");
            filterInParam.setValue((Object)node.getApiFilter());
            params.add(filterInParam);
            InParam formIdInParam = new InParam();
            formIdInParam.setNumber("formId");
            formIdInParam.setValue((Object)OpenApiUtil.getFormIdByApiId((String)node.getApiId()));
            params.add(formIdInParam);
            InParam orderbyInParam = new InParam();
            orderbyInParam.setNumber("orderby");
            orderbyInParam.setValue((Object)node.getOrderby());
            params.add(orderbyInParam);
            InParam topNumberInParam = new InParam();
            topNumberInParam.setNumber("topNumber");
            int topNumber = 1;
            if (StringUtils.isNotBlank((CharSequence)node.getTopNumber())) {
                topNumber = Integer.parseInt(node.getTopNumber());
            }
            topNumberInParam.setValue((Object)topNumber);
            params.add(topNumberInParam);
        } else {
            InParam refbillFieldInParam = new InParam();
            refbillFieldInParam.setNumber("refbillField");
            String refbillField = node.getRefbillField();
            if (WfConsts.VAR_PROC_PATTERN_OF_EXECUTERESULT.matcher(refbillField).matches()) {
                refbillField = refbillField.replaceAll("(\\$\\{proc\\..+?)(\\})", "$1_id$2");
            }
            refbillFieldInParam.setValue((Object)refbillField);
            params.add(refbillFieldInParam);
            String relaFormId = node.getTargetFormId();
            InParam relaFormIdInParam = new InParam();
            relaFormIdInParam.setNumber("relaFormId");
            relaFormIdInParam.setValue((Object)relaFormId);
            params.add(relaFormIdInParam);
        }
        InParam queryNumberParam = new InParam();
        queryNumberParam.setNumber("queryNumber");
        queryNumberParam.setValue((Object)node.getQueryNumber().getCode());
        params.add(queryNumberParam);
        inParams.setParams(params);
        result.add(inParams);
    }

    @Override
    protected void genOutParams(NoCodeWfNodeQueryData node, NoCodeWfNodeQueryData oldNode) {
        String refbillField;
        List outParams = node.getOutParams();
        if (node.getQueryNumber() == WfConsts.QueryNumberEnum.multi) {
            if (node.getQueryModel() == WfConsts.QueryModeEnum.byapi) {
                OutParam outParamQueryDataSet = new OutParam();
                outParamQueryDataSet.setName("\u67e5\u627e\u7684\u8bb0\u5f55");
                outParamQueryDataSet.setNumber("QueryDataSet");
                String formIdByApiId = OpenApiUtil.getFormIdByApiId((String)node.getApiId());
                String resultVarType = "refbill";
                if ("bos_user".equalsIgnoreCase(formIdByApiId)) {
                    resultVarType = "user";
                } else if ("bos_adminorg".equalsIgnoreCase(formIdByApiId)) {
                    resultVarType = "org";
                }
                outParamQueryDataSet.setType(resultVarType);
                outParamQueryDataSet.getOption().put("canJudge", Boolean.FALSE);
                outParams.add(outParamQueryDataSet);
                outParams.add(this.addRefBillIdOutParam(outParamQueryDataSet, Boolean.TRUE));
            } else {
                String relaFormId;
                refbillField = node.getRefbillField();
                if (StringUtils.isNotBlank((CharSequence)refbillField) && node.getQueryModel() == WfConsts.QueryModeEnum.byrela && StringUtils.isBlank((CharSequence)(relaFormId = node.getRefBillFormId()))) {
                    relaFormId = VariableHelper.getFormIdFromRefbillVariable(node.getId(), node.getRefbillField(), this.ctx.getVariables(), this.ncMetaData, this.ctx);
                    node.setRefBillFormId(relaFormId);
                }
                if (StringUtils.isEmpty((CharSequence)node.getTargetFormId())) {
                    return;
                }
                this.genMultiQueryDataOutParam(outParams, "\u67e5\u627e\u7684\u8bb0\u5f55", (IHasFormId)node);
            }
        } else if (node.getQueryModel() == WfConsts.QueryModeEnum.byfilter) {
            List<ShowColumnInfo> showColumns;
            String formId = node.getFormId();
            if (StringUtils.isBlank((CharSequence)formId)) {
                return;
            }
            if (NcEntityTypeUtil.isFormExist((String)formId) && (showColumns = VariableHelper.getShowColumnsIncludePk(formId)) != null && !showColumns.isEmpty()) {
                for (ShowColumnInfo showColumn : showColumns) {
                    OutParam outParam = new OutParam();
                    outParam.setName(showColumn.getCaption());
                    outParam.setType(showColumn.getType());
                    outParam.setNumber(showColumn.getId());
                    outParam.setOption(showColumn.getOption());
                    outParams.add(outParam);
                    if (!this.isRefBill(outParam.getType())) continue;
                    outParams.add(this.addRefBillIdOutParam(outParam, false));
                }
            }
        } else if (node.getQueryModel() == WfConsts.QueryModeEnum.byapi) {
            String apiId = node.getApiId();
            if (StringUtils.isBlank((CharSequence)apiId)) {
                return;
            }
            List showColumns = OpenApiUtil.getOpenApiOutParams((String)apiId);
            if (showColumns != null && !showColumns.isEmpty()) {
                for (ShowColumnInfo showColumn : showColumns) {
                    OutParam outParam = new OutParam();
                    outParam.setName(showColumn.getCaption());
                    outParam.setType(showColumn.getType());
                    outParam.setNumber(showColumn.getId());
                    outParam.setOption(showColumn.getOption());
                    outParams.add(outParam);
                }
            }
        } else {
            List<ShowColumnInfo> showColumns;
            refbillField = node.getRefbillField();
            if (StringUtils.isBlank((CharSequence)refbillField)) {
                return;
            }
            String relaFormId = node.getRefBillFormId();
            if (StringUtils.isBlank((CharSequence)relaFormId)) {
                relaFormId = VariableHelper.getFormIdFromRefbillVariable(node.getId(), node.getRefbillField(), this.ctx.getVariables(), this.ncMetaData, this.ctx);
                node.setRefBillFormId(relaFormId);
            }
            if (NcEntityTypeUtil.isFormExist((String)relaFormId) && (showColumns = VariableHelper.getShowColumnsIncludePk(relaFormId)) != null && !showColumns.isEmpty()) {
                for (ShowColumnInfo showColumn : showColumns) {
                    OutParam outParam = new OutParam();
                    outParam.setName(showColumn.getCaption());
                    outParam.setType(showColumn.getType());
                    outParam.setNumber(showColumn.getId());
                    outParam.setOption(showColumn.getOption());
                    outParams.add(outParam);
                    if (!this.isRefBill(outParam.getType())) continue;
                    outParams.add(this.addRefBillIdOutParam(outParam, false));
                }
            }
        }
        OutParam outParamQueryResult = new OutParam();
        outParamQueryResult.setName("\u67e5\u627e\u7ed3\u679c");
        outParamQueryResult.setNumber("QueryResult");
        outParamQueryResult.setType("combo");
        outParamQueryResult.getOption().put("valueItems", WfConsts.QueryResultEnum.getItems());
        outParams.add(outParamQueryResult);
    }

    @Override
    public void onAfterLoad(NoCodeWfNodeQueryData node) {
        if (StringUtils.isBlank((CharSequence)node.getRefBillFormId()) && StringUtils.isNotBlank((CharSequence)node.getRefbillField())) {
            String relaFormId = VariableHelper.getFormIdFromRefbillVariable(node.getId(), node.getRefbillField(), this.ctx.getVariables(), this.ncMetaData, this.ctx);
            node.setRefBillFormId(relaFormId);
        }
        super.onAfterLoad(node);
    }
}

