/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.convert.node;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.constant.LoopTypeEnum;
import kd.bos.nocode.constant.TriggerModeEnum;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.entity.WfTriggerTime;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.info.TriggerTime;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeStart;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.AutoService;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.InParam;
import kd.bos.nocode.utils.CronUtils;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.wf.NoCodeWfService;
import kd.bos.nocode.wf.designer.convert.node.AbstractWfModelNodeConvert;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;

public class WfModelStartConvert
extends AbstractWfModelNodeConvert<NoCodeWfNodeStart> {
    public WfModelStartConvert(WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        super(ctx, ncMetaData);
    }

    @Override
    protected NoCodeWfNodeStart convertTo_CreateNode() {
        return new NoCodeWfNodeStart();
    }

    @Override
    protected boolean convertTo_disp(NoCodeWfNodeStart node, NoCodeWfNodeStart disp) {
        String formId = node.getTargetFormId();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            String formCaption = NcEntityTypeUtil.getFormCaption((String)formId);
            disp.setFormId(formCaption);
            disp.setQueryFormId(formCaption);
        }
        disp.setFireType(WfConsts.FireTypeEnum.getByCode((String)node.getFireType()).getName());
        disp.setTriggerMode(TriggerModeEnum.getByCode((String)node.getTriggerMode()).getName());
        disp.setLoopType(LoopTypeEnum.getByCode((String)node.getLoopType()).getName());
        disp.setQueryNumber(node.getQueryNumber());
        disp.setTopNumber(node.getTopNumber());
        return true;
    }

    @Override
    protected boolean isNeedPublishNewVersion(NoCodeWfNodeStart node, NoCodeWfNodeStart oldNode) {
        if (oldNode == null || node == null) {
            return true;
        }
        return !node.equals((Object)oldNode);
    }

    @Override
    public void onBeforeSave(NoCodeWfNodeStart node, NoCodeWfNodeStart oldNode) {
        super.onBeforeSave(node, oldNode);
        this.removeAppIdFromFormId(node);
        if (StringUtils.isBlank((CharSequence)node.getFireKind()) || !node.getFireKind().contains("billSubmit")) {
            node.setFireType(null);
        }
        if (TriggerModeEnum.TIME.getCode().equals(node.getTriggerMode())) {
            node.setCronExpression(this.buildCronExpression(node.getLoopType(), node.getTriggerTime()));
            node.setParams(this.genInParams(node, oldNode));
            this.genAutoService(node);
        }
        this.syncFormIdAndQueryFormId(node);
    }

    private void genAutoService(NoCodeWfNodeStart node) {
        AutoService autoService = node.getAutoService();
        autoService.setCloudId("bos");
        autoService.setAppId("nocode");
        autoService.setServiceName(NoCodeWfService.class.getSimpleName());
        autoService.setMethodName("queryStartNodeFormData");
    }

    private List<InParam> genInParams(NoCodeWfNodeStart node, NoCodeWfNodeStart oldNode) {
        ArrayList<InParam> params = new ArrayList<InParam>(10);
        InParam entityNumberParam = new InParam();
        entityNumberParam.setNumber("entityNumber");
        entityNumberParam.setValue((Object)node.getEntityNumberWithoutAppId());
        params.add(entityNumberParam);
        InParam userIdParam = new InParam();
        userIdParam.setNumber("userId");
        userIdParam.setValue((Object)String.valueOf(RequestContext.get().getCurrUserId()));
        params.add(userIdParam);
        InParam filterInParam = new InParam();
        filterInParam.setNumber("filter");
        filterInParam.setValue((Object)node.getFilter());
        params.add(filterInParam);
        InParam orderbyInParam = new InParam();
        orderbyInParam.setNumber("orderby");
        orderbyInParam.setValue((Object)node.getOrderBy());
        params.add(orderbyInParam);
        InParam topNumberInParam = new InParam();
        topNumberInParam.setNumber("topNumber");
        int topNumber = 1;
        if (StringUtils.isNotBlank((CharSequence)node.getTopNumber()) && WfConsts.QueryNumberEnum.multi == node.getQueryNumber()) {
            topNumber = Integer.parseInt(node.getTopNumber());
        }
        topNumberInParam.setValue((Object)topNumber);
        params.add(topNumberInParam);
        return params;
    }

    private String[] buildCronExpression(String loopType, TriggerTime triggerTime) {
        WfTriggerTime wfTriggerTime = new WfTriggerTime();
        wfTriggerTime.setLoopTypeEnum(LoopTypeEnum.getByCode((String)loopType));
        wfTriggerTime.setDate(triggerTime.getDate());
        wfTriggerTime.setTime(triggerTime.getTime());
        return CronUtils.buildCronExpression((WfTriggerTime)wfTriggerTime).toArray(new String[0]);
    }

    @Override
    public void onAfterLoad(NoCodeWfNodeStart node) {
        List processDefinitions;
        super.onAfterLoad(node);
        this.fixupAppIdToFormId(node);
        this.syncFormIdAndQueryFormId(node);
        String realFormId = node.getTargetFormId();
        if (StringUtils.isNotBlank((CharSequence)realFormId) && (processDefinitions = NoCodeWorkflowServiceHelper.getProcessDefinitionsByTriggerMode((String)realFormId, null)) != null && !processDefinitions.isEmpty()) {
            node.setPublished(true);
        }
    }

    private void syncFormIdAndQueryFormId(NoCodeWfNodeStart node) {
        node.setFormId(node.getTargetFormId());
        node.setQueryFormId(node.getTargetFormId());
    }

    private void removeAppIdFromFormId(NoCodeWfNodeStart node) {
        String formId = node.getTargetFormId();
        if (StringUtils.isNotBlank((CharSequence)formId) && formId.indexOf(",") > 0) {
            node.setFormId(formId.split(",")[1]);
            node.setQueryFormId(formId.split(",")[1]);
        }
    }

    private void fixupAppIdToFormId(NoCodeWfNodeStart node) {
        String formId = node.getTargetFormId();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            String appIdByFormId = FormMetaUtil.getAppIdByFormId((String)formId);
            if (!this.ctx.getAppId().equalsIgnoreCase(appIdByFormId)) {
                node.setFormId(String.format("%s,%s", appIdByFormId, formId));
                node.setQueryFormId(String.format("%s,%s", appIdByFormId, formId));
            }
        }
    }
}

