/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.convert.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaHelper;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.info.UpdateSettingItem;
import kd.bos.nocode.ext.metadata.wf.nodes.IHasFormId;
import kd.bos.nocode.ext.metadata.wf.nodes.IHasResultInfo;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeStart;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeUpdateBill;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.AssignmentInfo;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.AutoService;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.InParam;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.InParams;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.OutParam;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.wf.designer.convert.node.WfModelAutoMicroServiceConvert;
import kd.bos.nocode.wf.designer.helper.AssignmentHelper;
import kd.bos.nocode.wf.designer.helper.ExpressDesignMetaHelper;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;

public class WfModelUpdateBillConvert
extends WfModelAutoMicroServiceConvert<NoCodeWfNodeUpdateBill> {
    public WfModelUpdateBillConvert(WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        super(ctx, ncMetaData);
    }

    @Override
    protected NoCodeWfNodeUpdateBill convertTo_CreateNode() {
        return new NoCodeWfNodeUpdateBill();
    }

    @Override
    protected boolean convertTo_disp(NoCodeWfNodeUpdateBill node, NoCodeWfNodeUpdateBill disp) {
        List setting;
        NoCodeWfNode refNode;
        disp.setDocumentation(node.getDocumentation());
        String refNodeId = node.getRefNodeId();
        String targetFormId = null;
        if (StringUtils.isNotBlank((CharSequence)refNodeId) && (refNode = this.getRefNode(node)) != null) {
            targetFormId = ((IHasFormId)refNode).getTargetFormId();
            String formCaption = NcEntityTypeUtil.getFormCaption((String)targetFormId);
            disp.setRefNodeId(String.format("%s\uff08%s\uff09", refNode.getName(), formCaption));
            if (StringUtils.isNotBlank((CharSequence)node.getTriggerProcess())) {
                disp.setTriggerProcess(node.getTriggerProcessDisp(targetFormId));
            }
        }
        if ((setting = node.getSetting()) != null && !setting.isEmpty()) {
            ArrayList<UpdateSettingItem> dispSetting = new ArrayList<UpdateSettingItem>(setting.size());
            for (UpdateSettingItem updateSettingItem : setting) {
                UpdateSettingItem item = new UpdateSettingItem();
                String expression = updateSettingItem.getExpression();
                AssignmentInfo assignmentInfo = AssignmentHelper.getAssignmentFieldInfoByUpdateBill(updateSettingItem, this.ncMetaData);
                if (assignmentInfo != null) {
                    item.setAssignment(assignmentInfo.getName());
                    if (this.isRefBill(assignmentInfo.getType()) && StringUtils.isNotBlank((CharSequence)expression) && !ExpressDesignMetaHelper.isNeedCallExpressParse(expression) && assignmentInfo.getOption().containsKey("billEntityId")) {
                        String billEntityId = (String)assignmentInfo.getOption().get("billEntityId");
                        String dispPropName = (String)assignmentInfo.getOption().get("displayProp");
                        if (StringUtils.isNotBlank((CharSequence)dispPropName)) {
                            dispPropName = dispPropName.split(",")[0];
                        }
                        expression = NcEntityTypeUtil.getBillCaption((String)billEntityId, (Object)expression, (String)dispPropName);
                    }
                }
                item.setExpression(expression);
                dispSetting.add(item);
            }
            disp.setSetting(dispSetting);
        }
        return true;
    }

    @Override
    protected boolean isNeedPublishNewVersion(NoCodeWfNodeUpdateBill node, NoCodeWfNodeUpdateBill oldNode) {
        String oldSetting;
        boolean diffSetting;
        boolean diffRefNodeId;
        if (oldNode == null || node == null) {
            return true;
        }
        boolean bl = diffRefNodeId = !StringUtils.equals((CharSequence)node.getRefNodeId(), (CharSequence)oldNode.getRefNodeId());
        if (diffRefNodeId) {
            return true;
        }
        String newSetting = SerializationUtils.toJsonString((Object)node.getSetting());
        boolean bl2 = diffSetting = !StringUtils.equals((CharSequence)newSetting, (CharSequence)(oldSetting = SerializationUtils.toJsonString((Object)oldNode.getSetting())));
        return diffSetting;
    }

    @Override
    protected void genAutoService(NoCodeWfNodeUpdateBill node, NoCodeWfNodeUpdateBill oldNode) {
        super.genAutoService(node, oldNode);
        AutoService autoService = node.getAutoService();
        autoService.setMethodName("updateBill");
    }

    @Override
    protected void genInParams(NoCodeWfNodeUpdateBill node, NoCodeWfNodeUpdateBill oldNode) {
        List result = node.getInParams();
        String modelFormId = this.getModelFormId();
        String refNodeFormId = this.getRefNodeFormId(node);
        String varOfNodeFormPkId = VariableHelper.getVarOfNodeFormPkId(node.getId(), node.getRefNodeId(), this.ncMetaData, this.ctx.getVariables(), this.ctx);
        List setting = node.getSetting();
        if (setting != null && !setting.isEmpty()) {
            for (UpdateSettingItem updateSettingItem : setting) {
                InParams inParams = new InParams();
                ArrayList<InParam> params = new ArrayList<InParam>(10);
                InParam businessFormIdInParam = new InParam();
                businessFormIdInParam.setNumber("businessFormId");
                businessFormIdInParam.setValue((Object)modelFormId);
                params.add(businessFormIdInParam);
                InParam businessKeyParam = new InParam();
                businessKeyParam.setNumber("businessKey");
                businessKeyParam.setValue((Object)String.format("${execution.%s}", "businessKey"));
                params.add(businessKeyParam);
                InParam refFormIdInParam = new InParam();
                refFormIdInParam.setNumber("refFormId");
                refFormIdInParam.setValue((Object)refNodeFormId);
                params.add(refFormIdInParam);
                InParam pkIdParam = new InParam();
                pkIdParam.setNumber("pkId");
                pkIdParam.setValue((Object)varOfNodeFormPkId);
                params.add(pkIdParam);
                InParam triggerProcess = new InParam();
                triggerProcess.setNumber("triggerProcess");
                triggerProcess.setValue((Object)node.getTriggerProcess());
                params.add(triggerProcess);
                String expression = updateSettingItem.getExpression();
                InParam assignmentParam = new InParam();
                AssignmentInfo assignmentInfo = AssignmentHelper.getAssignmentFieldInfoByUpdateBill(updateSettingItem, this.ncMetaData);
                if (assignmentInfo == null) continue;
                assignmentParam.setNumber(assignmentInfo.getNumber());
                assignmentParam.setValue(assignmentInfo.getValue());
                expression = this.prepareExrpess(expression, assignmentInfo.getType());
                params.add(assignmentParam);
                InParam expressionInParam = new InParam();
                expressionInParam.setNumber("expression");
                expressionInParam.setValue((Object)expression);
                params.add(expressionInParam);
                inParams.setParams(params);
                result.add(inParams);
            }
        }
    }

    private NoCodeWfNode getRefNode(NoCodeWfNodeUpdateBill node) {
        String nodeId = node.getRefNodeId();
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return null;
        }
        Optional<NoCodeWfNode> first = this.ncMetaData.getNodes().stream().filter(n -> nodeId.equalsIgnoreCase(n.getId())).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        return null;
    }

    private String getRefNodeFormId(NoCodeWfNodeUpdateBill node) {
        NoCodeWfNode refNode = this.getRefNode(node);
        if (refNode == null || !(refNode instanceof IHasFormId)) {
            return null;
        }
        return ((IHasFormId)refNode).getTargetFormId();
    }

    @Override
    protected void genOutParams(NoCodeWfNodeUpdateBill node, NoCodeWfNodeUpdateBill oldNode) {
        NoCodeWfNode refNode;
        List outParams = node.getOutParams();
        List setting = node.getSetting();
        if (setting != null && !setting.isEmpty() && (refNode = this.getRefNode(node)) != null) {
            if (refNode instanceof IHasResultInfo && ((IHasResultInfo)refNode).isMulti()) {
                this.genMultiQueryDataOutParam(outParams, "\u4fee\u6539\u7684\u8bb0\u5f55", (IHasFormId)node);
            } else {
                String refNodeFormId = this.getRefNodeFormId(node);
                for (UpdateSettingItem updateSettingItem : setting) {
                    OutParam outParam = this.setupUpdateModelOutParam(updateSettingItem, node);
                    if (outParam == null) continue;
                    outParam.getOption().put("ownerFormId", refNodeFormId);
                    outParams.add(outParam);
                    if (!this.isRefBill(outParam.getType())) continue;
                    OutParam refBillIdOutParam = this.addRefBillIdOutParam(outParam, false);
                    refBillIdOutParam.getOption().put("ownerFormId", node.getFormId());
                    outParams.add(refBillIdOutParam);
                }
                this.addPkIdOutParam(outParams, refNodeFormId);
            }
        }
    }

    protected OutParam setupUpdateModelOutParam(UpdateSettingItem updateSettingItem, NoCodeWfNodeUpdateBill node) {
        String assignment = updateSettingItem.getAssignment();
        if (StringUtils.isBlank((CharSequence)assignment)) {
            return null;
        }
        AssignmentInfo assignmentInfo = AssignmentHelper.getAssignmentFieldInfoByUpdateBill(updateSettingItem, this.ncMetaData);
        if (assignmentInfo == null) {
            return null;
        }
        OutParam outParam = new OutParam();
        outParam.setNumber(assignmentInfo.getNumber());
        outParam.setName(assignmentInfo.getName());
        outParam.setType(assignmentInfo.getType());
        String toUpdate = updateSettingItem.getAssignment();
        this.ctx.addUpdateAssignment(outParam, (NoCodeWfNode)node, toUpdate);
        outParam.setAssignment(this.ctx.getCascadeUpdateAssignment(toUpdate));
        outParam.setOption(assignmentInfo.getOption());
        return outParam;
    }

    private String getModelFormId() {
        NoCodeWfNodeStart startNode = NoCodeWfMetaHelper.getStartNode((NoCodeWfMetaData)this.ncMetaData);
        return startNode.getFormId();
    }

    @Override
    public void onBeforeSave(NoCodeWfNodeUpdateBill node, NoCodeWfNodeUpdateBill oldNode) {
        this.fixupFormId(node);
        super.onBeforeSave(node, oldNode);
    }

    @Override
    public void onFixupOutParams(NoCodeWfNodeUpdateBill node) {
        super.onFixupOutParams(node);
        if (StringUtils.isBlank((CharSequence)node.getFormId())) {
            this.fixupFormId(node);
        }
    }

    @Override
    protected boolean needFixupOutParams(NoCodeWfNodeUpdateBill node) {
        return true;
    }

    private void fixupFormId(NoCodeWfNodeUpdateBill node) {
        NoCodeWfNode refNode = this.getRefNode(node);
        if (refNode instanceof IHasFormId) {
            node.setFormId(((IHasFormId)refNode).getTargetFormId());
        } else {
            node.setFormId(null);
        }
    }
}

