/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.convert.node;

import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.nodes.IHasFormId;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeUserInput;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.wf.designer.convert.node.AbstractWfModelNodeConvert;
import kd.bos.nocode.wf.designer.helper.ParticipantHelper;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;

public class WfModelUserInputConvert
extends AbstractWfModelNodeConvert<NoCodeWfNodeUserInput> {
    public WfModelUserInputConvert(WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        super(ctx, ncMetaData);
    }

    @Override
    protected NoCodeWfNodeUserInput convertTo_CreateNode() {
        return new NoCodeWfNodeUserInput();
    }

    @Override
    protected boolean convertTo_disp(NoCodeWfNodeUserInput node, NoCodeWfNodeUserInput disp) {
        NoCodeWfNode refNode;
        String refNodeId = node.getRefNodeId();
        if (StringUtils.isNotBlank((CharSequence)refNodeId) && (refNode = this.getRefNode(node)) != null) {
            String targetFormId = ((IHasFormId)refNode).getTargetFormId();
            String formCaption = NcEntityTypeUtil.getFormCaption((String)targetFormId);
            disp.setRefNodeId(String.format("%s\uff08%s\uff09", refNode.getName(), formCaption));
            if (StringUtils.isNotBlank((CharSequence)node.getTriggerProcess())) {
                disp.setTriggerProcess(node.getTriggerProcessDisp(targetFormId));
            }
        }
        disp.setInputUser(node.getInputUser());
        return true;
    }

    @Override
    protected boolean isNeedPublishNewVersion(NoCodeWfNodeUserInput node, NoCodeWfNodeUserInput oldNode) {
        boolean diffRefNodeId;
        if (oldNode == null || node == null) {
            return true;
        }
        boolean bl = diffRefNodeId = !StringUtils.equals((CharSequence)node.getRefNodeId(), (CharSequence)oldNode.getRefNodeId());
        if (diffRefNodeId) {
            return true;
        }
        boolean diffInputContent = this.isDiffInputContent(node.getInputContent(), oldNode.getInputContent());
        if (diffInputContent) {
            return true;
        }
        return ParticipantHelper.isDiff((NoCodeWfNode)node, node.getInputUser(), (NoCodeWfNode)oldNode, oldNode.getInputUser(), this.ctx, this.ncMetaData);
    }

    private boolean isDiffInputContent(Map<String, Object> newContent, Map<String, Object> oldContext) {
        String oldJson;
        if (newContent == null || oldContext == null) {
            return true;
        }
        String newJson = SerializationUtils.toJsonString(newContent);
        return !StringUtils.equals((CharSequence)newJson, (CharSequence)(oldJson = SerializationUtils.toJsonString(oldContext)));
    }

    private NoCodeWfNode getRefNode(NoCodeWfNodeUserInput node) {
        String formId = node.getRefNodeId();
        if (StringUtils.isBlank((CharSequence)formId)) {
            return null;
        }
        Optional<NoCodeWfNode> first = this.ncMetaData.getNodes().stream().filter(n -> formId.equalsIgnoreCase(n.getId())).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        return null;
    }

    @Override
    public void onBeforeSave(NoCodeWfNodeUserInput node, NoCodeWfNodeUserInput oldNode) {
        super.onBeforeSave(node, oldNode);
        this.fixupFormId(node);
        String varOfNodeFormPkId = VariableHelper.getVarOfNodeFormPkId(node.getId(), node.getRefNodeId(), this.ncMetaData, this.ctx.getVariables(), this.ctx);
        node.setBillId(varOfNodeFormPkId);
        if (StringUtils.isNotBlank((CharSequence)node.getTaskSubject())) {
            node.setTaskSubject(VariableHelper.replaceAssigneeVar2Name(node.getTaskSubject()));
        }
    }

    @Override
    public void onFixupOutParams(NoCodeWfNodeUserInput node) {
        super.onFixupOutParams(node);
        if (StringUtils.isBlank((CharSequence)node.getFormId())) {
            this.fixupFormId(node);
        }
    }

    private void fixupFormId(NoCodeWfNodeUserInput node) {
        NoCodeWfNode refNode = this.getRefNode(node);
        if (refNode instanceof IHasFormId) {
            node.setFormId(((IHasFormId)refNode).getTargetFormId());
        } else {
            node.setFormId(null);
        }
    }
}

