/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.helper;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaHelper;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.info.CalcSettingItem;
import kd.bos.nocode.ext.metadata.wf.info.NewSettingItem;
import kd.bos.nocode.ext.metadata.wf.info.UpdateSettingItem;
import kd.bos.nocode.ext.metadata.wf.nodes.IHasFormId;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeNewBill;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeStart;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.AssignmentInfo;
import kd.bos.nocode.utils.NcEntityTypeUtil;

public class AssignmentHelper {
    public static AssignmentInfo getAssignmentFieldInfoByCalc(CalcSettingItem calcSettingItem, NoCodeWfMetaData ncMetaData) {
        String assignment = calcSettingItem.getAssignment();
        if (StringUtils.isBlank((CharSequence)assignment)) {
            return null;
        }
        Pattern compile = WfConsts.VAR_PROC_PATTERN_OF_EXECUTERESULT;
        Matcher matcher = compile.matcher(assignment);
        if (matcher.matches()) {
            String refNodeId = matcher.group(1);
            String refModelField = matcher.group(2);
            Optional<NoCodeWfNode> first = ncMetaData.getNodes().stream().filter(n -> n.getId().equalsIgnoreCase(refNodeId)).findFirst();
            if (!first.isPresent()) {
                return null;
            }
            NoCodeWfNode noCodeWfNode = first.get();
            if (noCodeWfNode instanceof IHasFormId && StringUtils.isNotBlank((CharSequence)((IHasFormId)noCodeWfNode).getTargetFormId())) {
                IDataEntityProperty assignmentProperty;
                AssignmentInfo info = new AssignmentInfo();
                String formId = ((IHasFormId)noCodeWfNode).getTargetFormId();
                info.setFormId(formId);
                BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)formId);
                if (dt != null) {
                    assignmentProperty = dt.findProperty(refModelField);
                    if (assignmentProperty == null) {
                        return null;
                    }
                } else {
                    return null;
                }
                info.setFieldId(refModelField);
                String number = String.format("%s_%s", formId, refModelField);
                info.setNumber(number);
                String queryNodePkVar = assignment.replaceAll("(\\$\\{proc\\..+?ExecuteResult\\.).+?(\\})", "$1id$2");
                String value = String.format("%s.%s.%s", formId, refModelField, queryNodePkVar);
                info.setValue((Object)value);
                info.setName(assignmentProperty.getDisplayName() != null ? assignmentProperty.getDisplayName().toString() : assignmentProperty.getName());
                String dataType = NcEntityTypeUtil.getDataType((IDataEntityProperty)assignmentProperty);
                info.setType(dataType);
                info.setOption(NcEntityTypeUtil.defaultOptionCustom((IDataEntityProperty)assignmentProperty));
                return info;
            }
        } else {
            AssignmentInfo info = new AssignmentInfo();
            String fieldId = assignment.replaceAll("\\$\\{model\\.(.+?)\\}", "$1");
            info.setFieldId(fieldId);
            info.setNumber(fieldId);
            info.setValue((Object)fieldId);
            String modelFormId = AssignmentHelper.getModelFormId(ncMetaData);
            info.setFormId(modelFormId);
            BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)modelFormId);
            if (dt != null) {
                IDataEntityProperty assignmentProperty = dt.findProperty(fieldId);
                if (assignmentProperty != null) {
                    info.setName(assignmentProperty.getDisplayName() != null ? assignmentProperty.getDisplayName().toString() : assignmentProperty.getName());
                    info.setType(NcEntityTypeUtil.getDataType((IDataEntityProperty)assignmentProperty));
                    info.setOption(NcEntityTypeUtil.defaultOptionCustom((IDataEntityProperty)assignmentProperty));
                } else {
                    return null;
                }
            }
            return info;
        }
        return null;
    }

    public static AssignmentInfo getAssignmentFieldInfoByUpdateBill(UpdateSettingItem updateSettingItem, NoCodeWfMetaData ncMetaData) {
        String assignment = updateSettingItem.getAssignment();
        if (StringUtils.isBlank((CharSequence)assignment)) {
            return null;
        }
        Pattern compile = WfConsts.VAR_PROC_PATTERN_OF_EXECUTERESULT;
        Matcher matcher = compile.matcher(assignment);
        if (matcher.matches()) {
            String refNodeId = matcher.group(1);
            String refModelField = matcher.group(2);
            Optional<NoCodeWfNode> first = ncMetaData.getNodes().stream().filter(n -> n.getId().equalsIgnoreCase(refNodeId)).findFirst();
            if (!first.isPresent()) {
                return null;
            }
            NoCodeWfNode noCodeWfNode = first.get();
            if (noCodeWfNode instanceof IHasFormId && StringUtils.isNotBlank((CharSequence)((IHasFormId)noCodeWfNode).getTargetFormId())) {
                IDataEntityProperty assignmentProperty;
                AssignmentInfo info = new AssignmentInfo();
                String formId = ((IHasFormId)noCodeWfNode).getTargetFormId();
                info.setFormId(formId);
                BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)formId);
                if (dt != null) {
                    assignmentProperty = dt.findProperty(refModelField);
                    if (assignmentProperty == null) {
                        return null;
                    }
                } else {
                    return null;
                }
                info.setFieldId(refModelField);
                info.setNumber(refModelField);
                info.setValue((Object)refModelField);
                info.setName(assignmentProperty.getDisplayName() != null ? assignmentProperty.getDisplayName().toString() : assignmentProperty.getName());
                String dataType = NcEntityTypeUtil.getDataType((IDataEntityProperty)assignmentProperty);
                info.setType(dataType);
                info.setOption(NcEntityTypeUtil.defaultOptionCustom((IDataEntityProperty)assignmentProperty));
                return info;
            }
        } else {
            Pattern compileDisp = WfConsts.VAR_DISP_PATTERN_OF_FIELD;
            Matcher matcherDisp = compileDisp.matcher(assignment);
            if (matcherDisp.matches()) {
                IDataEntityProperty assignmentProperty;
                String formId = matcherDisp.group(1);
                String refModelField = matcherDisp.group(2);
                AssignmentInfo info = new AssignmentInfo();
                BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)formId);
                if (dt != null) {
                    assignmentProperty = dt.findProperty(refModelField);
                    if (assignmentProperty == null) {
                        return null;
                    }
                } else {
                    return null;
                }
                info.setFieldId(refModelField);
                info.setNumber(refModelField);
                info.setValue((Object)refModelField);
                info.setName(assignmentProperty.getDisplayName() != null ? assignmentProperty.getDisplayName().toString() : assignmentProperty.getName());
                String dataType = NcEntityTypeUtil.getDataType((IDataEntityProperty)assignmentProperty);
                info.setType(dataType);
                info.setOption(NcEntityTypeUtil.defaultOptionCustom((IDataEntityProperty)assignmentProperty));
                return info;
            }
            AssignmentInfo info = new AssignmentInfo();
            String fieldId = assignment.replaceAll("\\$\\{model\\.(.+?)\\}", "$1");
            info.setFieldId(fieldId);
            info.setNumber(fieldId);
            info.setValue((Object)fieldId);
            String modelFormId = AssignmentHelper.getModelFormId(ncMetaData);
            info.setFormId(modelFormId);
            BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)modelFormId);
            if (dt != null) {
                IDataEntityProperty assignmentProperty = dt.findProperty(fieldId);
                if (assignmentProperty != null) {
                    info.setName(assignmentProperty.getDisplayName() != null ? assignmentProperty.getDisplayName().toString() : assignmentProperty.getName());
                    info.setType(NcEntityTypeUtil.getDataType((IDataEntityProperty)assignmentProperty));
                    info.setOption(NcEntityTypeUtil.defaultOptionCustom((IDataEntityProperty)assignmentProperty));
                } else {
                    return null;
                }
            }
            return info;
        }
        return null;
    }

    public static AssignmentInfo getAssignmentFieldInfoByNewBill(NoCodeWfNodeNewBill node, NewSettingItem updateSettingItem) {
        IDataEntityProperty assignmentProperty;
        String assignment = updateSettingItem.getAssignment();
        if (StringUtils.isBlank((CharSequence)assignment) || StringUtils.isBlank((CharSequence)node.getFormId())) {
            return null;
        }
        AssignmentInfo info = new AssignmentInfo();
        info.setFieldId(assignment);
        info.setNumber(assignment);
        info.setValue((Object)assignment);
        String formId = node.getFormId();
        info.setFormId(formId);
        BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)formId);
        if (dt != null) {
            assignmentProperty = dt.findProperty(assignment);
            if (assignmentProperty == null) {
                return null;
            }
        } else {
            return null;
        }
        info.setName(assignmentProperty.getDisplayName() != null ? assignmentProperty.getDisplayName().toString() : assignmentProperty.getName());
        info.setType(NcEntityTypeUtil.getDataType((IDataEntityProperty)assignmentProperty));
        info.setOption(NcEntityTypeUtil.defaultOptionCustom((IDataEntityProperty)assignmentProperty));
        return info;
    }

    private static String getModelFormId(NoCodeWfMetaData ncMetaData) {
        NoCodeWfNodeStart startNode = NoCodeWfMetaHelper.getStartNode((NoCodeWfMetaData)ncMetaData);
        return startNode.getFormId();
    }
}

