/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.FunctionGroup;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.NoCodeRuntimeService;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.express.NoCodeExpCtx;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfGraphCell;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.info.SettingItem;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.NoCodeWfNodeAutoMicroSrv;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.OutParam;
import kd.bos.nocode.utils.DateTimeUtils;
import kd.bos.nocode.utils.FuncUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.service.ServiceFactory;

public class ExpressDesignMetaHelper {
    private static Log log = LogFactory.getLog(ExpressDesignMetaHelper.class);
    public static final String KEY_SET_DESIGN_META = "setDesignMeta";
    private static final String RULES_DESIGN_META_FUNCTION_TYPES = "functionTypes";
    private static final String RULES_DESIGN_META_FUNCTION_OPERATIONS = "functionOperations";
    private static final Map<String, String> operationCharacter = new LinkedHashMap<String, String>(21);

    private ExpressDesignMetaHelper() {
        throw new IllegalStateException("ExpressDesignMetaHelper class");
    }

    public static synchronized Map<String, Object> getExpressDesignMeta(String metaType, String xmlFuncs, boolean isWf) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("metaType", metaType);
        FunctionTypes functionTypes = FuncUtil.getNoCodeFunctionType();
        ret.put(RULES_DESIGN_META_FUNCTION_TYPES, ExpressDesignMetaHelper.parseToJsonObject(functionTypes, isWf));
        ret.put(RULES_DESIGN_META_FUNCTION_OPERATIONS, operationCharacter);
        return ret;
    }

    public static FunctionType getFunctionType(String functionId, String xmlFuncs) {
        FunctionTypes functionTypes = null;
        functionTypes = StringUtils.isNotBlank((CharSequence)xmlFuncs) ? FunctionTypes.get((String)xmlFuncs) : FunctionTypes.get();
        Optional<FunctionType> first = functionTypes.getFunctionTypes().stream().filter(f -> f.getId().equalsIgnoreCase(functionId)).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        return null;
    }

    private static synchronized JSONArray parseToJsonObject(FunctionTypes functionTypes, boolean isWf) {
        JSONArray data = new JSONArray();
        List functionGroups = functionTypes.getFunctionGroups();
        Collections.sort(functionGroups, Comparator.comparingInt(FunctionGroup::getSeq));
        Map funcMap = FunctionManage.get().getFuncMap();
        for (FunctionGroup functionGroup : functionGroups) {
            if (!functionGroup.isVisible()) continue;
            JSONObject group = new JSONObject();
            group.put("id", (Object)functionGroup.getId());
            group.put("name", (Object)functionGroup.getName().toString());
            group.put("seq", (Object)functionGroup.getSeq());
            group.put("expend", (Object)functionGroup.isExpend());
            List types = functionTypes.getFunctionTypes().stream().filter(t -> functionGroup.getId().equalsIgnoreCase(t.getGroupId())).collect(Collectors.toList());
            Collections.sort(types, Comparator.comparingInt(FunctionType::getSeq));
            JSONArray typesData = new JSONArray();
            for (FunctionType functionType : types) {
                if (StringUtils.isNotBlank((CharSequence)functionType.getSettingFormId()) && !"DateTime".equals(functionType.getGroupId()) || "disp".equalsIgnoreCase(functionType.getId())) continue;
                JSONObject type = new JSONObject();
                String id = ExpressDesignMetaHelper.getRealFuncId(funcMap, functionType);
                type.put("id", (Object)id);
                type.put("name", (Object)functionType.getName().toString());
                type.put("def", (Object)functionType.getDef());
                type.put("returnType", (Object)functionType.getReturnType());
                type.put("desc", (Object)functionType.getDesc().toString().replace("\\n", "\n"));
                type.put("runClass", (Object)functionType.getRunClass());
                type.put("settingFormId", (Object)functionType.getSettingFormId());
                type.put("seq", (Object)functionType.getSeq());
                typesData.add((Object)type);
            }
            if (typesData.isEmpty()) continue;
            group.put("types", (Object)typesData);
            data.add((Object)group);
        }
        return data;
    }

    private static String getRealFuncId(Map<String, BOSUDFunction> funcMap, FunctionType functionType) {
        if (funcMap.containsKey(functionType.getId())) {
            return functionType.getId();
        }
        BOSUDFunction funcInstance = ExpressDesignMetaHelper.createFuncInstance(functionType.getRunClass());
        if (funcInstance != null) {
            return funcInstance.getName();
        }
        return functionType.getId();
    }

    public static String checkExpressionRefModel(String expression, String currentNodeId, JSONObject variables, boolean isAssignment, NoCodeWfMetaData noCodeWfMetaData, WfDesignerCtx ctx) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        String rtExpression = NcEntityTypeUtil.getRuntimeExpression((String)expression);
        StringBuilder sb = new StringBuilder();
        Matcher matcherDisp = WfConsts.VAR_DISP_PATTERN.matcher(rtExpression);
        while (matcherDisp.find()) {
            String dispVar = matcherDisp.group();
            JSONObject varItem = VariableHelper.findVariable(currentNodeId, dispVar, variables, noCodeWfMetaData, ctx);
            if (varItem == null) {
                log.debug("nocode:\u5b57\u6bb5\u5f15\u7528\u5931\u6548,dispVar:" + dispVar);
                sb.append(ResManager.loadKDString((String)"\u5b57\u6bb5\u5f15\u7528\u5931\u6548", (String)"ExpressDesignMetaHelper_0", (String)"bos-nocode-formplugin", (Object[])new Object[0])).append("\n");
                continue;
            }
            if (!isAssignment || !ExpressDesignMetaHelper.isRec(varItem)) continue;
            sb.append(ResManager.loadKDString((String)"\u4e0d\u53ef\u4fee\u6539\u7684\u8d4b\u503c\u5bf9\u8c61", (String)"ExpressDesignMetaHelper_1", (String)"bos-nocode-formplugin", (Object[])new Object[0])).append("\n");
        }
        Matcher m = WfConsts.varModelPattern.matcher(rtExpression);
        while (m.find()) {
            String modelVar = m.group();
            JSONObject varItem = VariableHelper.findVariable(currentNodeId, modelVar, variables, noCodeWfMetaData, ctx);
            if (varItem == null) {
                log.debug("nocode:\u5b57\u6bb5\u5f15\u7528\u5931\u6548,modelVar:" + modelVar);
                sb.append(ResManager.loadKDString((String)"\u5b57\u6bb5\u5f15\u7528\u5931\u6548", (String)"ExpressDesignMetaHelper_0", (String)"bos-nocode-formplugin", (Object[])new Object[0])).append("\n");
                continue;
            }
            if (!isAssignment || !ExpressDesignMetaHelper.isRec(varItem)) continue;
            sb.append(ResManager.loadKDString((String)"\u4e0d\u53ef\u4fee\u6539\u7684\u8d4b\u503c\u5bf9\u8c61", (String)"ExpressDesignMetaHelper_1", (String)"bos-nocode-formplugin", (Object[])new Object[0])).append("\n");
        }
        return sb.toString();
    }

    public static String checkExpressionRefProc(String expression, String currentNodeId, boolean checkIsResult, JSONObject variables, NoCodeWfMetaData noCodeWfMetaData, WfDesignerCtx ctx) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        String rtExpression = NcEntityTypeUtil.getRuntimeExpression((String)expression);
        StringBuilder sb = new StringBuilder();
        Matcher matcherDisp = WfConsts.VAR_DISP_PATTERN.matcher(rtExpression);
        while (matcherDisp.find()) {
            String dispVar = matcherDisp.group();
            JSONObject varItem = VariableHelper.findVariable(currentNodeId, dispVar, variables, noCodeWfMetaData, ctx);
            if (varItem == null) {
                log.debug("nocode:\u5b57\u6bb5\u5f15\u7528\u5931\u6548,dispVar:" + dispVar);
                sb.append(ResManager.loadKDString((String)"\u5b57\u6bb5\u5f15\u7528\u5931\u6548", (String)"ExpressDesignMetaHelper_0", (String)"bos-nocode-formplugin", (Object[])new Object[0])).append("\n");
            }
            if (!checkIsResult || !ExpressDesignMetaHelper.isRec(varItem)) continue;
            sb.append(ResManager.loadKDString((String)"\u4e0d\u53ef\u4fee\u6539\u7684\u8d4b\u503c\u5bf9\u8c61", (String)"ExpressDesignMetaHelper_1", (String)"bos-nocode-formplugin", (Object[])new Object[0])).append("\n");
        }
        Matcher m = WfConsts.varProcPattern.matcher(rtExpression);
        while (m.find()) {
            boolean isResult;
            String procVar = m.group();
            if ("${proc.procName}".equalsIgnoreCase(procVar)) continue;
            JSONObject varItem = VariableHelper.findVariable(currentNodeId, procVar, variables, noCodeWfMetaData, ctx);
            if (varItem == null) {
                log.debug("nocode:\u5b57\u6bb5\u5f15\u7528\u5931\u6548,procVar:" + procVar);
                sb.append(ResManager.loadKDString((String)"\u5b57\u6bb5\u5f15\u7528\u5931\u6548", (String)"ExpressDesignMetaHelper_0", (String)"bos-nocode-formplugin", (Object[])new Object[0])).append("\n");
                continue;
            }
            if (checkIsResult && varItem.containsKey((Object)"isResult") && (isResult = ((Boolean)varItem.get((Object)"isResult")).booleanValue())) {
                sb.append(ResManager.loadKDString((String)"\u4e0d\u53ef\u4fee\u6539\u7684\u8d4b\u503c\u5bf9\u8c61", (String)"ExpressDesignMetaHelper_1", (String)"bos-nocode-formplugin", (Object[])new Object[0])).append("\n");
                continue;
            }
            if (checkIsResult && VariableHelper.isAssigneeVar(procVar)) {
                sb.append(ResManager.loadKDString((String)"\u4e0d\u53ef\u4fee\u6539\u7684\u8d4b\u503c\u5bf9\u8c61", (String)"ExpressDesignMetaHelper_1", (String)"bos-nocode-formplugin", (Object[])new Object[0])).append("\n");
                continue;
            }
            if (!checkIsResult || !ExpressDesignMetaHelper.isRec(varItem)) continue;
            sb.append(ResManager.loadKDString((String)"\u4e0d\u53ef\u4fee\u6539\u7684\u8d4b\u503c\u5bf9\u8c61", (String)"ExpressDesignMetaHelper_1", (String)"bos-nocode-formplugin", (Object[])new Object[0])).append("\n");
        }
        return sb.toString();
    }

    private static boolean isRec(JSONObject fieldVar) {
        if (fieldVar == null) {
            return false;
        }
        Map option = (Map)fieldVar.get((Object)"option");
        if (option == null) {
            return false;
        }
        return option.containsKey("isRec") && (Boolean)option.get("isRec") != false;
    }

    private static BOSUDFunction createFuncInstance(String funcRunClass) {
        try {
            return (BOSUDFunction)TypesContainer.createInstance((String)funcRunClass);
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static String checkExpression(SettingItem settingItem, NoCodeWfGraphCell node, WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        try {
            String newRtExpression;
            String expression = settingItem.getExpression();
            if (StringUtils.isBlank((CharSequence)expression)) {
                return null;
            }
            String rtExpression = NcEntityTypeUtil.getRuntimeExpression((String)expression);
            if (rtExpression == null) {
                newRtExpression = "";
            } else {
                newRtExpression = ExpressDesignMetaHelper.mockModelFieldVar(rtExpression, node, ctx, ncMetaData);
                newRtExpression = ExpressDesignMetaHelper.mockProcVar(newRtExpression, node, ctx, ncMetaData);
                newRtExpression = ExpressDesignMetaHelper.mockDispVar(newRtExpression, node, ctx, ncMetaData);
            }
            NoCodeRuntimeService service = (NoCodeRuntimeService)ServiceFactory.getService(NoCodeRuntimeService.class);
            final String finalExpression = newRtExpression;
            NoCodeExpCtx expCtx = new NoCodeExpCtx(){

                public String getExpression() {
                    return finalExpression;
                }

                public Object getVarValue(String key) {
                    return key;
                }

                public Map<String, Object> getCustomParam() {
                    HashMap<String, Object> customParam = new HashMap<String, Object>();
                    customParam.put(WfConsts.ExpressionCtxType.class.getName(), WfConsts.ExpressionCtxType.CONDITION.getCode());
                    return customParam;
                }
            };
            return service.checkExpression(expCtx);
        }
        catch (Exception ex) {
            log.warn((Throwable)ex);
            return null;
        }
    }

    public static String tryMockAndParseExpression(String expression, NoCodeWfGraphCell node, WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        try {
            String newRtExpression;
            if (StringUtils.isBlank((CharSequence)expression)) {
                return null;
            }
            String rtExpression = NcEntityTypeUtil.getRuntimeExpression((String)expression);
            if (rtExpression == null) {
                newRtExpression = "";
            } else {
                newRtExpression = ExpressDesignMetaHelper.mockModelFieldVar(rtExpression, node, ctx, ncMetaData);
                newRtExpression = ExpressDesignMetaHelper.mockProcVar(newRtExpression, node, ctx, ncMetaData);
                newRtExpression = ExpressDesignMetaHelper.mockDispVar(newRtExpression, node, ctx, ncMetaData);
            }
            NoCodeRuntimeService service = (NoCodeRuntimeService)ServiceFactory.getService(NoCodeRuntimeService.class);
            final String finalExpression = newRtExpression;
            NoCodeExpCtx expCtx = new NoCodeExpCtx(){

                public String getExpression() {
                    return finalExpression;
                }

                public Object getVarValue(String key) {
                    return key;
                }

                public Map<String, Object> getCustomParam() {
                    HashMap<String, Object> customParam = new HashMap<String, Object>();
                    customParam.put(WfConsts.ExpressionCtxType.class.getName(), WfConsts.ExpressionCtxType.NOTIFY.getCode());
                    return customParam;
                }
            };
            return (String)service.getExpressionValue(expCtx);
        }
        catch (Exception ex) {
            log.warn((Throwable)ex);
            return expression;
        }
    }

    private static String getAssignmentDataType(SettingItem settingItem, NoCodeWfNodeAutoMicroSrv node) {
        if (StringUtils.isBlank((CharSequence)settingItem.getAssignment())) {
            return null;
        }
        Optional<OutParam> first = node.getOutParams().stream().filter(p -> settingItem.getAssignment().equalsIgnoreCase(p.getNumber())).findFirst();
        if (first.isPresent()) {
            return first.get().getType();
        }
        return null;
    }

    private static String mockModelFieldVar(String rtExpression, NoCodeWfGraphCell node, WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        Matcher m = WfConsts.varModelPattern.matcher(rtExpression);
        while (m.find()) {
            String modelVar = m.group();
            JSONObject varItem = VariableHelper.findVariable(node.getId(), modelVar, ctx.getVariables(), ncMetaData, ctx);
            Object mockData = "text".equalsIgnoreCase((String)varItem.get((Object)"type")) && ExpressDesignMetaHelper.isIncludeDateFunc(rtExpression) ? "\"" + DateTimeUtils.formatDateTime((Date)new Date()) + "\"" : NcEntityTypeUtil.getMockDataByType((JSONObject)varItem);
            String sMockData = mockData == null ? "" : mockData.toString();
            rtExpression = rtExpression.replace(modelVar, sMockData);
        }
        return rtExpression;
    }

    private static boolean isIncludeDateFunc(String rtExpression) {
        if (StringUtils.isBlank((CharSequence)rtExpression)) {
            return false;
        }
        return FuncUtil.HAS_DATE_FUNC_PATTERN.matcher(rtExpression).matches();
    }

    private static String mockProcVar(String rtExpression, NoCodeWfGraphCell node, WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        Matcher m = WfConsts.varProcPattern.matcher(rtExpression);
        while (m.find()) {
            String procVar = m.group();
            if ("${proc.procName}".equalsIgnoreCase(procVar)) {
                rtExpression = rtExpression.replace(procVar, ResManager.loadKDString((String)"\"\u6d41\u7a0b\u540d\u79f0\"", (String)"ExpressDesignMetaHelper_3", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
                continue;
            }
            JSONObject varItem = VariableHelper.findVariable(node.getId(), procVar, ctx.getVariables(), ncMetaData, ctx);
            Object mockData = "text".equalsIgnoreCase((String)varItem.get((Object)"type")) && ExpressDesignMetaHelper.isIncludeDateFunc(rtExpression) ? "\"" + DateTimeUtils.formatDateTime((Date)new Date()) + "\"" : NcEntityTypeUtil.getMockDataByType((JSONObject)varItem);
            String sMockData = mockData == null ? "" : mockData.toString();
            rtExpression = rtExpression.replace(procVar, sMockData);
        }
        return rtExpression;
    }

    private static String mockDispVar(String rtExpression, NoCodeWfGraphCell node, WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        Matcher m = WfConsts.VAR_DISP_PATTERN.matcher(rtExpression);
        while (m.find()) {
            String dispVar = m.group();
            rtExpression = rtExpression.replace(dispVar, "\"1\"");
        }
        return rtExpression;
    }

    public static boolean isNeedCallExpressParse(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return false;
        }
        return expression.indexOf("@@") != -1 || WfConsts.varPattern.matcher(expression).matches();
    }

    static {
        operationCharacter.put("plus", "+");
        operationCharacter.put("subtract", "-");
        operationCharacter.put("multiple", "*");
        operationCharacter.put("divide", "/");
        operationCharacter.put("equal", "=");
        operationCharacter.put("squarebrackets", "<>");
        operationCharacter.put("less", "<");
        operationCharacter.put("lessequal", "<=");
        operationCharacter.put("greater", ">");
        operationCharacter.put("greaterequal", ">=");
        operationCharacter.put("leftparentheses", "(");
        operationCharacter.put("rightparentheses", ")");
        operationCharacter.put("and", "and");
        operationCharacter.put("or", "or");
        operationCharacter.put("not", "NOT");
        operationCharacter.put("in", "IN");
        operationCharacter.put("notin", "NOT IN");
        operationCharacter.put("like", "LIKE");
        operationCharacter.put("notlike", "NOT LIKE");
        operationCharacter.put("clr", "CLR");
        operationCharacter.put("backspace", "Backspace");
    }
}

