/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.shaded.com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfGraphCell;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.info.BillIdAndFieldsInfo;
import kd.bos.nocode.ext.metadata.wf.info.OrgRelation;
import kd.bos.nocode.ext.metadata.wf.info.ParticipantInfo;
import kd.bos.nocode.ext.metadata.wf.info.ParticipantItem;
import kd.bos.nocode.ext.metadata.wf.info.PersonRelation;
import kd.bos.nocode.ext.metadata.wf.nodes.IHasFormId;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeAudit;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeUserInput;
import kd.bos.nocode.ext.util.WfProcessUtils;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.core.util.QFilterUtil;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.pojo.HandlerFieldSuffixEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.nocode.model.Role;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticipantHelper {
    private static final Log logger = LogFactory.getLog(ParticipantHelper.class);
    public static final String USER = "user";
    public static final String NODE = "node";
    public static final String APP_ROLE = "appRole";
    private static final String SUPERIOR = "superior";
    private static final String SELF = "self";
    public static final String ORG = "org";
    public static final String ORG_MANAGER = "org_manager";
    private static final String FIXED_ORGS = "_orgs_";
    private static final String MACRO = "_macros_";

    public static ParticipantInfo getParticipantInfo(NoCodeWfNode node, ParticipantInfo participant, WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        logger.debug("participant param\uff1a{}", (Object)participant);
        if (Objects.isNull(participant)) {
            participant = new ParticipantInfo();
        }
        List<ParticipantItem> sourceData = participant.getSourceData();
        ParticipantHelper.setSourceDataValidFieldAndUpdateName(node, sourceData, ctx, ncMetaData);
        sourceData = sourceData.stream().filter(ParticipantItem::isValid).collect(Collectors.toList());
        participant.setSourceData(sourceData);
        if (CollectionUtils.isEmpty(sourceData)) {
            participant.setSourceData((List)Lists.newArrayList());
        }
        String[] persons = ParticipantHelper.getIdsByMenuType(sourceData, USER);
        participant.setPerson(persons);
        String[] appRoles = ParticipantHelper.getIdsByMenuType(sourceData, APP_ROLE);
        participant.setAppRole(appRoles);
        String[] orgs = ParticipantHelper.getIdsByMenuType(sourceData, ORG);
        String[] orgManagers = ParticipantHelper.getIdsByMenuType(sourceData, ORG_MANAGER);
        List<String> macros = ParticipantHelper.getMacros(sourceData);
        Map<String, Map<String, Object[]>> collect = sourceData.stream().filter(e -> Objects.equals(e.getMenuType(), NODE) && !macros.contains(e.getId())).collect(Collectors.groupingBy(ParticipantHelper::getClassifier, Collectors.groupingBy(ParticipantItem::getFormNumber, new UserAndOrgCollector(ctx, node, ncMetaData))));
        PersonRelation personRelation = new PersonRelation();
        personRelation.setOneself(collect.getOrDefault(SELF, Maps.newHashMap()));
        personRelation.getOneself().put(MACRO, macros.toArray());
        personRelation.setSuperior(collect.getOrDefault(SUPERIOR, Maps.newHashMap()));
        participant.setPersonRelation(personRelation);
        OrgRelation orgRelation = new OrgRelation();
        orgRelation.setAll(collect.getOrDefault(ORG, Maps.newHashMap()));
        orgRelation.getAll().put(FIXED_ORGS, orgs);
        orgRelation.setManager(collect.getOrDefault(ORG_MANAGER, Maps.newHashMap()));
        orgRelation.getManager().put(FIXED_ORGS, orgManagers);
        participant.setOrgRelation(orgRelation);
        logger.debug("participant result\uff1a{}", (Object)participant);
        return participant;
    }

    private static List<String> getMacros(List<ParticipantItem> sourceData) {
        Iterator<ParticipantItem> iterator = sourceData.iterator();
        ArrayList<String> macros = new ArrayList<String>(sourceData.size());
        while (iterator.hasNext()) {
            ParticipantItem item = iterator.next();
            if (!item.getId().startsWith("Proc")) continue;
            macros.add(item.getId());
        }
        return macros;
    }

    private static String[] getIdsByMenuType(@NotNull List<ParticipantItem> sourceData, @NotNull String type) {
        return (String[])sourceData.stream().filter(e -> Objects.equals(e.getMenuType(), type)).map(ParticipantItem::getId).toArray(String[]::new);
    }

    private static void setSourceDataValidFieldAndUpdateName(NoCodeWfNode node, List<ParticipantItem> sourceData, WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        Map<String, List<ParticipantItem>> menuType2Items = sourceData.stream().collect(Collectors.groupingBy(ParticipantItem::getMenuType));
        block13: for (Map.Entry<String, List<ParticipantItem>> entry : menuType2Items.entrySet()) {
            String menuType = entry.getKey();
            List<ParticipantItem> items = entry.getValue();
            switch (menuType) {
                case "user": {
                    ParticipantHelper.checkUserValid(items);
                    continue block13;
                }
                case "org": 
                case "org_manager": {
                    ParticipantHelper.checkOrgValid(items, menuType.equals(ORG) ? WfConsts.getParticipantNamePrefixOrg() : WfConsts.getParticipantNamePrefixOrgManager());
                    continue block13;
                }
                case "appRole": {
                    ParticipantHelper.checkAppRoleValid(items, ctx.getAppId());
                    continue block13;
                }
                case "node": {
                    ParticipantHelper.checkNodeValid(node, items, ncMetaData.getNodes(), ctx, ncMetaData);
                    continue block13;
                }
            }
            throw new RestApiException("invalid menu type");
        }
    }

    private static void checkNodeValid(NoCodeWfNode currentNode, List<ParticipantItem> items, List<NoCodeWfNode> nodes, WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        List parentNodes = WfProcessUtils.getParentNodes((String)currentNode.getId(), (String)ncMetaData.getId(), nodes);
        List<NoCodeWfNode> menuNodes = ParticipantHelper.getMenuNodes(nodes, node -> parentNodes.contains(node.getId()));
        Map id2Node = menuNodes.stream().collect(Collectors.toMap(NoCodeWfGraphCell::getId, Function.identity()));
        List nodeMenus = menuNodes.stream().map(ParticipantHelper::wrapNode2MenuItem).filter(Objects::nonNull).collect(Collectors.toList());
        Map id2MenuItem = nodeMenus.stream().collect(Collectors.toMap(m -> (String)m.get("id"), Function.identity()));
        for (ParticipantItem e : items) {
            String menuId = e.getMenuId();
            NoCodeWfNode noCodeWfNode = (NoCodeWfNode)id2Node.get(menuId);
            Map menuItem = (Map)id2MenuItem.get(menuId);
            if (Objects.isNull(noCodeWfNode) || Objects.isNull(menuItem)) {
                e.setValid(false);
                continue;
            }
            String nodeName = menuNodes.stream().filter(nodeItem -> nodeItem.getId().equals(e.getMenuId())).findFirst().map(NoCodeWfNode::getName).orElse("");
            String[] fieldKeyAndSuffix = e.getId().split("\\$");
            String fieldKey = fieldKeyAndSuffix[0];
            String fieldSuffixDesc = "";
            if (fieldKeyAndSuffix.length > 1) {
                fieldSuffixDesc = HandlerFieldSuffixEnum.getSuffixDescByConstant(fieldKeyAndSuffix[1]);
            }
            String formNumber = e.getFormNumber();
            if (e.getFormNumber().equals("auditNode")) {
                e.setName("[" + nodeName + "]" + ResManager.loadKDString((String)"\u5ba1\u6279\u4eba", (String)"ParticipantHelper_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (!NcEntityTypeUtil.isFormExist((String)formNumber) || !Objects.equals(formNumber, menuItem.get("formNumber"))) {
                e.setValid(false);
                continue;
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formNumber);
            DynamicProperty property = dataEntityType.getProperty(fieldKey);
            if (Objects.isNull(property)) {
                if (WfProcessUtils.isUserInputNode((String)menuId) && fieldKey.startsWith("Proc")) continue;
                e.setValid(false);
                continue;
            }
            String formName = dataEntityType.getDisplayName().getLocaleValue();
            String fieldName = property.getDisplayName().getLocaleValue();
            e.setName("[" + nodeName + "\uff08" + formName + "\uff09]" + fieldName + fieldSuffixDesc);
        }
    }

    private static void checkAppRoleValid(List<ParticipantItem> items, String appId) {
        List roles = NoCodePermissionServiceHelper.getRoleByAppId((String)appId);
        Map<String, String> id2NameMap = roles.stream().collect(Collectors.toMap(Role::getId, e -> NoCodePermHelper.getRoleName((String)e.getName())));
        Set<String> existIdList = id2NameMap.keySet();
        items.forEach(e -> {
            String id = e.getId();
            if (!existIdList.contains(id)) {
                e.setValid(false);
            } else {
                e.setName(WfConsts.getParticipantNamePrefixAppRole() + (String)id2NameMap.get(id));
            }
        });
    }

    private static void checkOrgValid(List<ParticipantItem> items, String namePrefix) {
        List orgIdList = items.stream().map(ParticipantItem::getId).map(Long::parseLong).collect(Collectors.toList());
        List orgEmbeddedFilters = QFilterUtil.getOrgEmbeddedFilters();
        QFilter filter = new QFilter("id", "in", orgIdList);
        orgEmbeddedFilters.add(filter);
        DynamicObject[] existOrg = BusinessDataServiceHelper.load((String)"bos_adminorg", (String)"id,name", (QFilter[])orgEmbeddedFilters.toArray(new QFilter[0]));
        Map<Object, String> id2NameMap = Arrays.stream(existOrg).collect(Collectors.toMap(DataEntityBase::getPkValue, e -> e.getLocaleString("name").toString()));
        Set<Object> existPkIds = id2NameMap.keySet();
        items.forEach(e -> {
            Long id = Long.parseLong(e.getId());
            if (!existPkIds.contains(id)) {
                e.setValid(false);
            } else {
                e.setName(namePrefix + (String)id2NameMap.get(id));
            }
        });
    }

    private static void checkUserValid(List<ParticipantItem> items) {
        List userIdList = items.stream().map(ParticipantItem::getId).map(Long::parseLong).collect(Collectors.toList());
        List userEmbeddedFilters = QFilterUtil.getUserEmbeddedFilters();
        QFilter idFilter = new QFilter("id", "in", userIdList);
        userEmbeddedFilters.add(idFilter);
        DynamicObject[] existUsers = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name", (QFilter[])userEmbeddedFilters.toArray(new QFilter[0]));
        Map<Object, String> id2NameMap = Arrays.stream(existUsers).collect(Collectors.toMap(DataEntityBase::getPkValue, e -> e.getLocaleString("name").toString()));
        Set<Object> existPkIds = id2NameMap.keySet();
        items.forEach(e -> {
            Long id = Long.parseLong(e.getId());
            if (!existPkIds.contains(id)) {
                e.setValid(false);
            } else {
                e.setName(WfConsts.getParticipantNamePrefixUser() + (String)id2NameMap.get(id));
            }
        });
    }

    @NotNull
    private static String getClassifier(ParticipantItem participantItem) {
        String id = participantItem.getId();
        String suffix = ParticipantHelper.getSuffix(id);
        if (suffix.equalsIgnoreCase("$superior")) {
            return SUPERIOR;
        }
        if (suffix.equalsIgnoreCase("$org")) {
            return ORG;
        }
        if (suffix.equalsIgnoreCase("$org_manager")) {
            return ORG_MANAGER;
        }
        return SELF;
    }

    private static String getSuffix(String id) {
        int lastIndex = id.lastIndexOf("$");
        if (lastIndex == -1) {
            return "";
        }
        return id.substring(lastIndex);
    }

    public static boolean isDiff(NoCodeWfNode newNode, ParticipantInfo newInfo, NoCodeWfNode oldNode, ParticipantInfo oldInfo, WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        if (newInfo == null && oldInfo == null) {
            return false;
        }
        if (newInfo == null || oldInfo == null) {
            return true;
        }
        return !Objects.equals(newInfo, oldInfo);
    }

    public static List<NoCodeWfNode> getMenuNodes(List<NoCodeWfNode> nodes) {
        return ParticipantHelper.getMenuNodes(nodes, e -> true);
    }

    public static List<NoCodeWfNode> getMenuNodes(List<NoCodeWfNode> nodes, Predicate<NoCodeWfNode> customFilter) {
        return nodes.stream().filter(e -> customFilter.test((NoCodeWfNode)e) && ParticipantHelper.canAdd2Menu(e)).collect(Collectors.toList());
    }

    private static boolean canAdd2Menu(NoCodeWfNode node) {
        if (node instanceof NoCodeWfNodeAudit) {
            return true;
        }
        return node instanceof IHasFormId && StringUtils.isNotBlank((CharSequence)((IHasFormId)node).getTargetFormId());
    }

    @Nullable
    public static Map<String, Object> wrapNode2MenuItem(NoCodeWfNode node) {
        String formNumber = ParticipantHelper.getFormNumber(node);
        String selectProperties = "id,fieldName,fieldType";
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)formNumber)) {
            if (node instanceof NoCodeWfNodeAudit) {
                return ParticipantHelper.buildMenuItem(node.getItemId(), node.getName(), NODE, "auditNode", selectProperties, ListConfigUtils.getWfNodeApproverListConfig());
            }
            return null;
        }
        if (formNumber.contains(",")) {
            formNumber = formNumber.split(",")[1];
        }
        String itemId = node.getItemId();
        String procName = node.getName();
        String formName = ParticipantHelper.getFormName(formNumber);
        String menuName = procName + "\uff08" + formName + "\uff09";
        return ParticipantHelper.buildMenuItem(itemId, menuName, NODE, formNumber, selectProperties, ListConfigUtils.getWfNodeApproverListConfig());
    }

    private static String getFormNumber(NoCodeWfNode node) {
        if (node instanceof IHasFormId) {
            String formId = ((IHasFormId)node).getTargetFormId();
            return NcEntityTypeUtil.getRealBillEntityNumber((String)formId);
        }
        return "";
    }

    private static String getFormName(String formNumber) {
        return NcEntityTypeUtil.getFormCaption((String)formNumber);
    }

    public static Map<String, Object> buildMenuItem(String id, String name, String type, String formNumber, String select, List<Map<String, Object>> listItemConfig) {
        HashMap<String, Object> menuItem = new HashMap<String, Object>(4);
        menuItem.put("id", id);
        menuItem.put("name", name);
        menuItem.put("type", type);
        menuItem.put("formNumber", formNumber);
        menuItem.put("select", select);
        menuItem.put("listItemConfig", listItemConfig);
        return menuItem;
    }

    private static class UserAndOrgCollector
    implements Collector<ParticipantItem, List<ParticipantItem>, Object[]> {
        private final WfDesignerCtx ctx;
        private final NoCodeWfNode node;
        private final NoCodeWfMetaData ncMetaData;

        public UserAndOrgCollector(WfDesignerCtx ctx, NoCodeWfNode node, NoCodeWfMetaData ncMetaData) {
            this.ctx = ctx;
            this.node = node;
            this.ncMetaData = ncMetaData;
        }

        @Override
        public Supplier<List<ParticipantItem>> supplier() {
            return ArrayList::new;
        }

        @Override
        public BiConsumer<List<ParticipantItem>, ParticipantItem> accumulator() {
            return List::add;
        }

        @Override
        public BinaryOperator<List<ParticipantItem>> combiner() {
            return (list1, list2) -> {
                list1.addAll(list2);
                return list1;
            };
        }

        @Override
        public Function<List<ParticipantItem>, Object[]> finisher() {
            return e -> (BillIdAndFieldsInfo[])e.stream().map(e1 -> {
                logger.debug("\u805a\u5408ApproverItem\uff1a{}", (Object)SerializationUtils.toJsonString((Object)e1));
                BillIdAndFieldsInfo itemMap = new BillIdAndFieldsInfo();
                String id = e1.getId();
                int lastIndex = id.lastIndexOf("$");
                if (lastIndex != -1) {
                    id = id.substring(0, lastIndex);
                }
                String[] fields = new String[]{id};
                itemMap.setFields(fields);
                String menuId = e1.getMenuId();
                NoCodeWfNode menuNode = this.ncMetaData.getNodes().stream().filter(metaNode -> metaNode.getItemId().equalsIgnoreCase(menuId)).findFirst().orElse(null);
                if (menuId.contains("StartSignalEvent")) {
                    itemMap.setBillId("${execution.businessKey}");
                } else if (Objects.nonNull(menuNode) && menuNode instanceof NoCodeWfNodeUserInput) {
                    itemMap.setBillId(((NoCodeWfNodeUserInput)menuNode).getBillId());
                } else {
                    JSONArray variables = this.ctx.getVariables().getJSONArray(menuId);
                    if (CollectionUtils.isEmpty((Collection)variables)) {
                        return null;
                    }
                    logger.debug("variables\uff1a{}", (Object)SerializationUtils.toJsonString((Object)variables));
                    String billId = variables.stream().map(JSONObject.class::cast).filter(this::isPkVariable).findFirst().map(obj -> obj.getString("value")).orElse("");
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)billId)) {
                        logger.debug("\u89e3\u6790\u8868\u5355ID\u5f02\u5e38\uff0c\u672a\u627e\u5230pk\u7c7b\u578b\u7684\u5b8f\u53d8\u91cf, nodeType={}, menuId={}", (Object)menuId, (Object)this.node.getClass().getSimpleName());
                        return null;
                    }
                    itemMap.setBillId(billId);
                }
                return itemMap;
            }).filter(Objects::nonNull).toArray(BillIdAndFieldsInfo[]::new);
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }

        private boolean isPkVariable(JSONObject obj) {
            return "pk".equalsIgnoreCase(obj.getString("type")) && UserAndOrgCollector.canVisible(obj);
        }

        private static boolean canVisible(JSONObject obj) {
            JSONObject option = obj.getJSONObject("option");
            return !option.containsKey((Object)"visible") || option.getBoolean("visible") != false || option.getBoolean("multiPk") != false;
        }
    }
}

