/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.GeoPointProp;
import kd.bos.entity.property.NameVersionEntryProp;
import kd.bos.mservice.svc.attach.IAttachmentProp;
import kd.bos.mservice.svc.picture.IPictureProp;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfGraphCell;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaHelper;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.nodes.IHasFormId;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeStart;
import kd.bos.nocode.property.INoCodeGraphicDisplayProp;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.property.INoCodeRichTextProp;
import kd.bos.nocode.utils.FieldTreeBuilder;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.ShowColumnInfo;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.helper.WfModelIteratorHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.workflow.api.model.MacroItem;
import kd.bos.workflow.api.model.NodeMacro;
import org.jetbrains.annotations.Nullable;

public class VariableHelper {
    private VariableHelper() {
        throw new IllegalStateException("VariableHelper class");
    }

    public static JSONObject findVariable(String nodeId, String varValue, JSONObject variables, NoCodeWfMetaData noCodeWfMetaData, WfDesignerCtx ctx) {
        if (variables == null || variables.isEmpty() || StringUtils.isBlank((CharSequence)nodeId) || StringUtils.isBlank((CharSequence)varValue)) {
            return null;
        }
        if ("${proc.procName}".equalsIgnoreCase(varValue)) {
            return VariableHelper.getProcNameVariable();
        }
        Iterator<NoCodeWfGraphCell> iterator = WfModelIteratorHelper.getIterator(noCodeWfMetaData, ctx);
        while (iterator.hasNext()) {
            NoCodeWfGraphCell next = iterator.next();
            JSONObject varFormNode = VariableHelper.findVarFromNodeByValue(next, varValue, variables);
            if (varFormNode != null) {
                return varFormNode;
            }
            if (!nodeId.equalsIgnoreCase(next.getId())) continue;
            break;
        }
        return null;
    }

    public static JSONObject findVariableByNumber(String nodeId, String varNumber, JSONObject variables, NoCodeWfMetaData noCodeWfMetaData, WfDesignerCtx ctx) {
        if (variables == null || variables.isEmpty() || StringUtils.isBlank((CharSequence)nodeId) || StringUtils.isBlank((CharSequence)varNumber)) {
            return null;
        }
        Iterator<NoCodeWfGraphCell> iterator = WfModelIteratorHelper.getIterator(noCodeWfMetaData, ctx);
        while (iterator.hasNext()) {
            NoCodeWfGraphCell next = iterator.next();
            JSONObject varFormNode = VariableHelper.findVarFromNodeContainNumber(next, varNumber, variables);
            if (varFormNode != null) {
                return varFormNode;
            }
            if (!nodeId.equalsIgnoreCase(next.getId())) continue;
            break;
        }
        return null;
    }

    private static JSONObject getProcNameVariable() {
        JSONObject procNameVar = new JSONObject();
        procNameVar.put("title", (Object)ResManager.loadKDString((String)"[\u6587\u672c]\u6d41\u7a0b\u540d\u79f0", (String)"VariableHelper_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
        procNameVar.put("type", (Object)"text");
        procNameVar.put("value", (Object)"${proc.procName}");
        return procNameVar;
    }

    private static JSONObject findVarFromNodeByValue(NoCodeWfGraphCell next, String varValue, JSONObject variables) {
        JSONArray vars = (JSONArray)variables.get((Object)next.getId());
        if (vars != null && !vars.isEmpty()) {
            for (Object var : vars) {
                JSONObject v2;
                List children;
                JSONObject v = (JSONObject)var;
                String value = (String)v.get((Object)"value");
                if (varValue.equalsIgnoreCase(value)) {
                    return v;
                }
                if (!v.containsKey((Object)"option") || !((Map)v.get((Object)"option")).containsKey("children") || (children = (List)((Map)v.get((Object)"option")).get("children")) == null || children.isEmpty() || (v2 = VariableHelper.loopFindChildren(children, varValue)) == null) continue;
                return v2;
            }
        }
        return null;
    }

    private static JSONObject loopFindChildren(List<?> children, String varValue) {
        for (Object child : children) {
            JSONObject v2;
            List cc;
            JSONObject c = (JSONObject)child;
            String childValue = (String)c.get((Object)"value");
            if (varValue.equalsIgnoreCase(childValue)) {
                return c;
            }
            if (!c.containsKey((Object)"option") || !((Map)c.get((Object)"option")).containsKey("children") || (cc = (List)((Map)c.get((Object)"option")).get("children")) == null || cc.isEmpty() || (v2 = VariableHelper.loopFindChildren(cc, varValue)) == null) continue;
            return v2;
        }
        return null;
    }

    public static JSONObject findVarFromNodeContainNumber(NoCodeWfGraphCell next, String varNumber, JSONObject variables) {
        JSONArray vars = (JSONArray)variables.get((Object)next.getId());
        if (vars != null && !vars.isEmpty()) {
            for (Object var : vars) {
                JSONObject v = (JSONObject)var;
                String value = (String)v.get((Object)"value");
                if (!value.contains(varNumber)) continue;
                return v;
            }
        }
        return null;
    }

    public static String getVarTitle(JSONObject variable) {
        if (variable == null || variable.isEmpty()) {
            return null;
        }
        return (String)variable.get((Object)"title");
    }

    public static String getVarValue(JSONObject variable) {
        if (variable == null || variable.isEmpty()) {
            return null;
        }
        return (String)variable.get((Object)"value");
    }

    public static String getVarType(JSONObject variable) {
        if (variable == null || variable.isEmpty()) {
            return null;
        }
        return (String)variable.get((Object)"type");
    }

    public static String getFormIdFromRefbillVariable(String nodeId, String varValue, JSONObject variables, NoCodeWfMetaData noCodeWfMetaData, WfDesignerCtx ctx) {
        ThreeTuple<String, IDataEntityProperty, JSONObject> info = VariableHelper.getInfoFromRefbillVariable(nodeId, varValue, variables, noCodeWfMetaData, ctx);
        if (info == null) {
            return null;
        }
        return (String)info.item1;
    }

    public static ThreeTuple<String, IDataEntityProperty, JSONObject> getInfoFromRefbillVariable(String nodeId, String varValue, JSONObject variables, NoCodeWfMetaData noCodeWfMetaData, WfDesignerCtx ctx) {
        JSONObject variable = VariableHelper.findVariable(nodeId, varValue, variables, noCodeWfMetaData, ctx);
        if (variable == null || variable.isEmpty()) {
            Matcher mModel = WfConsts.varModelPattern.matcher(varValue);
            while (mModel.find()) {
                String modelVar = mModel.group();
                String fieldId = modelVar.replaceAll("\\$\\{model\\.(.+?)\\}", "$1");
                NoCodeWfNodeStart startNode = NoCodeWfMetaHelper.getStartNode((NoCodeWfMetaData)noCodeWfMetaData);
                BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)startNode.getFormId());
                if (dt == null) {
                    return null;
                }
                IDataEntityProperty refBillProp = dt.findProperty(fieldId);
                if (!(refBillProp instanceof INoCodeRefBillProp)) continue;
                return new ThreeTuple((Object)((INoCodeRefBillProp)refBillProp).getBillEntityId(), (Object)refBillProp, (Object)variable);
            }
            Pattern compile = WfConsts.VAR_PROC_PATTERN_OF_EXECUTERESULT;
            Matcher matcher = compile.matcher(varValue);
            if (matcher.matches()) {
                String formId;
                BillEntityType dt;
                String refNodeId = matcher.group(1);
                String refModelField = matcher.group(2);
                Optional<NoCodeWfNode> first = noCodeWfMetaData.getNodes().stream().filter(n -> n.getId().equalsIgnoreCase(refNodeId)).findFirst();
                if (!first.isPresent()) {
                    return null;
                }
                NoCodeWfNode noCodeWfNode = first.get();
                if (noCodeWfNode instanceof IHasFormId && StringUtils.isNotBlank((CharSequence)((IHasFormId)noCodeWfNode).getTargetFormId()) && (dt = NcEntityTypeUtil.getMainEntityType((String)(formId = ((IHasFormId)noCodeWfNode).getTargetFormId()))) != null) {
                    IDataEntityProperty refBillProp = dt.findProperty(refModelField);
                    if (refBillProp instanceof INoCodeRefBillProp) {
                        return new ThreeTuple((Object)((INoCodeRefBillProp)refBillProp).getBillEntityId(), (Object)refBillProp, (Object)variable);
                    }
                    if (Objects.isNull(refBillProp)) {
                        return new ThreeTuple((Object)formId, null, (Object)variable);
                    }
                }
            }
            return null;
        }
        String entityId = (String)variable.get((Object)"billEntityId");
        if (StringUtils.isBlank((CharSequence)entityId) && variable.get((Object)"option") != null) {
            Map option = (Map)variable.get((Object)"option");
            entityId = (String)option.get("billEntityId");
        }
        return new ThreeTuple((Object)entityId, null, (Object)variable);
    }

    public static JSONObject getOutParamPkIdVariable(String nodeId, JSONObject variables) {
        if (variables == null || variables.isEmpty() || StringUtils.isBlank((CharSequence)nodeId)) {
            return null;
        }
        JSONArray vars = (JSONArray)variables.get((Object)nodeId);
        if (vars != null && !vars.isEmpty()) {
            for (Object var : vars) {
                JSONObject v = (JSONObject)var;
                String type = (String)v.get((Object)"type");
                if (!"pk".equalsIgnoreCase(type) || v.get((Object)"option") != null && ((Map)v.get((Object)"option")).get("visible") == Boolean.FALSE) continue;
                return v;
            }
        }
        return null;
    }

    public static String getVarOfNodeFormPkId(String nodeId, String refNodeId, NoCodeWfMetaData ncMetaData, JSONObject variables, WfDesignerCtx ctx) {
        if (StringUtils.isBlank((CharSequence)refNodeId) || ncMetaData == null || variables.isEmpty()) {
            return null;
        }
        NoCodeWfNode targetNode = VariableHelper.getRefNode(nodeId, refNodeId, ncMetaData, ctx);
        if (!(targetNode instanceof IHasFormId)) {
            return null;
        }
        if (ctx.isSameGatewayNotSameSwitch(nodeId, refNodeId)) {
            return null;
        }
        if (targetNode instanceof NoCodeWfNodeStart) {
            return String.format("${execution.%s}", "businessKey");
        }
        JSONObject outParamPkIdVar = VariableHelper.getOutParamPkIdVariable(targetNode.getId(), variables);
        if (outParamPkIdVar != null && !outParamPkIdVar.isEmpty()) {
            return (String)outParamPkIdVar.get((Object)"value");
        }
        List macros = NoCodeWorkflowServiceHelper.getNodeMacros((String)NoCodeWfMetaHelper.serializeToString((Object)ncMetaData), (String)"ExecuteResult");
        NoCodeWfNode finalTargetNode = targetNode;
        Optional<NodeMacro> firstMacro = macros.stream().filter(m -> finalTargetNode.getId().equalsIgnoreCase(m.getNodeId())).findFirst();
        if (firstMacro.isPresent()) {
            NodeMacro macro = firstMacro.get();
            Optional<MacroItem> firstMacroItem = macro.getItems().stream().filter(i -> "pk".equalsIgnoreCase(i.getDataType()) && !"visible".equalsIgnoreCase(i.getName())).findFirst();
            if (firstMacroItem.isPresent()) {
                return String.format("${proc.%s.%s}", macro.getNumber(), firstMacroItem.get().getNumber());
            }
            Optional<MacroItem> firstMacroItem2 = macro.getItems().stream().filter(i -> "pk".equalsIgnoreCase(i.getDataType())).findFirst();
            if (firstMacroItem2.isPresent()) {
                return String.format("${proc.%s.%s}", macro.getNumber(), firstMacroItem2.get().getNumber());
            }
        }
        return null;
    }

    @Nullable
    public static NoCodeWfNode getRefNode(String nodeId, String refNodeId, NoCodeWfMetaData ncMetaData, WfDesignerCtx ctx) {
        NoCodeWfNode targetNode = null;
        Iterator<NoCodeWfGraphCell> iterator = WfModelIteratorHelper.getIterator(ncMetaData, ctx);
        while (iterator.hasNext()) {
            NoCodeWfGraphCell next = iterator.next();
            if (refNodeId.equalsIgnoreCase(next.getId())) {
                targetNode = (NoCodeWfNode)next;
            }
            if (!nodeId.equalsIgnoreCase(next.getId())) continue;
            break;
        }
        return targetNode;
    }

    public static String getNodeNameVar(String nodeId, WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        String nodeNameNumber = VariableHelper.getNodeNameVarFromCtx(nodeId, ctx);
        if (StringUtils.isNotBlank((CharSequence)nodeNameNumber)) {
            return nodeNameNumber;
        }
        String modelJson = NoCodeWfMetaHelper.serializeToString((Object)ncMetaData);
        ctx.setNodeNameMacros(NoCodeWorkflowServiceHelper.getNodeMacros((String)modelJson, (String)"NodeName"));
        return VariableHelper.getNodeNameVarFromCtx(nodeId, ctx);
    }

    private static String getNodeNameVarFromCtx(String nodeId, WfDesignerCtx ctx) {
        return ctx.getNodeNameMacros().stream().filter(m -> nodeId.equalsIgnoreCase(m.getNodeId())).map(NodeMacro::getNumber).findFirst().orElse(null);
    }

    public static String getNodeAssigneeVar(String nodeId, WfDesignerCtx ctx, NoCodeWfMetaData ncMetaData) {
        String assigneeVar = VariableHelper.getNodeAssigneeVarFromCtx(nodeId, ctx);
        if (StringUtils.isNotBlank((CharSequence)assigneeVar)) {
            return assigneeVar;
        }
        String modelJson = NoCodeWfMetaHelper.serializeToString((Object)ncMetaData);
        ctx.setAssigneeMacros(NoCodeWorkflowServiceHelper.getNodeMacros((String)modelJson, (String)"Assignee"));
        return VariableHelper.getNodeAssigneeVarFromCtx(nodeId, ctx);
    }

    public static String replaceAssigneeVar2Name(String content) {
        if (StringUtils.isNotBlank((CharSequence)content)) {
            Object[] split = content.split("@@");
            if (split.length > 1) {
                String realContent = content.split("@@")[0];
                realContent = realContent.replaceAll("(\\$\\{proc\\..+?Assignee)(\\})", "$1.name$2");
                Object[] arr = (String[])ArrayUtils.clone((Object[])split);
                arr = (String[])ArrayUtils.remove((Object[])arr, (int)0);
                arr = (String[])ArrayUtils.add((Object[])arr, (int)0, (Object)realContent);
                return String.join((CharSequence)"@@", (CharSequence[])arr);
            }
            return content.replaceAll("(\\$\\{proc\\..+?Assignee)(\\})", "$1.name$2");
        }
        return content;
    }

    public static boolean isAssigneeVar(String varValue) {
        if (StringUtils.isBlank((CharSequence)varValue)) {
            return false;
        }
        return WfConsts.varProcPattern_ASSIGNEE.matcher(varValue).matches();
    }

    private static String getNodeAssigneeVarFromCtx(String nodeId, WfDesignerCtx ctx) {
        return ctx.getAssigneeMacros().stream().filter(m -> nodeId.equalsIgnoreCase(m.getNodeId())).map(NodeMacro::getNumber).findFirst().orElse(null);
    }

    public static List<ShowColumnInfo> getShowColumnsIncludePk(String formId) {
        FieldTreeBuilder fieldTreeBuilder = new FieldTreeBuilder(formId);
        List showColumnsIncludePk = fieldTreeBuilder.withFeature(new FieldTreeBuilder.Feature[]{FieldTreeBuilder.Feature.IncludePK}).withoutFieldTypes(new FieldTreeBuilder.FieldType[]{FieldTreeBuilder.FieldType.NoCodeRichTextField, FieldTreeBuilder.FieldType.NoCodeGraphicDisplayField, FieldTreeBuilder.FieldType.NoCodeAttachmentUploadField, FieldTreeBuilder.FieldType.NoCodeImageUploadField, FieldTreeBuilder.FieldType.EntryField}).build();
        for (ShowColumnInfo info : showColumnsIncludePk) {
            info.getOption().put("ownerFormId", formId);
        }
        return showColumnsIncludePk;
    }

    private static boolean defaultIgnoreProp(IDataEntityProperty fieldProp) {
        return fieldProp instanceof GeoPointProp || fieldProp.getParent() instanceof EntryType || fieldProp instanceof INoCodeRichTextProp || fieldProp instanceof NameVersionEntryProp || fieldProp instanceof INoCodeGraphicDisplayProp || fieldProp instanceof IAttachmentProp || fieldProp instanceof IPictureProp;
    }
}

