/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.helper;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaHelper;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.OutParam;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.workflow.api.model.MacroItem;
import kd.bos.workflow.api.model.NodeMacro;

public class WfDesignerCtx
implements Serializable {
    private static final long serialVersionUID = 4733445554884921369L;
    private String appId;
    private JSONObject variables = new JSONObject(true);
    private JSONObject errors = new JSONObject();
    private List<NodeMacro> macros = new ArrayList<NodeMacro>();
    private List<NodeMacro> nodeNameMacros = new ArrayList<NodeMacro>();
    private List<NodeMacro> assigneeMacros = new ArrayList<NodeMacro>();
    private Set<String> needPublishNewVersionNodeIds = new HashSet<String>();
    private Map<String, List<Tuple<String, String>>> belongToGatewayNode = new HashMap<String, List<Tuple<String, String>>>();
    private Map<String, String> updateAssignmentOfVarMap = new HashMap<String, String>();

    public WfDesignerCtx() {
    }

    public WfDesignerCtx(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public JSONObject getVariables() {
        return this.variables;
    }

    public void setVariables(JSONObject variables) {
        this.variables = variables;
    }

    public JSONObject getErrors() {
        return this.errors;
    }

    public void setErrors(JSONObject errors) {
        this.errors = errors;
    }

    public List<NodeMacro> getMacros() {
        return this.macros;
    }

    public void setMacros(List<NodeMacro> macros) {
        this.macros = macros;
    }

    public NodeMacro getMacroByNode(NoCodeWfNode node) {
        List nodeMacros;
        if (node == null || StringUtils.isBlank((CharSequence)node.getId())) {
            return null;
        }
        boolean needUpdate = this.getNeedPublishNewVersionNodeIds().contains(node.getId());
        if (needUpdate && (nodeMacros = NoCodeWorkflowServiceHelper.getNodeMacros((String)"NoCodeFlow", (String)NoCodeWfMetaHelper.serializeToString((Object)node), (String)"ExecuteResult")) != null && !nodeMacros.isEmpty()) {
            this.getMacros().removeIf(m -> m.getNodeId().equalsIgnoreCase(node.getId()));
            this.getMacros().addAll(nodeMacros);
        }
        return this.getMacros().stream().filter(m -> m.getNodeId().equalsIgnoreCase(node.getId())).findFirst().orElse(null);
    }

    public List<NodeMacro> getNodeNameMacros() {
        return this.nodeNameMacros;
    }

    public void setNodeNameMacros(List<NodeMacro> nodeNameMacros) {
        this.nodeNameMacros = nodeNameMacros;
    }

    public List<NodeMacro> getAssigneeMacros() {
        return this.assigneeMacros;
    }

    public void setAssigneeMacros(List<NodeMacro> assigneeMacros) {
        this.assigneeMacros = assigneeMacros;
    }

    public Set<String> getNeedPublishNewVersionNodeIds() {
        return this.needPublishNewVersionNodeIds;
    }

    public void setNeedPublishNewVersionNodeIds(Set<String> needPublishNewVersionNodeIds) {
        this.needPublishNewVersionNodeIds = needPublishNewVersionNodeIds;
    }

    public void resetWhenSaveSuccess() {
        this.needPublishNewVersionNodeIds.clear();
        this.errors.clear();
    }

    public Map<String, List<Tuple<String, String>>> getBelongToGatewayNode() {
        return this.belongToGatewayNode;
    }

    public void addBelongToGatewayNode(String nodeId, String gatewayNodeId, String switchEdgeId) {
        List<Tuple<String, String>> data = this.getBelongToGatewayNode().get(nodeId);
        if (data != null && !data.isEmpty()) {
            return;
        }
        data = new ArrayList<Tuple<String, String>>();
        this.getBelongToGatewayNode().put(nodeId, data);
        List<Tuple<String, String>> parentBelongTos = this.getParentBelongTos(gatewayNodeId);
        if (parentBelongTos != null && !parentBelongTos.isEmpty()) {
            data.addAll(parentBelongTos);
        }
        data.add((Tuple<String, String>)new Tuple((Object)gatewayNodeId, (Object)switchEdgeId));
    }

    private List<Tuple<String, String>> getParentBelongTos(String nodeId) {
        return this.getBelongToGatewayNode().get(nodeId);
    }

    public boolean isSameGatewayNotSameSwitch(String sourceNodeId, String targetNodeId) {
        List<Tuple<String, String>> sourceData = this.getBelongToGatewayNode().get(sourceNodeId);
        List<Tuple<String, String>> targetData = this.getBelongToGatewayNode().get(targetNodeId);
        if (sourceData == null || sourceData.isEmpty() || targetData == null || targetData.isEmpty()) {
            return false;
        }
        for (int i = 0; i < sourceData.size(); ++i) {
            Tuple<String, String> sourceTuple = sourceData.get(i);
            if (i >= targetData.size()) break;
            Tuple<String, String> targetTuple = targetData.get(i);
            if (!((String)sourceTuple.item1).equalsIgnoreCase((String)targetTuple.item1) || ((String)sourceTuple.item2).equalsIgnoreCase((String)targetTuple.item2)) continue;
            return true;
        }
        return false;
    }

    public void addUpdateAssignment(OutParam outParam, NoCodeWfNode node, String assignment) {
        NodeMacro macro = this.getMacroByNode(node);
        if (macro == null) {
            return;
        }
        for (MacroItem item : macro.getItems()) {
            if (!outParam.getNumber().equalsIgnoreCase(item.getNumber())) continue;
            String value = String.format("${proc.%s.%s}", macro.getNumber(), item.getNumber());
            this.updateAssignmentOfVarMap.put(value, assignment);
            break;
        }
    }

    public String getCascadeUpdateAssignment(String assignment) {
        ArrayList<String> uaList = new ArrayList<String>(10);
        uaList.add(assignment);
        this.findAssignment(uaList, assignment);
        return String.join((CharSequence)",", uaList);
    }

    private void findAssignment(List<String> uaList, String assignment) {
        String toUpdate = this.updateAssignmentOfVarMap.get(assignment);
        if (!StringUtils.isBlank((CharSequence)toUpdate)) {
            uaList.add(toUpdate);
            this.findAssignment(uaList, toUpdate);
        }
    }
}

