/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.helper;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfEdge;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfGraphCell;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeEnd;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeGateway;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeStart;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;

public class WfModelIteratorHelper {
    private WfModelIteratorHelper() {
        throw new IllegalStateException("WfModelIteratorHelper class");
    }

    public static Iterator<NoCodeWfGraphCell> getIterator(NoCodeWfMetaData ncMetaData, WfDesignerCtx ctx) {
        return new NoCodeWfGraphCellIterator(ncMetaData, ctx);
    }

    private static Iterator<NoCodeWfGraphCell> getNodeIterator(NoCodeWfGraphCell node, NoCodeWfMetaData ncMetaData, WfDesignerCtx ctx) {
        if (node instanceof NoCodeWfNodeGateway && !((NoCodeWfNodeGateway)node).isNullNode()) {
            return new GatewayNodeIterator(node, ncMetaData, ctx);
        }
        return null;
    }

    static class GatewayNodeIterator
    implements Iterator<NoCodeWfGraphCell> {
        private NoCodeWfMetaData ncMetaData;
        private NoCodeWfGraphCell node;
        private NoCodeWfGraphCell nextCell;
        private Iterator<NoCodeWfGraphCell> nodeIterator;
        private Map<String, NoCodeWfEdge> edgeIds = new LinkedHashMap<String, NoCodeWfEdge>(64);
        private WfDesignerCtx ctx;
        private String currentSwitch;

        public GatewayNodeIterator(NoCodeWfGraphCell node, NoCodeWfMetaData ncMetaData, WfDesignerCtx ctx) {
            this.ctx = ctx;
            this.ncMetaData = ncMetaData;
            this.node = node;
            List edges = ncMetaData.getEdges().stream().filter(e -> e.getSource().equalsIgnoreCase(node.getId())).collect(Collectors.toList());
            for (NoCodeWfEdge edge : edges) {
                this.edgeIds.put(edge.getId(), edge);
            }
            this.nextCell = this.nextSwitch();
        }

        private NoCodeWfEdge nextSwitch() {
            if (this.edgeIds.size() > 0) {
                String edgeId;
                Map.Entry<String, NoCodeWfEdge> next = this.edgeIds.entrySet().iterator().next();
                this.currentSwitch = edgeId = next.getKey();
                NoCodeWfEdge edge = next.getValue();
                this.edgeIds.remove(edgeId);
                return edge;
            }
            this.currentSwitch = null;
            return null;
        }

        @Override
        public boolean hasNext() {
            boolean nullNode;
            if (this.nodeIterator != null) {
                boolean hasN = this.nodeIterator.hasNext();
                if (!hasN) {
                    this.nextCell = this.nodeIterator.next();
                    this.nodeIterator = null;
                } else {
                    return true;
                }
            }
            if (nullNode = this.isNullNode(this.nextCell)) {
                return false;
            }
            return this.nextCell != null;
        }

        @Override
        public NoCodeWfGraphCell next() {
            NoCodeWfGraphCell ret = this.nextCell;
            if (ret == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6d41\u7a0b\u6570\u636e\u5f02\u5e38", (String)"WfModelIteratorHelper_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
            }
            boolean nullNode = this.isNullNode(ret);
            if (nullNode) {
                return ret;
            }
            if (ret instanceof NoCodeWfNode) {
                this.ctx.addBelongToGatewayNode(ret.getId(), this.node.getId(), this.currentSwitch);
            }
            this.nextCell = this.findNextCell();
            return ret;
        }

        private NoCodeWfGraphCell findNextCell() {
            NoCodeWfGraphCell node;
            if (this.nextCell == null) {
                return null;
            }
            if (this.nodeIterator != null) {
                return this.nodeIterator.next();
            }
            if (this.nextCell instanceof NoCodeWfNode) {
                NoCodeWfNode nodeCode = (NoCodeWfNode)this.nextCell;
                this.nodeIterator = WfModelIteratorHelper.getNodeIterator((NoCodeWfGraphCell)nodeCode, this.ncMetaData, this.ctx);
                if (this.nodeIterator != null) {
                    return this.nodeIterator.next();
                }
                if (this.isNullNode((NoCodeWfGraphCell)nodeCode)) {
                    return this.nextCell;
                }
                Optional<NoCodeWfEdge> first = this.ncMetaData.getEdges().stream().filter(e -> e.getSource().equalsIgnoreCase(nodeCode.getId())).findFirst();
                if (!first.isPresent()) {
                    return null;
                }
                node = (NoCodeWfGraphCell)first.get();
            } else {
                NoCodeWfEdge edgeCell = (NoCodeWfEdge)this.nextCell;
                Optional<NoCodeWfNode> first = this.ncMetaData.getNodes().stream().filter(n -> n.getId().equalsIgnoreCase(edgeCell.getTarget())).findFirst();
                if (!first.isPresent()) {
                    throw new KDBizException("invalid NoCodeWfMetaData");
                }
                node = (NoCodeWfGraphCell)first.get();
                if (this.isNullNode(node)) {
                    NoCodeWfEdge nSwitch = this.nextSwitch();
                    this.nextCell = nSwitch == null ? node : nSwitch;
                    return this.nextCell;
                }
            }
            return node;
        }

        private boolean isNullNode(NoCodeWfGraphCell nextCell) {
            return nextCell instanceof NoCodeWfNodeGateway && ((NoCodeWfNodeGateway)nextCell).isNullNode() && this.node.getId().equalsIgnoreCase(nextCell.getParentId());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }
    }

    static class NoCodeWfGraphCellIterator
    implements Iterator<NoCodeWfGraphCell> {
        private NoCodeWfMetaData ncMetaData;
        private NoCodeWfGraphCell nextCell;
        private Iterator<NoCodeWfGraphCell> nodeIterator;
        private WfDesignerCtx ctx;

        public NoCodeWfGraphCellIterator(NoCodeWfMetaData ncMetaData, WfDesignerCtx ctx) {
            this.ctx = ctx;
            ctx.getBelongToGatewayNode().clear();
            this.ncMetaData = ncMetaData;
            Optional<NoCodeWfNode> first = ncMetaData.getNodes().stream().filter(n -> n instanceof NoCodeWfNodeStart).findFirst();
            if (!first.isPresent()) {
                throw new KDBizException("invalid NoCodeWfMetaData");
            }
            this.nextCell = (NoCodeWfGraphCell)first.get();
        }

        @Override
        public boolean hasNext() {
            if (this.nodeIterator != null) {
                boolean hasN = this.nodeIterator.hasNext();
                if (!hasN) {
                    this.nextCell = this.nodeIterator.next();
                    this.nodeIterator = null;
                } else {
                    return true;
                }
            }
            return this.nextCell != null;
        }

        @Override
        public NoCodeWfGraphCell next() {
            NoCodeWfGraphCell ret = this.nextCell;
            if (ret == null) {
                throw new NoSuchElementException();
            }
            this.nextCell = this.findNextCell();
            return ret;
        }

        private NoCodeWfGraphCell findNextCell() {
            NoCodeWfGraphCell node;
            if (this.nextCell == null) {
                return null;
            }
            if (this.nodeIterator != null) {
                return this.nodeIterator.next();
            }
            if (this.nextCell instanceof NoCodeWfNodeEnd) {
                node = null;
            } else if (this.nextCell instanceof NoCodeWfNode) {
                NoCodeWfNode nodeCode = (NoCodeWfNode)this.nextCell;
                this.nodeIterator = WfModelIteratorHelper.getNodeIterator((NoCodeWfGraphCell)nodeCode, this.ncMetaData, this.ctx);
                if (this.nodeIterator != null) {
                    return this.nodeIterator.next();
                }
                Optional<NoCodeWfEdge> first = this.ncMetaData.getEdges().stream().filter(e -> e.getSource().equalsIgnoreCase(nodeCode.getId())).findFirst();
                if (!first.isPresent()) {
                    return null;
                }
                node = (NoCodeWfGraphCell)first.get();
            } else {
                NoCodeWfEdge edgeCell = (NoCodeWfEdge)this.nextCell;
                Optional<NoCodeWfNode> first = this.ncMetaData.getNodes().stream().filter(n -> n.getId().equalsIgnoreCase(edgeCell.getTarget())).findFirst();
                if (!first.isPresent()) {
                    throw new KDBizException("invalid NoCodeWfMetaData");
                }
                node = (NoCodeWfGraphCell)first.get();
            }
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }
    }
}

