/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.sync;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfGraphCell;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaHelper;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.info.MultiRefBillInfo;
import kd.bos.nocode.ext.metadata.wf.nodes.IHasFormId;
import kd.bos.nocode.ext.metadata.wf.nodes.IHasTriggerProcess;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeApiInvoke;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeNewBill;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeQueryData;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeStart;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeUpdateBill;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.NoCodeWfNodeAutoMicroSrv;
import kd.bos.nocode.ext.wf.control.events.WfDesignerMetaSyncEvent;
import kd.bos.nocode.utils.FieldTreeBuilder;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.OpenApiUtil;
import kd.bos.nocode.utils.ShowColumnInfo;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.sync.IWfModelSync;

public abstract class AbstractWfModelSync<T extends NoCodeWfGraphCell>
implements IWfModelSync<T> {
    protected static final Log logger = LogFactory.getLog(AbstractWfModelSync.class);
    protected WfDesignerMetaSyncEvent syncArgs;
    protected NoCodeWfMetaData ncMetaData;
    protected static final String KEY_NODE_ID = "nodeId";
    protected static final String KEY_VAR = "var";
    protected static final String KEY_VALUE_FORMAT = "%s.%s";
    protected static final String KEY_TYPE_TEXT = "text";
    protected static final String KEY_ERRORS = "errors";
    protected JSONObject errors;
    protected JSONObject variables;
    protected WfDesignerCtx ctx;
    private static final Map<String, String> MAPPING_DICT_DATA_TYPE = new HashMap<String, String>();

    public AbstractWfModelSync(WfDesignerCtx ctx, WfDesignerMetaSyncEvent syncArgs, NoCodeWfMetaData ncMetaData) {
        this.syncArgs = syncArgs;
        this.ctx = ctx;
        if (this.syncArgs.getParam().containsKey(WfConsts.SyncTypeEnum.VARIABLES.getCode())) {
            this.variables = (JSONObject)this.syncArgs.getParam().get(WfConsts.SyncTypeEnum.VARIABLES.getCode());
        }
        if (this.syncArgs.getParam().containsKey(WfConsts.SyncTypeEnum.ERRORS.getCode())) {
            this.errors = (JSONObject)this.syncArgs.getParam().get(WfConsts.SyncTypeEnum.ERRORS.getCode());
        }
        this.ncMetaData = ncMetaData;
    }

    @Override
    public void buildVariable(JSONObject variables, T node) {
        boolean hasV = this.hasVar(node);
        if (!hasV && this.syncArgs.isInit()) {
            return;
        }
        JSONArray fieldVars = new JSONArray();
        if (hasV) {
            this.genVars(node, fieldVars);
            this.postSetVars(node, fieldVars);
        }
        if (StringUtils.isNotBlank((CharSequence)node.getId())) {
            variables.put(node.getId(), (Object)fieldVars);
        }
    }

    protected abstract boolean hasVar(T var1);

    protected abstract void genVars(T var1, JSONArray var2);

    protected void postSetVars(T node, JSONArray fieldVars) {
        List collect;
        Map option;
        String ownerFormId;
        JSONObject refField;
        if (fieldVars.size() > 0 && (refField = (JSONObject)fieldVars.stream().filter(f -> f instanceof JSONObject && this.isRec((JSONObject)f)).findFirst().orElseGet(() -> null)) != null && StringUtils.isNotBlank((CharSequence)(ownerFormId = (String)(option = (Map)refField.get((Object)"option")).get("ownerFormId"))) && !(collect = fieldVars.stream().filter(f -> f instanceof JSONObject && !this.isRec((JSONObject)f) && this.isOwner((JSONObject)f, ownerFormId)).collect(Collectors.toList())).isEmpty()) {
            JSONArray childFieldVars = new JSONArray(collect.size());
            childFieldVars.addAll(collect);
            option.put("children", childFieldVars);
            option.put("isMulti", false);
            option.put("cannotAssign", false);
            fieldVars.removeAll(collect);
        }
    }

    private boolean isRec(JSONObject fieldVar) {
        Map option = (Map)fieldVar.get((Object)"option");
        if (option == null) {
            return false;
        }
        return option.containsKey("isRec") && (Boolean)option.get("isRec") != false;
    }

    private boolean isOwner(JSONObject fieldVar, String ownerFormId) {
        Map option = (Map)fieldVar.get((Object)"option");
        if (option == null) {
            return false;
        }
        return ownerFormId.equalsIgnoreCase((String)option.get("ownerFormId"));
    }

    protected JSONObject addVar(String title, String value, String type, Map<String, Object> option, JSONArray fieldVars, T node) {
        JSONObject fieldVar = new JSONObject();
        fieldVar.put("title", (Object)title);
        fieldVar.put("value", (Object)value);
        fieldVar.put("type", (Object)(StringUtils.isBlank((CharSequence)type) ? "unknown" : type));
        if (option == null) {
            option = new HashMap<String, Object>();
        }
        if (StringUtils.isNotBlank((CharSequence)type) && type.startsWith("combo")) {
            this.fixupValueItems(type, option);
        }
        if ("pk".equalsIgnoreCase(type) && node instanceof IHasFormId) {
            IHasFormId theNode = (IHasFormId)node;
            if (!option.containsKey("visible") || ((Boolean)option.get("visible")).booleanValue()) {
                String nodeName = ((NoCodeWfNode)node).getName();
                if (node instanceof NoCodeWfNodeQueryData) {
                    nodeName = ResManager.loadKDString((String)"\u67e5\u627e", (String)"AbstractWfModelSync_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
                } else if (node instanceof NoCodeWfNodeUpdateBill) {
                    nodeName = ResManager.loadKDString((String)"\u4fee\u6539", (String)"AbstractWfModelSync_1", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
                } else if (node instanceof NoCodeWfNodeNewBill) {
                    nodeName = ResManager.loadKDString((String)"\u65b0\u589e", (String)"AbstractWfModelSync_2", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
                } else if (node instanceof NoCodeWfNodeApiInvoke) {
                    nodeName = ResManager.loadKDString((String)"\u8fd4\u56de", (String)"AbstractWfModelSync_3", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
                } else if (node instanceof NoCodeWfNodeStart) {
                    nodeName = ResManager.loadKDString((String)"\u89e6\u53d1\u6d41\u7a0b", (String)"AbstractWfModelSync_4", (String)"bos-nocode-formplugin", (Object[])new Object[0]);
                }
                fieldVar.put("title", (Object)String.format(WfConsts.getNodeBillIdTitleFormat(), theNode.getTargetFormCaption(), ResManager.loadKDString((String)"\u5355\u6761", (String)"AbstractWfModelSync_5", (String)"bos-nocode-formplugin", (Object[])new Object[0]), nodeName));
                option.put("isRec", true);
            }
            option.put("billEntityId", theNode.getTargetFormId());
            if (StringUtils.isEmpty((CharSequence)((String)option.get("displayProp")))) {
                List<ShowColumnInfo> showColumnInfos = VariableHelper.getShowColumnsIncludePk(theNode.getTargetFormId());
                String displayProps = showColumnInfos.stream().limit(5L).map(ShowColumnInfo::getId).collect(Collectors.joining(","));
                option.put("displayProp", displayProps);
            }
        } else if ("pk".equalsIgnoreCase(type) && node instanceof NoCodeWfNodeApiInvoke) {
            String rootNodeName = String.format(WfConsts.getNodeBillIdTitleFormat(), "API", ResManager.loadKDString((String)"\u5355\u6761", (String)"AbstractWfModelSync_5", (String)"bos-nocode-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8fd4\u56de", (String)"AbstractWfModelSync_3", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
            fieldVar.put("title", (Object)rootNodeName);
            option.put("isRec", true);
        }
        if ("date".equalsIgnoreCase(type)) {
            // empty if block
        }
        if (!option.isEmpty()) {
            fieldVar.put("option", option);
        }
        fieldVars.add((Object)fieldVar);
        return fieldVar;
    }

    private void fixupValueItems(String type, Map<String, Object> option) {
        Object valueItemsObj = option.get("valueItems");
        if (valueItemsObj == null || valueItemsObj instanceof ArrayList) {
            List valueItems;
            List list = valueItems = valueItemsObj == null ? NcEntityTypeUtil.getSelectItems((String)type) : (List)valueItemsObj;
            if (valueItems != null && !valueItems.isEmpty()) {
                JSONArray items = new JSONArray();
                for (ValueMapItem valueItem : valueItems) {
                    if (!valueItem.isItemVisible()) continue;
                    JSONObject item = new JSONObject();
                    item.put("name", (Object)valueItem.getName().toString());
                    item.put("value", (Object)valueItem.getValue());
                    items.add((Object)item);
                }
                option.put("valueItems", items);
            }
        }
    }

    protected JSONObject addNodeNameVar(T node, JSONArray fieldVars) {
        if (StringUtils.isBlank((CharSequence)node.getId()) || this.ncMetaData == null) {
            return null;
        }
        String nodeNameVar = VariableHelper.getNodeNameVar(node.getId(), this.ctx, this.ncMetaData);
        if (StringUtils.isBlank((CharSequence)nodeNameVar)) {
            return null;
        }
        JSONObject fieldVar = new JSONObject();
        fieldVar.put("title", (Object)NcEntityTypeUtil.getDataTitle((String)NcEntityTypeUtil.getDataTypeTextCap(), (String)ResManager.loadKDString((String)"\u8282\u70b9\u540d\u79f0", (String)"AbstractWfModelSync_6", (String)"bos-nocode-formplugin", (Object[])new Object[0])));
        fieldVar.put("value", (Object)String.format("${proc.%s}", nodeNameVar));
        fieldVar.put("type", (Object)KEY_TYPE_TEXT);
        fieldVars.add((Object)fieldVar);
        return fieldVar;
    }

    @Override
    public void buildError(JSONObject errors, T node) {
        if (StringUtils.isBlank((CharSequence)node.getId())) {
            return;
        }
        JSONArray theErrors = new JSONArray();
        this.genErrors(node, theErrors);
        if (theErrors.isEmpty() && this.syncArgs.isInit()) {
            return;
        }
        errors.put(node.getId(), (Object)theErrors);
    }

    protected abstract void genErrors(T var1, JSONArray var2);

    protected void addErr(String type, String msg, String property, JSONArray errors) {
        JSONObject err = new JSONObject();
        err.put("type", (Object)type);
        err.put("msg", (Object)msg);
        err.put("prop", (Object)property);
        errors.add((Object)err);
    }

    protected static void addRequiredErr(String property, String title, JSONArray errors) {
        JSONObject err = new JSONObject();
        err.put("type", (Object)"error");
        err.put("msg", (Object)String.format("%s%s", title, WfConsts.getMustInput()));
        err.put("prop", (Object)property);
        errors.add((Object)err);
    }

    protected String getDataTypeCaption(String dataType) {
        return MAPPING_DICT_DATA_TYPE.get(dataType);
    }

    protected void genErrors_TriggerProcess(IHasTriggerProcess node, JSONArray errors) {
        String[] procs;
        NoCodeWfNodeStart startNode = NoCodeWfMetaHelper.getStartNode((NoCodeWfMetaData)this.ncMetaData);
        if (node == null || startNode == null || StringUtils.isBlank((CharSequence)node.getTriggerProcess())) {
            return;
        }
        String nodeId = ((NoCodeWfGraphCell)node).getId();
        for (String proc : procs = node.getTriggerProcess().split(",")) {
            List<Tuple<String, String>> tuples;
            boolean isSameThis = this.ncMetaData.getId().equalsIgnoreCase(proc);
            if (!isSameThis || (tuples = this.ctx.getBelongToGatewayNode().get(nodeId)) != null && !tuples.isEmpty()) continue;
            this.addErr("error", ResManager.loadKDString((String)"\u89e6\u53d1\u6d41\u7a0b\u5f15\u7528\u4e86\u672c\u6d41\u7a0b\uff0c\u53ef\u80fd\u5bfc\u81f4\u6d41\u7a0b\u65e0\u9650\u5faa\u73af\uff0c\u8bf7\u68c0\u67e5", (String)"AbstractWfModelSync_14", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "triggerProcess", errors);
            break;
        }
    }

    protected void expendChildrenToSimpleRefBill(Map<String, Object> option, String formId, String value, boolean expendOnlyInExp) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        List<ShowColumnInfo> showColumns = VariableHelper.getShowColumnsIncludePk(formId);
        if (showColumns != null && !showColumns.isEmpty()) {
            JSONArray fieldVars = new JSONArray(showColumns.size());
            for (ShowColumnInfo showColumn : showColumns) {
                if ("pk".equalsIgnoreCase(showColumn.getType())) continue;
                JSONObject fieldVar = new JSONObject();
                String dataTypeCaption = NcEntityTypeUtil.getDataTypeCaption((String)showColumn.getType(), (Map)showColumn.getOption());
                fieldVar.put("title", (Object)String.format("%s%s", dataTypeCaption, showColumn.getCaption()));
                fieldVar.put("value", (Object)MultiRefBillInfo.encodeMultiRefBillInfo((MultiRefBillInfo)new MultiRefBillInfo(formId, showColumn.getId(), value)));
                fieldVar.put("type", (Object)showColumn.getType());
                HashMap newOption = new HashMap(showColumn.getOption());
                fieldVar.put("option", newOption);
                fieldVars.add((Object)fieldVar);
            }
            option.put("children", fieldVars);
            option.put("isMulti", false);
            option.put("cannotAssign", true);
            option.put("billEntityId", formId);
            if (expendOnlyInExp) {
                option.put("expendOnlyInExp", true);
            }
        }
    }

    protected void expendChildrenToMultiRefBill(Map<String, Object> option, String formId, String value, boolean expendOnlyInExp) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        List<ShowColumnInfo> showColumns = VariableHelper.getShowColumnsIncludePk(formId);
        if (showColumns != null && !showColumns.isEmpty()) {
            JSONArray fieldVars = new JSONArray(showColumns.size());
            String formCaption = NcEntityTypeUtil.getFormCaption((String)formId);
            for (ShowColumnInfo showColumn : showColumns) {
                JSONObject fieldVar = new JSONObject();
                if ("pk".equalsIgnoreCase(showColumn.getType())) {
                    fieldVar.put("title", (Object)String.format("[%s]%s", formCaption, ResManager.loadKDString((String)"\u5173\u8054\u7684\u8bb0\u5f55", (String)"AbstractWfModelSync_15", (String)"bos-nocode-formplugin", (Object[])new Object[0])));
                    fieldVar.put("value", (Object)MultiRefBillInfo.encodeMultiRefBillInfo((MultiRefBillInfo)new MultiRefBillInfo(formId, showColumn.getId(), value)));
                    fieldVar.put("type", (Object)this.getRefType(formId));
                    HashMap<String, Object> pkOption = new HashMap<String, Object>();
                    pkOption.put("billEntityId", formId);
                    pkOption.put("isMulti", false);
                    pkOption.put("cannotAssign", true);
                    pkOption.put("isRec", true);
                    fieldVar.put("option", pkOption);
                } else {
                    String dataTypeCaption = NcEntityTypeUtil.getDataTypeCaption((String)showColumn.getType(), (Map)showColumn.getOption());
                    fieldVar.put("title", (Object)String.format("%s%s", dataTypeCaption, showColumn.getCaption()));
                    fieldVar.put("value", (Object)MultiRefBillInfo.encodeMultiRefBillInfo((MultiRefBillInfo)new MultiRefBillInfo(formId, showColumn.getId(), value)));
                    fieldVar.put("type", (Object)showColumn.getType());
                    HashMap newOption = new HashMap(showColumn.getOption());
                    fieldVar.put("option", newOption);
                }
                fieldVars.add((Object)fieldVar);
            }
            option.put("children", fieldVars);
            option.put("isMulti", true);
            option.put("cannotAssign", true);
            option.put("billEntityId", formId);
            if (expendOnlyInExp) {
                option.put("expendOnlyInExp", true);
            }
        }
    }

    protected void expendChildrenToMultiByApi(Map<String, Object> option, String apiId, String formId, String value, boolean expendOnlyInExp) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        List openApiOutParams = OpenApiUtil.getOpenApiOutParams((String)apiId);
        if (openApiOutParams == null || openApiOutParams.isEmpty()) {
            return;
        }
        JSONArray fieldVars = new JSONArray(openApiOutParams.size());
        for (ShowColumnInfo showColumn : openApiOutParams) {
            JSONObject fieldVar = new JSONObject();
            fieldVar.put("title", (Object)String.format("%s%s", showColumn.getTypeCaption(), showColumn.getCaption()));
            String propName = showColumn.getId();
            if (showColumn.getOption().containsKey("Api_OutPropName")) {
                propName = (String)showColumn.getOption().get("Api_OutPropName");
            }
            fieldVar.put("value", (Object)MultiRefBillInfo.encodeMultiRefBillInfo((MultiRefBillInfo)new MultiRefBillInfo(formId, propName, value)));
            fieldVar.put("type", (Object)showColumn.getType());
            HashMap newOption = new HashMap(showColumn.getOption());
            fieldVar.put("option", newOption);
            fieldVars.add((Object)fieldVar);
        }
        option.put("children", fieldVars);
        option.put("isMulti", true);
        option.put("cannotAssign", true);
        option.put("billEntityId", formId);
        if (expendOnlyInExp) {
            option.put("expendOnlyInExp", true);
        }
    }

    private String getRefType(String formId) {
        if (NcEntityTypeUtil.isRefBillOfUser((String)formId)) {
            return "user";
        }
        if (NcEntityTypeUtil.isRefBillOfOrg((String)formId)) {
            return "org";
        }
        return "refbill";
    }

    protected boolean isMultiQueryDataset(String nodeId) {
        NoCodeWfNode noCodeWfNode;
        Optional<NoCodeWfNode> first = this.ncMetaData.getNodes().stream().filter(n -> n.getId().equalsIgnoreCase(nodeId)).findFirst();
        if (first.isPresent() && (noCodeWfNode = first.get()) instanceof NoCodeWfNodeAutoMicroSrv) {
            NoCodeWfNodeAutoMicroSrv autoNode = (NoCodeWfNodeAutoMicroSrv)noCodeWfNode;
            return autoNode.getOutParams().stream().anyMatch(p -> "QueryDataSet".equalsIgnoreCase(p.getNumber()));
        }
        return false;
    }

    protected void addAssigneeVar(String varCaption, T node, JSONArray fieldVars) {
        String nodeAssigneeVar = VariableHelper.getNodeAssigneeVar(node.getId(), this.ctx, this.ncMetaData);
        HashMap<String, Object> option = new HashMap<String, Object>(1);
        HashMap<String, Object> optionName = new HashMap<String, Object>(1);
        option.put("billEntityId", "bos_user");
        FieldTreeBuilder fieldTreeBuilder = new FieldTreeBuilder("68bde9ca00000eac");
        List showColumnInfos = fieldTreeBuilder.withFeature(new FieldTreeBuilder.Feature[]{FieldTreeBuilder.Feature.AttachmentDetail}).withoutFieldTypes(new FieldTreeBuilder.FieldType[]{FieldTreeBuilder.FieldType.NoCodeRichTextField, FieldTreeBuilder.FieldType.NoCodeGraphicDisplayField, FieldTreeBuilder.FieldType.NoCodeAttachmentUploadField, FieldTreeBuilder.FieldType.NoCodeImageUploadField, FieldTreeBuilder.FieldType.NoCodeBillNoField, FieldTreeBuilder.FieldType.EntryField}).build();
        String displayProps = showColumnInfos.stream().limit(5L).map(ShowColumnInfo::getId).collect(Collectors.joining(","));
        option.put("displayProp", displayProps);
        optionName.put("billEntityId", "bos_user");
        String dataTypeCaption = NcEntityTypeUtil.getDataTypeCaption((String)"user", option);
        this.addVar(NcEntityTypeUtil.getDataTitle((String)dataTypeCaption, (String)varCaption), String.format("${proc.%s}", nodeAssigneeVar), "user", option, fieldVars, node);
        optionName.put("visible", false);
        this.addVar(NcEntityTypeUtil.getDataTitle((String)dataTypeCaption, (String)varCaption), String.format("${proc.%s}", nodeAssigneeVar + ".name"), "user", optionName, fieldVars, node);
    }

    static {
        MAPPING_DICT_DATA_TYPE.put(KEY_TYPE_TEXT, ResManager.loadKDString((String)"\u6587\u672c", (String)"AbstractWfModelSync_7", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
        MAPPING_DICT_DATA_TYPE.put("bool", ResManager.loadKDString((String)"\u903b\u8f91", (String)"AbstractWfModelSync_8", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
        MAPPING_DICT_DATA_TYPE.put("date", ResManager.loadKDString((String)"\u65e5\u671f:\u5e74\u6708\u65e5", (String)"AbstractWfModelSync_9", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
        MAPPING_DICT_DATA_TYPE.put("time", ResManager.loadKDString((String)"\u65e5\u671f:\u65f6\u5206\u79d2", (String)"AbstractWfModelSync_10", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
        MAPPING_DICT_DATA_TYPE.put("number", ResManager.loadKDString((String)"\u6570\u5b57", (String)"AbstractWfModelSync_11", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
        MAPPING_DICT_DATA_TYPE.put("person", ResManager.loadKDString((String)"\u4eba\u5458", (String)"AbstractWfModelSync_12", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
        MAPPING_DICT_DATA_TYPE.put("org", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"AbstractWfModelSync_13", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
    }
}

