/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.sync;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfEdge;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfGraphCell;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeApiInvoke;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeAudit;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeCalculate;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeCustomJson;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeEnd;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeGateway;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeJudge;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeNewBill;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeNotify;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeQueryData;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeStart;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeUpdateBill;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeUserInput;
import kd.bos.nocode.ext.wf.control.events.WfDesignerMetaSyncEvent;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.helper.WfModelIteratorHelper;
import kd.bos.nocode.wf.designer.sync.IWfModelSync;
import kd.bos.nocode.wf.designer.sync.WfModelCommonSync;
import kd.bos.nocode.wf.designer.sync.edge.WfModelSequenceEdgeSync;
import kd.bos.nocode.wf.designer.sync.node.NoCodeWfNodeApiInvokeSync;
import kd.bos.nocode.wf.designer.sync.node.WfModelAuditSync;
import kd.bos.nocode.wf.designer.sync.node.WfModelCalculateSync;
import kd.bos.nocode.wf.designer.sync.node.WfModelCustomJsonSync;
import kd.bos.nocode.wf.designer.sync.node.WfModelEndSync;
import kd.bos.nocode.wf.designer.sync.node.WfModelGatewaySync;
import kd.bos.nocode.wf.designer.sync.node.WfModelJudgeSync;
import kd.bos.nocode.wf.designer.sync.node.WfModelNewBillSync;
import kd.bos.nocode.wf.designer.sync.node.WfModelNotifySync;
import kd.bos.nocode.wf.designer.sync.node.WfModelQueryDataSync;
import kd.bos.nocode.wf.designer.sync.node.WfModelStartSync;
import kd.bos.nocode.wf.designer.sync.node.WfModelUpdateBillSync;
import kd.bos.nocode.wf.designer.sync.node.WfModelUserInputSync;
import kd.bos.workflow.api.model.ProcPublishResult;
import kd.bos.workflow.api.model.ValidateResultItem;

public class WfModelSync {
    private static final String KEY_TYPE = "type";
    private static final String KEY_ERRORS = "errors";
    private static final String KEY_MSG = "msg";
    private static final String KEY_PROP = "prop";

    public static JSONObject buildSyncData(WfDesignerCtx ctx, NoCodeWfMetaData noCodeWfMetaData, NoCodeWfMetaData oldNoCodeWfMetaData, WfDesignerMetaSyncEvent syncArgs) {
        boolean includeErrTypes;
        Iterator<NoCodeWfGraphCell> iterator = WfModelIteratorHelper.getIterator(noCodeWfMetaData, ctx);
        List nodeIds = syncArgs.getNodeIds();
        List types = syncArgs.getTypes();
        boolean includeVarsTypes = types.size() == 0 || types.stream().anyMatch(t -> t != null && t.equalsIgnoreCase(WfConsts.SyncTypeEnum.VARIABLES.getCode()));
        boolean bl = includeErrTypes = types.size() == 0 || types.stream().anyMatch(t -> t != null && t.equalsIgnoreCase(WfConsts.SyncTypeEnum.ERRORS.getCode()));
        while (iterator.hasNext()) {
            boolean includeNodeIds;
            NoCodeWfGraphCell next = iterator.next();
            if (!(next instanceof NoCodeWfNode)) continue;
            boolean bl2 = includeNodeIds = nodeIds.size() == 0 || nodeIds.stream().anyMatch(n -> n != null && n.equalsIgnoreCase(next.getId()));
            if (includeVarsTypes) {
                WfModelSync.buildVariable(ctx, ctx.getVariables(), next, syncArgs, noCodeWfMetaData, oldNoCodeWfMetaData);
            }
            if (!includeNodeIds || !includeErrTypes) continue;
            WfModelSync.buildError(ctx, ctx.getErrors(), next, syncArgs, noCodeWfMetaData);
        }
        JSONObject variables = ctx.getVariables().clone();
        WfModelSync.removeUnUseVariables(variables, nodeIds);
        WfModelSync.removeInVisibleVariables(variables);
        JSONObject errors = WfModelSync.removeUnUseErrors(ctx.getErrors(), nodeIds);
        JSONObject syncData = new JSONObject();
        if (!variables.isEmpty()) {
            syncData.put(WfConsts.SyncTypeEnum.VARIABLES.getCode(), (Object)variables);
        }
        if (!errors.isEmpty()) {
            syncData.put(WfConsts.SyncTypeEnum.ERRORS.getCode(), (Object)errors);
        }
        return syncData;
    }

    private static void removeUnUseVariables(JSONObject variables, List<String> nodeIds) {
        if (variables.isEmpty() || nodeIds.isEmpty()) {
            return;
        }
        HashSet unUseNodeIds = new HashSet();
        unUseNodeIds.addAll(variables.keySet());
        unUseNodeIds.removeAll(nodeIds);
        for (String next : unUseNodeIds) {
            variables.remove((Object)next);
        }
    }

    private static void removeInVisibleVariables(JSONObject variables) {
        for (Object value : variables.values()) {
            JSONArray fieldVars = (JSONArray)value;
            fieldVars.removeIf(v -> WfModelSync.isNotVisible(v));
            for (Object fieldVar : fieldVars) {
                JSONArray childFieldVars;
                JSONObject fldVar = (JSONObject)fieldVar;
                Map option = (Map)fldVar.get((Object)"option");
                if (option == null || (childFieldVars = (JSONArray)option.get("children")) == null || childFieldVars.isEmpty()) continue;
                childFieldVars.removeIf(v -> WfModelSync.isNotVisible(v));
            }
        }
    }

    private static boolean isNotVisible(Object fieldVar) {
        if (fieldVar instanceof JSONObject) {
            return ((JSONObject)fieldVar).get((Object)"option") != null && ((Map)((JSONObject)fieldVar).get((Object)"option")).get("visible") != null && ((Map)((JSONObject)fieldVar).get((Object)"option")).get("visible") == Boolean.FALSE;
        }
        return false;
    }

    private static JSONObject removeUnUseErrors(JSONObject errors, List<String> nodeIds) {
        if (errors.isEmpty() || nodeIds.isEmpty()) {
            return errors;
        }
        HashSet unUseNodeIds = new HashSet(64);
        unUseNodeIds.addAll(errors.keySet());
        unUseNodeIds.removeAll(nodeIds);
        Iterator iterator = unUseNodeIds.iterator();
        JSONObject clone = errors.clone();
        while (iterator.hasNext()) {
            String next = (String)iterator.next();
            clone.remove((Object)next);
        }
        return clone;
    }

    public static JSONObject buildSyncDataFromPublish(NoCodeWfMetaData noCodeWfMetaData, ProcPublishResult procPublishResult, WfDesignerCtx ctx) {
        JSONObject errors = new JSONObject();
        Iterator<NoCodeWfGraphCell> iterator = WfModelIteratorHelper.getIterator(noCodeWfMetaData, ctx);
        ArrayList<ValidateResultItem> items = new ArrayList<ValidateResultItem>(procPublishResult.getValidateResult());
        NoCodeWfGraphCell startNode = null;
        while (iterator.hasNext()) {
            NoCodeWfNode node;
            ValidateResultItem validateResultItem;
            NoCodeWfGraphCell next = iterator.next();
            if (!(next instanceof NoCodeWfNode) || StringUtils.isBlank((CharSequence)next.getId()) || StringUtils.isBlank((CharSequence)((NoCodeWfNode)next).getName())) continue;
            if (startNode == null) {
                startNode = next;
            }
            if ((validateResultItem = WfModelSync.findValidateResultItem(items, node = (NoCodeWfNode)next)) == null || !items.stream().anyMatch(i -> node.getName().equalsIgnoreCase(i.getNodeName()))) continue;
            JSONArray theErrors = new JSONArray();
            JSONObject err = new JSONObject();
            err.put(KEY_TYPE, (Object)KEY_ERRORS);
            err.put(KEY_MSG, (Object)validateResultItem.getMessage());
            err.put(KEY_PROP, (Object)validateResultItem.getProperty());
            theErrors.add((Object)err);
            errors.put(node.getId(), (Object)theErrors);
            items.remove(validateResultItem);
        }
        WfModelSync.otherErrorPutAtStartNode(startNode, items, errors);
        JSONObject syncData = new JSONObject();
        if (!errors.isEmpty()) {
            syncData.put(WfConsts.SyncTypeEnum.ERRORS.getCode(), (Object)errors);
        }
        return syncData;
    }

    private static ValidateResultItem findValidateResultItem(List<ValidateResultItem> validateResultItems, NoCodeWfNode node) {
        Optional<ValidateResultItem> first = validateResultItems.stream().filter(i -> node.getId().equalsIgnoreCase(i.getNodeId())).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        return null;
    }

    private static void otherErrorPutAtStartNode(NoCodeWfGraphCell startNode, List<ValidateResultItem> items, JSONObject errors) {
        if (startNode != null && items.size() > 0) {
            JSONArray theErrors = new JSONArray();
            for (ValidateResultItem item : items) {
                JSONObject err = new JSONObject();
                err.put(KEY_TYPE, (Object)KEY_ERRORS);
                err.put(KEY_MSG, (Object)item.getMessage());
                theErrors.add((Object)err);
            }
            errors.put(startNode.getId(), (Object)theErrors);
        }
    }

    public static int calcErrorCount(JSONObject syncData) {
        JSONObject errors = (JSONObject)syncData.get((Object)WfConsts.SyncTypeEnum.ERRORS.getCode());
        if (errors == null || errors.isEmpty()) {
            return 0;
        }
        int iCount = 0;
        for (Map.Entry entry : errors.entrySet()) {
            JSONArray nodeErrors;
            Object nodeData = entry.getValue();
            if (!(nodeData instanceof JSONArray) || (nodeErrors = (JSONArray)nodeData) == null) continue;
            iCount += WfModelSync.getErrorCountWithSub(nodeErrors);
        }
        return iCount;
    }

    private static int getErrorCountWithSub(JSONArray nodeErrors) {
        int size = 0;
        for (Object nodeError : nodeErrors) {
            JSONObject err = (JSONObject)nodeError;
            Object msg = err.get((Object)KEY_MSG);
            if (msg instanceof JSONObject) {
                JSONObject msgSubs = (JSONObject)msg;
                for (Object value : msgSubs.values()) {
                    JSONArray subErrs = (JSONArray)value;
                    size += subErrs.size();
                }
                continue;
            }
            ++size;
        }
        return size;
    }

    public static void showErrorNotificationNonProp(NoCodeWfGraphCell startNode, JSONObject syncData, IFormView formView) {
        JSONObject errors = (JSONObject)syncData.get((Object)WfConsts.SyncTypeEnum.ERRORS.getCode());
        if (errors == null || errors.isEmpty()) {
            return;
        }
        JSONArray startErrors = (JSONArray)errors.get((Object)startNode.getId());
        if (startErrors == null) {
            return;
        }
        for (Object nodeError : startErrors) {
            JSONObject err = (JSONObject)nodeError;
            Object msg = err.get((Object)KEY_MSG);
            Object prop = err.get((Object)KEY_PROP);
            if (prop != null || !(msg instanceof String)) continue;
            formView.showErrorNotification((String)msg);
        }
    }

    private static void buildVariable(WfDesignerCtx ctx, JSONObject variables, NoCodeWfGraphCell node, WfDesignerMetaSyncEvent syncArgs, NoCodeWfMetaData ncMetaData, NoCodeWfMetaData oldNcMetaData) {
        syncArgs.getParam().put(WfConsts.SyncTypeEnum.VARIABLES.getCode(), variables);
        IWfModelSync sync = WfModelSync.getSync(ctx, node, syncArgs, ncMetaData, oldNcMetaData);
        sync.buildVariable(variables, node);
    }

    private static void buildError(WfDesignerCtx ctx, JSONObject errors, NoCodeWfGraphCell node, WfDesignerMetaSyncEvent syncArgs, NoCodeWfMetaData ncMetaDta) {
        syncArgs.getParam().put(WfConsts.SyncTypeEnum.ERRORS.getCode(), errors);
        IWfModelSync sync = WfModelSync.getSync(ctx, node, syncArgs, ncMetaDta, null);
        sync.buildError(errors, node);
    }

    private static IWfModelSync getSync(WfDesignerCtx ctx, NoCodeWfGraphCell node, WfDesignerMetaSyncEvent syncArgs, NoCodeWfMetaData ncMetaDta, NoCodeWfMetaData oldNcMetaDta) {
        if (node == null) {
            throw new KDBizException("no sync");
        }
        if (node instanceof NoCodeWfNodeStart) {
            return new WfModelStartSync(ctx, syncArgs, ncMetaDta);
        }
        if (node instanceof NoCodeWfEdge) {
            return new WfModelSequenceEdgeSync(ctx, syncArgs, ncMetaDta);
        }
        if (node instanceof NoCodeWfNodeNotify) {
            return new WfModelNotifySync(ctx, syncArgs, ncMetaDta, oldNcMetaDta);
        }
        if (node instanceof NoCodeWfNodeEnd) {
            return new WfModelEndSync(ctx, syncArgs, ncMetaDta);
        }
        if (node instanceof NoCodeWfNodeAudit) {
            return new WfModelAuditSync(ctx, syncArgs, ncMetaDta);
        }
        if (node instanceof NoCodeWfNodeCalculate) {
            return new WfModelCalculateSync(ctx, syncArgs, ncMetaDta, oldNcMetaDta);
        }
        if (node instanceof NoCodeWfNodeUpdateBill) {
            return new WfModelUpdateBillSync(ctx, syncArgs, ncMetaDta, oldNcMetaDta);
        }
        if (node instanceof NoCodeWfNodeNewBill) {
            return new WfModelNewBillSync(ctx, syncArgs, ncMetaDta, oldNcMetaDta);
        }
        if (node instanceof NoCodeWfNodeQueryData) {
            return new WfModelQueryDataSync(ctx, syncArgs, ncMetaDta, oldNcMetaDta);
        }
        if (node instanceof NoCodeWfNodeGateway) {
            return new WfModelGatewaySync(ctx, syncArgs, ncMetaDta);
        }
        if (node instanceof NoCodeWfNodeJudge) {
            return new WfModelJudgeSync(ctx, syncArgs, ncMetaDta);
        }
        if (node instanceof NoCodeWfNodeUserInput) {
            return new WfModelUserInputSync(ctx, syncArgs, ncMetaDta);
        }
        if (node instanceof NoCodeWfNodeApiInvoke) {
            return new NoCodeWfNodeApiInvokeSync(ctx, syncArgs, ncMetaDta, oldNcMetaDta);
        }
        if (node instanceof NoCodeWfNodeCustomJson) {
            return new WfModelCustomJsonSync(ctx, syncArgs, ncMetaDta, oldNcMetaDta);
        }
        return new WfModelCommonSync(ctx, syncArgs, ncMetaDta);
    }

    private WfModelSync() {
        throw new IllegalStateException("WfModelSync class");
    }
}

