/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.sync.node;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfGraphCell;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.info.SettingItem;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.AssignmentInfo;
import kd.bos.nocode.ext.wf.control.events.WfDesignerMetaSyncEvent;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.wf.designer.helper.ExpressDesignMetaHelper;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.sync.AbstractWfModelSync;
import kd.bos.workflow.api.model.MacroItem;
import kd.bos.workflow.api.model.NodeMacro;

public abstract class AbstractWfModelSyncWithMacro<T extends NoCodeWfGraphCell>
extends AbstractWfModelSync<T> {
    protected static final Log logger = LogFactory.getLog(AbstractWfModelSyncWithMacro.class);
    public static final String ERROR = "error";
    private List<NodeMacro> macros = new ArrayList<NodeMacro>();

    public AbstractWfModelSyncWithMacro(WfDesignerCtx ctx, WfDesignerMetaSyncEvent syncArgs, NoCodeWfMetaData ncMetaData, NoCodeWfMetaData oldNcMetaData) {
        super(ctx, syncArgs, ncMetaData);
        this.initNodeMacro(ncMetaData, oldNcMetaData);
    }

    private void initNodeMacro(NoCodeWfMetaData ncMetaData, NoCodeWfMetaData oldNcMetaData) {
        try {
            this.macros = this.ctx.getMacros();
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    public List<NodeMacro> getMacros() {
        return this.macros;
    }

    public NodeMacro getMacroByNode(NoCodeWfNode node) {
        return this.ctx.getMacroByNode(node);
    }

    protected boolean isEmptyMacroItem(MacroItem nacroItem) {
        return StringUtils.isBlank((CharSequence)nacroItem.getDataType()) && StringUtils.isBlank((CharSequence)nacroItem.getName()) && StringUtils.isBlank((CharSequence)nacroItem.getNumber());
    }

    protected <S extends SettingItem> void genError2Settings(List<S> settings, JSONArray errors, T node) {
        if (settings == null || settings.isEmpty()) {
            return;
        }
        JSONObject msg = new JSONObject();
        for (SettingItem setting : settings) {
            JSONArray errs = new JSONArray();
            this.genError2Setting(setting, errs, node);
            if (errs.isEmpty()) continue;
            msg.put(setting.getCalcId(), (Object)errs);
        }
        this.checkSettingsRepeat(settings, msg);
        if (msg.isEmpty()) {
            return;
        }
        JSONObject settingErr = new JSONObject();
        settingErr.put("type", (Object)ERROR);
        settingErr.put("msg", (Object)msg);
        settingErr.put("prop", (Object)"setting");
        errors.add((Object)settingErr);
    }

    protected <S extends SettingItem> void checkSettingsRepeat(List<S> settings, JSONObject msg) {
    }

    protected <S extends SettingItem> void genError2Setting(S setting, JSONArray errors, T node) {
        boolean hasErr = this.genAssignmentErrors(setting, errors, node);
        if (hasErr) {
            return;
        }
        hasErr = this.genExpressionErrors(setting, errors, node);
        if (hasErr) {
            return;
        }
        this.genAssignTypeCompatible(setting, errors, node);
    }

    protected <S extends SettingItem> boolean genAssignmentErrors(S setting, JSONArray errors, T node) {
        if (StringUtils.isBlank((CharSequence)setting.getAssignment())) {
            AbstractWfModelSyncWithMacro.addRequiredErr("assignment", this.getAssignmentTitle(setting, node), errors);
            return true;
        }
        if (WfConsts.VAR_PROC_PATTERN_OF_EXECUTERESULT_QUERYDATASET.matcher(setting.getAssignment()).matches()) {
            this.addErr(ERROR, ResManager.loadKDString((String)"\u591a\u6761\u7ed3\u679c\u96c6\u4e0d\u53ef\u66f4\u65b0", (String)"AbstractWfModelSyncWithMacro_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "assignment", errors);
            return true;
        }
        String sError = ExpressDesignMetaHelper.checkExpressionRefModel(setting.getAssignment(), node.getId(), this.variables, true, this.ncMetaData, this.ctx);
        if (StringUtils.isNotBlank((CharSequence)sError)) {
            this.addErr(ERROR, sError, "assignment", errors);
            return true;
        }
        String sErrorRefProc = ExpressDesignMetaHelper.checkExpressionRefProc(setting.getAssignment(), node.getId(), true, this.variables, this.ncMetaData, this.ctx);
        if (StringUtils.isNotBlank((CharSequence)sErrorRefProc)) {
            this.addErr(ERROR, sErrorRefProc, "assignment", errors);
            return true;
        }
        return false;
    }

    protected <S extends SettingItem> boolean genExpressionErrors(S setting, JSONArray errors, T node) {
        String sErrorCheckExp;
        if (StringUtils.isBlank((CharSequence)setting.getExpression()) && this.isExpressionMustInput(setting, node)) {
            AbstractWfModelSyncWithMacro.addRequiredErr("expression", WfConsts.getPropsKeyCalcExpressionTitle(), errors);
            return true;
        }
        String sError = ExpressDesignMetaHelper.checkExpressionRefModel(setting.getExpression(), node.getId(), this.variables, false, this.ncMetaData, this.ctx);
        if (StringUtils.isNotBlank((CharSequence)sError)) {
            this.addErr(ERROR, sError, "expression", errors);
            return true;
        }
        String sErrorRefProc = ExpressDesignMetaHelper.checkExpressionRefProc(setting.getExpression(), node.getId(), false, this.variables, this.ncMetaData, this.ctx);
        if (StringUtils.isNotBlank((CharSequence)sErrorRefProc)) {
            this.addErr(ERROR, sErrorRefProc, "expression", errors);
            return true;
        }
        if (this.isNeedCheckExpression(setting, node) && StringUtils.isNotBlank((CharSequence)(sErrorCheckExp = ExpressDesignMetaHelper.checkExpression(setting, node, this.ctx, this.ncMetaData)))) {
            this.addErr(ERROR, sErrorCheckExp, "expression", errors);
            return true;
        }
        return false;
    }

    protected boolean checkExpressionErrors(String expression, JSONArray errors, T node, String prop) {
        String sError = ExpressDesignMetaHelper.checkExpressionRefModel(expression, node.getId(), this.variables, false, this.ncMetaData, this.ctx);
        if (StringUtils.isNotBlank((CharSequence)sError)) {
            this.addErr(ERROR, sError, prop, errors);
            return true;
        }
        String sErrorRefProc = ExpressDesignMetaHelper.checkExpressionRefProc(expression, node.getId(), false, this.variables, this.ncMetaData, this.ctx);
        if (StringUtils.isNotBlank((CharSequence)sErrorRefProc)) {
            this.addErr(ERROR, sErrorRefProc, prop, errors);
            return true;
        }
        return false;
    }

    protected <S extends SettingItem> void genAssignTypeCompatible(S setting, JSONArray errors, T node) {
        AssignmentInfo assignmentFieldInfo = this.getAssignmentFieldInfo(setting, node);
        if (assignmentFieldInfo == null || setting.getExpression() == null) {
            return;
        }
        if (!WfConsts.varPattern.matcher(setting.getExpression()).matches()) {
            if (NcEntityTypeUtil.isRefBill((String)assignmentFieldInfo.getType()) && NcEntityTypeUtil.isRecPk((String)setting.getExpression()) && !NcEntityTypeUtil.isFormRecExist((String)((String)assignmentFieldInfo.getOption().get("billEntityId")), (String)setting.getExpression())) {
                this.addErr(ERROR, ResManager.loadKDString((String)"\u5f15\u7528\u5931\u6548", (String)"AbstractWfModelSyncWithMacro_1", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "expression", errors);
                return;
            }
            return;
        }
        JSONObject varExpression = this.findVarFromExpression(setting.getExpression(), node.getId());
        if (varExpression == null) {
            return;
        }
        String typeExpression = (String)varExpression.get((Object)"type");
        if (!this.isTypeCompatible(assignmentFieldInfo, varExpression, typeExpression)) {
            this.addErr(ERROR, ResManager.loadKDString((String)"\u8d4b\u503c\u6570\u636e\u7c7b\u578b\u4e0d\u517c\u5bb9", (String)"AbstractWfModelSyncWithMacro_2", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "expression", errors);
            return;
        }
    }

    protected <S extends SettingItem> AssignmentInfo getAssignmentFieldInfo(S setting, T node) {
        return null;
    }

    private boolean isTypeCompatible(AssignmentInfo assignmentFieldInfo, JSONObject varExpression, String typeExpression) {
        String typeAssignment = assignmentFieldInfo.getType();
        if (StringUtils.isBlank((CharSequence)typeExpression) || StringUtils.isBlank((CharSequence)typeAssignment)) {
            return false;
        }
        Map srcOption = (Map)varExpression.get((Object)"option");
        Map targetOption = assignmentFieldInfo.getOption();
        return NcEntityTypeUtil.isTypeCanAssign((String)typeExpression, (String)typeAssignment, (Map)srcOption, (Map)targetOption);
    }

    private JSONObject findVarFromExpression(String expression, String currentNodeId) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        JSONObject varObj = null;
        String assignmentExpression = NcEntityTypeUtil.getRuntimeExpression((String)expression);
        Matcher varDispPattern = WfConsts.VAR_DISP_PATTERN.matcher(assignmentExpression);
        while (varDispPattern.find()) {
            String dispVar = varDispPattern.group();
            if (varObj != null) {
                return null;
            }
            varObj = VariableHelper.findVariable(currentNodeId, dispVar, this.variables, this.ncMetaData, this.ctx);
        }
        Matcher varModelPattern = WfConsts.varModelPattern.matcher(assignmentExpression);
        while (varModelPattern.find()) {
            String modelVar = varModelPattern.group();
            if (varObj != null) {
                return null;
            }
            varObj = VariableHelper.findVariable(currentNodeId, modelVar, this.variables, this.ncMetaData, this.ctx);
        }
        Matcher varProcPattern = WfConsts.varProcPattern.matcher(assignmentExpression);
        while (varProcPattern.find()) {
            String procVar = varProcPattern.group();
            if (varObj != null) {
                return null;
            }
            if ("${proc.procName}".equalsIgnoreCase(procVar)) continue;
            varObj = VariableHelper.findVariable(currentNodeId, procVar, this.variables, this.ncMetaData, this.ctx);
        }
        return varObj;
    }

    private boolean isMultiRefBill(JSONObject varObj) {
        if (!varObj.containsKey((Object)"option")) {
            return false;
        }
        Map option = (Map)varObj.get((Object)"option");
        if (option == null) {
            return false;
        }
        return option.containsKey("isMulti") && (Boolean)option.get("isMulti") != false;
    }

    private boolean isMultiRefBill(AssignmentInfo assignmentFieldInfo) {
        if (assignmentFieldInfo == null || !NcEntityTypeUtil.isRefBill((String)assignmentFieldInfo.getType())) {
            return false;
        }
        Map option = assignmentFieldInfo.getOption();
        if (option == null) {
            return false;
        }
        return option.containsKey("isMulti") && (Boolean)option.get("isMulti") != false;
    }

    protected <S extends SettingItem> boolean isExpressionMustInput(S setting, T node) {
        return true;
    }

    protected <S extends SettingItem> boolean isNeedCheckExpression(S setting, T node) {
        String expression = setting.getExpression();
        if (StringUtils.isBlank((CharSequence)expression)) {
            return false;
        }
        return expression.indexOf("@@") != -1 || WfConsts.varPattern.matcher(expression).matches();
    }

    protected <S extends SettingItem> String getAssignmentTitle(S setting, T node) {
        return WfConsts.getPropsKeyCalcAssignmentTitle();
    }

    @Override
    protected boolean hasVar(T node) {
        return true;
    }

    @Override
    protected void genVars(T node, JSONArray fieldVars) {
        this.addNodeNameVar(node, fieldVars);
    }
}

