/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.sync.node;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.info.MultiRefBillInfo;
import kd.bos.nocode.ext.metadata.wf.info.ParameterSetting;
import kd.bos.nocode.ext.metadata.wf.info.RequestBody;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeApiInvoke;
import kd.bos.nocode.ext.metadata.wf.nodes.automicro.OutParam;
import kd.bos.nocode.ext.util.WfProcessUtils;
import kd.bos.nocode.ext.wf.control.events.WfDesignerMetaSyncEvent;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.WfUtils;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.sync.node.AbstractWfModelSyncWithMacro;
import kd.bos.workflow.api.model.MacroItem;
import kd.bos.workflow.api.model.NodeMacro;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class NoCodeWfNodeApiInvokeSync
extends AbstractWfModelSyncWithMacro<NoCodeWfNodeApiInvoke> {
    public NoCodeWfNodeApiInvokeSync(WfDesignerCtx ctx, WfDesignerMetaSyncEvent syncArgs, NoCodeWfMetaData ncMetaData, NoCodeWfMetaData oldNcMetaData) {
        super(ctx, syncArgs, ncMetaData, oldNcMetaData);
    }

    @Override
    protected void genVars(NoCodeWfNodeApiInvoke node, JSONArray fieldVars) {
        super.genVars(node, fieldVars);
        NodeMacro macro = this.getMacroByNode((NoCodeWfNode)node);
        if (Objects.isNull(macro)) {
            return;
        }
        List items = macro.getItems();
        for (MacroItem item : items) {
            if (this.isEmptyMacroItem(item)) continue;
            Map option = node.getOutParams().stream().filter(p -> p.getNumber().equalsIgnoreCase(item.getNumber())).map(OutParam::getOption).findFirst().orElseGet(HashMap::new);
            String value = String.format("${proc.%s.%s}", macro.getNumber(), item.getNumber());
            if ("QueryDataSet".equalsIgnoreCase(item.getNumber())) {
                String billEntityIdVarValue = this.getBillEntityIdVarValue(macro, items);
                this.expendChildren(option, node.getResponseParamsBase62(), billEntityIdVarValue, value, false);
            }
            String dataTypeCaption = NcEntityTypeUtil.getDataTypeCaption((String)item.getDataType(), (Map)option);
            this.addVar(NcEntityTypeUtil.getDataTitle((String)dataTypeCaption, (String)item.getName()), value, item.getDataType(), option, fieldVars, node);
        }
    }

    private String getBillEntityIdVarValue(NodeMacro macro, List<MacroItem> items) {
        for (MacroItem item : items) {
            if (this.isEmptyMacroItem(item) || !item.getNumber().equalsIgnoreCase("billEntityId")) continue;
            return String.format("${proc.%s.%s}", macro.getNumber(), item.getNumber());
        }
        return "";
    }

    private void expendChildren(Map<String, Object> option, List<ParameterSetting> responseParams, String formId, String value, boolean expendOnlyInExp) {
        JSONArray fieldVars = new JSONArray(responseParams.size());
        for (ParameterSetting responseParam : responseParams) {
            JSONObject fieldVar = new JSONObject();
            fieldVar.put("title", (Object)String.format("%s%s", NcEntityTypeUtil.getDataTypeCaption((String)responseParam.getFieldType(), new HashMap()), responseParam.getFieldName()));
            fieldVar.put("value", (Object)MultiRefBillInfo.encodeMultiRefBillInfo((MultiRefBillInfo)new MultiRefBillInfo(formId, responseParam.getName(), value)));
            fieldVar.put("type", (Object)responseParam.getFieldType());
            fieldVar.put("option", new HashMap(16));
            fieldVars.add((Object)fieldVar);
        }
        option.put("children", fieldVars);
        option.put("isMulti", true);
        option.put("cannotAssign", true);
        if (expendOnlyInExp) {
            option.put("expendOnlyInExp", true);
        }
    }

    @Override
    protected void genErrors(NoCodeWfNodeApiInvoke node, JSONArray errors) {
        NoCodeWfNodeApiInvokeSync.checkProperties(node, errors, false);
        this.checkVarProperties(node, errors);
    }

    private void checkVarProperties(NoCodeWfNodeApiInvoke node, JSONArray errors) {
        ParameterSetting responseParam;
        if (WfProcessUtils.isBasicAuthNode((NoCodeWfNodeApiInvoke)node)) {
            super.checkExpressionErrors(node.getUsername(), errors, node, "username");
            super.checkExpressionErrors(node.getPassword(), errors, node, "password");
            return;
        }
        if (WfProcessUtils.isOAuth2Node((NoCodeWfNodeApiInvoke)node)) {
            super.checkExpressionErrors(node.getAccessTokenUrl(), errors, node, "accessTokenUrl");
        } else {
            super.checkExpressionErrors(node.getUrl(), errors, node, "url");
        }
        Iterator iterator = node.getRequestHeader().iterator();
        while (!(!iterator.hasNext() || StringUtils.isNotEmpty((CharSequence)(responseParam = (ParameterSetting)iterator.next()).getValue()) && super.checkExpressionErrors(responseParam.getValue(), errors, node, "requestHeader"))) {
        }
        RequestBody requestBody = node.getRequestBody();
        if ("formData".equalsIgnoreCase(requestBody.getEnctype())) {
            ParameterSetting responseParam2;
            List formData = requestBody.getFormData();
            Iterator iterator2 = formData.iterator();
            while (!(!iterator2.hasNext() || StringUtils.isNotEmpty((CharSequence)(responseParam2 = (ParameterSetting)iterator2.next()).getValue()) && super.checkExpressionErrors(responseParam2.getValue(), errors, node, "requestBody"))) {
            }
        } else {
            super.checkExpressionErrors(requestBody.getJson(), errors, node, "requestBody");
        }
    }

    public static void checkProperties(NoCodeWfNodeApiInvoke node, JSONArray errors, boolean fromTestApi) {
        if (StringUtils.isBlank((CharSequence)node.getName())) {
            NoCodeWfNodeApiInvokeSync.addRequiredErr("name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"NoCodeWfNodeApiInvokeSync_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        }
        if (WfProcessUtils.isBasicAuthNode((NoCodeWfNodeApiInvoke)node)) {
            if (StringUtils.isBlank((CharSequence)node.getUsername())) {
                NoCodeWfNodeApiInvokeSync.addRequiredErr("username", ResManager.loadKDString((String)"\u7528\u6237\u540d", (String)"NoCodeWfNodeApiInvokeSync_1", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
            }
            if (StringUtils.isBlank((CharSequence)node.getPassword())) {
                NoCodeWfNodeApiInvokeSync.addRequiredErr("password", ResManager.loadKDString((String)"\u5bc6\u7801", (String)"NoCodeWfNodeApiInvokeSync_2", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
            }
            return;
        }
        if (WfProcessUtils.isOAuth2Node((NoCodeWfNodeApiInvoke)node)) {
            if (StringUtils.isBlank((CharSequence)node.getAccessTokenUrl())) {
                NoCodeWfNodeApiInvokeSync.addRequiredErr("accessTokenUrl", "Access Token URL", errors);
            } else {
                NoCodeWfNodeApiInvokeSync.checkUrlValid(node.getAccessTokenUrl(), "accessTokenUrl", "Access Token URL", errors);
            }
        } else if (StringUtils.isBlank((CharSequence)node.getUrl())) {
            NoCodeWfNodeApiInvokeSync.addRequiredErr("url", ResManager.loadKDString((String)"API\u7684URL", (String)"NoCodeWfNodeApiInvokeSync_3", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        } else {
            NoCodeWfNodeApiInvokeSync.checkUrlValid(node.getUrl(), "url", ResManager.loadKDString((String)"API\u7684URL", (String)"NoCodeWfNodeApiInvokeSync_3", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        }
        NoCodeWfNodeApiInvokeSync.checkRequestHeader(node.getRequestHeader(), errors);
        NoCodeWfNodeApiInvokeSync.checkRequestBody(node.getRequestBody(), errors);
        if (!fromTestApi) {
            NoCodeWfNodeApiInvokeSync.checkResponseParams(node.getResponseParams(), errors);
        }
    }

    private static void checkRequestBody(RequestBody requestBody, JSONArray errors) {
        String json;
        String enctype = requestBody.getEnctype();
        if ("formData".equalsIgnoreCase(enctype)) {
            List formData = requestBody.getFormData();
            NoCodeWfNodeApiInvokeSync.checkParameterSettings(formData, "requestBody", errors, false);
        } else if (!"json".equalsIgnoreCase(enctype) || StringUtils.isBlank((CharSequence)(json = requestBody.getJson()))) {
            // empty if block
        }
    }

    private static void checkUrlValid(String url, String prop, String propName, JSONArray errors) {
        if (WfUtils.isVar((String)url)) {
            return;
        }
        Pattern pattern = Pattern.compile("^(https?://)([^/:]+)(:([0-9]{1,5}))?(/.*)?(\\?.*)?$");
        if (!pattern.matcher(url).matches()) {
            JSONObject err = new JSONObject();
            err.put("type", (Object)"error");
            err.put("msg", (Object)String.format("%s%s", propName, ResManager.loadKDString((String)"\u4e0d\u5408\u6cd5", (String)"NoCodeWfNodeApiInvokeSync_4", (String)"bos-nocode-formplugin", (Object[])new Object[0])));
            err.put("prop", (Object)prop);
            errors.add((Object)err);
        }
    }

    private static void checkRequestHeader(List<ParameterSetting> requestHeader, JSONArray errors) {
        NoCodeWfNodeApiInvokeSync.checkParameterSettings(requestHeader, "requestHeader", errors, false);
    }

    private static void checkParameterSettings(List<ParameterSetting> parameterSettings, String prop, JSONArray errors, boolean isResponseParam) {
        Map<String, Long> name2Count = parameterSettings.stream().map(ParameterSetting::getName).filter(Objects::nonNull).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        JSONObject msg = new JSONObject();
        for (ParameterSetting parameterSetting : parameterSettings) {
            JSONArray errs = new JSONArray();
            NoCodeWfNodeApiInvokeSync.genErrors2ParameterSetting(parameterSetting, errs, isResponseParam, name2Count);
            if (!CollectionUtils.isNotEmpty((Collection)errs)) continue;
            msg.put(parameterSetting.getId(), (Object)errs);
        }
        if (MapUtils.isEmpty((Map)msg)) {
            return;
        }
        JSONObject settingErr = new JSONObject();
        settingErr.put("type", (Object)"error");
        settingErr.put("msg", (Object)msg);
        settingErr.put("prop", (Object)prop);
        errors.add((Object)settingErr);
    }

    private static void genErrors2ParameterSetting(ParameterSetting parameterSetting, JSONArray errs, boolean isResponseParam, Map<String, Long> name2Count) {
        String name = parameterSetting.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            NoCodeWfNodeApiInvokeSync.addRequiredErr("name", ResManager.loadKDString((String)"\u53c2\u6570\u540d", (String)"NoCodeWfNodeApiInvokeSync_5", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errs);
        }
        if (StringUtils.isNotBlank((CharSequence)name) && name2Count.get(name) > 1L) {
            JSONObject err = new JSONObject();
            err.put("type", (Object)"error");
            err.put("msg", (Object)ResManager.loadKDString((String)"\u53c2\u6570\u540d\u4e0d\u80fd\u91cd\u590d", (String)"NoCodeWfNodeApiInvokeSync_6", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
            err.put("prop", (Object)"name");
            errs.add((Object)err);
        }
        if (isResponseParam) {
            if (StringUtils.isBlank((CharSequence)parameterSetting.getFieldName())) {
                NoCodeWfNodeApiInvokeSync.addRequiredErr("fieldName", ResManager.loadKDString((String)"\u53d8\u91cf\u540d\u79f0", (String)"NoCodeWfNodeApiInvokeSync_7", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errs);
            }
            if (StringUtils.isBlank((CharSequence)parameterSetting.getFieldType())) {
                NoCodeWfNodeApiInvokeSync.addRequiredErr("fieldType", ResManager.loadKDString((String)"\u53d8\u91cf\u7c7b\u578b", (String)"NoCodeWfNodeApiInvokeSync_8", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errs);
            }
            if (StringUtils.isBlank((CharSequence)parameterSetting.getResponseType())) {
                NoCodeWfNodeApiInvokeSync.addRequiredErr("responseType", ResManager.loadKDString((String)"\u54cd\u5e94\u7c7b\u578b", (String)"NoCodeWfNodeApiInvokeSync_9", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errs);
            }
        } else if (StringUtils.isBlank((CharSequence)parameterSetting.getValue())) {
            NoCodeWfNodeApiInvokeSync.addRequiredErr("value", ResManager.loadKDString((String)"\u53c2\u6570\u503c", (String)"NoCodeWfNodeApiInvokeSync_10", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errs);
        }
    }

    private static void checkResponseParams(List<ParameterSetting> responseParams, JSONArray errors) {
        NoCodeWfNodeApiInvokeSync.checkParameterSettings(responseParams, "responseParams", errors, true);
    }
}

