/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf.designer.sync.node;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.nocode.constant.WfTaskActionEnum;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.info.MsgItem;
import kd.bos.nocode.ext.metadata.wf.info.ParticipantInfo;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeAudit;
import kd.bos.nocode.ext.wf.control.events.WfDesignerMetaSyncEvent;
import kd.bos.nocode.restapi.api.model.DecisionOption;
import kd.bos.nocode.wf.designer.helper.ParticipantHelper;
import kd.bos.nocode.wf.designer.helper.VariableHelper;
import kd.bos.nocode.wf.designer.helper.WfDesignerCtx;
import kd.bos.nocode.wf.designer.sync.AbstractWfModelSync;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class WfModelAuditSync
extends AbstractWfModelSync<NoCodeWfNodeAudit> {
    public WfModelAuditSync(WfDesignerCtx ctx, WfDesignerMetaSyncEvent syncArgs, NoCodeWfMetaData ncMetaData) {
        super(ctx, syncArgs, ncMetaData);
    }

    @Override
    protected boolean hasVar(NoCodeWfNodeAudit node) {
        return true;
    }

    @Override
    protected void genVars(NoCodeWfNodeAudit node, JSONArray fieldVars) {
        this.addNodeNameVar(node, fieldVars);
        this.addAssigneeVar(ResManager.loadKDString((String)"\u5ba1\u6279\u4eba", (String)"WfModelAuditSync_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]), node, fieldVars);
        HashMap<String, Object> option = new HashMap<String, Object>(1);
        option.put("valueItems", this.buildItemsFromDecisionOptions(node));
        option.put("isResult", true);
        this.addVar("[\u9009\u9879]\u5ba1\u6279\u7ed3\u679c", String.format("${proc.%sAuditNumber}", node.getId()), "combo", option, fieldVars, node);
    }

    private List<ValueMapItem> buildItemsFromDecisionOptions(NoCodeWfNodeAudit node) {
        List decisionOptions = node.getDecisionOptions();
        if (CollectionUtils.isEmpty((Collection)decisionOptions)) {
            return Collections.emptyList();
        }
        return decisionOptions.stream().filter(e -> !e.getNumber().equalsIgnoreCase(WfTaskActionEnum.Reject.toString())).map(this::buildItem).collect(Collectors.toList());
    }

    private ValueMapItem buildItem(DecisionOption option) {
        ValueMapItem item = new ValueMapItem();
        item.setName(new LocaleString(option.getName()));
        item.setValue(option.getNumber());
        return item;
    }

    @Override
    protected void genErrors(NoCodeWfNodeAudit node, JSONArray errors) {
        List decisionOptions;
        if (StringUtils.isBlank((CharSequence)node.getName())) {
            WfModelAuditSync.addRequiredErr("name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"WfModelAuditSync_1", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        }
        ParticipantInfo participantInfo = ParticipantHelper.getParticipantInfo((NoCodeWfNode)node, node.getParticipant(), this.ctx, this.ncMetaData);
        node.setParticipant(participantInfo);
        if (CollectionUtils.isEmpty((Collection)participantInfo.getSourceData())) {
            WfModelAuditSync.addRequiredErr("participant", ResManager.loadKDString((String)"\u5ba1\u6279\u4eba", (String)"WfModelAuditSync_0", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        } else {
            List sourceData = participantInfo.getSourceData();
            if (sourceData.stream().anyMatch(e -> !e.isValid())) {
                this.addErr("error", ResManager.loadKDString((String)"\u5b58\u5728\u5931\u6548\u7684\u5ba1\u6279\u4eba", (String)"WfModelAuditSync_2", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "participant", errors);
            } else {
                String[] person = participantInfo.getPerson();
                Arrays.stream(person).forEach(userId -> {
                    String varType;
                    JSONObject variable;
                    if (StringUtils.isNotBlank((CharSequence)userId) && userId.startsWith("${") && (variable = VariableHelper.findVariable(node.getId(), userId, this.ctx.getVariables(), this.ncMetaData, this.ctx)) != null && !"user".equalsIgnoreCase(varType = VariableHelper.getVarType(variable))) {
                        this.addErr("error", ResManager.loadKDString((String)"\u5ba1\u6279\u4eba\u53ea\u80fd\u5173\u8054\u4eba\u5458\u7c7b\u578b", (String)"WfModelAuditSync_3", (String)"bos-nocode-formplugin", (Object[])new Object[0]), "participant", errors);
                    }
                });
            }
        }
        MsgItem notifyApproverMsg = node.getNotifyApproverMsg();
        if (notifyApproverMsg != null && notifyApproverMsg.isCheck() && StringUtils.isBlank((CharSequence)notifyApproverMsg.getContent())) {
            WfModelAuditSync.addRequiredErr("notifyApproverMsg", ResManager.loadKDString((String)"\u5f85\u5ba1\u6279\u65f6\u901a\u77e5\u5185\u5bb9", (String)"WfModelAuditSync_4", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        }
        if (CollectionUtils.isEmpty((Collection)(decisionOptions = node.getDecisionOptions()))) {
            WfModelAuditSync.addRequiredErr("decisionOptions", ResManager.loadKDString((String)"\u51b3\u7b56\u9879", (String)"WfModelAuditSync_5", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errors);
        } else {
            this.genError2DecisionOptions(decisionOptions, errors, node);
        }
    }

    private void genError2DecisionOptions(List<DecisionOption> decisionOptions, JSONArray errors, NoCodeWfNodeAudit node) {
        JSONObject msg = new JSONObject();
        Map<String, Long> name2CountMap = decisionOptions.stream().collect(Collectors.groupingBy(DecisionOption::getName, Collectors.counting()));
        for (DecisionOption decisionOption : decisionOptions) {
            JSONArray errs = new JSONArray();
            this.genErrors2DecisionOption(decisionOption, errs, node, name2CountMap);
            if (!CollectionUtils.isNotEmpty((Collection)errs)) continue;
            msg.put(decisionOption.getNumber(), (Object)errs);
        }
        if (MapUtils.isEmpty((Map)msg)) {
            return;
        }
        JSONObject settingErr = new JSONObject();
        settingErr.put("type", (Object)"error");
        settingErr.put("msg", (Object)msg);
        settingErr.put("prop", (Object)"decisionOptions");
        errors.add((Object)settingErr);
    }

    private void genErrors2DecisionOption(DecisionOption decisionOption, JSONArray errs, NoCodeWfNodeAudit node, Map<String, Long> name2CountMap) {
        this.genNameErrors(decisionOption, errs, node, name2CountMap);
        this.genMessageErrors(decisionOption, errs, node);
    }

    private void genMessageErrors(DecisionOption decisionOption, JSONArray errs, NoCodeWfNodeAudit node) {
        if (decisionOption.isSendMessage() && StringUtils.isBlank((CharSequence)decisionOption.getMessage())) {
            WfModelAuditSync.addRequiredErr("message", ResManager.loadKDString((String)"\u6d88\u606f\u5185\u5bb9", (String)"WfModelAuditSync_6", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errs);
        }
    }

    private void genNameErrors(DecisionOption decisionOption, JSONArray errs, NoCodeWfNodeAudit node, Map<String, Long> name2CountMap) {
        if (StringUtils.isBlank((CharSequence)decisionOption.getName())) {
            WfModelAuditSync.addRequiredErr("name", ResManager.loadKDString((String)"\u51b3\u7b56\u540d\u79f0", (String)"WfModelAuditSync_7", (String)"bos-nocode-formplugin", (Object[])new Object[0]), errs);
        } else if (name2CountMap.get(decisionOption.getName()) > 1L) {
            JSONObject err = new JSONObject();
            err.put("type", (Object)"error");
            err.put("msg", (Object)ResManager.loadKDString((String)"\u51b3\u7b56\u540d\u79f0\u4e0d\u80fd\u91cd\u590d", (String)"WfModelAuditSync_8", (String)"bos-nocode-formplugin", (Object[])new Object[0]));
            err.put("prop", (Object)"name");
            errs.add((Object)err);
        }
    }
}

